/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotesvillage.entity.Humanoid.SecondRounderEntity;
import com.jerotes.jerotesvillage.goal.EyeDiscRangedAttackGoal;
import com.jerotes.jerotesvillage.goal.HighNearestAttackableTargetGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EyeDiscEntity
extends Monster
implements RangedAttackMob,
JerotesEntity,
SpellUseEntity {
    private static final EntityDataAccessor<Boolean> BLIND = SynchedEntityData.m_135353_(EyeDiscEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SPELL_LEVEL_OF = SynchedEntityData.m_135353_(EyeDiscEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOOT_TICK = SynchedEntityData.m_135353_(EyeDiscEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int spellLevel = 2;

    public EyeDiscEntity(EntityType<? extends EyeDiscEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(2.6f);
        this.f_21364_ = 20;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 3, true);
    }

    public boolean isJerotesFlyingMob() {
        return true;
    }

    protected PathNavigation m_6037_(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new EyeDiscRangedAttackGoal(this, 1.5, 2, 36.0f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 20){

            protected Vec3 m_7037_() {
                RandomSource random = EyeDiscEntity.this.m_217043_();
                double dir_x = EyeDiscEntity.this.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                double dir_y = EyeDiscEntity.this.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                double dir_z = EyeDiscEntity.this.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new HighNearestAttackableTargetGoal<Player>((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(2, new HighNearestAttackableTargetGoal<SecondRounderEntity>((Mob)this, SecondRounderEntity.class, false));
        this.f_21346_.m_25352_(2, new HighNearestAttackableTargetGoal<AbstractVillager>((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(2, new HighNearestAttackableTargetGoal<IronGolem>((Mob)this, IronGolem.class, false));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        this.setSpellLevelOf(this.getSpellLevel());
        if (!this.m_9236_().m_5776_()) {
            this.setShootTick(60 + this.getSpellLevel() * 50);
        }
        OtherSpellList.EyeDiscShoot(this.getSpellLevel(), (LivingEntity)this, (Entity)livingEntity).spellUse();
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.15);
        builder = builder.m_22268_(Attributes.f_22280_, 1.15);
        builder = builder.m_22268_(Attributes.f_22276_, 32.0);
        builder = builder.m_22268_(Attributes.f_22281_, 4.0);
        builder = builder.m_22268_(Attributes.f_22277_, 48.0);
        return builder;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.EYE_DISC_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.EYE_DISC_DEATH;
    }

    protected float m_6121_() {
        return 1.0f;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 1.125f;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268549_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (EntityAndItemFind.MagicResistance((DamageSource)damagesource) && !this.isBlind()) {
            return super.m_6469_(damagesource, amount / 6.0f);
        }
        return super.m_6469_(damagesource, amount);
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public boolean isBlind() {
        return (Boolean)this.m_20088_().m_135370_(BLIND);
    }

    public void setBlind(boolean bl) {
        this.m_20088_().m_135381_(BLIND, (Object)bl);
    }

    public int getSpellLevelOf() {
        return (Integer)this.m_20088_().m_135370_(SPELL_LEVEL_OF);
    }

    public void setSpellLevelOf(int n) {
        this.m_20088_().m_135381_(SPELL_LEVEL_OF, (Object)n);
    }

    public int getShootTick() {
        return (Integer)this.m_20088_().m_135370_(SHOOT_TICK);
    }

    public void setShootTick(int n) {
        this.m_20088_().m_135381_(SHOOT_TICK, (Object)n);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("ShootTick", this.getShootTick());
        compoundTag.m_128379_("IsBlind", this.isBlind());
        compoundTag.m_128405_("SpellLevelOf", this.getSpellLevelOf());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.setShootTick(compoundTag.m_128451_("ShootTick"));
        this.setBlind(compoundTag.m_128471_("IsBlind"));
        this.setSpellLevelOf(compoundTag.m_128451_("SpellLevelOf"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(BLIND, (Object)false);
        this.m_20088_().m_135372_(SPELL_LEVEL_OF, (Object)2);
        this.m_20088_().m_135372_(SHOOT_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (BLIND.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 13; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)JerotesVillageParticleTypes.EYE_DISC.get(), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (this.m_5448_() != null && this.getPersistentData().m_128459_("jerotesvillage_eye_disc_shoot") > 0.0) {
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setShootTick(Math.max(0, this.getShootTick() - 1));
            if (this.m_5448_() == null && !this.m_5912_()) {
                this.getPersistentData().m_128347_("jerotesvillage_eye_disc_shoot", 0.0);
                this.setShootTick((int)this.getPersistentData().m_128459_("jerotesvillage_eye_disc_shoot"));
            }
        }
        if (this.m_21023_(MobEffects.f_19610_) && !this.isBlind()) {
            this.setBlind(true);
        }
        if (!this.m_21023_(MobEffects.f_19610_) && this.isBlind()) {
            this.setBlind(false);
        }
    }
}

