/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.IllagerFaction;

import com.google.common.collect.Maps;
import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.entity.UseThrowEntity;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedThrowAttackGoal;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotesvillage.entity.Monster.IllagerFaction.MeleeIllagerEntity;
import com.jerotes.jerotesvillage.entity.in.AlwaysShowArmIllagerEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BlasterEntity
extends MeleeIllagerEntity
implements AlwaysShowArmIllagerEntity,
RangedAttackMob,
UseThrowEntity {
    public AnimationState idle1AnimationState = new AnimationState();
    public AnimationState idle2AnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState throw1AnimationState = new AnimationState();
    public AnimationState throw2AnimationState = new AnimationState();

    public BlasterEntity(EntityType<? extends BlasterEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 20;
        this.m_21553_(false);
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Monster.m_33035_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.36);
        builder = builder.m_22268_(Attributes.f_22276_, 24.0);
        builder = builder.m_22268_(Attributes.f_22284_, 3.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new JerotesRangedThrowAttackGoal((RangedAttackMob)this, 0.4, 40, 12.0f));
        this.f_21345_.m_25352_(1, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.1, true));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                if (BlasterEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        ItemStack handItem = this.m_21205_();
        if ((this.m_21205_().m_41619_() || InventoryEntity.isMeleeWeapon((ItemStack)this.m_21205_())) && !this.m_21206_().m_41619_()) {
            handItem = this.m_21206_();
        }
        if (InventoryEntity.isThrow((ItemStack)handItem)) {
            this.useThrowShoot((LivingEntity)this, livingEntity);
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesSounds.ITEM_THROW, this.m_5720_(), 0.5f, 0.4f / (this.m_9236_().m_213780_().m_188501_() * 0.4f + 0.8f));
            }
        }
        if (!this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.BLASTER_THROW, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        }
        if (!this.m_9236_().m_5776_()) {
            this.setThrowTick(80);
            this.setAnimTick(10);
            if (handItem == this.m_21205_()) {
                this.setAnimationState("throw1");
            } else {
                this.setAnimationState("throw2");
            }
        }
        this.idle1AnimationState.m_216973_();
        this.idle2AnimationState.m_216973_();
        if (JerotesGameRules.JEROTES_RANGE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_RANGE_CAN_BREAK) && (handItem.m_41720_() instanceof BowItem || handItem.m_41720_() instanceof TridentItem)) {
            handItem.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    public float meleeOrRangeDistance() {
        return 6.0f;
    }

    @Override
    public boolean canUseThrow() {
        return true;
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.BLASTER_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.BLASTER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (this.m_21275_(damageSource)) {
            return SoundEvents.f_12346_;
        }
        return JerotesVillageSounds.BLASTER_HURT;
    }

    @Override
    public SoundEvent m_7930_() {
        return JerotesVillageSounds.BLASTER_CHEER;
    }

    @Override
    public void m_7895_(int n, boolean bl) {
        ItemStack itemStack = new ItemStack((ItemLike)JerotesVillageItems.OMINOUS_CUTLASS.get());
        Raid raid = this.m_37885_();
        int n2 = 1;
        if (n > raid.m_37724_(Difficulty.NORMAL)) {
            n2 = 2;
        }
        boolean bl2 = this.f_19796_.m_188501_() <= raid.m_37783_();
        boolean bl3 = bl2;
        if (bl2) {
            HashMap hashMap = Maps.newHashMap();
            hashMap.put(Enchantments.f_44977_, n2);
            EnchantmentHelper.m_44865_((Map)hashMap, (ItemStack)itemStack);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
    }

    @Override
    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        if (Objects.equals(animation, "throw1")) {
            return 2;
        }
        if (Objects.equals(animation, "throw2")) {
            return 3;
        }
        return 0;
    }

    @Override
    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        list.add(this.throw1AnimationState);
        list.add(this.throw2AnimationState);
        return list;
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 2: {
                    this.throw1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.throw1AnimationState);
                    break;
                }
                case 3: {
                    this.throw2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.throw2AnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_5448_() == null && !this.m_9236_().m_5776_()) {
            this.setThrowTick(80);
        }
        if (this.m_6084_() && this.getAttackTick() < 12 && this.getThrowTick() > 50) {
            if (InventoryEntity.isThrow((ItemStack)this.m_21205_())) {
                this.idle1AnimationState.m_216982_(this.f_19797_);
            }
            if (InventoryEntity.isThrow((ItemStack)this.m_21206_())) {
                this.idle2AnimationState.m_216982_(this.f_19797_);
            }
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (!this.m_9236_().m_5776_()) {
            this.setThrowTick(0);
            this.setAnimTick(5);
            this.setAnimationState("attack");
        }
        this.idle1AnimationState.m_216973_();
        this.idle2AnimationState.m_216973_();
        boolean bl = super.m_7327_(entity);
        if (bl && !this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.BLASTER_ATTACK, 1.0f, 1.0f);
        }
        return bl;
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268415_)) {
            return super.m_6469_(damagesource, amount / 5.0f);
        }
        return super.m_6469_(damagesource, amount);
    }

    @Override
    public ItemStack createSpawnWeapon(float weaponRandom) {
        return new ItemStack((ItemLike)JerotesVillageItems.OMINOUS_CUTLASS.get());
    }

    @Override
    public ItemStack createSpawnOffhand(float offhandRandom) {
        return new ItemStack((ItemLike)JerotesVillageItems.OMINOUS_BOMB.get());
    }
}

