/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.IllagerFaction;

import com.google.common.collect.Maps;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.entity.Monster.IllagerFaction.MeleeIllagerEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class CyclonerEntity
extends MeleeIllagerEntity {
    public AnimationState idle1AnimationState = new AnimationState();
    public AnimationState idle2AnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState rollAnimationState = new AnimationState();
    public AnimationState rollStartAnimationState = new AnimationState();

    public CyclonerEntity(EntityType<? extends CyclonerEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 25;
        this.m_21553_(false);
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        this.maybeWearArmor(EquipmentSlot.HEAD, new ItemStack((ItemLike)JerotesVillageItems.HORNED_HELMET.get()), randomSource);
    }

    private void maybeWearArmor(EquipmentSlot equipmentSlot, ItemStack itemStack, RandomSource randomSource) {
        this.m_8061_(equipmentSlot, itemStack);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Monster.m_33035_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 32.0);
        builder = builder.m_22268_(Attributes.f_22284_, 5.0);
        builder = builder.m_22268_(Attributes.f_22281_, 6.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.7);
        builder = builder.m_22268_(Attributes.f_22282_, 0.5);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 64.0f, 0.0f, false){

            public boolean m_8036_() {
                if (CyclonerEntity.this.getSpellTick() <= 0) {
                    return false;
                }
                if (this.f_25513_ != this.f_25512_.m_5448_()) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                if (CyclonerEntity.this.getSpellTick() <= 0) {
                    return false;
                }
                if (this.f_25513_ != this.f_25512_.m_5448_()) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.1, true));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                if (CyclonerEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.CYCLONER_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.CYCLONER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (this.m_21275_(damageSource)) {
            return SoundEvents.f_12346_;
        }
        return JerotesVillageSounds.CYCLONER_HURT;
    }

    @Override
    public SoundEvent m_7930_() {
        return JerotesVillageSounds.CYCLONER_CHEER;
    }

    @Override
    public void m_7895_(int n, boolean bl) {
        ItemStack itemStack = new ItemStack((ItemLike)JerotesVillageItems.OMINOUS_MACE.get());
        Raid raid = this.m_37885_();
        int n2 = 1;
        if (n > raid.m_37724_(Difficulty.NORMAL)) {
            n2 = 2;
        }
        boolean bl2 = this.f_19796_.m_188501_() <= raid.m_37783_();
        boolean bl3 = bl2;
        if (bl2) {
            HashMap hashMap = Maps.newHashMap();
            hashMap.put(Enchantments.f_44977_, n2);
            EnchantmentHelper.m_44865_((Map)hashMap, (ItemStack)itemStack);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
        this.m_8061_(EquipmentSlot.OFFHAND, itemStack);
    }

    @Override
    protected AABB m_292684_() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(0.5, 0.5, 0.5);
    }

    @Override
    public boolean m_217066_(LivingEntity livingEntity) {
        return this.m_292684_().m_82381_(livingEntity.m_20191_());
    }

    @Override
    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        if (Objects.equals(animation, "roll")) {
            return 2;
        }
        if (Objects.equals(animation, "rollStart")) {
            return 3;
        }
        return 0;
    }

    @Override
    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        list.add(this.rollAnimationState);
        list.add(this.rollStartAnimationState);
        return list;
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 2: {
                    this.rollAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.rollAnimationState);
                    break;
                }
                case 3: {
                    this.rollStartAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.rollStartAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_5448_() != null && this.m_5912_() && this.getSpellTick() <= -120 && this.m_217043_().m_188503_(60) == 1 && !this.m_9236_().m_5776_()) {
            this.setSpellTick(120);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!this.m_20145_()) {
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.CYCLONER_CYCLONES_DISPLAY.get()), this.m_20185_(), this.m_20191_().f_82292_ + 0.5, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (!this.m_9236_().m_5776_()) {
                this.setAnimTick(20);
                this.setAnimationState("rollStart");
            }
        }
        if (this.getSpellTick() > -120 && this.m_6084_() && this.getSpellTick() > 0) {
            if (this.m_5448_() != null && this.getSpellTick() % 10 == 0 && this.m_20096_()) {
                this.jumpToTarget(this.m_5448_());
            }
            if (this.getSpellTick() % 2 == 0 && !this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.CYCLONER_ROLL, 1.0f, 1.0f);
            }
            if (this.getSpellTick() % 5 == 0) {
                this.trueHurt();
            }
            if (this.getSpellTick() % 10 == 0 && this.getSpellTick() <= 100) {
                this.rollStartAnimationState.m_216973_();
                if (!this.m_9236_().m_5776_()) {
                    this.setAnimTick(10);
                    this.setAnimationState("roll");
                }
            }
        }
        if (this.getSpellTick() <= 0 || !this.m_6084_()) {
            this.rollAnimationState.m_216973_();
        }
        if (this.getSpellTick() <= 0 && this.m_6084_()) {
            if (!this.m_21526_()) {
                if (!this.m_21205_().m_41619_()) {
                    this.idle1AnimationState.m_216982_(this.f_19797_);
                }
                if (!this.m_21206_().m_41619_()) {
                    this.idle2AnimationState.m_216982_(this.f_19797_);
                }
            } else {
                if (!this.m_21205_().m_41619_()) {
                    this.idle2AnimationState.m_216982_(this.f_19797_);
                }
                if (!this.m_21206_().m_41619_()) {
                    this.idle1AnimationState.m_216982_(this.f_19797_);
                }
            }
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (this.getSpellTick() > 0) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(5);
            this.setAnimationState("attack");
        }
        if ((bl = super.m_7327_(entity)) && !this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.CYCLONER_ATTACK, 1.0f, 1.0f);
        }
        return bl;
    }

    public boolean trueHurt() {
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_(0.25));
        for (LivingEntity hurt : list) {
            if (hurt == null || this.m_20280_((Entity)hurt) > 64.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt)) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)0.75f, (float)1.5f, (boolean)false, (float)0.0f);
        }
        Main.sweepAttack((Entity)this);
        if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
            ItemStack hand = this.m_21205_();
            hand.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean jumpToTarget(LivingEntity target) {
        this.m_21391_((Entity)target, 360.0f, 360.0f);
        double smoothX = Mth.m_14008_((double)Math.abs(target.m_20185_() - this.m_20185_()), (double)0.0, (double)1.0);
        double smoothZ = Mth.m_14008_((double)Math.abs(target.m_20189_() - this.m_20189_()), (double)0.0, (double)1.0);
        double d0 = (target.m_20185_() - this.m_20185_()) * 0.3 * smoothX;
        double d2 = (target.m_20189_() - this.m_20189_()) * 0.3 * smoothZ;
        float up = 0.5f + this.m_217043_().m_188501_() * 0.8f;
        this.m_20256_(this.m_20184_().m_82520_(d0 * 0.75, (double)up, d2 * 0.75));
        this.m_21573_().m_5624_((Entity)target, 1.0);
        return true;
    }

    protected int m_5639_(float f, float f2) {
        return super.m_5639_(f, f2) - 12;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268549_) && this.getSpellTick() > 0) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setSpellTick(this.getSpellTick() - 40);
        }
        return super.m_6469_(damagesource, amount);
    }

    @Override
    public ItemStack createSpawnWeapon(float weaponRandom) {
        return new ItemStack((ItemLike)JerotesVillageItems.OMINOUS_MACE.get());
    }

    @Override
    public ItemStack createSpawnOffhand(float offhandRandom) {
        return new ItemStack((ItemLike)JerotesVillageItems.OMINOUS_MACE.get());
    }
}

