/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.IllagerFaction;

import com.jerotes.jerotes.entity.BreakShieldEntity;
import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.OminouseBannerRaidForceEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.goal.JerotesHelpAlliesGoal;
import com.jerotes.jerotes.goal.JerotesHelpSameFactionGoal;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.init.JerotesDamageTypes;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.control.GiantMoveControl;
import com.jerotes.jerotesvillage.entity.Part.FirepowerPourerChainsawPart;
import com.jerotes.jerotesvillage.entity.Part.FirepowerPourerGunPart;
import com.jerotes.jerotesvillage.entity.Part.FirepowerPourerPart;
import com.jerotes.jerotesvillage.entity.Shoot.Arrow.VirtualCaveCrystalArrowEntity;
import com.jerotes.jerotesvillage.event.AdvancementEvent;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageGameRules;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class FirepowerPourerEntity
extends Raider
implements EliteEntity,
OminouseBannerRaidForceEntity,
JerotesEntity,
BreakShieldEntity {
    private static final UUID CHAINSAW_ATTACK_DAMAGE_MODIFIER_UUID = UUID.fromString("0a8dd507-ff80-455d-991c-346cd5d360c7");
    private static final EntityDataAccessor<Float> CHAINSAW_HEALTH = SynchedEntityData.m_135353_(FirepowerPourerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> GUN_HEALTH = SynchedEntityData.m_135353_(FirepowerPourerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(FirepowerPourerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(FirepowerPourerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(FirepowerPourerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_USE = SynchedEntityData.m_135353_(FirepowerPourerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COOL_TICK = SynchedEntityData.m_135353_(FirepowerPourerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> COOLING_TICK = SynchedEntityData.m_135353_(FirepowerPourerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOOT_TICK = SynchedEntityData.m_135353_(FirepowerPourerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOOT_USE_TICK = SynchedEntityData.m_135353_(FirepowerPourerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10, false);
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState attack3AnimationState = new AnimationState();
    public AnimationState attack4AnimationState = new AnimationState();
    public AnimationState attack5AnimationState = new AnimationState();
    public AnimationState break1AnimationState = new AnimationState();
    public AnimationState break2AnimationState = new AnimationState();
    public AnimationState shootAnimationState = new AnimationState();
    public AnimationState coolAnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    public final FirepowerPourerChainsawPart chainsaw;
    public final FirepowerPourerGunPart gun;
    public final FirepowerPourerPart[] allParts;

    public FirepowerPourerEntity(EntityType<? extends FirepowerPourerEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.6f);
        this.f_21364_ = 80;
        this.m_21553_(false);
        this.f_21342_ = new GiantMoveControl((Mob)this);
        this.chainsawAbout();
        this.chainsaw = new FirepowerPourerChainsawPart(this, "chainsaw", 1.2f, 1.2f);
        this.gun = new FirepowerPourerGunPart(this, "gun", 1.0f, 1.0f);
        this.allParts = new FirepowerPourerPart[]{this.chainsaw, this.gun};
    }

    public boolean isFactionWith(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && (EntityFactionFind.isRaider((LivingEntity)(livingEntity = (LivingEntity)entity)) || OtherEntityFactionFind.isFactionOminousBannerRaidForce(livingEntity));
    }

    public String getFactionTypeName() {
        return "ominous_banner_raid_force";
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6543_(serverPlayer);
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6539_(serverPlayer);
        }
    }

    public void m_8024_() {
        super.m_8024_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        super.m_142687_(reason);
        if (this.allParts != null) {
            for (FirepowerPourerPart part : this.allParts) {
                part.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Monster.m_33035_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.28);
        builder = builder.m_22268_(Attributes.f_22276_, 220.0);
        builder = builder.m_22268_(Attributes.f_22284_, 16.0);
        builder = builder.m_22268_(Attributes.f_22281_, 12.0);
        builder = builder.m_22268_(Attributes.f_22282_, 1.2);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22282_, 1.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        return builder;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.1, true));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, AbstractIllager.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpSameFactionGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpAlliesGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                if (FirepowerPourerEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.FIREPOWER_POURER_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.FIREPOWER_POURER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.FIREPOWER_POURER_HURT;
    }

    public SoundEvent m_7930_() {
        return JerotesVillageSounds.FIREPOWER_POURER_CHEER;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(JerotesVillageSounds.FIREPOWER_POURER_WALK, 0.5f, 1.0f);
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public boolean m_37882_() {
        return true;
    }

    public void m_7895_(int n, boolean bl) {
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public void m_7023_(Vec3 vec3) {
        super.m_7023_(vec3);
        if (this.getCoolingTick() > 0) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
        } else if (this.getShootUseTick() > 0) {
            this.m_20256_(this.m_20184_().m_82542_(0.05, 1.0, 0.05));
        }
    }

    protected AABB m_292684_() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(1.25, 1.25, 1.25);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.m_292684_().m_82381_(livingEntity.m_20191_());
    }

    public void chainsawAbout() {
        if (!this.m_9236_().f_46443_) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22120_(CHAINSAW_ATTACK_DAMAGE_MODIFIER_UUID);
            if (this.getChainsawHealth() > 0.0f) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22118_(new AttributeModifier(CHAINSAW_ATTACK_DAMAGE_MODIFIER_UUID, "Chainsaw attack damage", 8.0, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public boolean m_213824_() {
        return this.getChainsawHealth() > 0.0f || super.m_213824_();
    }

    public int getShieldBreakStrength() {
        if (this.getChainsawHealth() > 0.0f) {
            return 100;
        }
        return 0;
    }

    protected void m_6731_(LivingEntity livingEntity) {
        if (this.getChainsawHealth() > 0.0f && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_36384_(true);
        }
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 3.25f;
    }

    public float getChainsawHealth() {
        return ((Float)this.f_19804_.m_135370_(CHAINSAW_HEALTH)).floatValue();
    }

    public void setChainsawHealth(float f) {
        this.f_19804_.m_135381_(CHAINSAW_HEALTH, (Object)Float.valueOf(Mth.m_14036_((float)f, (float)0.0f, (float)110.0f)));
    }

    public float getGunHealth() {
        return ((Float)this.f_19804_.m_135370_(GUN_HEALTH)).floatValue();
    }

    public void setGunHealth(float f) {
        this.f_19804_.m_135381_(GUN_HEALTH, (Object)Float.valueOf(Mth.m_14036_((float)f, (float)0.0f, (float)110.0f)));
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public int getAttackUse() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_USE);
    }

    public void setAttackUse(int n) {
        this.m_20088_().m_135381_(ATTACK_USE, (Object)n);
    }

    public void setShootTick(int n) {
        this.m_20088_().m_135381_(SHOOT_TICK, (Object)n);
    }

    public int getShootTick() {
        return (Integer)this.m_20088_().m_135370_(SHOOT_TICK);
    }

    public void setShootUseTick(int n) {
        this.m_20088_().m_135381_(SHOOT_USE_TICK, (Object)n);
    }

    public int getShootUseTick() {
        return (Integer)this.m_20088_().m_135370_(SHOOT_USE_TICK);
    }

    public void setCoolTick(int n) {
        this.m_20088_().m_135381_(COOL_TICK, (Object)n);
    }

    public int getCoolTick() {
        return (Integer)this.m_20088_().m_135370_(COOL_TICK);
    }

    public void setCoolingTick(int n) {
        this.m_20088_().m_135381_(COOLING_TICK, (Object)n);
    }

    public int getCoolingTick() {
        return (Integer)this.m_20088_().m_135370_(COOLING_TICK);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack1")) {
            return 1;
        }
        if (Objects.equals(animation, "attack2")) {
            return 2;
        }
        if (Objects.equals(animation, "attack3")) {
            return 3;
        }
        if (Objects.equals(animation, "attack4")) {
            return 4;
        }
        if (Objects.equals(animation, "attack5")) {
            return 5;
        }
        if (Objects.equals(animation, "break1")) {
            return 6;
        }
        if (Objects.equals(animation, "break2")) {
            return 7;
        }
        if (Objects.equals(animation, "shoot")) {
            return 8;
        }
        if (Objects.equals(animation, "cool")) {
            return 9;
        }
        if (Objects.equals(animation, "dead")) {
            return 10;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.attack3AnimationState);
        list.add(this.attack4AnimationState);
        list.add(this.attack5AnimationState);
        list.add(this.break1AnimationState);
        list.add(this.break2AnimationState);
        list.add(this.shootAnimationState);
        list.add(this.coolAnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("AttackTick", this.getAttackTick());
        compoundTag.m_128405_("AttackUse", this.getAttackUse());
        compoundTag.m_128405_("ShootTick", this.getShootTick());
        compoundTag.m_128405_("ShootUseTick", this.getShootUseTick());
        compoundTag.m_128405_("CoolTick", this.getCoolTick());
        compoundTag.m_128405_("CoolingTick", this.getCoolingTick());
        compoundTag.m_128350_("ChainsawHealth", this.getChainsawHealth());
        compoundTag.m_128350_("GunHealth", this.getGunHealth());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.setAttackTick(compoundTag.m_128451_("AttackTick"));
        this.setAttackUse(compoundTag.m_128451_("AttackUse"));
        this.setShootTick(compoundTag.m_128451_("ShootTick"));
        this.setShootUseTick(compoundTag.m_128451_("ShootUseTick"));
        this.setCoolTick(compoundTag.m_128451_("CoolTick"));
        this.setCoolingTick(compoundTag.m_128451_("CoolingTick"));
        this.setChainsawHealth(compoundTag.m_128457_("ChainsawHealth"));
        this.setGunHealth(compoundTag.m_128457_("GunHealth"));
        this.chainsawAbout();
        this.bossEvent.setId(this.m_20148_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(CHAINSAW_HEALTH, (Object)Float.valueOf(110.0f));
        this.m_20088_().m_135372_(GUN_HEALTH, (Object)Float.valueOf(110.0f));
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(ATTACK_USE, (Object)0);
        this.m_20088_().m_135372_(SHOOT_TICK, (Object)0);
        this.m_20088_().m_135372_(SHOOT_USE_TICK, (Object)0);
        this.m_20088_().m_135372_(COOL_TICK, (Object)0);
        this.m_20088_().m_135372_(COOLING_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 2: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 3: {
                    this.attack3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack3AnimationState);
                    break;
                }
                case 4: {
                    this.attack4AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack4AnimationState);
                    break;
                }
                case 5: {
                    this.attack5AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack5AnimationState);
                    break;
                }
                case 6: {
                    this.break1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.break1AnimationState);
                    break;
                }
                case 7: {
                    this.break2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.break2AnimationState);
                    break;
                }
                case 8: {
                    this.shootAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shootAnimationState);
                    break;
                }
                case 9: {
                    this.coolAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.coolAnimationState);
                    break;
                }
                case 10: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:storage_blocks/iron"))) && this.m_21223_() >= this.m_21233_()) {
            this.setChainsawHealth(110.0f);
            this.setGunHealth(110.0f);
            this.chainsawAbout();
            float f2 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
            this.m_5496_(JerotesSounds.REPAIR_MOB, 1.0f, f2);
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:ingots/iron")))) {
            this.repair(player, itemStack);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, interactionHand);
    }

    public boolean repair(Player player, ItemStack itemStack) {
        this.m_5634_(this.m_21233_() / 8.0f);
        float f2 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
        this.m_5496_(JerotesSounds.REPAIR_MOB, 1.0f, f2);
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return true;
    }

    public void handBreak1() {
        if (!(this.getCoolingTick() <= 0 && this.getShootUseTick() <= 0 || this.m_9236_().m_5776_())) {
            this.setAnimTick(5);
            this.setAnimationState("break1");
        }
    }

    public void handBreak2() {
        if (!(this.getCoolingTick() <= 0 && this.getAttackTick() <= -10 || this.m_9236_().m_5776_())) {
            this.setAnimTick(5);
            this.setAnimationState("break2");
        }
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.allParts;
    }

    public void m_141965_(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        super.m_141965_(clientboundAddEntityPacket);
        this.chainsaw.m_20234_(1 + clientboundAddEntityPacket.m_131496_());
        this.gun.m_20234_(2 + clientboundAddEntityPacket.m_131496_());
    }

    private void tickMultipart() {
        Vec3[] avector3d = new Vec3[this.allParts.length];
        for (int j = 0; j < this.allParts.length; ++j) {
            avector3d[j] = new Vec3(this.allParts[j].m_20185_(), this.allParts[j].m_20186_(), this.allParts[j].m_20189_());
        }
        Vec3 center = this.m_20182_().m_82520_(0.0, (double)(this.m_20206_() * 0.5f), 0.0);
        if (this.getChainsawHealth() > 0.0f) {
            this.chainsaw.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, 0.0, (double)1.6f), 0.0f, this.f_20883_ + 45.0f).m_82549_(center));
        } else {
            this.chainsaw.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, 0.0, 0.0), 0.0f, 0.0f).m_82549_(center));
        }
        if (this.getGunHealth() > 0.0f) {
            this.gun.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, 0.0, (double)1.6f), 0.0f, this.f_20883_ - 45.0f).m_82549_(center));
        } else {
            this.gun.setPosCenteredY(this.rotateOffsetVec(new Vec3(0.0, 0.0, 0.0), 0.0f, 0.0f).m_82549_(center));
        }
        for (int l = 0; l < this.allParts.length; ++l) {
            this.allParts[l].f_19854_ = avector3d[l].f_82479_;
            this.allParts[l].f_19855_ = avector3d[l].f_82480_;
            this.allParts[l].f_19856_ = avector3d[l].f_82481_;
            this.allParts[l].f_19790_ = avector3d[l].f_82479_;
            this.allParts[l].f_19791_ = avector3d[l].f_82480_;
            this.allParts[l].f_19792_ = avector3d[l].f_82481_;
        }
    }

    private Vec3 rotateOffsetVec(Vec3 offset, float xRot, float yRot) {
        return offset.m_82496_(-xRot * ((float)Math.PI / 180)).m_82524_(-yRot * ((float)Math.PI / 180));
    }

    public void m_8119_() {
        this.tickMultipart();
        super.m_8119_();
    }

    public void m_8107_() {
        boolean hell;
        Raider raider;
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.update();
            if (OtherMainConfig.EliteBossBarOnlyCombat) {
                this.bossEvent.m_8321_(this.m_5448_() != null);
            }
        }
        if (this.f_19796_.m_188503_(900) == 1 && this.m_6084_()) {
            this.m_5634_(3.0f);
            if (!this.m_9236_().m_5776_()) {
                if (this.getChainsawHealth() > 0.0f && this.getChainsawHealth() < 110.0f) {
                    this.setChainsawHealth(this.getChainsawHealth() + 1.0f);
                }
                if (this.getGunHealth() > 0.0f && this.getGunHealth() < 110.0f) {
                    this.setGunHealth(this.getGunHealth() + 1.0f);
                }
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(-10, this.getAttackTick() - 1));
        }
        if (this.getAttackUse() != 5) {
            if (this.getAttackUse() == 2 && this.getChainsawHealth() > 0.0f) {
                if (this.getAttackTick() >= 12 && this.getAttackTick() <= 17 && this.m_6084_()) {
                    this.trueHurt();
                }
            } else if (this.getAttackTick() == 14 && this.m_6084_()) {
                this.trueHurt();
            }
        } else if ((this.getAttackTick() == 8 || this.getAttackTick() == 5 || this.getAttackTick() == 2) && this.m_6084_()) {
            this.trueHurt();
        }
        if (this.getAttackTick() > 0) {
            if (this.m_5448_() != null && this.getAttackTick() > 18) {
                this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
            }
            this.m_21573_().m_26573_();
        }
        if (this.m_5448_() == null && (livingEntity = this.m_21188_()) instanceof Raider && (raider = (Raider)livingEntity).m_5448_() == this) {
            this.m_6710_((LivingEntity)raider);
        }
        if (this.m_5448_() == null || this.m_5448_() != null && !this.m_5448_().m_6084_() && this.m_5448_() instanceof Raider) {
            this.m_21561_(false);
            this.m_6710_(null);
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (this.getCoolingTick() <= 0) {
            if (!this.m_5912_()) {
                if (this.getCoolTick() > 0 && !this.m_9236_().m_5776_()) {
                    this.setCoolTick(this.getCoolTick() - 1);
                }
            } else if (!this.m_9236_().m_5776_()) {
                this.setCoolTick(this.getCoolTick() + 1);
            }
        } else if (this.getCoolTick() < 0 && !this.m_9236_().m_5776_()) {
            this.setCoolTick(0);
        }
        if (this.getCoolTick() >= 640 && this.m_6084_()) {
            if (!this.m_9236_().m_5776_()) {
                this.setCoolTick(0);
                this.setCoolingTick(60);
                this.setAnimTick(30);
                this.setAnimationState("cool");
            }
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.FIREPOWER_POURER_COOL, 5.0f, 1.0f);
            }
        }
        boolean bl = hell = "Hell Marcher".equals(string) || "HellMarcher".equals(string) || "  ".equals(string) || "\u5730\u72f1\u884c\u519b\u8005".equals(string);
        if (hell && this.f_19797_ % 10 == 0 && !this.m_9236_().m_5776_()) {
            this.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.FIRE_ABSORPTION.get(), 200, 2, false, false), (Entity)this);
        }
        if (this.getCoolingTick() > 0) {
            if (!this.m_9236_().m_5776_()) {
                this.setCoolingTick(this.getCoolingTick() - 1);
            }
            this.m_21573_().m_26573_();
            if (!this.m_9236_().m_5776_()) {
                this.f_21345_.m_25360_(Goal.Flag.MOVE, false);
                this.f_21345_.m_25360_(Goal.Flag.JUMP, false);
                this.f_21345_.m_25360_(Goal.Flag.LOOK, false);
            }
            if (this.m_9236_().m_5776_()) {
                int i;
                for (i = 0; i < 8; ++i) {
                    if (hell) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123747_, this.m_20208_(0.5), this.m_20188_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.m_20208_(0.5), this.m_20188_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
                        continue;
                    }
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20188_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20208_(0.5), this.m_20188_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
                }
                for (i = 0; i < 3; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_(), this.m_20188_(), this.m_20189_(), 0.0, 0.15, 0.0);
                }
            }
        } else if (this.getCoolingTick() < 0 && !this.m_9236_().m_5776_()) {
            this.setCoolingTick(0);
        }
        if (this.getShootUseTick() <= 0 && this.getShootTick() < 240 && this.getGunHealth() > 0.0f && !this.m_9236_().m_5776_()) {
            this.setShootTick(this.getShootTick() + 1);
        }
        if (this.getShootTick() >= 240 && this.m_6084_() && this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_5448_().m_20270_((Entity)this) > 8.0f && this.getGunHealth() > 0.0f) {
            if (!this.m_9236_().m_5776_()) {
                this.setShootTick(0);
                this.setShootUseTick(30);
                this.setAnimTick(15);
                this.setAnimationState("shoot");
            }
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.FIREPOWER_POURER_WANT_SHOOT, 5.0f, 1.0f);
            }
        }
        if (this.getShootUseTick() > 0 && this.getGunHealth() > 0.0f && this.m_6084_()) {
            if (this.m_5448_() != null && this.getShootUseTick() > 30) {
                this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
            }
            if (!this.m_9236_().m_5776_()) {
                this.setShootUseTick(this.getShootUseTick() - 1);
            }
            this.m_21573_().m_26573_();
            if (!this.m_9236_().f_46443_) {
                this.f_21345_.m_25360_(Goal.Flag.MOVE, false);
                this.f_21345_.m_25360_(Goal.Flag.JUMP, false);
            }
            if ((this.getShootUseTick() == 26 || this.getShootUseTick() == 24 || this.getShootUseTick() == 20 || this.getShootUseTick() == 18) && this.gun != null) {
                for (int i = 0; i < 3; ++i) {
                    if (this.m_5448_() != null) {
                        this.gun.m_7618_(EntityAnchorArgument.Anchor.EYES, this.m_5448_().m_20318_(0.5f));
                        this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
                        this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
                    }
                    float angleYaw = 1.3089969f;
                    float offsetY = 2.0f;
                    float radius = 3.0f;
                    float renderYawOffset = this.m_146908_();
                    VirtualCaveCrystalArrowEntity abstractArrow = new VirtualCaveCrystalArrowEntity((EntityType<? extends VirtualCaveCrystalArrowEntity>)((EntityType)JerotesVillageEntityType.VIRTUAL_CAVE_CRYSTAL_ARROW.get()), this.m_9236_());
                    abstractArrow.m_37251_((Entity)this, this.gun.m_146909_(), this.gun.m_146908_() - 3.0f + (float)(i * 3), 0.0f, 3.0f, 0.0f);
                    abstractArrow.m_20256_(abstractArrow.m_20184_().m_82520_(0.0, 0.5, 0.0));
                    abstractArrow.m_6034_(this.f_19854_ + (double)(radius * Mth.m_14089_((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)angleYaw)))), this.f_19855_ + (double)offsetY, this.f_19856_ + (double)(radius * Mth.m_14031_((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)angleYaw)))));
                    if (hell) {
                        abstractArrow.m_20254_(100);
                    }
                    abstractArrow.m_5602_((Entity)this);
                    this.m_9236_().m_7967_((Entity)abstractArrow);
                }
                if (!this.m_20067_()) {
                    this.m_5496_(JerotesVillageSounds.FIREPOWER_POURER_SHOOT, 5.0f, 1.0f);
                }
            }
        }
        if (this.getGunHealth() <= 0.0f && !this.m_9236_().m_5776_()) {
            this.setShootTick(0);
            this.setShootUseTick(0);
        }
        if (hell) {
            this.m_20095_();
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean hell;
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        boolean bl = hell = "Hell Marcher".equals(string) || "HellMarcher".equals(string) || "Hellmarcher".equals(string) || "\u5730\u72f1\u884c\u519b\u8005".equals(string);
        if (this.getCoolingTick() > 0 || this.getShootUseTick() > 0 || this.getAttackTick() > 0) {
            return false;
        }
        if (this.getAttackTick() > -10 && !hell) {
            return false;
        }
        this.chainsawAbout();
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(20);
            float f = 0.1f;
            if (hell) {
                f = 0.4f;
            }
            if (this.m_217043_().m_188501_() > f) {
                this.setAnimTick(10);
                int attackRandom = this.m_217043_().m_188503_(40);
                if (hell) {
                    if (attackRandom > 35) {
                        this.setAttackUse(1);
                        this.setAnimationState("attack1");
                    } else if (attackRandom > 10) {
                        this.setAttackUse(2);
                        this.setAnimationState("attack2");
                    } else if (attackRandom > 5) {
                        this.setAttackUse(3);
                        this.setAnimationState("attack3");
                    } else {
                        this.setAttackUse(4);
                        this.setAnimationState("attack4");
                    }
                } else if (attackRandom > 30) {
                    this.setAttackUse(1);
                    this.setAnimationState("attack1");
                } else if (attackRandom > 20) {
                    this.setAttackUse(2);
                    this.setAnimationState("attack2");
                } else if (attackRandom > 10) {
                    this.setAttackUse(3);
                    this.setAnimationState("attack3");
                } else {
                    this.setAttackUse(4);
                    this.setAnimationState("attack4");
                }
            } else {
                this.setAttackUse(5);
                this.setAnimTick(20);
                this.setAnimationState("attack5");
            }
        }
        return true;
    }

    public boolean trueHurt() {
        boolean fire = false;
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if ("Hell Marcher".equals(string) || "HellMarcher".equals(string) || "Hellmarcher".equals(string) || "\u5730\u72f1\u884c\u519b\u8005".equals(string)) {
            fire = true;
        }
        if (this.getCoolingTick() > 0 || this.getShootUseTick() > 0) {
            return false;
        }
        if (!this.m_20067_()) {
            if (this.getChainsawHealth() > 0.0f) {
                this.m_5496_(JerotesVillageSounds.FIREPOWER_POURER_ATTACK_2, 1.0f, 1.0f);
            } else {
                this.m_5496_(JerotesVillageSounds.FIREPOWER_POURER_ATTACK_1, 1.0f, 1.0f);
            }
        }
        float reach = 0.5f;
        if (this.getAttackUse() == 5) {
            reach = 0.75f;
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_((double)reach));
        for (LivingEntity hurt : list) {
            boolean bl;
            if (hurt == null || this.m_20280_((Entity)hurt) > 64.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || !Main.canSee((Entity)hurt, (Entity)this) && this.getAttackUse() != 5) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            float base = 1.0f;
            if (fire) {
                base = 1.25f;
            }
            if (this.getChainsawHealth() > 0.0f && (this.getAttackUse() == 2 || this.getAttackUse() == 5)) {
                DamageSource damageSources = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(JerotesDamageTypes.BYPASSES_COOLDOWN_MELEE), (Entity)this);
                bl = AttackFind.attackAfterCustomDamage((LivingEntity)this, (Entity)hurt, (DamageSource)damageSources, (float)(0.4f * base), (float)0.1f, (boolean)false, (float)0.0f);
            } else {
                bl = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)base, (float)1.0f, (boolean)false, (float)0.0f);
            }
            if (!bl) continue;
            if (this.getChainsawHealth() > 0.0f && !hurt.m_9236_().m_5776_()) {
                hurt.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.BLEEDING.get(), 60, 0), (Entity)this);
            }
            if (!fire) continue;
            hurt.m_20254_(14);
        }
        Main.sweepAttack((Entity)this);
        if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
            ItemStack hand = this.m_21205_();
            hand.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_276093_(DamageTypes.f_268612_) || damageSource.m_269533_(DamageTypeTags.f_268581_)) {
            return true;
        }
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if (("Hell Marcher".equals(string) || "HellMarcher".equals(string) || "Hellmarcher".equals(string) || "\u5730\u72f1\u884c\u519b\u8005".equals(string)) && damageSource.m_269533_(DamageTypeTags.f_268745_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        LivingEntity livingEntity;
        Entity entity;
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        float damage = 1.0f;
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if ("Hell Marcher".equals(string) || "HellMarcher".equals(string) || "Hellmarcher".equals(string) || "\u5730\u72f1\u884c\u519b\u8005".equals(string)) {
            damage *= 0.75f;
        }
        this.chainsawAbout();
        if (this.getCoolingTick() > 0) {
            damage *= 1.5f;
        }
        if ((entity = damageSource.m_7639_()) instanceof LivingEntity && EntityFactionFind.isHumanoid((LivingEntity)(livingEntity = (LivingEntity)entity)) && EntityAndItemFind.isMeleeDamage((DamageSource)damageSource)) {
            damage *= 0.5f;
        }
        return super.m_6469_(damageSource, amount * damage);
    }

    public boolean hurtByGunPart(DamageSource damageSource, float f) {
        boolean bl = this.m_6469_(damageSource, f * 0.1f);
        if (bl && this.getGunHealth() > 0.0f && damageSource.m_7639_() != this && !this.m_9236_().m_5776_()) {
            if (f > this.getGunHealth()) {
                Level level;
                ItemStack itemStack = new ItemStack((ItemLike)JerotesVillageItems.FIREPOWER_POURER_CROSSBOW.get());
                itemStack.m_41721_(itemStack.m_41776_() / 2 + 1);
                ItemEntity itemEntity = this.m_5552_(itemStack, 1.0f);
                if (itemEntity != null) {
                    itemEntity.m_6034_(this.m_20185_(), this.m_20188_() + 0.2, this.m_20189_());
                    itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.2f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
                }
                if ((level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 8; ++i) {
                        serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50183_.m_49966_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.3, 0.0, 0.3, 0.0);
                    }
                }
                this.handBreak2();
                if (this.getChainsawHealth() <= 0.0f && (level = damageSource.m_7639_()) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)level;
                    AdvancementEvent.AdvancementGive(serverPlayer, "jerotesvillage:disarmed");
                }
            }
            this.setGunHealth(this.getGunHealth() - f);
        }
        return bl;
    }

    public boolean hurtByChainsawPart(DamageSource damageSource, float f) {
        boolean bl = this.m_6469_(damageSource, f * 0.1f);
        if (bl && this.getChainsawHealth() > 0.0f && damageSource.m_7639_() != this && !this.m_9236_().f_46443_) {
            if (f > this.getChainsawHealth()) {
                Level level;
                this.chainsawAbout();
                ItemStack itemStack = new ItemStack((ItemLike)JerotesVillageItems.FIREPOWER_POURER_CHAINSAW.get());
                itemStack.m_41721_(itemStack.m_41776_() / 2 + 1);
                ItemEntity itemEntity = this.m_5552_(itemStack, 1.0f);
                if (itemEntity != null) {
                    itemEntity.m_6034_(this.m_20185_(), this.m_20188_() + 0.2, this.m_20189_());
                    itemEntity.m_20256_(itemEntity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.2f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
                }
                if ((level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 8; ++i) {
                        serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50183_.m_49966_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.3, 0.0, 0.3, 0.0);
                    }
                }
                this.handBreak1();
                if (this.getGunHealth() <= 0.0f && (level = damageSource.m_7639_()) instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)level;
                    AdvancementEvent.AdvancementGive(serverPlayer, "jerotesvillage:disarmed");
                }
            }
            this.setChainsawHealth(this.getChainsawHealth() - f);
        }
        return bl;
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

