/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.IllagerFaction;

import com.google.common.collect.Maps;
import com.jerotes.jerotes.entity.InventoryEntity;
import com.jerotes.jerotes.entity.UseThrowEntity;
import com.jerotes.jerotes.entity.UseThrownJavelinEntity;
import com.jerotes.jerotes.entity.arrow.BaseJavelinEntity;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedJavelinAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedThrowAttackGoal;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotesvillage.entity.Monster.IllagerFaction.MeleeIllagerEntity;
import com.jerotes.jerotesvillage.entity.Shoot.Arrow.ThrownOminousJavalinEntity;
import com.jerotes.jerotesvillage.entity.in.AlwaysShowArmIllagerEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class JavelinThrowerEntity
extends MeleeIllagerEntity
implements AlwaysShowArmIllagerEntity,
UseThrowEntity,
RangedAttackMob,
UseThrownJavelinEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState itemAttackAnimationState = new AnimationState();
    public AnimationState throw1AnimationState = new AnimationState();
    public AnimationState throw2AnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> JAVELIN_COUNT = SynchedEntityData.m_135353_(JavelinThrowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> LIMITED_JAVELIN = SynchedEntityData.m_135353_(JavelinThrowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("0f16775e-c5ad-4472-98db-7aea68887638");
    public int javalinCountMax = 5;

    public JavelinThrowerEntity(EntityType<? extends JavelinThrowerEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 20;
        this.m_21553_(false);
    }

    public boolean UseThrownJavelinEntityStopUse() {
        return false;
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Monster.m_33035_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 32.0);
        builder = builder.m_22268_(Attributes.f_22284_, 3.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new JerotesRangedJavelinAttackGoal<JavelinThrowerEntity>((RangedAttackMob)this, 0.4, 60, 12.0f, this.meleeOrRangeDistance()){

            public boolean m_8036_() {
                String string = ChatFormatting.m_126649_((String)JavelinThrowerEntity.this.m_7755_().getString());
                if (JavelinThrowerEntity.this.getJavalinCount() <= 0 && JavelinThrowerEntity.this.isLimitedJavelin() && !"Armored".equals(string)) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                String string = ChatFormatting.m_126649_((String)JavelinThrowerEntity.this.m_7755_().getString());
                if (JavelinThrowerEntity.this.getJavalinCount() <= 0 && JavelinThrowerEntity.this.isLimitedJavelin() && !"Armored".equals(string)) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new JerotesRangedThrowAttackGoal((RangedAttackMob)this, 0.4, 40, 12.0f));
        this.f_21345_.m_25352_(1, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.1, true));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                if (JavelinThrowerEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        ItemStack handItem = this.m_21205_();
        if ((this.m_21205_().m_41619_() || InventoryEntity.isMeleeWeapon((ItemStack)this.m_21205_())) && !this.m_21206_().m_41619_()) {
            handItem = this.m_21206_();
        }
        if (InventoryEntity.isThrow((ItemStack)handItem)) {
            this.useThrowShoot((LivingEntity)this, livingEntity);
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesSounds.ITEM_THROW, this.m_5720_(), 0.5f, 0.4f / (this.m_9236_().m_213780_().m_188501_() * 0.4f + 0.8f));
            }
            if (!this.m_9236_().m_5776_()) {
                this.setAnimTick(10);
                if (handItem == this.m_21205_()) {
                    this.setAnimationState("throw1");
                } else {
                    this.setAnimationState("throw2");
                }
            }
        }
        if ((this.getJavalinCount() > 0 || !this.isLimitedJavelin() || "Armored".equals(string)) && InventoryEntity.isRangeJavelin((ItemStack)handItem)) {
            this.useTridentShoot((LivingEntity)this, livingEntity, 1.6f);
            if ("Armored".equals(string)) {
                this.m_21563_().m_24960_((Entity)livingEntity, 360.0f, 360.0f);
                this.m_21391_((Entity)livingEntity, 360.0f, 360.0f);
                ThrownOminousJavalinEntity spear1 = new ThrownOminousJavalinEntity(this.m_9236_(), (LivingEntity)this, new ItemStack((ItemLike)JerotesVillageItems.OMINOUS_JAVELIN.get()));
                ThrownOminousJavalinEntity spear2 = new ThrownOminousJavalinEntity(this.m_9236_(), (LivingEntity)this, new ItemStack((ItemLike)JerotesVillageItems.OMINOUS_JAVELIN.get()));
                double d = livingEntity.m_20185_() - this.m_20185_();
                double d2 = livingEntity.m_20227_(0.3333333333333333) - spear1.m_20186_();
                double d3 = livingEntity.m_20189_() - this.m_20189_();
                double d4 = Math.sqrt(d * d + d3 * d3);
                spear1.m_6686_(d, d2 + d4 * (double)0.2f, d3, 1.6f, 4.0f);
                spear2.m_6686_(d, d2 + d4 * (double)0.2f, d3, 1.6f, 4.0f);
                this.m_9236_().m_7967_((Entity)spear1);
                this.m_9236_().m_7967_((Entity)spear2);
            }
            if (!this.m_9236_().m_5776_()) {
                this.setThrowTick(60);
                this.setAnimTick(10);
                if (handItem == this.m_21205_()) {
                    this.setAnimationState("throw1");
                } else {
                    this.setAnimationState("throw2");
                }
            }
            if (!"Armored".equals(string) && !this.m_9236_().m_5776_()) {
                this.setJavelinCount(this.getJavalinCount() - 1);
            }
        }
        if (JerotesGameRules.JEROTES_RANGE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_RANGE_CAN_BREAK) && (handItem.m_41720_() instanceof BowItem || handItem.m_41720_() instanceof TridentItem)) {
            handItem.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    @Override
    public boolean canUseRangeJavelin() {
        return true;
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.JAVELIN_THROWER_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.JAVELIN_THROWER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (this.m_21275_(damageSource)) {
            return SoundEvents.f_12346_;
        }
        return JerotesVillageSounds.JAVELIN_THROWER_HURT;
    }

    @Override
    public SoundEvent m_7930_() {
        return JerotesVillageSounds.JAVELIN_THROWER_CHEER;
    }

    @Override
    public void m_7895_(int n, boolean bl) {
        ItemStack itemStack = new ItemStack((ItemLike)JerotesVillageItems.OMINOUS_JAVELIN.get());
        Raid raid = this.m_37885_();
        int n2 = 1;
        if (n > raid.m_37724_(Difficulty.NORMAL)) {
            n2 = 2;
        }
        boolean bl2 = this.f_19796_.m_188501_() <= raid.m_37783_();
        boolean bl3 = bl2;
        if (bl2) {
            HashMap hashMap = Maps.newHashMap();
            hashMap.put(Enchantments.f_44982_, n2);
            EnchantmentHelper.m_44865_((Map)hashMap, (ItemStack)itemStack);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
    }

    public void setJavelinCount(int n) {
        this.m_20088_().m_135381_(JAVELIN_COUNT, (Object)n);
    }

    public int getJavalinCount() {
        return (Integer)this.m_20088_().m_135370_(JAVELIN_COUNT);
    }

    public void setLimitedJavelin(boolean bl) {
        this.m_20088_().m_135381_(LIMITED_JAVELIN, (Object)bl);
    }

    public boolean isLimitedJavelin() {
        return (Boolean)this.m_20088_().m_135370_(LIMITED_JAVELIN);
    }

    @Override
    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        if (Objects.equals(animation, "itemAttack")) {
            return 2;
        }
        if (Objects.equals(animation, "throw1")) {
            return 3;
        }
        if (Objects.equals(animation, "throw2")) {
            return 4;
        }
        return 0;
    }

    @Override
    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        list.add(this.itemAttackAnimationState);
        list.add(this.throw1AnimationState);
        list.add(this.throw2AnimationState);
        return list;
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22120_(ARMOR_MODIFIER_UUID);
        if (component != null && component.getString().equals("Armored")) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Armored armor", 8.0, AttributeModifier.Operation.ADDITION));
        }
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("JavalinCountMax", this.javalinCountMax);
        compoundTag.m_128405_("JavalinCount", this.getJavalinCount());
        compoundTag.m_128379_("LimitedJavelin", this.isLimitedJavelin());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.javalinCountMax = compoundTag.m_128451_("JavalinCountMax");
        this.setJavelinCount(compoundTag.m_128451_("JavalinCount"));
        this.setLimitedJavelin(compoundTag.m_128471_("LimitedJavelin"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(JAVELIN_COUNT, (Object)5);
        this.m_20088_().m_135372_(LIMITED_JAVELIN, (Object)true);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 2: {
                    this.itemAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.itemAttackAnimationState);
                    break;
                }
                case 3: {
                    this.throw1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.throw1AnimationState);
                    break;
                }
                case 4: {
                    this.throw2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.throw2AnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_5448_() == null && !this.m_9236_().m_5776_()) {
            this.setThrowTick(60);
        }
        if (!this.m_5912_() && this.getJavalinCount() < this.javalinCountMax && this.m_217043_().m_188503_(2400) == 1 && this.f_20919_ == 0 && !this.m_9236_().m_5776_()) {
            this.setJavelinCount(this.getJavalinCount() + 1);
        }
        List listSelfJavelin = this.m_9236_().m_45976_(BaseJavelinEntity.class, this.m_20191_().m_82377_(1.0, 1.0, 1.0));
        listSelfJavelin.removeIf(ominousJavalin -> ominousJavalin.m_19749_() != this);
        double d = Double.MAX_VALUE;
        for (BaseJavelinEntity ominousJavalin2 : listSelfJavelin) {
            if (ominousJavalin2 == null || this.m_20280_((Entity)ominousJavalin2) > d || !ominousJavalin2.m_20096_()) continue;
            ominousJavalin2.m_146870_();
            if (!this.m_9236_().m_5776_() && this.getJavalinCount() < this.javalinCountMax) {
                this.setJavelinCount(this.getJavalinCount() + 1);
            }
            if (this.m_20067_()) continue;
            this.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
        }
        if (this.getAttackTick() < -8 && this.getThrowTick() > 50 && this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(0);
            if (this.m_21205_().m_41619_()) {
                this.setAnimTick(5);
                this.setAnimationState("attack");
            } else {
                this.setAnimTick(8);
                this.setAnimationState("itemAttack");
            }
        }
        this.idleAnimationState.m_216973_();
        boolean bl = super.m_7327_(entity);
        if (bl && !this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.JAVELIN_THROWER_ATTACK, 1.0f, 1.0f);
        }
        return bl;
    }

    public boolean m_6673_(DamageSource damageSource) {
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if ("Armored".equals(string) && damageSource.m_269533_(DamageTypeTags.f_268549_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        SpawnGroupData spawnGroupData2 = super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
        if (mobSpawnType != MobSpawnType.CONVERSION) {
            this.setJavelinCount(this.javalinCountMax);
        }
        return spawnGroupData2;
    }

    @Override
    public ItemStack createSpawnWeapon(float weaponRandom) {
        return new ItemStack((ItemLike)JerotesVillageItems.OMINOUS_JAVELIN.get());
    }
}

