/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.IllagerFaction;

import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotesvillage.entity.Monster.IllagerFaction.SpellIllagerEntity;
import com.jerotes.jerotesvillage.goal.BigWitchAttackGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageBlocks;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class LampWizardEntity
extends SpellIllagerEntity
implements RangedAttackMob,
SpellUseEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState shoot1AnimationState = new AnimationState();
    public AnimationState shoot2AnimationState = new AnimationState();
    public AnimationState shoot3AnimationState = new AnimationState();
    public int spellLevel = 2;

    public LampWizardEntity(EntityType<? extends LampWizardEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 25;
        this.m_21553_(false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Monster.m_33035_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 32.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BigWitchAttackGoal(this, 0.4, 80, 12.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, false){

            public boolean m_8036_() {
                if (LampWizardEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        int spellLevel = this.getSpellLevel();
        if (this.f_19796_.m_188501_() > 0.65f || this.m_20270_((Entity)livingEntity) > 24.0f) {
            if (!this.m_9236_().m_5776_()) {
                this.setSpellTick(20);
                this.setAnimTick(15);
                this.setAnimationState("shoot1");
            }
            OtherSpellList.ArcaneLightSpot(this.getSpellLevel(), (LivingEntity)this, (Entity)livingEntity).spellUse();
        } else if (this.f_19796_.m_188501_() > 0.75f) {
            if (!this.m_9236_().m_5776_()) {
                this.setSpellTick(20);
                this.setAnimTick(15);
                this.setAnimationState("shoot2");
            }
            OtherSpellList.ElasticLightBall(this.getSpellLevel(), (LivingEntity)this, (Entity)livingEntity).spellUse();
        } else {
            if (!this.m_9236_().m_5776_()) {
                this.setSpellTick(20);
                this.setAnimTick(16);
                this.setAnimationState("shoot3");
            }
            OtherSpellList.RadiantBomb(this.getSpellLevel(), (LivingEntity)this, (Entity)livingEntity).spellUse();
        }
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.LAMP_WIZARD_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.LAMP_WIZARD_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.LAMP_WIZARD_HURT;
    }

    @Override
    public SoundEvent m_7930_() {
        return JerotesVillageSounds.LAMP_WIZARD_CHEER;
    }

    @Override
    protected SoundEvent m_7894_() {
        return JerotesVillageSounds.LAMP_WIZARD_SHOOT_1;
    }

    @Override
    public SpellcasterIllager.IllagerSpell customSpell() {
        return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
    }

    public boolean m_6060_() {
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if ("Soul Lampologer".equals(string) || "Soullampologer".equals(string) || "Lampologer".equals(string)) {
            return false;
        }
        return super.m_6060_();
    }

    @Override
    public int getSpellLevel() {
        return this.spellLevel;
    }

    @Override
    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "shoot1")) {
            return 1;
        }
        if (Objects.equals(animation, "shoot2")) {
            return 2;
        }
        if (Objects.equals(animation, "shoot3")) {
            return 3;
        }
        return 0;
    }

    @Override
    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.shoot1AnimationState);
        list.add(this.shoot2AnimationState);
        list.add(this.shoot3AnimationState);
        return list;
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.shoot1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shoot1AnimationState);
                    break;
                }
                case 2: {
                    this.shoot2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shoot2AnimationState);
                    break;
                }
                case 3: {
                    this.shoot3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shoot3AnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if ("Soul Lampologer".equals(string) || "Soullampologer".equals(string) || "Lampologer".equals(string)) {
            this.m_20095_();
            if (this.m_9236_().m_5776_()) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123745_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        if (this.f_19797_ % 20 == 0 && this.f_20919_ == 0 && !this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            BlockState blockState = ((Block)JerotesVillageBlocks.GLOW_SHINE.get()).m_49966_();
            BlockPos blockPos = this.m_20097_().m_7494_().m_7494_();
            if ((this.m_9236_().m_8055_(blockPos).m_60795_() || this.m_9236_().m_8055_(blockPos).m_60734_() == JerotesVillageBlocks.GLOW_SHINE.get()) && blockState.m_60710_((LevelReader)this.m_9236_(), blockPos)) {
                this.m_9236_().m_46597_(blockPos, blockState);
                this.m_9236_().m_220407_(GameEvent.f_157797_, blockPos, GameEvent.Context.m_223719_((Entity)this, (BlockState)blockState));
            }
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if (("Soul Lampologer".equals(string) || "Soullampologer".equals(string) || "Lampologer".equals(string)) && (damageSource.m_276093_(DamageTypes.f_268493_) || damageSource.m_276093_(DamageTypes.f_268641_) || damageSource.m_269533_(DamageTypeTags.f_268745_))) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (EntityAndItemFind.MagicResistance((DamageSource)damagesource)) {
            return super.m_6469_(damagesource, amount / 5.0f);
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_214076_(ServerLevel serverLevel, LivingEntity livingEntity) {
        boolean bl = super.m_214076_(serverLevel, livingEntity);
        if (livingEntity instanceof Villager) {
            Villager villager = (Villager)livingEntity;
            villager.m_35311_().m_19195_().forEach(arg_0 -> ((LampWizardEntity)this).m_19983_(arg_0));
            ZombieVillager zombieVillager = (ZombieVillager)villager.m_21406_(EntityType.f_20530_, false);
            if (zombieVillager != null) {
                zombieVillager.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(zombieVillager.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true), null);
                zombieVillager.m_34375_(villager.m_7141_());
                zombieVillager.m_34391_((Tag)villager.m_35517_().m_262795_((DynamicOps)NbtOps.f_128958_));
                zombieVillager.m_34411_(villager.m_6616_().m_45388_());
                zombieVillager.m_34373_(villager.m_7809_());
                if (!this.m_20067_()) {
                    serverLevel.m_5898_(null, 1026, this.m_20183_(), 0);
                }
                bl = false;
            }
        }
        return bl;
    }
}

