/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.IllagerFaction;

import com.google.common.collect.Maps;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotesvillage.control.QoaikuMoveControl;
import com.jerotes.jerotesvillage.entity.Monster.IllagerFaction.MeleeIllagerEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class SubmarinerEntity
extends MeleeIllagerEntity
implements SpellUseEntity {
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState itemAttackAnimationState = new AnimationState();
    public AnimationState waveAnimationState = new AnimationState();
    public AnimationState waveInWaterAnimationState = new AnimationState();
    public boolean isLandNavigatorType = true;
    public int spellLevel = 2;

    public SubmarinerEntity(EntityType<? extends SubmarinerEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 25;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Monster.m_33035_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.36);
        builder = builder.m_22268_(Attributes.f_22276_, 24.0);
        builder = builder.m_22268_(Attributes.f_22284_, 3.0);
        builder = builder.m_22268_(Attributes.f_22281_, 6.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.1, true));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                if (SubmarinerEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.SUBMARINER_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.SUBMARINER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (this.m_21275_(damageSource)) {
            return SoundEvents.f_12346_;
        }
        return JerotesVillageSounds.SUBMARINER_HURT;
    }

    @Override
    public SoundEvent m_7930_() {
        return JerotesVillageSounds.SUBMARINER_CHEER;
    }

    @Override
    public void m_7895_(int n, boolean bl) {
        ItemStack itemStack = new ItemStack((ItemLike)JerotesVillageItems.OMINOUS_DAGGER.get());
        Raid raid = this.m_37885_();
        int n2 = 1;
        if (n > raid.m_37724_(Difficulty.NORMAL)) {
            n2 = 2;
        }
        boolean bl2 = this.f_19796_.m_188501_() <= raid.m_37783_();
        boolean bl3 = bl2;
        if (bl2) {
            HashMap hashMap = Maps.newHashMap();
            hashMap.put(Enchantments.f_44977_, n2);
            EnchantmentHelper.m_44865_((Map)hashMap, (ItemStack)itemStack);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigation((Mob)this, level);
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.75));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
            if (this.getSpellTick() > 220) {
                this.m_20256_(this.m_20184_().m_82542_(0.05, 1.0, 0.05));
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
                    this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
                }
            }
        } else {
            super.m_7023_(vec3);
            if (this.getSpellTick() > 220) {
                this.m_20256_(this.m_20184_().m_82542_(0.05, 1.0, 0.05));
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 10.0f, 10.0f);
                    this.m_21391_((Entity)this.m_5448_(), 10.0f, 10.0f);
                }
            }
        }
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    @Override
    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        if (Objects.equals(animation, "itemAttack")) {
            return 2;
        }
        if (Objects.equals(animation, "wave")) {
            return 3;
        }
        if (Objects.equals(animation, "waveInWater")) {
            return 4;
        }
        return 0;
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        this.m_252802_(compoundTag);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.m_253224_(compoundTag);
    }

    @Override
    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        list.add(this.itemAttackAnimationState);
        list.add(this.waveAnimationState);
        list.add(this.waveInWaterAnimationState);
        return list;
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 2: {
                    this.itemAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.itemAttackAnimationState);
                    break;
                }
                case 3: {
                    this.waveAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.waveAnimationState);
                    break;
                }
                case 4: {
                    this.waveInWaterAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.waveInWaterAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8107_() {
        BlockState blockState;
        super.m_8107_();
        if (this.m_20069_() && this.isLandNavigatorType) {
            this.f_21342_ = new QoaikuMoveControl((Mob)this);
            this.f_21344_ = new AmphibiousPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigatorType = false;
        }
        if (!this.m_20069_() && !this.isLandNavigatorType) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigatorType = true;
        }
        if (this.m_21573_().m_26570_() != null && !this.m_21573_().m_26571_() && (!(blockState = this.m_9236_().m_8055_(this.m_21573_().m_26570_().m_77406_())).m_60819_().m_76178_() && !blockState.m_60795_() || this.m_5448_() != null && this.m_5448_().m_20096_()) && this.m_20069_() && this.f_19862_) {
            for (int n = 0; n < 18; ++n) {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), 0, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.2, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.5);
            }
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
        }
        if (this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_()) && this.getSpellTick() <= 0 && this.m_20270_((Entity)this.m_5448_()) < 6.0f && !this.m_9236_().m_5776_()) {
            this.setSpellTick(240);
            this.setAnimTick(20);
            if (this.m_20069_()) {
                this.setAnimationState("waveInWater");
            } else {
                this.setAnimationState("wave");
            }
        }
        if (this.getSpellTick() > 220) {
            if (this.m_20069_()) {
                this.waveAnimationState.m_216973_();
            } else {
                this.waveInWaterAnimationState.m_216973_();
            }
        }
        if (this.getSpellTick() == 225) {
            OtherSpellList.GemstoneWaves(this.getSpellLevel(), (LivingEntity)this, (Entity)this).spellUse();
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (this.getSpellTick() > 220) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.m_21205_().m_41619_()) {
                this.setAnimTick(5);
                this.setAnimationState("attack");
            } else {
                this.setAnimTick(10);
                this.setAnimationState("itemAttack");
            }
        }
        if ((bl = super.m_7327_(entity)) && !this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.SUBMARINER_ATTACK, 1.0f, 1.0f);
        }
        return bl;
    }

    @Override
    public ItemStack createSpawnWeapon(float weaponRandom) {
        return new ItemStack((ItemLike)JerotesVillageItems.OMINOUS_DAGGER.get());
    }

    @Override
    public ItemStack createSpawnOffhand(float offhandRandom) {
        return new ItemStack((ItemLike)JerotesVillageItems.OMINOUS_DAGGER.get());
    }
}

