/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster.IllagerFaction;

import com.google.common.collect.Maps;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotesvillage.entity.Monster.IllagerFaction.MeleeIllagerEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellFind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TrumpeterEntity
extends MeleeIllagerEntity
implements SpellUseEntity {
    private static final EntityDataAccessor<Integer> BLOW_TICK = SynchedEntityData.m_135353_(TrumpeterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState itemAttackAnimationState = new AnimationState();
    public AnimationState blowAnimationState = new AnimationState();
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("5e71e582-5631-478e-bc04-ef5c1301b532");
    public int spellLevel = 1;

    public TrumpeterEntity(EntityType<? extends TrumpeterEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 25;
        this.m_21553_(false);
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Monster.m_33035_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.32);
        builder = builder.m_22268_(Attributes.f_22276_, 32.0);
        builder = builder.m_22268_(Attributes.f_22284_, 3.0);
        builder = builder.m_22268_(Attributes.f_22281_, 6.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.1, true));
        this.f_21345_.m_25352_(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                if (TrumpeterEntity.this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.TRUMPETER_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.TRUMPETER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (this.m_21275_(damageSource)) {
            return SoundEvents.f_12346_;
        }
        return JerotesVillageSounds.TRUMPETER_HURT;
    }

    @Override
    public SoundEvent m_7930_() {
        return JerotesVillageSounds.TRUMPETER_CHEER;
    }

    @Override
    public void m_7895_(int n, boolean bl) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42383_);
        Raid raid = this.m_37885_();
        int n2 = 1;
        if (n > raid.m_37724_(Difficulty.NORMAL)) {
            n2 = 2;
        }
        boolean bl2 = this.f_19796_.m_188501_() <= raid.m_37783_();
        boolean bl3 = bl2;
        if (bl2) {
            HashMap hashMap = Maps.newHashMap();
            hashMap.put(Enchantments.f_44977_, n2);
            EnchantmentHelper.m_44865_((Map)hashMap, (ItemStack)itemStack);
        }
        this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
    }

    public void m_7023_(Vec3 vec3) {
        super.m_7023_(vec3);
        if (this.getBlowTick() < 1) {
            this.m_20256_(this.m_20184_().m_82542_(0.05, 1.0, 0.05));
        }
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public void setBlowTick(int n) {
        this.m_20088_().m_135381_(BLOW_TICK, (Object)n);
    }

    public int getBlowTick() {
        return (Integer)this.m_20088_().m_135370_(BLOW_TICK);
    }

    @Override
    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        if (Objects.equals(animation, "itemAttack")) {
            return 2;
        }
        if (Objects.equals(animation, "blow")) {
            return 3;
        }
        return 0;
    }

    @Override
    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        list.add(this.itemAttackAnimationState);
        list.add(this.blowAnimationState);
        return list;
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22120_(ARMOR_MODIFIER_UUID);
        if (component != null && component.getString().equals("Elite")) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Elite armor", 6.0, AttributeModifier.Operation.ADDITION));
        }
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("BlowTick", this.getBlowTick());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.setBlowTick(compoundTag.m_128451_("BlowTick"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(BLOW_TICK, (Object)10);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 2: {
                    this.itemAttackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.itemAttackAnimationState);
                    break;
                }
                case 3: {
                    this.blowAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.blowAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        int spellLevel = this.getSpellLevel();
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if ("Elite".equals(string)) {
            spellLevel = this.getSpellLevel() + 1;
        }
        if (this.getBlowTick() > 1) {
            if (!this.m_9236_().m_5776_()) {
                this.setBlowTick(this.getBlowTick() - 1);
            }
        } else if (this.getBlowTick() < 1 && this.getBlowTick() > -30 && !this.m_9236_().m_5776_()) {
            this.setBlowTick(this.getBlowTick() - 1);
        }
        if (this.getBlowTick() == 1 && this.m_21206_().m_150930_(Items.f_220219_) && this.m_5448_() != null && !this.m_9236_().m_5776_()) {
            this.setBlowTick(0);
        }
        if (this.getBlowTick() == 0) {
            if (!this.m_9236_().m_5776_()) {
                this.setAnimTick(30);
                this.setAnimationState("blow");
            }
            this.m_6672_(InteractionHand.OFF_HAND);
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.TRUMPETER_BLOW, this.m_5720_(), 10.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
        }
        if (this.getBlowTick() <= -30) {
            if (!this.m_9236_().m_5776_()) {
                this.setBlowTick(360);
            }
            OtherSpellFind.OminousHorn((LivingEntity)this, spellLevel * 30, spellLevel, spellLevel * 12, spellLevel + 2, 32);
        }
        if (this.getBlowTick() > 1 && this.f_20935_.m_150930_(Items.f_220219_)) {
            this.m_5810_();
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (this.getBlowTick() < 1) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.m_21205_().m_41619_()) {
                this.setAnimTick(5);
                this.setAnimationState("attack");
            } else {
                this.setAnimTick(10);
                this.setAnimationState("itemAttack");
            }
        }
        if ((bl = super.m_7327_(entity)) && !this.m_20067_()) {
            this.m_5496_(JerotesVillageSounds.TRUMPETER_ATTACK, 1.0f, 1.0f);
        }
        return bl;
    }

    @Override
    public ItemStack createSpawnWeapon(float weaponRandom) {
        return new ItemStack((ItemLike)Items.f_42383_);
    }

    @Override
    public ItemStack createSpawnOffhand(float offhandRandom) {
        return new ItemStack((ItemLike)Items.f_220219_);
    }
}

