/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotesvillage.entity.Humanoid.SecondRounderEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageBiomes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PredationToothedFlowerEntity
extends Monster
implements RangedAttackMob,
JerotesEntity,
SpellUseEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState shootAnimationState = new AnimationState();
    public AnimationState hideAnimationState = new AnimationState();
    public AnimationState unHideAnimationState = new AnimationState();
    public AnimationState inHideAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(PredationToothedFlowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(PredationToothedFlowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> UN_HIDE = SynchedEntityData.m_135353_(PredationToothedFlowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> HIDE_TICK = SynchedEntityData.m_135353_(PredationToothedFlowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOOT_TICK = SynchedEntityData.m_135353_(PredationToothedFlowerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int spellLevel = 1;
    private int hideAboutTick;

    public PredationToothedFlowerEntity(EntityType<? extends PredationToothedFlowerEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(0.0f);
        this.f_21364_ = 20;
        this.m_6862_(false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.25, true){

            public boolean m_8045_() {
                return PredationToothedFlowerEntity.this.getShootTick() > 0 && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal(this, 1.0, 40, 20.0f){

            public boolean m_8045_() {
                return PredationToothedFlowerEntity.this.m_5448_() != null && PredationToothedFlowerEntity.this.getShootTick() <= 0 && PredationToothedFlowerEntity.this.m_20280_((Entity)PredationToothedFlowerEntity.this.m_5448_()) > 8.0 && super.m_8045_();
            }
        });
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, SecondRounderEntity.class, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        if (this.hideAboutTick < 140) {
            this.hideAboutTick = 140;
        }
        if (this.getHideTick() > 0) {
            return;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setShootTick(85);
            this.setAnimTick(10);
            this.setAnimationState("shoot");
        }
        OtherSpellList.PredationToothedFlowerShoot(this.getSpellLevel(), (LivingEntity)this, (Entity)livingEntity).spellUse();
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22288_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22282_, 1.0);
        builder = builder.m_22268_(Attributes.f_22281_, 7.0);
        builder = builder.m_22268_(Attributes.f_22277_, 24.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        return builder;
    }

    public SoundEvent m_7515_() {
        return JerotesVillageSounds.PREDATION_TOOTHED_FLOWER_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.PREDATION_TOOTHED_FLOWER_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.PREDATION_TOOTHED_FLOWER_DEATH;
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6862_(false);
        if (!this.m_9236_().m_5776_()) {
            this.f_21345_.m_25360_(Goal.Flag.JUMP, false);
        }
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public void setUnHide(boolean bl) {
        this.m_20088_().m_135381_(UN_HIDE, (Object)bl);
    }

    public boolean isUnHide() {
        return (Boolean)this.m_20088_().m_135370_(UN_HIDE);
    }

    public void setHideTick(int n) {
        this.m_20088_().m_135381_(HIDE_TICK, (Object)n);
    }

    public int getHideTick() {
        return (Integer)this.m_20088_().m_135370_(HIDE_TICK);
    }

    public void setShootTick(int n) {
        this.m_20088_().m_135381_(SHOOT_TICK, (Object)n);
    }

    public int getShootTick() {
        return (Integer)this.m_20088_().m_135370_(SHOOT_TICK);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        if (Objects.equals(animation, "shoot")) {
            return 2;
        }
        if (Objects.equals(animation, "hide")) {
            return 3;
        }
        if (Objects.equals(animation, "unHide")) {
            return 4;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        list.add(this.shootAnimationState);
        list.add(this.hideAnimationState);
        list.add(this.unHideAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128379_("IsUnHide", this.isUnHide());
        compoundTag.m_128405_("UnHideTick", this.getHideTick());
        compoundTag.m_128405_("ShootTick", this.getShootTick());
        compoundTag.m_128405_("HideAboutTick", this.hideAboutTick);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.setUnHide(compoundTag.m_128471_("UnHide"));
        this.setHideTick(compoundTag.m_128451_("HideTick"));
        this.setShootTick(compoundTag.m_128451_("ShootTick"));
        this.hideAboutTick = compoundTag.m_128451_("HideAboutTick");
        this.m_20011_(this.m_142242_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(UN_HIDE, (Object)true);
        this.m_20088_().m_135372_(HIDE_TICK, (Object)0);
        this.m_20088_().m_135372_(SHOOT_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 2: {
                    this.shootAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shootAnimationState);
                    break;
                }
                case 3: {
                    this.hideAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.hideAnimationState);
                    break;
                }
                case 4: {
                    this.unHideAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.unHideAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected AABB m_142242_() {
        if (!this.isUnHide()) {
            return AABB.m_165882_((Vec3)new Vec3(this.m_20185_(), this.m_20186_() + 0.05, this.m_20189_()), (double)1.0, (double)0.1, (double)1.0);
        }
        return AABB.m_165882_((Vec3)new Vec3(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_()), (double)1.0, (double)2.0, (double)1.0);
    }

    protected AABB m_292684_() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(0.75, 0.75, 0.75);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.m_292684_().m_82381_(livingEntity.m_20191_());
    }

    public void m_8107_() {
        Player player;
        Object object;
        super.m_8107_();
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (object = this.m_5448_()) instanceof Player && ((player = (Player)object).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        this.hideAboutTick = Math.max(0, this.hideAboutTick - 1);
        if (!this.m_9236_().m_5776_()) {
            this.setHideTick(Math.max(0, this.getHideTick() - 1));
            this.setShootTick(Math.max(0, this.getShootTick() - 1));
        }
        if (this.hideAboutTick <= 0 && this.isUnHide() && !this.m_9236_().m_5776_()) {
            this.setUnHide(false);
            this.setHideTick(20);
            this.setAnimTick(21);
            this.setAnimationState("hide");
            this.m_20011_(this.m_142242_());
        }
        if (this.hideAboutTick > 0 && !this.isUnHide() && !this.m_9236_().m_5776_()) {
            this.setUnHide(true);
            this.setHideTick(20);
            this.setAnimTick(21);
            this.setAnimationState("unHide");
            this.m_20011_(this.m_142242_());
        }
        if (this.isUnHide() && this.getHideTick() <= 0) {
            this.idleAnimationState.m_216982_(this.f_19797_);
            this.unHideAnimationState.m_216973_();
            this.hideAnimationState.m_216973_();
        } else {
            this.idleAnimationState.m_216973_();
        }
        if (!this.isUnHide() && this.getHideTick() <= 0) {
            this.inHideAnimationState.m_216982_(this.f_19797_);
            this.unHideAnimationState.m_216973_();
            this.hideAnimationState.m_216973_();
        } else {
            this.inHideAnimationState.m_216973_();
        }
        if (this.f_19797_ % 5 == 0) {
            List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.2, 0.2));
            for (LivingEntity find : list) {
                if (find == null || find == this || find instanceof PredationToothedFlowerEntity || !(find instanceof Player) && !(find instanceof Mob) || this.m_20270_((Entity)find) > 3.0f || this.m_5448_() != null || find.m_7307_((Entity)this) || !this.m_6779_(find) || !this.m_6549_(find.m_6095_())) continue;
                if (find instanceof ServerPlayer) {
                    ServerPlayer player2 = (ServerPlayer)find;
                    if (player2.f_8941_.m_9290_() == GameType.CREATIVE || player2.f_8941_.m_9290_() == GameType.SPECTATOR) continue;
                }
                if (find.m_5833_() || find instanceof Enemy && this.m_9236_().m_204166_(BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_())).m_203565_(JerotesVillageBiomes.VIRTUAL_CAVE)) continue;
                if (this.hideAboutTick < 40) {
                    this.hideAboutTick = 40;
                }
                this.m_9236_().m_7605_((Entity)this, (byte)12);
                this.m_6710_(find);
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (this.hideAboutTick < 140) {
            this.hideAboutTick = 140;
        }
        if (this.getHideTick() > 0) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(10);
            this.setAnimationState("attack");
        }
        if (bl = super.m_7327_(entity)) {
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.PREDATION_TOOTHED_FLOWER_ATTACK, this.m_5720_(), 5.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!entity.m_9236_().f_46443_) {
                    livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 40, 1), (Entity)this);
                }
            }
        }
        return bl;
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_276093_(DamageTypes.f_268612_) || damageSource.m_269533_(DamageTypeTags.f_268549_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (damagesource.m_276093_(DamageTypes.f_268631_)) {
            return super.m_6469_(damagesource, amount * 2.0f);
        }
        if (damagesource.m_276093_(DamageTypes.f_268468_)) {
            return super.m_6469_(damagesource, amount * 2.0f);
        }
        return super.m_6469_(damagesource, amount);
    }
}

