/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.SuperDeathCreeperEntity;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SwellGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class PurpleSandCreeperEntity
extends Creeper
implements JerotesEntity,
SuperDeathCreeperEntity {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(PurpleSandCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_POWERED = SynchedEntityData.m_135353_(PurpleSandCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(PurpleSandCreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    private int swell;
    private int maxSwell = 25;
    private int explosionRadius = 3;
    private int droppedSkulls;

    public PurpleSandCreeperEntity(EntityType<? extends PurpleSandCreeperEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 10;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SwellGoal((Creeper)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder m_32318_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.275);
        builder = builder.m_22268_(Attributes.f_22276_, 22.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }

    public int m_6056_() {
        if (this.m_5448_() == null) {
            return 3;
        }
        return 3 + (int)(this.m_21223_() - 1.0f);
    }

    public boolean m_142535_(float f, float f2, DamageSource damageSource) {
        boolean bl = super.m_142535_(f, f2, damageSource);
        this.swell += (int)(f * 1.5f);
        if (this.swell > this.maxSwell - 5) {
            this.swell = this.maxSwell - 5;
        }
        return bl;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.m_20088_().m_135372_(DATA_IS_POWERED, (Object)false);
        this.m_20088_().m_135372_(DATA_IS_IGNITED, (Object)false);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED)).booleanValue()) {
            compoundTag.m_128379_("powered", true);
        }
        compoundTag.m_128376_("Fuse", (short)this.maxSwell);
        compoundTag.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        compoundTag.m_128379_("ignited", this.m_32311_());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)compoundTag.m_128471_("powered"));
        if (compoundTag.m_128425_("Fuse", 99)) {
            this.maxSwell = compoundTag.m_128448_("Fuse");
        }
        if (compoundTag.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = compoundTag.m_128445_("ExplosionRadius");
        }
        if (compoundTag.m_128471_("ignited")) {
            this.m_32312_();
        }
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int n;
            this.oldSwell = this.swell;
            if (this.m_32311_()) {
                this.m_32283_(1);
            }
            if ((n = this.m_32310_()) > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += n;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.m_32315_();
            }
        }
        super.m_8119_();
    }

    public void m_6710_(@Nullable LivingEntity livingEntity) {
        if (livingEntity instanceof Goat) {
            return;
        }
        super.m_6710_(livingEntity);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11836_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11835_;
    }

    protected void m_7472_(DamageSource damageSource, int n, boolean bl) {
        Creeper creeper;
        super.m_7472_(damageSource, n, bl);
        Entity entity = damageSource.m_7639_();
        if (entity != this && entity instanceof Creeper && (creeper = (Creeper)entity).m_32313_()) {
            creeper.m_32314_();
            this.m_19998_((ItemLike)JerotesVillageItems.PURPLE_SAND_CREEPER_HEAD.get());
        }
    }

    public boolean m_7090_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED);
    }

    public float m_32320_(float f) {
        return Mth.m_14179_((float)f, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int m_32310_() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void m_32283_(int n) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)n);
    }

    public void m_8038_(ServerLevel serverLevel, LightningBolt lightningBolt) {
        super.m_8038_(serverLevel, lightningBolt);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)true);
    }

    protected InteractionResult m_6071_(Player player2, InteractionHand interactionHand) {
        ItemStack itemStack = player2.m_21120_(interactionHand);
        if (itemStack.m_204117_(ItemTags.f_262757_)) {
            SoundEvent soundEvent = itemStack.m_150930_(Items.f_42613_) ? SoundEvents.f_11874_ : SoundEvents.f_11942_;
            this.m_9236_().m_6263_(player2, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundEvent, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.m_9236_().f_46443_) {
                this.m_32312_();
                if (!itemStack.m_41763_()) {
                    itemStack.m_41774_(1);
                } else {
                    itemStack.m_41622_(1, (LivingEntity)player2, player -> player.m_21190_(interactionHand));
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player2, interactionHand);
    }

    private void m_32315_() {
        if (!this.m_9236_().f_46443_) {
            float f = this.m_7090_() ? 2.0f * this.getBase() : this.getBase();
            this.f_20890_ = true;
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius * f, Level.ExplosionInteraction.MOB);
            this.m_146870_();
            this.m_32316_();
        }
    }

    private float getBase() {
        float f = this.m_9236_().m_8055_(this.m_20097_()).m_60800_((BlockGetter)this.m_9236_(), this.m_20097_());
        if (f > 0.0f) {
            return 1.5f + Math.min(f * 0.1f, 2.0f);
        }
        return 1.5f;
    }

    private void m_32316_() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaEffectCloud.m_19712_(2.5f * this.getBase());
            areaEffectCloud.m_19732_(-0.5f);
            areaEffectCloud.m_19740_(10);
            areaEffectCloud.m_19734_(areaEffectCloud.m_19748_() / 2);
            areaEffectCloud.m_19738_(-areaEffectCloud.m_19743_() / (float)areaEffectCloud.m_19748_());
            for (MobEffectInstance mobEffectInstance : collection) {
                areaEffectCloud.m_19716_(new MobEffectInstance(mobEffectInstance));
            }
            this.m_9236_().m_7967_((Entity)areaEffectCloud);
        }
    }

    public boolean m_32311_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED);
    }

    public void m_32312_() {
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
    }

    public boolean m_32313_() {
        return this.m_7090_() && this.droppedSkulls < 1;
    }

    public void m_32314_() {
        ++this.droppedSkulls;
    }
}

