/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.init.JerotesDamageTypes;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotesvillage.init.JerotesVillageBlocks;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class SliderEntity
extends Monster
implements JerotesEntity {
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(SliderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SliderEntity(EntityType<? extends SliderEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(3.1f);
        this.f_21364_ = 20;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 18.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 24.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.95);
        return builder;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(JerotesVillageSounds.SLIDER_AMBIENT, 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return JerotesVillageSounds.SLIDER_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.SLIDER_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.SLIDER_AMBIENT;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_276093_(JerotesDamageTypes.BLEEDING) || damageSource.m_269533_(DamageTypeTags.f_268549_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (!EntityAndItemFind.MagicResistance((DamageSource)damagesource) && !damagesource.m_269533_(DamageTypeTags.f_268738_) && ((double)amount < this.m_21133_(Attributes.f_22276_) * 0.75 ? (double)this.f_19796_.m_188501_() < 0.75 : (double)amount < this.m_21133_(Attributes.f_22276_) * 1.5 && (double)this.f_19796_.m_188501_() < 0.5)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 0.4f;
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AttackTick", this.getAttackTick());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAttackTick(compoundTag.m_128451_("AttackTick"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(-10, this.getAttackTick() - 1));
            if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
                BlockState blockState = ((Block)JerotesVillageBlocks.SLIDER_MARK.get()).m_49966_();
                for (int i = 0; i < 4; ++i) {
                    int n = Mth.m_14107_((double)(this.m_20185_() + (double)((float)(i % 2 * 2 - 1) * 0.25f)));
                    int n2 = Mth.m_14107_((double)this.m_20186_());
                    int n3 = Mth.m_14107_((double)(this.m_20189_() + (double)((float)(i / 2 % 2 * 2 - 1) * 0.25f)));
                    BlockPos blockPos = new BlockPos(n, n2, n3);
                    if (!this.m_9236_().m_8055_(blockPos).m_60795_() || !blockState.m_60710_((LevelReader)this.m_9236_(), blockPos)) continue;
                    this.m_9236_().m_46597_(blockPos, blockState);
                    this.m_9236_().m_220407_(GameEvent.f_157797_, blockPos, GameEvent.Context.m_223719_((Entity)this, (BlockState)blockState));
                }
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (this.getAttackTick() > -10) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(10);
        }
        if (bl = super.m_7327_(entity)) {
            if (!this.m_20067_()) {
                this.m_5496_(JerotesVillageSounds.SLIDER_AMBIENT, 1.0f, 1.0f);
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!livingEntity.m_9236_().f_46443_) {
                    livingEntity.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.CORROSIVE.get(), 60, 0), (Entity)this);
                }
            }
        }
        return bl;
    }
}

