/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Monster;

import com.jerotes.jerotes.entity.CanNotSkeletonSpiderEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotesvillage.entity.Monster.WickedRidiculeCalls.SecondRounderSpiderEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class VirtualCaveSpiderEntity
extends Spider
implements JerotesEntity,
CanNotSkeletonSpiderEntity {
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState climbAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(VirtualCaveSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(VirtualCaveSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_COLOR_A_ID = SynchedEntityData.m_135353_(VirtualCaveSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_COLOR_B_ID = SynchedEntityData.m_135353_(VirtualCaveSpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public VirtualCaveSpiderEntity(EntityType<? extends VirtualCaveSpiderEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.1f);
        this.f_21364_ = 25;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new SpiderAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new SpiderTargetGoal<Player>(this, Player.class));
        this.f_21346_.m_25352_(3, new SpiderTargetGoal<IronGolem>(this, IronGolem.class));
    }

    public static AttributeSupplier.Builder m_33815_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.45);
        builder = builder.m_22268_(Attributes.f_22276_, 48.0);
        builder = builder.m_22268_(Attributes.f_22284_, 5.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.4);
        builder = builder.m_22268_(Attributes.f_22281_, 8.0);
        builder = builder.m_22268_(Attributes.f_22277_, 35.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.2);
        return builder;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268549_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268549_)) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_7327_(Entity entity) {
        boolean bl;
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(7);
            this.setAnimationState("attack");
        }
        if ((bl = super.m_7327_(entity)) && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int n = 2;
            if (this.m_9236_().m_46791_() == Difficulty.NORMAL) {
                n = 4;
            } else if (this.m_9236_().m_46791_() == Difficulty.HARD) {
                n = 8;
                if (!entity.m_9236_().f_46443_) {
                    livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19597_, n * 20, 1), (Entity)this);
                }
            }
            if (!entity.m_9236_().f_46443_) {
                livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, n * 20, 1), (Entity)this);
            }
        }
        return bl;
    }

    public void m_7601_(BlockState blockState, Vec3 vec3) {
        if (!blockState.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(blockState, vec3);
        }
        this.m_183634_();
    }

    public boolean isColorA() {
        return (Boolean)this.m_20088_().m_135370_(DATA_COLOR_A_ID);
    }

    public boolean isColorB() {
        return (Boolean)this.m_20088_().m_135370_(DATA_COLOR_B_ID);
    }

    public void setColorA(boolean bl) {
        this.m_20088_().m_135381_(DATA_COLOR_A_ID, (Object)bl);
    }

    public void setColorB(boolean bl) {
        this.m_20088_().m_135381_(DATA_COLOR_B_ID, (Object)bl);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack")) {
            return 1;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.attackAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsColorA", this.isColorA());
        compoundTag.m_128379_("IsColorB", this.isColorB());
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("IsColorA")) {
            this.setColorA(compoundTag.m_128471_("IsColorA"));
        }
        if (compoundTag.m_128441_("IsColorB")) {
            this.setColorB(compoundTag.m_128471_("IsColorB"));
        }
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_COLOR_A_ID, (Object)false);
        this.m_20088_().m_135372_(DATA_COLOR_B_ID, (Object)false);
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (DATA_COLOR_A_ID.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (DATA_COLOR_B_ID.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attackAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        Entity object;
        RandomSource randomSource = serverLevelAccessor.m_213780_();
        if (randomSource.m_188503_(40) == 1 && (object = ((EntityType)JerotesVillageEntityType.SECOND_ROUNDER_SPIDER.get()).m_20615_(this.m_9236_())) != null) {
            object.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            ((SecondRounderSpiderEntity)object).m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, null, null);
            if (!this.m_9236_().f_46443_) {
                object.m_20329_((Entity)this);
            }
        }
        RandomSource randomSourceSkin = serverLevelAccessor.m_213780_();
        if (mobSpawnType != MobSpawnType.CONVERSION) {
            if (randomSourceSkin.m_188501_() < 0.25f) {
                this.setColorA(true);
            }
            if (randomSourceSkin.m_188501_() < 0.3f) {
                this.setColorB(true);
            }
        }
        return spawnGroupData;
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.m_33816_()) {
            this.climbAnimationState.m_216977_(this.f_19797_);
        } else {
            this.climbAnimationState.m_216973_();
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == JerotesVillageMobEffects.FISHING_NET_CONFINEMET.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 0.8f;
    }

    public int m_8085_() {
        return 15;
    }

    public int m_8132_() {
        return 15;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    static class SpiderAttackGoal
    extends JerotesMeleeAttackGoal {
        public SpiderAttackGoal(Spider spider) {
            super((PathfinderMob)spider, 1.0, true);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.mob.m_20160_();
        }

        public boolean m_8045_() {
            float f = this.mob.m_213856_();
            if (f >= 0.5f && this.mob.m_217043_().m_188503_(100) == 1) {
                this.mob.m_6710_(null);
                return false;
            }
            return super.m_8045_();
        }
    }

    static class SpiderTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public SpiderTargetGoal(Spider spider, Class<T> class_) {
            super((Mob)spider, class_, true);
        }

        public boolean m_8036_() {
            float f = this.f_26135_.m_213856_();
            if (f >= 0.5f) {
                return false;
            }
            return super.m_8036_();
        }
    }
}

