/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Neutral;

import com.google.common.collect.Lists;
import com.jerotes.jerotes.entity.CarvedEntity;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesHelpAlliesGoal;
import com.jerotes.jerotes.goal.JerotesHelpCarvedGoal;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.init.JerotesDamageTypes;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Animal.CarvedHoundEntity;
import com.jerotes.jerotesvillage.entity.Animal.CarvedLlamaEntity;
import com.jerotes.jerotesvillage.entity.Monster.IllagerFaction.DefectorEntity;
import com.jerotes.jerotesvillage.entity.Neutral.CarvedAllayEntity;
import com.jerotes.jerotesvillage.event.RelationshipEvent;
import com.jerotes.jerotesvillage.goal.CarvedIronGolemMeleeAttackGoal;
import com.jerotes.jerotesvillage.goal.HelpVillagerGoal;
import com.jerotes.jerotesvillage.item.CarvedFlag;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GolemRandomStrollInVillageGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.OfferFlowerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class CarvedIronGolemEntity
extends IronGolem
implements JerotesEntity,
CarvedEntity {
    private static final EntityDataAccessor<Integer> NETHERITE_TICK = SynchedEntityData.m_135353_(CarvedIronGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(CarvedIronGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(CarvedIronGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_0 = SynchedEntityData.m_135353_(CarvedIronGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Optional<UUID>> DATA_TRUSTED_ID_1 = SynchedEntityData.m_135353_(CarvedIronGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public CarvedIronGolemEntity(EntityType<? extends CarvedIronGolemEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
    }

    public boolean isFactionWith(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && OtherEntityFactionFind.isFactionCopperCarvedCompany(livingEntity = (LivingEntity)entity);
    }

    public String getFactionTypeName() {
        return "copper_carved_company";
    }

    public static AttributeSupplier.Builder m_28883_() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.27);
        builder = builder.m_22268_(Attributes.f_22276_, 120.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22284_, 17.0);
        builder = builder.m_22268_(Attributes.f_22281_, 17.0);
        builder = builder.m_22268_(Attributes.f_22277_, 48.0);
        return builder;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new CarvedIronGolemMeleeAttackGoal(this, 1.05, true));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.05, true));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(3, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.6, false));
        this.f_21345_.m_25352_(4, (Goal)new GolemRandomStrollInVillageGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(5, (Goal)new OfferFlowerGoal((IronGolem)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, AbstractVillager.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, IronGolem.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, CarvedAllayEntity.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, CarvedHoundEntity.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, CarvedLlamaEntity.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{CarvedEntity.class}));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpCarvedGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HelpVillagerGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpAlliesGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        if (OtherMainConfig.CarvedObligation) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, mob -> !(!(mob instanceof Enemy) && !OtherMainConfig.CarvedGonnaActiveAttackList.contains(mob.m_20078_()) || OtherMainConfig.CarvedGonnaActiveAttackList.contains(mob.m_20078_()) || mob instanceof Creeper && !OtherMainConfig.CarvedActiveAttackCreeper)));
        } else {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, mob -> OtherMainConfig.CarvedGonnaActiveAttackList.contains(mob.m_20078_()) && !OtherMainConfig.CarvedGonnaActiveAttackList.contains(mob.m_20078_()) && (!(mob instanceof Creeper) || OtherMainConfig.CarvedActiveAttackCreeper)));
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, 5, false, false, mob -> !(mob instanceof NeutralMob) && !OtherMainConfig.CarvedNeverGonnaActiveAttack.contains(mob.m_20078_())));
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, 5, false, false, mob -> !(mob instanceof NeutralMob) && !OtherMainConfig.CarvedNeverGonnaActiveAttack.contains(mob.m_20078_())));
        }
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, livingEntity -> {
            Player player;
            return livingEntity instanceof Player && RelationshipEvent.LessCopperCarvedCompanyRelationship(player = (Player)livingEntity, -500) && !this.trusts(player.m_20148_());
        }));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((CarvedIronGolemEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected AABB m_292684_() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(0.5, 0.5, 0.5);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.m_292684_().m_82381_(livingEntity.m_20191_());
    }

    public boolean isEmerald(ItemStack stack) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42616_)}).test(stack);
    }

    public IronGolem.Crackiness m_28873_() {
        return IronGolem.Crackiness.m_28901_((float)(this.m_21223_() / this.m_21233_()));
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public int getNetheriteTick() {
        return (Integer)this.m_20088_().m_135370_(NETHERITE_TICK);
    }

    public void setNetheriteTick(int n) {
        this.m_20088_().m_135381_(NETHERITE_TICK, (Object)n);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        List<UUID> list = this.getTrustedUUIDs();
        ListTag listTag = new ListTag();
        for (UUID uUID : list) {
            if (uUID == null) continue;
            listTag.add((Object)NbtUtils.m_129226_((UUID)uUID));
        }
        compoundTag.m_128365_("Trusted", (Tag)listTag);
        compoundTag.m_128405_("NetheriteTick", this.getNetheriteTick());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        ListTag listTag = compoundTag.m_128437_("Trusted", 11);
        for (Tag tag : listTag) {
            this.addTrustedUUID(NbtUtils.m_129233_((Tag)tag));
        }
        if (compoundTag.m_128441_("NetheriteTick")) {
            this.setNetheriteTick(compoundTag.m_128451_("NetheriteTick"));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_TRUSTED_ID_0, Optional.empty());
        this.m_20088_().m_135372_(DATA_TRUSTED_ID_1, Optional.empty());
        this.m_20088_().m_135372_(DATA_TYPE_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_FLAGS_ID, (Object)0);
        this.m_20088_().m_135372_(NETHERITE_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (NETHERITE_TICK.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(entityDataAccessor);
    }

    List<UUID> getTrustedUUIDs() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).orElse(null));
        arrayList.add(((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_1)).orElse(null));
        return arrayList;
    }

    void addTrustedUUID(@Nullable UUID uUID) {
        if (((Optional)this.f_19804_.m_135370_(DATA_TRUSTED_ID_0)).isPresent()) {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_1, Optional.ofNullable(uUID));
        } else {
            this.f_19804_.m_135381_(DATA_TRUSTED_ID_0, Optional.ofNullable(uUID));
        }
    }

    protected void m_5502_(Player player, Mob mob) {
        this.addTrustedUUID(player.m_20148_());
    }

    public boolean trusts(UUID uUID) {
        return this.getTrustedUUIDs().contains(uUID);
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (itemstack.m_41720_() instanceof CarvedFlag) {
            float f1 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
            if (!this.m_20067_()) {
                this.m_5496_(SoundEvents.f_12009_, 1.0f, f1);
            }
            return InteractionResult.PASS;
        }
        if (itemstack.m_41720_() == Items.f_42791_) {
            if (!this.m_9236_().m_5776_()) {
                this.setNetheriteTick(12000);
            }
            player.m_6674_(interactionHand);
            float f = (float)this.m_20186_();
            Vec3 vec3 = this.m_20184_();
            for (int i = 0; i < 10; ++i) {
                float f2 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                float f3 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50721_.m_49966_()), this.m_20185_() + (double)f2, (double)(f + 2.0f), this.m_20189_() + (double)f3, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!this.m_20067_()) {
                this.m_5496_(SoundEvents.f_12009_, 1.0f, 1.0f);
            }
            return InteractionResult.PASS;
        }
        if (!this.m_5912_() && this.isEmerald(itemstack)) {
            if (!this.m_9236_().f_46443_) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19621_, 12000, 0));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 12000, 1));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 12000, 1));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 12000, 1));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19616_, 12000, 2));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19595_, 12000, 4));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 660, 1));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19601_, 1, 3));
            }
            float f1 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
            if (!this.m_20067_()) {
                this.m_5496_(SoundEvents.f_12009_, 1.0f, f1);
            }
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            float f = (float)this.m_20186_();
            Vec3 vec3 = this.m_20184_();
            for (int i = 0; i < 10; ++i) {
                float f2 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                float f3 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_() + (double)f2, (double)(f + 2.0f), this.m_20189_() + (double)f3, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
            if (!this.trusts(player.m_20148_())) {
                RelationshipEvent.AddCopperCarvedCompanyRelationship(player, 5);
            }
            this.addTrustedUUID(player.m_20148_());
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, interactionHand);
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(3.0f);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (this.getNetheriteTick() > 0) {
            this.m_20095_();
            if (!this.m_9236_().m_5776_()) {
                this.setNetheriteTick(this.getNetheriteTick() - 1);
            }
        }
    }

    public boolean m_7327_(Entity entity) {
        if (this.getNetheriteTick() > 0) {
            this.m_9236_().m_7605_((Entity)this, (byte)4);
            AttackFind.attackBegin((LivingEntity)this, (Entity)entity);
            DamageSource damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(JerotesDamageTypes.BYPASSES_COOLDOWN_MELEE), (Entity)this);
            boolean bl = AttackFind.attackAfterCustomDamage((LivingEntity)this, (Entity)entity, (DamageSource)damageSource, (float)0.3f, (float)0.5f, (boolean)false, (float)0.0f);
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
            return bl;
        }
        return super.m_7327_(entity);
    }

    public void m_5993_(Entity entity, int score, DamageSource damageSource) {
        super.m_5993_(entity, score, damageSource);
        if (!this.m_9236_().f_46443_) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 660, 0));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 660, 0));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 660, 0));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 660, 0));
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_276093_(DamageTypes.f_268722_) || damageSource.m_276093_(DamageTypes.f_268526_) || damageSource.m_269533_(DamageTypeTags.f_268745_) && this.getNetheriteTick() > 0) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, f);
        }
        boolean bl = super.m_6469_(damageSource, f);
        if (bl) {
            Player player;
            Entity entity = damageSource.m_7639_();
            if (entity instanceof Player && !this.trusts((player = (Player)entity).m_20148_()) && this.m_5448_() == null) {
                RelationshipEvent.AddCopperCarvedCompanyRelationship(player, -2);
            }
            float damage = f;
            if (this.getNetheriteTick() > 0) {
                float f2 = (float)this.getNetheriteTick() / 12000.0f / 4.0f;
                if (f2 > 0.25f) {
                    f2 = 0.25f;
                }
                f -= f * f2 * 4.0f;
                if (!this.m_9236_().m_5776_()) {
                    this.setNetheriteTick(this.getNetheriteTick() - (int)damage * 20);
                }
            }
        }
        return bl;
    }

    public boolean m_7307_(Entity entity) {
        LivingEntity livingEntity;
        Player player;
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.m_7307_(entity)) {
            return true;
        }
        if (this.trusts(entity.m_20148_())) {
            return true;
        }
        if (entity instanceof Player && RelationshipEvent.MoreCopperCarvedCompanyRelationship(player = (Player)entity, 500)) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        if (entity instanceof LivingEntity && EntityFactionFind.isFaction((LivingEntity)this, (LivingEntity)(livingEntity = (LivingEntity)entity))) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        Player player;
        DefectorEntity defector;
        if (this.trusts(livingEntity.m_20148_())) {
            return false;
        }
        if ((this.m_5647_() == null && livingEntity.m_5647_() == null || this.m_5647_() == livingEntity.m_5647_()) && EntityFactionFind.isFaction((LivingEntity)this, (LivingEntity)livingEntity)) {
            return false;
        }
        if (OtherMainConfig.CarvedCanNotAttackList.contains(livingEntity.m_20078_())) {
            return false;
        }
        if (livingEntity instanceof DefectorEntity && (defector = (DefectorEntity)livingEntity).m_5448_() != this && !defector.isMustEnemy()) {
            return false;
        }
        if (livingEntity instanceof Player && RelationshipEvent.MoreCopperCarvedCompanyRelationship(player = (Player)livingEntity, 500)) {
            return false;
        }
        return super.m_6779_(livingEntity);
    }

    public void m_6667_(DamageSource damageSource) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            RelationshipEvent.AddCopperCarvedCompanyRelationship(player, -10);
        }
        if (!this.m_9236_().m_5776_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && !this.getTrustedUUIDs().isEmpty()) {
            List<UUID> list = this.getTrustedUUIDs();
            for (UUID uUID : list) {
                ServerLevel serverLevel;
                Level level;
                if (uUID == null || !(this.m_9236_() instanceof ServerLevel) || !((level = this.m_9236_()) instanceof ServerLevel) || !((level = (serverLevel = (ServerLevel)level).m_8791_(uUID)) instanceof Player)) continue;
                Player player = (Player)level;
                player.m_213846_(this.m_21231_().m_19293_());
            }
        }
        super.m_6667_(damageSource);
    }
}

