/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Neutral.MerorMachine;

import com.jerotes.jerotes.entity.BreakShieldEntity;
import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.goal.JerotesMeleeAttackGoal;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.control.GiantBodyRotationControl;
import com.jerotes.jerotesvillage.control.GiantLookControl;
import com.jerotes.jerotesvillage.control.GiantMoveControl;
import com.jerotes.jerotesvillage.entity.Neutral.MerorMachine.MerorCubeEntity;
import com.jerotes.jerotesvillage.entity.Neutral.MerorMachine.MerorMachineEntity;
import com.jerotes.jerotesvillage.entity.in.StopLook;
import com.jerotes.jerotesvillage.init.JerotesVillageGameRules;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellFind;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MerorMonstrosityEntity
extends MerorMachineEntity
implements BreakShieldEntity,
SpellUseEntity,
StopLook,
EliteEntity {
    public AnimationState attack1AnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState spellAnimationState = new AnimationState();
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState sendAnimationState = new AnimationState();
    public AnimationState standAnimationState = new AnimationState();
    public AnimationState standStartAnimationState = new AnimationState();
    public AnimationState standStopAnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(MerorMonstrosityEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOOT_TICK = SynchedEntityData.m_135353_(MerorMonstrosityEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHOOT_USE_TICK = SynchedEntityData.m_135353_(MerorMonstrosityEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SEND_TICK = SynchedEntityData.m_135353_(MerorMonstrosityEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SEND_USE_TICK = SynchedEntityData.m_135353_(MerorMonstrosityEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> STAND_TICK = SynchedEntityData.m_135353_(MerorMonstrosityEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> STAND = SynchedEntityData.m_135353_(MerorMonstrosityEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.NOTCHED_20, false);
    public int spellLevel = 4;
    private double blockDestroyTick;
    private int sitTick = 0;

    public MerorMonstrosityEntity(EntityType<? extends MerorMonstrosityEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(2.6f);
        this.f_21364_ = 120;
        this.m_21441_(BlockPathTypes.LEAVES, 4.0f);
        this.m_21441_(BlockPathTypes.FENCE, 4.0f);
        this.m_21441_(BlockPathTypes.BLOCKED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_WOOD_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.DOOR_IRON_CLOSED, 4.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 0.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.f_21365_ = new GiantLookControl((Mob)this, 10);
        this.f_21342_ = new GiantMoveControl((Mob)this);
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6543_(serverPlayer);
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6539_(serverPlayer);
        }
    }

    public void m_8024_() {
        super.m_8024_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.22);
        builder = builder.m_22268_(Attributes.f_22276_, 640.0);
        builder = builder.m_22268_(Attributes.f_22282_, 4.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22284_, 12.0);
        builder = builder.m_22268_(Attributes.f_22281_, 30.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new JerotesMeleeAttackGoal((PathfinderMob)this, 1.25, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((MerorMonstrosityEntity)this).m_21674_(arg_0)));
    }

    protected SoundEvent m_7515_() {
        if (this.getStandTick() > 0 && !this.isInSittingPose()) {
            return JerotesVillageSounds.MEROR_MONSTROSITY_AMBIENT;
        }
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (!EntityAndItemFind.isMerorAttack((DamageSource)damageSource)) {
            return JerotesVillageSounds.MEROR_TOUGHNESS;
        }
        return JerotesVillageSounds.MEROR_MONSTROSITY_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.MEROR_MONSTROSITY_DEATH;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(JerotesVillageSounds.MEROR_MONSTROSITY_WALK, 1.0f, 1.0f);
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public int m_8085_() {
        return 15;
    }

    public int m_8132_() {
        return 15;
    }

    public int m_21529_() {
        return 5;
    }

    public int getShieldBreakStrength() {
        return 2400;
    }

    public boolean m_213824_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_147240_(double d, double d2, double d3) {
        super.m_147240_(0.0, 0.0, 0.0);
    }

    public void m_5997_(double d, double d2, double d3) {
        super.m_5997_(0.0, 0.0, 0.0);
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 4.25f;
    }

    public boolean m_5843_() {
        return this.m_20184_().m_165925_() > 2.5 && this.f_19796_.m_188503_(5) == 1;
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public void m_21391_(Entity entity, float f, float f2) {
        if (!this.stopLookTime()) {
            super.m_21391_(entity, f, f2);
        }
    }

    public void m_146926_(float f) {
        if (!this.stopLookTime()) {
            super.m_146926_(f);
        }
    }

    public void m_146922_(float f) {
        if (!this.stopLookTime()) {
            super.m_146922_(f);
        }
    }

    public void m_5618_(float f) {
        if (!this.stopLookTime()) {
            super.m_5618_(f);
        }
    }

    protected AABB m_292684_() {
        AABB aabb;
        AABB aabb1;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(1.75, 1.75, 1.75);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.m_292684_().m_82381_(livingEntity.m_20191_());
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new GiantBodyRotationControl((Mob)this);
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public void setShootTick(int n) {
        this.m_20088_().m_135381_(SHOOT_TICK, (Object)n);
    }

    public int getShootTick() {
        return (Integer)this.m_20088_().m_135370_(SHOOT_TICK);
    }

    public void setShootUseTick(int n) {
        this.m_20088_().m_135381_(SHOOT_USE_TICK, (Object)n);
    }

    public int getShootUseTick() {
        return (Integer)this.m_20088_().m_135370_(SHOOT_USE_TICK);
    }

    public void setSendTick(int n) {
        this.m_20088_().m_135381_(SEND_TICK, (Object)n);
    }

    public int getSendTick() {
        return (Integer)this.m_20088_().m_135370_(SEND_TICK);
    }

    public void setSendUseTick(int n) {
        this.m_20088_().m_135381_(SEND_USE_TICK, (Object)n);
    }

    public int getSendUseTick() {
        return (Integer)this.m_20088_().m_135370_(SEND_USE_TICK);
    }

    public void setStandTick(int n) {
        this.m_20088_().m_135381_(STAND_TICK, (Object)n);
    }

    public int getStandTick() {
        return (Integer)this.m_20088_().m_135370_(STAND_TICK);
    }

    public boolean isStand() {
        return (Boolean)this.m_20088_().m_135370_(STAND);
    }

    public void setStand(boolean bl) {
        this.m_20088_().m_135381_(STAND, (Object)bl);
    }

    @Override
    public boolean specialAction() {
        return (this.getStandTick() < 0 || this.getStandTick() > 5980) && !this.isTame() || this.getSendUseTick() > 0 || this.getShootUseTick() > 0;
    }

    @Override
    public boolean stopLookTime() {
        return this.specialAction() || this.getAttackTick() > 0;
    }

    public void m_6593_(@Nullable Component component) {
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    @Override
    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "attack1")) {
            return 1;
        }
        if (Objects.equals(animation, "attack2")) {
            return 2;
        }
        if (Objects.equals(animation, "spell")) {
            return 3;
        }
        if (Objects.equals(animation, "send")) {
            return 4;
        }
        if (Objects.equals(animation, "dead")) {
            return 5;
        }
        return super.getAnimationState(animation);
    }

    @Override
    public List<AnimationState> getAllAnimations() {
        List<AnimationState> list = super.getAllAnimations();
        list.add(this.attack1AnimationState);
        list.add(this.attack2AnimationState);
        list.add(this.spellAnimationState);
        list.add(this.sendAnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("StandTick", this.getStandTick());
        compoundTag.m_128379_("IsStand", this.isStand());
        compoundTag.m_128405_("AttackTick", this.getAttackTick());
        compoundTag.m_128405_("ShootTick", this.getShootTick());
        compoundTag.m_128405_("ShootUseTick", this.getShootUseTick());
        compoundTag.m_128405_("SendTick", this.getSendTick());
        compoundTag.m_128405_("SendUseTick", this.getSendUseTick());
        compoundTag.m_128347_("BlockDestroyTick", this.blockDestroyTick);
        compoundTag.m_128405_("SitTick", this.sitTick);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.setStandTick(compoundTag.m_128451_("StandTick"));
        if (compoundTag.m_128441_("IsStand")) {
            this.setStand(compoundTag.m_128471_("IsStand"));
        }
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.setAttackTick(compoundTag.m_128451_("AttackTick"));
        this.setShootTick(compoundTag.m_128451_("ShootTick"));
        this.setShootUseTick(compoundTag.m_128451_("ShootUseTick"));
        this.setSendTick(compoundTag.m_128451_("SendTick"));
        this.setSendUseTick(compoundTag.m_128451_("SendUseTick"));
        this.blockDestroyTick = compoundTag.m_128459_("BlockDestroyTick");
        this.sitTick = compoundTag.m_128451_("SitTick");
        this.bossEvent.setId(this.m_20148_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(SHOOT_TICK, (Object)0);
        this.m_20088_().m_135372_(SHOOT_USE_TICK, (Object)0);
        this.m_20088_().m_135372_(SEND_TICK, (Object)0);
        this.m_20088_().m_135372_(SEND_USE_TICK, (Object)0);
        this.m_20088_().m_135372_(STAND_TICK, (Object)-30);
        this.m_20088_().m_135372_(STAND, (Object)false);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (STAND.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.attack1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack1AnimationState);
                    break;
                }
                case 2: {
                    this.attack2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.attack2AnimationState);
                    break;
                }
                case 3: {
                    this.spellAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.spellAnimationState);
                    break;
                }
                case 4: {
                    this.sendAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.sendAnimationState);
                    break;
                }
                case 5: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8107_() {
        float f;
        super.m_8107_();
        String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.update();
            if (OtherMainConfig.EliteBossBarOnlyCombat) {
                this.bossEvent.m_8321_(this.m_5448_() != null);
            }
            if ("Redstone Monstrosity".equals(string) || "\u7ea2\u77f3\u5de8\u517d".equals(string)) {
                this.bossEvent.m_6451_(BossEvent.BossBarColor.RED);
            } else {
                this.bossEvent.m_6451_(BossEvent.BossBarColor.PINK);
            }
        }
        if (this.m_5448_() != null && !this.stopLookTime() && this.getAttackTick() <= 0) {
            if (this.m_20270_((Entity)this.m_5448_()) > 12.0f) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
                this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
            } else {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                this.m_21391_((Entity)this.m_5448_(), 30.0f, 30.0f);
            }
        }
        if (this.f_267362_.m_267780_() && this.m_20096_() && this.m_21223_() > this.m_21233_() / 4.0f && !this.m_6162_() && (double)Math.abs(f = (float)Math.cos(this.f_267362_.m_267756_() * 0.8f - 1.5f)) < 0.2) {
            List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(8.0, 8.0, 8.0));
            for (LivingEntity shake : listShake) {
                if (shake == null || shake == this || this.m_20280_((Entity)shake) > Double.MAX_VALUE || shake.m_9236_().m_5776_()) continue;
                shake.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 20, 0, false, false), (Entity)this);
            }
        }
        if (this.m_20069_()) {
            this.f_19812_ = true;
        }
        if (this.m_6084_() && (!this.isTame() && this.getStandTick() <= 6000 && this.getStandTick() > 20 || this.isTame() && !this.isInSittingPose())) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        } else {
            this.idleAnimationState.m_216973_();
        }
        if (this.m_6084_()) {
            if (this.isTame()) {
                if (this.isInSittingPose()) {
                    this.idleAnimationState.m_216973_();
                } else {
                    this.standAnimationState.m_216973_();
                }
                if (this.isInSittingPose() && this.sitTick <= 0) {
                    this.sitTick = 40;
                }
                if (!this.isInSittingPose() && this.sitTick > 0) {
                    this.standStopAnimationState.m_216977_(this.f_19797_);
                    this.sitTick = 0;
                    this.standAnimationState.m_216973_();
                    this.standStartAnimationState.m_216973_();
                }
                if (this.sitTick == 40) {
                    this.standStartAnimationState.m_216977_(this.f_19797_);
                }
                if (this.sitTick == 20) {
                    this.standStartAnimationState.m_216973_();
                    this.standAnimationState.m_216977_(this.f_19797_);
                }
                if (this.sitTick > 5) {
                    --this.sitTick;
                }
            } else {
                if (this.getStandTick() >= 0) {
                    if (!this.m_9236_().m_5776_()) {
                        this.setStandTick(this.getStandTick() - 1);
                    }
                } else if (this.m_217043_().m_188503_(100) == 1 && this.m_6084_()) {
                    this.m_5634_(15.0f);
                }
                if (this.m_5912_() || this.getSendUseTick() > 0 || this.getShootUseTick() > 0 || this.m_5448_() != null || this.m_21188_() != null) {
                    if (this.getStandTick() <= 20) {
                        if (!this.m_9236_().m_5776_()) {
                            this.setStand(false);
                            this.setStandTick(6000);
                        }
                    } else if (this.getStandTick() < 5980 && !this.m_9236_().m_5776_()) {
                        this.setStandTick(5980);
                    }
                }
                if (this.getStandTick() == 6000) {
                    this.standStartAnimationState.m_216973_();
                    this.standAnimationState.m_216973_();
                    this.standStopAnimationState.m_216977_(this.f_19797_);
                    if (!this.m_20067_()) {
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.MEROR_MONSTROSITY_AWAKE, this.m_5720_(), 15.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                    }
                }
                if (this.getStandTick() == 5979) {
                    this.standStartAnimationState.m_216973_();
                    this.standAnimationState.m_216973_();
                }
                if (this.getStandTick() == 21) {
                    this.standAnimationState.m_216973_();
                    this.standStartAnimationState.m_216977_(this.f_19797_);
                }
                if (this.getStandTick() <= 0) {
                    this.standStartAnimationState.m_216973_();
                    this.standAnimationState.m_216977_(this.f_19797_);
                    if (!this.isStand() && !this.m_9236_().m_5776_()) {
                        this.setStand(true);
                    }
                } else {
                    this.standAnimationState.m_216973_();
                }
            }
        }
        if (this.blockDestroyTick > 0.0) {
            this.blockDestroyTick -= 1.0;
        }
        if (this.blockDestroyTick <= 0.0 && (this.f_19862_ || this.m_5448_() != null && this.m_5448_().m_20186_() > this.m_20186_() && this.f_19863_) && this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            boolean canBlockDestroy = this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
            boolean blockDestroy = Main.BlockDestroy((Mob)this, (float)5.0f);
            if (blockDestroy) {
                this.blockDestroyTick = 30.0;
            }
            if (!this.m_9236_().m_5776_() && !canBlockDestroy && this.m_20096_()) {
                this.m_6135_();
            }
        }
        if (this.getAttackTick() == 20 && this.m_6084_()) {
            this.trueHurt();
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(-30, this.getAttackTick() - 1));
        }
        if (this.getAttackTick() > 40) {
            if (this.m_5448_() != null && !this.stopLookTime()) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 120.0f, 120.0f);
                this.m_21391_((Entity)this.m_5448_(), 120.0f, 120.0f);
            }
            this.m_21573_().m_26573_();
        }
        if (this.specialAction() || this.getAttackTick() > 0) {
            this.m_21573_().m_26573_();
        }
        if (("Classic".equals(string) || "Old".equals(string) || "classic".equals(string) || "old".equals(string)) && this.getAttackTick() == 16) {
            double d = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            double d2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)level;
                _level.m_8767_((ParticleOptions)((SimpleParticleType)JerotesVillageParticleTypes.MEROR_MONSTROSITY_ATTACK.get()), this.m_20185_() + d, this.m_20186_() + 0.1, this.m_20189_() + d2, 0, d, 0.0, d2, 0.0);
            }
        }
        List listCube = this.m_9236_().m_45976_(MerorCubeEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        listCube.removeIf(entity -> this.m_5448_() == entity || entity.m_5448_() == this || (this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
        List ListMonstrosity = this.m_9236_().m_45976_(MerorMonstrosityEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        ListMonstrosity.removeIf(entity -> this.m_5448_() == entity || entity.m_5448_() == this || (this.m_5647_() != null || entity.m_5647_() != null) && !entity.m_7307_((Entity)this));
        if (this.getAttackTick() <= -30 && this.getSendTick() >= 1200 && !this.specialAction() && !this.m_21525_() && listCube.size() < ListMonstrosity.size() * 32 && this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_5448_() instanceof LivingEntity && this.m_20270_((Entity)this.m_5448_()) < 16.0f && !this.m_9236_().m_5776_()) {
            this.setSendUseTick(70);
        }
        if (this.getSendUseTick() == 70 && !this.m_9236_().m_5776_()) {
            this.setSendTick(0);
            this.setAnimTick(70);
            this.setAnimationState("send");
        }
        if (this.getSendUseTick() > 0) {
            this.m_21573_().m_26573_();
            if (!this.m_9236_().m_5776_()) {
                this.f_21345_.m_25360_(Goal.Flag.MOVE, false);
                this.f_21345_.m_25360_(Goal.Flag.JUMP, false);
                this.f_21345_.m_25360_(Goal.Flag.LOOK, false);
            }
        }
        if (this.getSendUseTick() == 50) {
            this.trueHurt(false);
            ParticleOptions particleOptions = (ParticleOptions)JerotesVillageParticleTypes.MEROR_MONSTROSITY_ATTACK_IN.get();
            if ("Redstone Monstrosity".equals(string) || "\u7ea2\u77f3\u5de8\u517d".equals(string)) {
                particleOptions = (ParticleOptions)JerotesVillageParticleTypes.MEROR_MONSTROSITY_ATTACK_IN_REDSTONE_MONSTROSITY.get();
            }
            float angleYaw1 = 2.3998277f;
            float angleYaw2 = 0.7417649f;
            float renderYawOffset = this.f_20883_;
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_(particleOptions, this.f_19854_ + (double)(3.0f * Mth.m_14089_((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)angleYaw1)))), this.f_19855_ + (double)0.1f, this.f_19856_ + (double)(3.0f * Mth.m_14031_((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)angleYaw1)))), 0, 0.0, 0.0, 0.0, 0.0);
                serverLevel.m_8767_(particleOptions, this.f_19854_ + (double)(3.0f * Mth.m_14089_((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)angleYaw2)))), this.f_19855_ + (double)0.1f, this.f_19856_ + (double)(3.0f * Mth.m_14031_((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)angleYaw2)))), 0, 0.0, 0.0, 0.0, 0.0);
            }
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.MEROR_MONSTROSITY_ROAR, this.m_5720_(), 15.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
        }
        if (this.getSendUseTick() == 25) {
            OtherSpellFind.ConjureMerorCube((LivingEntity)this, this.getSpellLevel() * 2, this.getSpellLevel() * 3, 16);
        }
        if (this.getAttackTick() <= -30 && this.getShootTick() >= 600 && !this.specialAction() && !this.m_21525_() && this.m_5448_() != null && this.m_5448_().m_6084_() && this.m_5448_() instanceof LivingEntity && this.m_20270_((Entity)this.m_5448_()) < 16.0f && !this.m_9236_().m_5776_()) {
            this.setShootUseTick(45);
        }
        if (this.getShootUseTick() == 45 && !this.m_9236_().m_5776_()) {
            this.setShootTick(0);
            this.setAnimTick(45);
            this.setAnimationState("spell");
        }
        if (this.getShootUseTick() > 0) {
            if (this.m_5448_() != null && this.getShootUseTick() > 40) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 120.0f, 120.0f);
                this.m_21391_((Entity)this.m_5448_(), 120.0f, 120.0f);
            }
            this.m_21573_().m_26573_();
        }
        if (this.getShootUseTick() == 15) {
            if (this.m_5448_() != null) {
                OtherSpellFind.MerorBomb((LivingEntity)this, (Entity)this.m_5448_(), 5.0f, 6, 4.0f, false);
            } else {
                OtherSpellFind.MerorBomb((LivingEntity)this, (Entity)this, 5.0f, 6, 4.0f, false);
            }
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.MEROR_MONSTROSITY_SHOOT, this.m_5720_(), 5.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setShootTick(Math.min(600, this.getShootTick() + 1));
            this.setShootUseTick(Math.max(0, this.getShootUseTick() - 1));
            this.setSendTick(Math.min(1200, this.getSendTick() + 1));
            this.setSendUseTick(Math.max(0, this.getSendUseTick() - 1));
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (!this.specialAction() && this.getAttackTick() <= -30) {
            if (this.m_217043_().m_188501_() > 0.75f) {
                if (!this.m_9236_().m_5776_()) {
                    this.setAttackTick(30);
                    this.setAnimTick(40);
                    this.setAnimationState("attack1");
                }
            } else if (!this.m_9236_().m_5776_()) {
                this.setAttackTick(35);
                this.setAnimTick(50);
                this.setAnimationState("attack2");
            }
            return true;
        }
        return false;
    }

    public boolean trueHurt() {
        return this.trueHurt(true);
    }

    public boolean trueHurt(boolean useParticles) {
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), JerotesVillageSounds.MEROR_MONSTROSITY_ATTACK, this.m_5720_(), 5.0f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_(1.0));
        for (Object hurt : list) {
            if (hurt == null || this.m_20280_((Entity)hurt) > 64.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt)) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            boolean bl = AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)1.0f, (float)1.0f, (boolean)false, (float)0.0f);
            if (!bl) continue;
            if ((Main.mobSizeSmall((Entity)hurt) || Main.mobSizeMedium((Entity)hurt) || Main.mobSizeLarge((Entity)hurt)) && !EntityAndItemFind.isNoSpecialKnockback((EntityType)hurt.m_6095_())) {
                double d = 0.0;
                if (hurt.m_21051_(Attributes.f_22278_) != null) {
                    d = Math.max(hurt.m_21133_(Attributes.f_22278_), 1.0);
                }
                double d3 = Math.max(0.0, 1.0 - d) + 0.5;
                hurt.m_6853_(false);
                hurt.m_20256_(hurt.m_20184_().m_82520_(-(this.m_20185_() - hurt.m_20185_()) * 1.4 * d3, -(this.m_20186_() - hurt.m_20186_()) * 2.0 * d3 + (double)0.2f, -(this.m_20189_() - hurt.m_20189_()) * 1.4 * d3));
            }
            if (!Main.mobSizeSmall((Entity)hurt) && !Main.mobSizeMedium((Entity)hurt)) continue;
            hurt.m_20256_(hurt.m_20184_().m_82520_(0.0, (double)((7.0f - this.m_20270_((Entity)hurt)) / 4.0f), 0.0));
        }
        Main.sweepAttack((Entity)this);
        List listShake = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(24.0, 24.0, 24.0));
        for (LivingEntity shake : listShake) {
            if (shake == null || shake == this || this.m_20280_((Entity)shake) > Double.MAX_VALUE || shake.m_9236_().m_5776_()) continue;
            shake.m_147207_(new MobEffectInstance((MobEffect)JerotesMobEffects.QUAKE.get(), 40, 0, false, false), (Entity)this);
        }
        if (useParticles) {
            String string = ChatFormatting.m_126649_((String)this.m_7755_().getString());
            ParticleOptions particleOptions = (ParticleOptions)JerotesVillageParticleTypes.MEROR_BULLET.get();
            ParticleOptions particleOptionsOut = (ParticleOptions)JerotesVillageParticleTypes.MEROR_MONSTROSITY_ATTACK_OUT.get();
            ParticleOptions particleOptionsIn = (ParticleOptions)JerotesVillageParticleTypes.MEROR_MONSTROSITY_ATTACK_IN.get();
            if ("Redstone Monstrosity".equals(string) || "\u7ea2\u77f3\u5de8\u517d".equals(string)) {
                particleOptions = ParticleTypes.f_123777_;
                particleOptionsOut = (ParticleOptions)JerotesVillageParticleTypes.MEROR_MONSTROSITY_ATTACK_OUT_REDSTONE_MONSTROSITY.get();
                particleOptionsIn = (ParticleOptions)JerotesVillageParticleTypes.MEROR_MONSTROSITY_ATTACK_IN_REDSTONE_MONSTROSITY.get();
            }
            if (!("Classic".equals(string) || "Old".equals(string) || "classic".equals(string) || "old".equals(string))) {
                float angleYaw = 1.5707964f;
                float renderYawOffset = this.f_20883_;
                Vec3 vec3 = new Vec3(this.f_19854_ + (double)(2.0f * Mth.m_14089_((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)angleYaw)))), this.f_19855_ + (double)0.1f, this.f_19856_ + (double)(2.0f * Mth.m_14031_((float)((float)((double)renderYawOffset * (Math.PI / 180) + (double)angleYaw)))));
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    double offsetZ;
                    double offsetX;
                    double radius;
                    double angle;
                    int i;
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_(particleOptionsOut, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_(particleOptionsIn, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0, 0.0, 0.0, 0.0, 0.0);
                    double d = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                    double d2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                    for (i = 0; i < 160; ++i) {
                        angle = Math.PI * 2 * (double)i / 160.0;
                        radius = 8.0;
                        offsetX = Math.cos(angle) * radius;
                        offsetZ = Math.sin(angle) * radius;
                        serverLevel.m_8767_(particleOptions, vec3.m_7096_() + offsetX + d, vec3.m_7098_() + (double)0.2f, vec3.m_7094_() + offsetZ + d2, 0, offsetX * 0.02, -0.04, offsetZ * 0.02, 1.0);
                    }
                    for (i = 0; i < 100; ++i) {
                        angle = Math.PI * 2 * (double)i / 100.0;
                        radius = 5.0;
                        offsetX = Math.cos(angle) * radius;
                        offsetZ = Math.sin(angle) * radius;
                        serverLevel.m_8767_(particleOptions, vec3.m_7096_() + offsetX + d, vec3.m_7098_() + (double)0.2f, vec3.m_7094_() + offsetZ + d2, 0, offsetX * 0.05, -0.02, offsetZ * 0.05, 1.0);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        if (amount <= 4.0f) {
            return false;
        }
        return super.m_6469_(damagesource, amount);
    }

    protected void m_6731_(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_36384_(true);
        }
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        this.standAnimationState.m_216973_();
        this.standStopAnimationState.m_216973_();
        this.standStartAnimationState.m_216973_();
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

