/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Neutral.WildernessGiantSkeleton;

import com.jerotes.jerotes.entity.BreakShieldEntity;
import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Neutral.WildernessGiantSkeleton.WildernessGiantSkeletonEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageGameRules;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class WoodlandHeartGuardianEntity
extends WildernessGiantSkeletonEntity
implements EliteEntity,
BreakShieldEntity {
    private final JerotesBossEvent bossEvent = new JerotesBossEvent((Mob)this, this.m_20148_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.NOTCHED_6, false);
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(WoodlandHeartGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(WoodlandHeartGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_ANIM = SynchedEntityData.m_135353_(WoodlandHeartGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(WoodlandHeartGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_USE = SynchedEntityData.m_135353_(WoodlandHeartGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_SMALL = SynchedEntityData.m_135353_(WoodlandHeartGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState left1AnimationState = new AnimationState();
    public AnimationState right1AnimationState = new AnimationState();
    public AnimationState left2AnimationState = new AnimationState();
    public AnimationState right2AnimationState = new AnimationState();
    public AnimationState left3AnimationState = new AnimationState();
    public AnimationState right3AnimationState = new AnimationState();
    public AnimationState cutAnimationState = new AnimationState();
    public AnimationState rollAnimationState = new AnimationState();
    public AnimationState deadAnimationState = new AnimationState();

    public WoodlandHeartGuardianEntity(EntityType type, Level world) {
        super((EntityType<? extends WildernessGiantSkeletonEntity>)type, world);
        this.f_21364_ = 40;
        this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 2.0f;
        this.m_252801_();
    }

    public void m_6457_(ServerPlayer serverPlayer) {
        super.m_6457_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6543_(serverPlayer);
        }
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_6539_(serverPlayer);
        }
    }

    public void m_8024_() {
        super.m_8024_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    @Override
    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        this.maybeWearArmor(EquipmentSlot.HEAD, new ItemStack((ItemLike)JerotesVillageItems.WOODLAND_HEART_GUARDIAN_MASK.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.CHEST, new ItemStack((ItemLike)JerotesVillageItems.WILDERNESS_GIANT_CHESTPLATE.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.LEGS, new ItemStack((ItemLike)JerotesVillageItems.WILDERNESS_GIANT_LEGGINGS.get()), randomSource);
        this.maybeWearArmor(EquipmentSlot.FEET, new ItemStack((ItemLike)JerotesVillageItems.WILDERNESS_GIANT_BOOTS.get()), randomSource);
    }

    private void maybeWearArmor(EquipmentSlot equipmentSlot, ItemStack itemStack, RandomSource randomSource) {
        this.m_8061_(equipmentSlot, itemStack);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.25);
        builder = builder.m_22268_(Attributes.f_22276_, 135.0);
        builder = builder.m_22268_(Attributes.f_22284_, 4.0);
        builder = builder.m_22268_(Attributes.f_22281_, 11.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        builder = builder.m_22268_(Attributes.f_22278_, 0.5);
        return builder;
    }

    public boolean m_21526_() {
        return false;
    }

    public boolean canUseCrossbow() {
        return false;
    }

    public boolean canUseThrow() {
        return false;
    }

    public boolean canUseRangeJavelin() {
        return false;
    }

    public boolean canUseBow() {
        return false;
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public int getShieldBreakStrength() {
        if (this.getAttackUse() == 2) {
            return 100;
        }
        return 0;
    }

    public boolean m_213824_() {
        return this.getAttackUse() == 2;
    }

    protected void m_6731_(LivingEntity livingEntity) {
        if (this.getAttackUse() == 2 && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_36384_(true);
        }
    }

    public int getAttackAnim() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_ANIM);
    }

    public void setAttackAnim(int n) {
        this.m_20088_().m_135381_(ATTACK_ANIM, (Object)n);
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public void setAttackTick(int n) {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)n);
    }

    public int getAttackUse() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_USE);
    }

    public void setAttackUse(int n) {
        this.m_20088_().m_135381_(ATTACK_USE, (Object)n);
    }

    public boolean isSmall() {
        return (Boolean)this.m_20088_().m_135370_(IS_SMALL);
    }

    public void setSmall(boolean bl) {
        this.m_20088_().m_135381_(IS_SMALL, (Object)bl);
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "left1")) {
            return 1;
        }
        if (Objects.equals(animation, "right1")) {
            return 2;
        }
        if (Objects.equals(animation, "left2")) {
            return 3;
        }
        if (Objects.equals(animation, "right2")) {
            return 4;
        }
        if (Objects.equals(animation, "left3")) {
            return 5;
        }
        if (Objects.equals(animation, "right3")) {
            return 6;
        }
        if (Objects.equals(animation, "cut")) {
            return 7;
        }
        if (Objects.equals(animation, "roll")) {
            return 8;
        }
        if (Objects.equals(animation, "dead")) {
            return 9;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.left1AnimationState);
        list.add(this.right1AnimationState);
        list.add(this.left2AnimationState);
        list.add(this.right2AnimationState);
        list.add(this.left3AnimationState);
        list.add(this.right3AnimationState);
        list.add(this.cutAnimationState);
        list.add(this.rollAnimationState);
        list.add(this.deadAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_6593_(@Nullable Component component) {
        String string = ChatFormatting.m_126649_((String)component.getString());
        super.m_6593_(component);
        this.bossEvent.m_6456_(this.m_5446_());
        this.setSmall("Skyrim".equals(string));
        this.m_6210_();
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        compoundTag.m_128405_("AttackAnim", this.getAttackAnim());
        compoundTag.m_128405_("AttackTick", this.getAttackTick());
        compoundTag.m_128405_("AttackUse", this.getAttackUse());
        compoundTag.m_128379_("IsSmall", this.isSmall());
        this.m_6210_();
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.setAttackAnim(compoundTag.m_128451_("AttackAnim"));
        this.setAttackTick(compoundTag.m_128451_("AttackTick"));
        this.setAttackUse(compoundTag.m_128451_("AttackUse"));
        this.setSmall(compoundTag.m_128471_("IsSmall"));
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        this.bossEvent.setId(this.m_20148_());
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.isSmall()) {
            return super.m_6972_(pose).m_20390_(0.5714286f, 0.52941173f);
        }
        return super.m_6972_(pose);
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        if (this.isSmall()) {
            return this.m_6162_() ? 0.86f : 1.62f;
        }
        return this.m_6162_() ? 1.63f : 3.05f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(ATTACK_ANIM, (Object)0);
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(ATTACK_USE, (Object)0);
        this.m_20088_().m_135372_(IS_SMALL, (Object)false);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.left1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.left1AnimationState);
                    break;
                }
                case 2: {
                    this.right1AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.right1AnimationState);
                    break;
                }
                case 3: {
                    this.left2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.left2AnimationState);
                    break;
                }
                case 4: {
                    this.right2AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.right2AnimationState);
                    break;
                }
                case 5: {
                    this.left3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.left3AnimationState);
                    break;
                }
                case 6: {
                    this.right3AnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.right3AnimationState);
                    break;
                }
                case 7: {
                    this.cutAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.cutAnimationState);
                    break;
                }
                case 8: {
                    this.rollAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.rollAnimationState);
                    break;
                }
                case 9: {
                    this.deadAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.deadAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesVillageGameRules.JEROTES_VILLAGE_SOME_ELITE_HAS_BOSS_BAR) && OtherMainConfig.EliteCanHasBossBar.contains(this.m_20078_())) {
            this.bossEvent.update();
            if (OtherMainConfig.EliteBossBarOnlyCombat) {
                this.bossEvent.m_8321_(this.m_5448_() != null);
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.m_6084_()) {
            this.idleAnimationState.m_216982_(this.f_19797_);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAttackTick(Math.max(0, this.getAttackTick() - 1));
        }
        if (this.getAttackUse() != 5 && this.getAttackTick() == 15 && this.m_6084_()) {
            this.trueHurt();
        }
        if (this.getAttackUse() == 5 && this.m_6084_() && (this.getAttackTick() == 20 || this.getAttackTick() == 10)) {
            this.trueHurt();
        }
        if (this.getAttackTick() > 0) {
            this.m_21573_().m_26573_();
        }
        if (this.m_5448_() != null && this.getAttackTick() <= 5) {
            if (!this.m_9236_().m_5776_()) {
                this.setAttackAnim(Math.min(this.getAttackAnim() + 1, 10));
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.setAttackAnim(Math.max(this.getAttackAnim() - 2, 0));
        }
        if (this.getAttackTick() > 20 && this.m_5448_() != null) {
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
            this.m_21563_().m_24960_((Entity)this.m_5448_(), 360.0f, 360.0f);
        }
        if (this.getAttackUse() == 2 && this.getAttackTick() <= 20 && this.getAttackTick() > 15) {
            float f = this.m_146908_();
            float f2 = this.m_146909_();
            float f3 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
            float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
            float f5 = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
            float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
            float f7 = 0.15f;
            float f8 = f4 *= f7 / f6 * 2.0f;
            if (!this.m_20096_()) {
                f8 = 0.0f;
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(f3 *= f7 / f6 * 2.0f), (double)f8, (double)(f5 *= f7 / f6 * 2.0f)));
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (this.getAttackTick() > 0) {
            return false;
        }
        if (!this.m_9236_().m_5776_()) {
            boolean onlyRight;
            int attackRandom = this.m_217043_().m_188503_(100);
            boolean onlyLeft = this.m_21205_().m_41619_() && !this.m_21206_().m_41619_();
            boolean bl = onlyRight = !this.m_21205_().m_41619_() && this.m_21206_().m_41619_();
            if (attackRandom > 90) {
                this.setAnimTick(20);
                this.setAttackTick(25);
                this.setAttackUse(1);
                if (onlyRight) {
                    this.setAnimationState("right1");
                } else {
                    this.setAnimationState("left1");
                }
            } else if (attackRandom > 80) {
                this.setAnimTick(20);
                this.setAttackTick(25);
                this.setAttackUse(1);
                if (onlyLeft) {
                    this.setAnimationState("left1");
                } else {
                    this.setAnimationState("right1");
                }
            } else if (attackRandom > 70) {
                this.setAnimTick(20);
                this.setAttackTick(25);
                this.setAttackUse(2);
                if (onlyRight) {
                    this.setAnimationState("right2");
                } else {
                    this.setAnimationState("left2");
                }
            } else if (attackRandom > 60) {
                this.setAnimTick(20);
                this.setAttackTick(25);
                this.setAttackUse(2);
                if (onlyLeft) {
                    this.setAnimationState("left2");
                } else {
                    this.setAnimationState("right2");
                }
            } else if (attackRandom > 50) {
                this.setAnimTick(20);
                this.setAttackTick(25);
                this.setAttackUse(3);
                if (onlyRight) {
                    this.setAnimationState("right3");
                } else {
                    this.setAnimationState("left3");
                }
            } else if (attackRandom > 40) {
                this.setAnimTick(20);
                this.setAttackTick(25);
                this.setAttackUse(3);
                if (onlyLeft) {
                    this.setAnimationState("left3");
                } else {
                    this.setAnimationState("right3");
                }
            } else if (attackRandom > 25) {
                this.setAnimTick(20);
                this.setAttackTick(25);
                this.setAttackUse(4);
                this.setAnimationState("cut");
            } else {
                this.setAnimTick(25);
                this.setAttackTick(30);
                this.setAttackUse(5);
                this.setAnimationState("roll");
            }
        }
        this.m_21573_().m_26573_();
        this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
        return true;
    }

    public boolean trueHurt() {
        if (!this.m_20067_()) {
            if (this.getAttackUse() == 1) {
                this.m_5496_(SoundEvents.f_12313_, 2.0f, 1.0f);
            }
            if (this.getAttackUse() == 2) {
                this.m_5496_(SoundEvents.f_12314_, 2.0f, 1.0f);
            }
            if (this.getAttackUse() == 3) {
                this.m_5496_(SoundEvents.f_12317_, 2.0f, 1.0f);
            }
            if (this.getAttackUse() == 4) {
                this.m_5496_(SoundEvents.f_12316_, 2.0f, 1.0f);
            }
            if (this.getAttackUse() == 5) {
                this.m_5496_(SoundEvents.f_12313_, 2.0f, 1.0f);
            }
        }
        float damageBase = 1.0f;
        float knockbackBase = 1.0f;
        float reach = 1.35f;
        if (this.getAttackUse() == 2) {
            damageBase = 1.5f;
            knockbackBase = 1.75f;
            reach = 1.5f;
        }
        if (this.getAttackUse() == 3) {
            damageBase = 1.25f;
            knockbackBase = 1.25f;
            reach = 1.5f;
        }
        if (this.getAttackUse() == 4) {
            damageBase = 1.75f;
            knockbackBase = 1.25f;
            reach = 1.5f;
        }
        if (this.getAttackUse() == 5) {
            damageBase = 2.0f;
            knockbackBase = 2.0f;
            reach = 1.5f;
        }
        List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_292684_().m_82400_((double)reach));
        for (LivingEntity hurt : list) {
            if (hurt == null || this.m_20280_((Entity)hurt) > 64.0 || AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)hurt) || !this.m_142582_((Entity)hurt) || !Main.canSee((Entity)hurt, (Entity)this) && this.getAttackUse() != 3 && this.getAttackUse() != 4 && this.getAttackUse() != 5) continue;
            AttackFind.attackBegin((LivingEntity)this, (Entity)hurt);
            AttackFind.attackAfter((LivingEntity)this, (Entity)hurt, (float)damageBase, (float)knockbackBase, (boolean)false, (float)0.0f);
        }
        if (this.getAttackUse() == 2) {
            float f = this.m_146908_();
            float f2 = this.m_146909_();
            float f3 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
            float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
            float f5 = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
            float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
            float f7 = 0.5f;
            float f8 = f4 *= f7 / f6 * 2.0f;
            if (!this.m_20096_()) {
                f8 = 0.0f;
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(f3 *= f7 / f6 * 2.0f), (double)f8, (double)(f5 *= f7 / f6 * 2.0f)));
        }
        Main.sweepAttack((Entity)this);
        if (JerotesGameRules.JEROTES_MELEE_CAN_BREAK != null && this.m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_MELEE_CAN_BREAK)) {
            ItemStack hand = this.m_21205_();
            hand.m_41622_(1, (LivingEntity)this, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        return super.m_6469_(damagesource, amount);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.setShieldLevel(2);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    @Override
    public ItemStack createSpawnWeapon(float weaponRandom) {
        return new ItemStack((ItemLike)JerotesVillageItems.WILDERNESS_SWORD.get());
    }

    @Override
    public ItemStack createSpawnOffhand(float offhandRandom) {
        return new ItemStack((ItemLike)JerotesVillageItems.WILDERNESS_SWORD.get());
    }

    public void m_6153_() {
        if (this.f_20919_ <= 0 && !this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("dead");
        }
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

