/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Neutral.Wonderlin;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.jerotes.jerotes.goal.JerotesAddSpellAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIIIMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIIMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesCombatIVMagicAttackGoal;
import com.jerotes.jerotes.goal.JerotesMainSpellAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedBowAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedCrossbowAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedJavelinAttackGoal;
import com.jerotes.jerotes.goal.JerotesRangedThrowAttackGoal;
import com.jerotes.jerotes.goal.JerotesShiftKeyDownGoal;
import com.jerotes.jerotes.goal.JerotesSpearUseGoal;
import com.jerotes.jerotesvillage.entity.Neutral.Wonderlin.BaseWonderlinEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.BasicItemListing;

public class WonderlinMerchantEntity
extends BaseWonderlinEntity
implements Merchant,
RangedAttackMob {
    @Nullable
    private Player tradingPlayer;
    @Nullable
    protected MerchantOffers offers;
    @Nullable
    private BlockPos wanderTarget;
    public static final Int2ObjectMap<VillagerTrades.ItemListing[]> WINDERLIN_MERCHANT = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new BasicItemListing(new ItemStack((ItemLike)Items.f_42398_, 64), new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_FRUIT.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)Items.f_42410_, 2), new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_FRUIT.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_FRUIT.get(), 3), new ItemStack((ItemLike)JerotesVillageItems.IMMORTAL_BREW.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_FRUIT.get(), 5), new ItemStack((ItemLike)JerotesVillageItems.AWN_HERB_BANDAGE.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_FRUIT.get(), 3), new ItemStack((ItemLike)JerotesVillageItems.WONDERLIN_PAINTING.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_FRUIT.get(), 32), new ItemStack((ItemLike)JerotesVillageItems.WONDERLIN_HANG_GLIDER.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_FRUIT.get(), 2), new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_SAPLING.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_FRUIT.get(), 3), new ItemStack((ItemLike)JerotesVillageItems.VINE_THROWING_BALL.get(), 4), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_FRUIT.get(), 12), new ItemStack((ItemLike)JerotesVillageItems.WONDERLIN_SMALL_BAG.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_FRUIT.get(), 16), new ItemStack((ItemLike)JerotesVillageItems.WONDERLIN_FAKE_EARS.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_FRUIT.get(), 32), new ItemStack((ItemLike)JerotesVillageItems.COLLECTING_ARROWS_BALL.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_FRUIT.get(), 32), new ItemStack((ItemLike)JerotesVillageItems.SUSPICIOUS_BRANCH.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_FRUIT.get(), 16), new ItemStack((ItemLike)JerotesVillageItems.RAMBLER_SKIN_WAND.get(), 1), 30, 5, 0.05f), new BasicItemListing(new ItemStack((ItemLike)JerotesVillageItems.WONDERLAND_FRUIT.get(), 64), new ItemStack((ItemLike)JerotesVillageItems.TYRANT_OF_THE_MOUNTAIN_REALM_STATUE.get(), 1), 30, 5, 0.05f)}));

    public WonderlinMerchantEntity(EntityType<? extends WonderlinMerchantEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 5;
    }

    @Override
    public boolean m_7243_(ItemStack itemStack) {
        return false;
    }

    @Override
    protected boolean m_7808_(ItemStack itemStack, ItemStack itemStack2) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.32);
        builder = builder.m_22268_(Attributes.f_22276_, 14.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        return builder;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new JerotesShiftKeyDownGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new JerotesMainSpellAttackGoal((Mob)this, this.getSpellLevel(), 60, 240, 0.5f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesAddSpellAttackGoal((Mob)this, this.getSpellLevel(), 180, 240, 0.5f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIMagicAttackGoal((PathfinderMob)this, 0.5, 15.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIIMagicAttackGoal((PathfinderMob)this, 0.2, true, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIIIMagicAttackGoal((PathfinderMob)this, 0.5, 15.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesCombatIVMagicAttackGoal((PathfinderMob)this, 0.5, 15.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedBowAttackGoal((Mob)this, 0.5, 20, 15.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedCrossbowAttackGoal((Mob)this, 1.0, 15.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedThrowAttackGoal((RangedAttackMob)this, 0.4, 40, 12.0f));
        this.f_21345_.m_25352_(1, (Goal)new JerotesRangedJavelinAttackGoal((RangedAttackMob)this, 1.0, 60, 12.0f, this.meleeOrRangeDistance()));
        this.f_21345_.m_25352_(1, (Goal)new JerotesSpearUseGoal((PathfinderMob)this, 1.0, 1.0, 10.0f, 2.0f));
        this.f_21345_.m_25352_(2, (Goal)new BaseWonderlinEntity.WonderlinMeleeAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BaseWonderlinEntity.WonderlinAvoidGoal(this));
    }

    @Override
    public boolean NonCombatEmptyWeapon() {
        return true;
    }

    @Override
    public boolean NonCombatEmptyShield() {
        return true;
    }

    @Override
    public ItemStack createSpawnWeapon(float weaponRandom) {
        return new ItemStack((ItemLike)JerotesVillageItems.VINE_THROWING_BALL.get());
    }

    public boolean helpAllSameFaction() {
        return false;
    }

    public boolean helpByAllSameFaction() {
        return false;
    }

    public boolean helpSameType() {
        return true;
    }

    public boolean canBeHelp(Entity entity) {
        return false;
    }

    @Override
    public boolean canRush() {
        return true;
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        MerchantOffers merchantOffers = this.m_6616_();
        if (!merchantOffers.isEmpty()) {
            compoundTag.m_128365_("Offers", (Tag)merchantOffers.m_45388_());
        }
        this.m_252802_(compoundTag);
        if (this.wanderTarget != null) {
            compoundTag.m_128365_("WanderTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.wanderTarget));
        }
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("Offers", 10)) {
            this.offers = new MerchantOffers(compoundTag.m_128469_("Offers"));
        }
        this.m_253224_(compoundTag);
        if (compoundTag.m_128441_("WanderTarget")) {
            this.wanderTarget = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_("WanderTarget"));
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (this.m_5448_() == null && this.m_6084_() && !this.isTrading() && !player.m_6144_()) {
            if (interactionHand == InteractionHand.MAIN_HAND) {
                player.m_36220_(Stats.f_12940_);
            }
            if (this.m_6616_().isEmpty()) {
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.offers != null && !this.m_9236_().f_46443_ && !this.offers.isEmpty()) {
                this.startTrading(player);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, interactionHand);
    }

    private void startTrading(Player player) {
        this.updateSpecialPrices(player);
        this.m_7189_(player);
        this.m_45301_(player, this.m_5446_(), 1);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.f_19796_.m_188503_(24000) == 1) {
            for (MerchantOffer merchantOffer : this.m_6616_()) {
                merchantOffer.m_45372_();
            }
        }
        if (this.m_5912_() && this.f_19797_ % 10 == 0 && !this.m_9236_().f_46443_) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 20, 0));
        }
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, amount);
        }
        boolean bl = super.m_6469_(damageSource, amount);
        if (bl) {
            this.stopTrading();
        }
        return bl;
    }

    public void m_7189_(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.updateTrades();
        }
        return this.offers;
    }

    public void m_6255_(@Nullable MerchantOffers merchantOffers) {
    }

    public void m_6621_(int n) {
    }

    private void updateSpecialPrices(Player player) {
        boolean feet;
        this.resetSpecialPrices();
        boolean helmet = player.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.MOUNTAIN_REALM_HELMET.get() || player.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.WONDERLIN_FAKE_EARS.get();
        boolean chestplate = player.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.MOUNTAIN_REALM_CHESTPLATE.get();
        boolean legs = player.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.MOUNTAIN_REALM_LEGGINGS.get();
        boolean bl = feet = player.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.MOUNTAIN_REALM_BOOTS.get();
        if (helmet || chestplate || legs || feet) {
            for (MerchantOffer merchantOffer : this.m_6616_()) {
                double d = 0.4;
                int n3 = (int)Math.floor(d * (double)merchantOffer.m_45352_().m_41613_());
                merchantOffer.m_45353_(-Math.max(n3, 1));
            }
        }
    }

    private void resetSpecialPrices() {
        for (MerchantOffer merchantOffer : this.m_6616_()) {
            merchantOffer.m_45376_();
        }
    }

    public void m_6996_(MerchantOffer merchantOffer) {
        merchantOffer.m_45374_();
        this.f_21363_ = -this.m_8100_();
        this.rewardTradeXp(merchantOffer);
    }

    protected void rewardTradeXp(MerchantOffer merchantOffer) {
        if (merchantOffer.m_45383_()) {
            int n = 3 + this.f_19796_.m_188503_(4);
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), n));
        }
    }

    public boolean m_7826_() {
        return false;
    }

    public void m_7713_(ItemStack itemStack) {
        if (!this.m_9236_().f_46443_ && this.f_21363_ > -this.m_8100_() + 20) {
            this.f_21363_ = -this.m_8100_();
            this.m_5496_(this.getTradeUpdatedSound(!itemStack.m_41619_()), this.m_6121_(), this.m_6100_());
        }
    }

    public int m_7809_() {
        return 0;
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_12275_;
    }

    protected SoundEvent getTradeUpdatedSound(boolean bl) {
        return bl ? SoundEvents.f_12275_ : JerotesVillageSounds.WONDERLIN_AMBIENT;
    }

    @Nullable
    public Entity m_5489_(ServerLevel serverLevel) {
        this.stopTrading();
        return super.m_5489_(serverLevel);
    }

    protected void stopTrading() {
        this.m_7189_(null);
        this.resetSpecialPrices();
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        this.stopTrading();
    }

    public SlotAccess m_141942_(int n) {
        int n2 = n - 300;
        if (n2 >= 0 && n2 < this.m_35311_().m_6643_()) {
            return SlotAccess.m_147292_((Container)this.m_35311_(), (int)n2);
        }
        return super.m_141942_(n);
    }

    protected void updateTrades() {
        VillagerTrades.ItemListing[] arritemListing = (VillagerTrades.ItemListing[])WINDERLIN_MERCHANT.get(1);
        if (arritemListing == null) {
            return;
        }
        MerchantOffers merchantOffers = this.m_6616_();
        this.addOffersFromItemListings(merchantOffers, arritemListing, 9);
    }

    protected void addOffersFromItemListings(MerchantOffers merchantOffers, VillagerTrades.ItemListing[] arritemListing, int n) {
        ArrayList arrayList = Lists.newArrayList((Object[])arritemListing);
        int n2 = 0;
        while (n2 < n && !arrayList.isEmpty()) {
            MerchantOffer merchantOffer = ((VillagerTrades.ItemListing)arrayList.remove(this.f_19796_.m_188503_(arrayList.size()))).m_213663_((Entity)this, this.f_19796_);
            if (merchantOffer == null) continue;
            merchantOffers.add((Object)merchantOffer);
            ++n2;
        }
    }

    public Vec3 m_7398_(float f) {
        float f2 = Mth.m_14179_((float)f, (float)this.f_20884_, (float)this.f_20883_) * ((float)Math.PI / 180);
        Vec3 vec3 = new Vec3(0.0, this.m_20191_().m_82376_() - 1.0, 0.2);
        return this.m_20318_(f).m_82549_(vec3.m_82524_(-f2));
    }

    public boolean m_183595_() {
        return this.m_9236_().f_46443_;
    }
}

