/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Neutral.Zsiein;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.goal.JerotesHelpAlliesGoal;
import com.jerotes.jerotes.goal.JerotesHelpSameFactionGoal;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotesvillage.entity.Boss.Biome.VariantZsieinEntity;
import com.jerotes.jerotesvillage.entity.Neutral.MerorMachine.MerorMachineEntity;
import com.jerotes.jerotesvillage.entity.Neutral.Zsiein.RigiderEntity;
import com.jerotes.jerotesvillage.event.WorldEvent;
import com.jerotes.jerotesvillage.goal.HighNearestAttackableTargetGoal;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class ZsieinEntity
extends PathfinderMob
implements NeutralMob,
OwnableEntity,
JerotesEntity {
    private static final UUID MAX_HEALTH_MODIFIER_UUID = UUID.fromString("9795362f-1129-45a2-b767-392f870c8786");
    private static final UUID ATTACK_DAMAGE_MODIFIER_UUID = UUID.fromString("99be7f89-39b9-48dc-be3b-4678bc3948ff");
    private static final UUID ATTACK_KNOCKBACK_MODIFIER_UUID = UUID.fromString("571c179d-b456-47cf-bec0-212bf584ae73");
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("753cf7d6-ba0a-4890-9206-5dd0e610d7bc");
    private static final UUID KNOCKBACK_RESISTANCE_MODIFIER_UUID = UUID.fromString("a935133e-e959-4060-817c-01ed0a3bcc35");
    private static final UUID MOVEMENT_SPEED_MODIFIER_UUID = UUID.fromString("1065d154-2ee9-4446-978c-bcfee0d58edc");
    private static final UUID FOLLOW_RANGE_MODIFIER_UUID = UUID.fromString("54e2f555-545c-41be-bb8b-747bb42217f1");
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(ZsieinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID_ID = SynchedEntityData.m_135353_(ZsieinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(ZsieinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(ZsieinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public boolean isLandNavigatorType = true;
    private UUID persistentAngerTarget;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    public ZsieinEntity leader;
    private int schoolSize = 1;

    public ZsieinEntity(EntityType<? extends ZsieinEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21530_();
        this.reassessTameGoals();
    }

    public boolean isFactionWith(Entity entity) {
        LivingEntity livingEntity;
        return entity instanceof LivingEntity && OtherEntityFactionFind.isFactionZsiein(livingEntity = (LivingEntity)entity);
    }

    public String getFactionTypeName() {
        return "zsiein";
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpSameFactionGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new JerotesHelpAlliesGoal((Mob)this, LivingEntity.class, false, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new HighNearestAttackableTargetGoal<Player>((Mob)this, Player.class, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(2, new HighNearestAttackableTargetGoal<Mob>((Mob)this, Mob.class, false, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(3, new HighNearestAttackableTargetGoal<MerorMachineEntity>((Mob)this, MerorMachineEntity.class, true, livingEntity -> livingEntity instanceof LivingEntity));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((ZsieinEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_7601_(BlockState blockState, Vec3 vec3) {
        this.m_183634_();
    }

    public boolean m_6785_(double d) {
        return false;
    }

    protected void reassessTameGoals() {
    }

    public void tame(Player player) {
        this.setTame(true);
        this.setOwnerUUID(player.m_20148_());
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_21515_() && (this.m_20069_() || this.m_20077_())) {
            this.m_19920_(this.m_6113_(), vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(vec3);
        }
    }

    public void resetAbout(Level level) {
        if (WorldEvent.ZsieinLatentInfectedAbove(level)) {
            double affinity = WorldEvent.ZsieinAffinityGet(level);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22120_(MAX_HEALTH_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22120_(ATTACK_DAMAGE_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22282_)).m_22120_(ATTACK_KNOCKBACK_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22120_(ARMOR_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22120_(KNOCKBACK_RESISTANCE_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22120_(MOVEMENT_SPEED_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22277_)).m_22120_(FOLLOW_RANGE_MODIFIER_UUID);
            double max_health = Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22115_();
            double attack_damage = Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22115_();
            double attack_knockback = Objects.requireNonNull(this.m_21051_(Attributes.f_22282_)).m_22115_();
            double armor = Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22115_();
            double knockback_resistance = Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22115_();
            double movement_speed = Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22115_();
            double follow_range = Objects.requireNonNull(this.m_21051_(Attributes.f_22277_)).m_22115_();
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22118_(new AttributeModifier(MAX_HEALTH_MODIFIER_UUID, "Zsiein max health", 0.001 * max_health * affinity, AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22118_(new AttributeModifier(ATTACK_DAMAGE_MODIFIER_UUID, "Zsiein attack damage", 0.001 * attack_damage * affinity, AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22282_)).m_22118_(new AttributeModifier(ATTACK_KNOCKBACK_MODIFIER_UUID, "Zsiein attack knockback", 0.001 * attack_knockback * affinity, AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22118_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Zsiein armor", 5.0E-4 * armor * affinity, AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22118_(new AttributeModifier(KNOCKBACK_RESISTANCE_MODIFIER_UUID, "Zsiein knockback resistance", 0.001 * knockback_resistance * affinity, AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22118_(new AttributeModifier(MOVEMENT_SPEED_MODIFIER_UUID, "Zsiein movement speed", 2.5E-4 * movement_speed * affinity, AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(this.m_21051_(Attributes.f_22277_)).m_22118_(new AttributeModifier(FOLLOW_RANGE_MODIFIER_UUID, "Zsiein follow range", 0.003 * follow_range * affinity, AttributeModifier.Operation.ADDITION));
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22120_(MAX_HEALTH_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22120_(ATTACK_DAMAGE_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22282_)).m_22120_(ATTACK_KNOCKBACK_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22284_)).m_22120_(ARMOR_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22278_)).m_22120_(KNOCKBACK_RESISTANCE_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22120_(MOVEMENT_SPEED_MODIFIER_UUID);
            Objects.requireNonNull(this.m_21051_(Attributes.f_22277_)).m_22120_(FOLLOW_RANGE_MODIFIER_UUID);
        }
    }

    protected AABB m_292684_() {
        AABB aabb;
        AABB aabb1;
        double reach = 0.5 + WorldEvent.ZsieinAffinityGet(this.m_9236_()) / 1000.0;
        Entity entity = this.m_20202_();
        if (entity != null) {
            aabb1 = entity.m_20191_();
            AABB aabb2 = this.m_20191_();
            aabb = new AABB(Math.min(aabb2.f_82288_, aabb1.f_82288_), aabb2.f_82289_, Math.min(aabb2.f_82290_, aabb1.f_82290_), Math.max(aabb2.f_82291_, aabb1.f_82291_), aabb2.f_82292_, Math.max(aabb2.f_82293_, aabb1.f_82293_));
        } else {
            aabb = this.m_20191_();
        }
        aabb1 = aabb.m_82377_(Math.sqrt(2.04f) - (double)0.6f, 0.0, Math.sqrt(2.04f) - (double)0.6f);
        return aabb1.m_82377_(reach, reach, reach);
    }

    public boolean m_217066_(LivingEntity livingEntity) {
        return this.m_292684_().m_82381_(livingEntity.m_20191_());
    }

    @Nullable
    public Entity m_5489_(ServerLevel serverLevel) {
        this.resetAbout((Level)serverLevel);
        return super.m_5489_(serverLevel);
    }

    public boolean m_142079_() {
        if (WorldEvent.ZsieinModerateInfectedAbove(this.m_9236_())) {
            return false;
        }
        return super.m_142079_();
    }

    public boolean m_203117_() {
        if (WorldEvent.ZsieinModerateInfectedAbove(this.m_9236_())) {
            return false;
        }
        return super.m_203117_();
    }

    public boolean m_6060_() {
        if (WorldEvent.ZsieinModerateInfectedAbove(this.m_9236_())) {
            return false;
        }
        return super.m_6060_();
    }

    public boolean m_6126_() {
        if (WorldEvent.ZsieinModerateInfectedAbove(this.m_9236_())) {
            return false;
        }
        return super.m_6126_();
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        if (this instanceof VariantZsieinEntity) {
            return;
        }
        this.f_19804_.m_135381_(DATA_OWNER_UUID_ID, Optional.ofNullable(uuid));
    }

    @Nullable
    public UUID m_21805_() {
        if (this instanceof VariantZsieinEntity) {
            return null;
        }
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID_ID)).orElse(null);
    }

    public void setTame(boolean bl) {
        if (this instanceof VariantZsieinEntity) {
            return;
        }
        byte bl1 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (bl) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(bl1 | 4)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(bl1 & 0xFFFFFFFB)));
        }
        this.reassessTameGoals();
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
        this.m_21678_(compoundTag);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
        this.m_147285_(this.m_9236_(), compoundTag);
        this.resetAbout(this.m_9236_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
        this.m_20088_().m_135372_(DATA_FLAGS_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_OWNER_UUID_ID, Optional.empty());
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    protected void spawnTamingParticles(boolean bl) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!bl) {
            particleoptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new GroundPathNavigation((Mob)this, level);
    }

    public void m_8107_() {
        BlockState blockState;
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (WorldEvent.ZsieinModerateInfectedAbove(this.m_9236_())) {
            this.m_20095_();
            if (this.m_146888_() > 0) {
                this.m_146917_(0);
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
        }
        if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
            this.setAnimationState(0);
        }
        if (this.f_19796_.m_188503_(900) == 1 && this.f_20919_ == 0) {
            this.m_5634_(3.0f);
        }
        if (this.m_20069_() && this.isLandNavigatorType) {
            this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.2f, 0.2f, true);
            this.f_21344_ = new AmphibiousPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigatorType = false;
        }
        if (!this.m_20069_() && !this.isLandNavigatorType) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigatorType = true;
        }
        if (this.m_21573_().m_26570_() != null && !this.m_21573_().m_26571_() && (!(blockState = this.m_9236_().m_8055_(this.m_21573_().m_26570_().m_77406_())).m_60819_().m_76178_() && !blockState.m_60795_() || this.m_5448_() != null && this.m_5448_().m_20096_()) && this.m_20069_() && this.f_19862_) {
            for (int n = 0; n < 18; ++n) {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5), this.m_20186_() + 0.5, this.m_20262_(0.5), 0, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.2, ((double)this.m_217043_().m_188501_() - 0.5) * (double)0.2f, 0.5);
            }
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
        }
        this.followAiStep();
    }

    public boolean m_7327_(Entity entity) {
        this.resetAbout(this.m_9236_());
        return super.m_7327_(entity);
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_276093_(DamageTypes.f_268585_) || damageSource.m_276093_(DamageTypes.f_268469_) || damageSource.m_276093_(DamageTypes.f_268440_) || damageSource.m_269533_(DamageTypeTags.f_268549_) || damageSource.m_276093_(DamageTypes.f_268752_) || damageSource.m_276093_(DamageTypes.f_268612_) || damageSource.m_276093_(DamageTypes.f_268493_) || damageSource.m_276093_(DamageTypes.f_268641_) || damageSource.m_276093_(DamageTypes.f_268659_) || damageSource.m_276093_(DamageTypes.f_268526_) || damageSource.m_276093_(DamageTypes.f_268513_)) {
            return true;
        }
        if (WorldEvent.ZsieinModerateInfectedAbove(this.m_9236_()) && (damageSource.m_269533_(DamageTypeTags.f_268745_) || damageSource.m_269533_(DamageTypeTags.f_268419_) || damageSource.m_269533_(DamageTypeTags.f_268725_) || damageSource.m_269533_(DamageTypeTags.f_268581_))) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        LivingEntity livingEntity;
        Mob zsiein;
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        this.resetAbout(this.m_9236_());
        Entity entity = damagesource.m_7639_();
        if (entity instanceof Mob && OtherEntityFactionFind.isZsiein((zsiein = (Mob)entity).m_6095_()) && zsiein.m_5448_() != this && this.m_5448_() != zsiein) {
            return false;
        }
        if (this.m_5448_() == null && (entity = damagesource.m_7639_()) instanceof LivingEntity && !AttackFind.FindCanNotAttack((LivingEntity)this, (Entity)(livingEntity = (LivingEntity)entity))) {
            this.m_6710_(livingEntity);
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_7301_(MobEffectInstance mobEffectInstance) {
        if (mobEffectInstance.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19613_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == MobEffects.f_19620_) {
            return false;
        }
        if (mobEffectInstance.m_19544_() == JerotesMobEffects.ABACK.get()) {
            return false;
        }
        return super.m_7301_(mobEffectInstance);
    }

    public void m_7822_(byte by) {
        if (by == 7) {
            this.spawnTamingParticles(true);
        } else if (by == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.m_7822_(by);
        }
    }

    public boolean m_7307_(Entity entity) {
        LivingEntity livingEntity;
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && EntityFactionFind.isFaction((LivingEntity)this, (LivingEntity)(livingEntity = (LivingEntity)entity))) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    public boolean m_6779_(LivingEntity livingEntity) {
        if ((this.m_5647_() == null && livingEntity.m_5647_() == null || this.m_5647_() == livingEntity.m_5647_()) && EntityFactionFind.isFaction((LivingEntity)this, (LivingEntity)livingEntity)) {
            return false;
        }
        return super.m_6779_(livingEntity);
    }

    public void m_6667_(DamageSource damageSource) {
        Component deathMessage = this.m_21231_().m_19293_();
        super.m_6667_(damageSource);
        if (this.f_20890_ && !this.m_9236_().f_46443_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && this.m_269323_() instanceof ServerPlayer) {
            this.m_269323_().m_213846_(deathMessage);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        this.resetAbout(this.m_9236_());
        this.m_21153_(this.m_21233_());
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int n) {
        this.remainingPersistentAngerTime = n;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID uUID) {
        this.persistentAngerTarget = uUID;
    }

    public int getMaxSchoolSize() {
        return 256;
    }

    protected boolean canRandomSwim() {
        return !this.isFollower();
    }

    public boolean isFollower() {
        return this.leader != null && this.leader.m_6084_();
    }

    public ZsieinEntity startFollowing(ZsieinEntity zsiein) {
        this.leader = zsiein;
        zsiein.addFollower();
        return zsiein;
    }

    public void stopFollowing() {
        if (this.leader != null) {
            this.leader.removeFollower();
        }
        this.leader = null;
    }

    private void addFollower() {
        ++this.schoolSize;
    }

    private void removeFollower() {
        --this.schoolSize;
    }

    public boolean canBeFollowed() {
        return this.hasFollowers() && this.schoolSize < this.getMaxSchoolSize();
    }

    public void followAiStep() {
        List list;
        if (this.hasFollowers() && this.m_9236_().f_46441_.m_188503_(200) == 1 && (list = this.m_9236_().m_45976_(((Object)((Object)this)).getClass(), this.m_20191_().m_82377_(64.0, 64.0, 64.0))).size() <= 1) {
            this.schoolSize = 1;
        }
        List listVariant = this.m_9236_().m_45976_(VariantZsieinEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        List listRigider = this.m_9236_().m_45976_(RigiderEntity.class, this.m_20191_().m_82377_(64.0, 64.0, 64.0));
        if (!listVariant.isEmpty()) {
            if (this.isFollower()) {
                if (!(this.leader instanceof VariantZsieinEntity)) {
                    for (VariantZsieinEntity variantZsiein : listVariant) {
                        this.stopFollowing();
                        this.leader = variantZsiein;
                        variantZsiein.leader = null;
                    }
                }
            } else if (!(this instanceof VariantZsieinEntity)) {
                for (VariantZsieinEntity variantZsiein : listVariant) {
                    this.stopFollowing();
                    this.leader = variantZsiein;
                    variantZsiein.leader = null;
                }
                if (this.hasFollowers()) {
                    this.schoolSize = 1;
                }
            }
        } else if (!listRigider.isEmpty()) {
            if (this.isFollower()) {
                if (!(this.leader instanceof RigiderEntity)) {
                    for (RigiderEntity rigider : listRigider) {
                        this.stopFollowing();
                        this.leader = rigider;
                        rigider.leader = null;
                    }
                }
            } else if (!(this instanceof RigiderEntity)) {
                for (RigiderEntity rigider : listRigider) {
                    this.stopFollowing();
                    this.leader = rigider;
                    rigider.leader = null;
                }
                if (this.hasFollowers()) {
                    this.schoolSize = 1;
                }
            }
        }
    }

    public boolean hasFollowers() {
        return this.schoolSize > 1;
    }

    public boolean inRangeOfLeader() {
        if (this.leader != null) {
            return this.m_20280_((Entity)this.leader) <= 64.0;
        }
        return false;
    }

    public void pathToLeader() {
        if (this.isFollower() && this.leader != null) {
            this.m_21573_().m_5624_((Entity)this.leader, 1.0);
        }
    }

    public void addFollowers(Stream<? extends ZsieinEntity> stream) {
        stream.limit(this.getMaxSchoolSize() - this.schoolSize).filter(zsiein -> zsiein != this).forEach(zsiein -> zsiein.startFollowing(this));
    }

    static class ZsieinRandomStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        private final ZsieinEntity fish;

        public ZsieinRandomStrollGoal(ZsieinEntity zsieinEntity, double d) {
            super((PathfinderMob)zsieinEntity, d);
            this.fish = zsieinEntity;
        }

        public boolean m_8036_() {
            return this.fish.canRandomSwim() && super.m_8036_();
        }
    }
}

