/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Shoot.Magic.MagicShoot;

import com.jerotes.jerotes.entity.magic.MagicAbstractHurtingProjectile;
import com.jerotes.jerotes.init.JerotesParticleTypes;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotesvillage.entity.MagicSummoned.Bulge.BulgeEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RuinsWindChargeEntity
extends MagicAbstractHurtingProjectile
implements ItemSupplier {
    public static final WindChargeExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new WindChargeExplosionDamageCalculator();
    public int life = 0;
    public int spellLevelDamage = 1;

    public RuinsWindChargeEntity(EntityType<? extends RuinsWindChargeEntity> entityType, Level level) {
        super(entityType, level);
    }

    public RuinsWindChargeEntity(EntityType<? extends RuinsWindChargeEntity> entityType, double d, double d2, double d3, double d4, double d5, double d6, Level level) {
        this(entityType, level);
        this.m_7678_(d, d2, d3, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d7 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (d7 != 0.0) {
            this.xPower = d4 / d7 * 0.1;
            this.yPower = d5 / d7 * 0.1;
            this.zPower = d6 / d7 * 0.1;
        }
    }

    public RuinsWindChargeEntity(int spellLevelDamage, Level level, LivingEntity livingEntity, double d, double d2, double d3) {
        super((EntityType)JerotesVillageEntityType.RUINS_WIND_CHARGE.get(), livingEntity, d, d2, d3, level);
        this.spellLevelDamage = spellLevelDamage;
    }

    protected AABB m_142242_() {
        float f = this.m_6095_().m_20680_().f_20377_ / 2.0f;
        float f2 = this.m_6095_().m_20680_().f_20378_;
        float f3 = 0.15f;
        return new AABB(this.m_20182_().f_82479_ - (double)f, this.m_20182_().f_82480_ - (double)0.15f, this.m_20182_().f_82481_ - (double)f, this.m_20182_().f_82479_ + (double)f, this.m_20182_().f_82480_ - (double)0.15f + (double)f2, this.m_20182_().f_82481_ + (double)f);
    }

    public boolean m_7337_(Entity entity) {
        if (entity instanceof RuinsWindChargeEntity) {
            return false;
        }
        return super.m_7337_(entity);
    }

    protected boolean m_5603_(Entity entity) {
        if (entity instanceof RuinsWindChargeEntity) {
            return false;
        }
        return super.m_5603_(entity);
    }

    public static void explode(Entity entity) {
        entity.m_9236_().m_255039_(entity, null, (ExplosionDamageCalculator)EXPLOSION_DAMAGE_CALCULATOR, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (float)(3.0 + RandomSource.m_216327_().m_188500_()), false, Level.ExplosionInteraction.BLOW, (ParticleOptions)JerotesVillageParticleTypes.GUST.get(), (ParticleOptions)ParticleTypes.f_303377_, JerotesSounds.WIND_BURST);
    }

    public static void explodes(Entity self) {
        float radius = (float)(3.0 + RandomSource.m_216327_().m_188500_());
        float f2 = radius * 2.0f;
        AABB explosionArea = new AABB((double)Mth.m_14107_((double)(self.m_20185_() - (double)f2 - 1.0)), (double)Mth.m_14107_((double)(self.m_20186_() - (double)f2 - 1.0)), (double)Mth.m_14107_((double)(self.m_20189_() - (double)f2 - 1.0)), (double)Mth.m_14107_((double)(self.m_20185_() + (double)f2 + 1.0)), (double)Mth.m_14107_((double)(self.m_20186_() + (double)f2 + 1.0)), (double)Mth.m_14107_((double)(self.m_20189_() + (double)f2 + 1.0)));
        List entities = self.m_9236_().m_45933_(self, explosionArea);
        Vec3 center = new Vec3(self.m_20185_(), self.m_20186_(), self.m_20189_());
        for (Entity entity : entities) {
            Player player;
            double distanceRatio = Math.sqrt(entity.m_20238_(center)) / (double)f2;
            if (distanceRatio > 1.0) continue;
            Vec3 delta = new Vec3(entity.m_20185_() - self.m_20185_(), (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - self.m_20186_(), entity.m_20189_() - self.m_20189_());
            double magnitude = delta.m_82553_();
            if (magnitude == 0.0) continue;
            Vec3 direction = delta.m_82541_();
            double force = (1.0 - distanceRatio) * (double)RuinsWindChargeEntity.getSeenPercent(center, entity);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                force = ProtectionEnchantment.m_45135_((LivingEntity)livingEntity, (double)force);
            }
            Vec3 velocity = direction.m_82490_(force);
            entity.m_20256_(entity.m_20184_().m_82549_(velocity));
            if (entity instanceof Player && !(player = (Player)entity).m_5833_() && player.m_7500_() && !player.m_150110_().f_35935_) continue;
        }
    }

    public static float getSeenPercent(Vec3 vec3, Entity entity) {
        AABB aABB = entity.m_20191_();
        double d = 1.0 / ((aABB.f_82291_ - aABB.f_82288_) * 2.0 + 1.0);
        double d2 = 1.0 / ((aABB.f_82292_ - aABB.f_82289_) * 2.0 + 1.0);
        double d3 = 1.0 / ((aABB.f_82293_ - aABB.f_82290_) * 2.0 + 1.0);
        double d4 = (1.0 - Math.floor(1.0 / d) * d) / 2.0;
        double d5 = (1.0 - Math.floor(1.0 / d3) * d3) / 2.0;
        if (d < 0.0 || d2 < 0.0 || d3 < 0.0) {
            return 0.0f;
        }
        int n = 0;
        int n2 = 0;
        for (double d6 = 0.0; d6 <= 1.0; d6 += d) {
            for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                for (double d8 = 0.0; d8 <= 1.0; d8 += d3) {
                    double d9 = Mth.m_14139_((double)d6, (double)aABB.f_82288_, (double)aABB.f_82291_);
                    double d10 = Mth.m_14139_((double)d7, (double)aABB.f_82289_, (double)aABB.f_82292_);
                    double d11 = Mth.m_14139_((double)d8, (double)aABB.f_82290_, (double)aABB.f_82293_);
                    Vec3 vec32 = new Vec3(d9 + d4, d10, d11 + d5);
                    if (entity.m_9236_().m_45547_(new ClipContext(vec32, vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).m_6662_() == HitResult.Type.MISS) {
                        ++n;
                    }
                    ++n2;
                }
            }
        }
        return (float)n / (float)n2;
    }

    protected float m_6380_(Pose pose, EntityDimensions entityDimensions) {
        return 0.0f;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        DamageSource damageSource;
        super.m_5790_(entityHitResult);
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        if (!entity.m_6469_(damageSource = new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268576_), (Entity)this, this.m_19749_()), (float)this.spellLevelDamage * 4.0f)) {
            entity.m_6469_(this.m_269291_().m_269104_((Entity)this, this.m_19749_()), (float)this.spellLevelDamage * 3.0f);
        }
        RuinsWindChargeEntity.explode((Entity)this);
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        RuinsWindChargeEntity.explode((Entity)this);
        this.m_146870_();
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Life", this.life);
        compoundTag.m_128405_("SpellLevelDamage", this.spellLevelDamage);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.life = compoundTag.m_128451_("Life");
        this.spellLevelDamage = compoundTag.m_128451_("SpellLevelDamage");
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.life >= this.getMaxLife()) {
            this.m_146870_();
        } else {
            ++this.life;
        }
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (hitResult.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)hitResult).m_82443_() instanceof BulgeEntity) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    protected boolean shouldBurn() {
        return false;
    }

    public int getMaxLife() {
        return 320;
    }

    protected ParticleOptions getTrailParticle() {
        return (ParticleOptions)JerotesParticleTypes.NULL.get();
    }

    protected ClipContext.Block getClipType() {
        return ClipContext.Block.OUTLINE;
    }

    public ItemStack m_7846_() {
        return ItemStack.f_41583_;
    }

    protected float getInertia() {
        return 1.0f;
    }

    protected float getLiquidInertia() {
        return 1.0f;
    }

    public int getSpellLevel() {
        return this.spellLevelDamage;
    }

    public static final class WindChargeExplosionDamageCalculator
    extends ExplosionDamageCalculator {
        public boolean m_304921_(Explosion explosion, Entity entity) {
            return false;
        }
    }
}

