/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Shoot.Other;

import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.init.JerotesVillageParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class MerorShockWaveEntity
extends Projectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(MerorShockWaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public double xPower;
    public double yPower;
    public double zPower;
    public int life = 0;

    public MerorShockWaveEntity(EntityType<? extends MerorShockWaveEntity> entityType, Level level) {
        super(entityType, level);
    }

    public MerorShockWaveEntity(EntityType<? extends MerorShockWaveEntity> entityType, double d, double d2, double d3, double d4, double d5, double d6, Level level) {
        this(entityType, level);
        this.m_7678_(d, d2, d3, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d7 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (d7 != 0.0) {
            this.xPower = d4 / d7 * 0.1;
            this.yPower = d5 / d7 * 0.1;
            this.zPower = d6 / d7 * 0.1;
        }
    }

    protected MerorShockWaveEntity(EntityType<? extends MerorShockWaveEntity> entityType, double d, double d2, double d3, Level level) {
        this(entityType, level);
        this.m_6034_(d, d2, d3);
    }

    public MerorShockWaveEntity(EntityType<? extends MerorShockWaveEntity> entityType, LivingEntity livingEntity, double d, double d2, double d3, Level level) {
        this(entityType, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), d, d2, d3, level);
        this.m_5602_((Entity)livingEntity);
        this.m_19915_(livingEntity.m_146908_(), livingEntity.m_146909_());
    }

    public boolean m_6783_(double d) {
        double d2;
        double d22 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d22)) {
            d22 = 4.0;
        }
        return d < d2 * (d22 *= 64.0);
    }

    protected ClipContext.Block getClipType() {
        return ClipContext.Block.COLLIDER;
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        LivingEntity livingEntity;
        super.m_5790_(entityHitResult);
        if (this.m_9236_().f_46443_) {
            return;
        }
        Entity entity = entityHitResult.m_82443_();
        Entity entity2 = this.m_19749_();
        this.m_5496_(SoundEvents.f_11913_, 1.0f, 1.0f);
        if (!entity.m_6469_(this.m_269291_().m_269036_((Entity)this, entity2), 12.0f) && entity2 instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity2;
            entity.m_6469_(this.m_269291_().m_269299_((Entity)this, livingEntity), 8.0f);
        }
        this.m_19970_((LivingEntity)entity2, entity);
        Entity entity3 = this.m_19749_();
        if (!(entity3 instanceof LivingEntity) || !AttackFind.FindCanNotAttack((LivingEntity)(livingEntity = (LivingEntity)entity3), (Entity)entity)) {
            entity.m_20334_(this.m_20184_().f_82479_ / 2.0, this.m_20184_().f_82480_ / 2.0, this.m_20184_().f_82481_ / 2.0);
        }
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (hitResult.m_6662_() == HitResult.Type.ENTITY && this.m_150171_(((EntityHitResult)hitResult).m_82443_())) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.life += 4;
        }
    }

    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player) || this.m_19749_() == null) {
            super.m_6123_(player);
        }
    }

    public void m_8119_() {
        float f;
        HitResult hitResult;
        if (this.life >= 30) {
            this.m_146870_();
        } else {
            ++this.life;
        }
        Entity entity = this.m_19749_();
        if (!this.m_9236_().f_46443_ && (entity != null && entity.m_213877_() || !this.m_9236_().m_46805_(this.m_20183_()))) {
            this.life += 20;
            return;
        }
        super.m_8119_();
        if (this.shouldBurn()) {
            this.m_20254_(1);
        }
        if ((hitResult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_)).m_6662_() != HitResult.Type.MISS) {
            this.m_6532_(hitResult);
        }
        this.m_20101_();
        Vec3 vec3 = this.m_20184_();
        double d = this.m_20185_() + vec3.f_82479_ * 1.0;
        double d2 = this.m_20186_() + vec3.f_82480_ * 1.0;
        double d3 = this.m_20189_() + vec3.f_82481_ * 1.0;
        ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                float f2 = 0.25f;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d - vec3.f_82479_ * 0.25, d2 - vec3.f_82480_ * 0.25, d3 - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
            f = this.getLiquidInertia();
        } else {
            f = this.getInertia();
        }
        this.m_20256_(vec3.m_82520_(this.xPower, this.yPower, this.zPower).m_82490_((double)f));
        ParticleOptions particleOptions = this.getTrailParticle();
        if (particleOptions != null) {
            this.m_9236_().m_7106_(particleOptions, d, d2 + 0.5, d3, 0.0, 0.0, 0.0);
        }
        this.m_6034_(d, d2, d3);
    }

    protected boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) && !entity.f_19794_;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        return false;
    }

    protected ParticleOptions getTrailParticle() {
        return (ParticleOptions)JerotesVillageParticleTypes.MEROR_SHOCK_WAVE.get();
    }

    protected boolean shouldBurn() {
        return false;
    }

    protected float getInertia() {
        return 0.999f;
    }

    protected float getLiquidInertia() {
        return 0.99f;
    }

    public void setItem(ItemStack itemStack) {
        if (!itemStack.m_150930_(Items.f_41852_) || itemStack.m_41782_()) {
            this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)itemStack.m_255036_(1));
        }
    }

    protected ItemStack getItemRaw() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    public ItemStack m_7846_() {
        ItemStack itemStack = this.getItemRaw();
        return itemStack.m_41619_() ? new ItemStack((ItemLike)JerotesVillageItems.MEROR_SHOCK_WAVE.get()) : itemStack;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Life", this.life);
        ItemStack itemStack = this.getItemRaw();
        if (!itemStack.m_41619_()) {
            compoundTag.m_128365_("Item", (Tag)itemStack.m_41739_(new CompoundTag()));
        }
        compoundTag.m_128365_("power", (Tag)this.m_20063_(new double[]{this.xPower, this.yPower, this.zPower}));
    }

    public void m_7378_(CompoundTag compoundTag) {
        ListTag listTag;
        super.m_7378_(compoundTag);
        this.life = compoundTag.m_128451_("Life");
        ItemStack itemStack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("Item"));
        this.setItem(itemStack);
        if (compoundTag.m_128425_("power", 9) && (listTag = compoundTag.m_128437_("power", 6)).size() == 3) {
            this.xPower = listTag.m_128772_(0);
            this.yPower = listTag.m_128772_(1);
            this.zPower = listTag.m_128772_(2);
        }
    }

    public float m_6143_() {
        return 1.0f;
    }

    public float m_213856_() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        Entity entity = this.m_19749_();
        int n = entity == null ? 0 : entity.m_19879_();
        return new ClientboundAddEntityPacket(this.m_19879_(), this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), n, new Vec3(this.xPower, this.yPower, this.zPower), 0.0);
    }

    public void m_141965_(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        super.m_141965_(clientboundAddEntityPacket);
        double d = clientboundAddEntityPacket.m_131503_();
        double d2 = clientboundAddEntityPacket.m_131504_();
        double d3 = clientboundAddEntityPacket.m_131505_();
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        if (d4 != 0.0) {
            this.xPower = d / d4 * 0.1;
            this.yPower = d2 / d4 * 0.1;
            this.zPower = d3 / d4 * 0.1;
        }
    }

    protected float getWaterInertia() {
        return 0.99f;
    }
}

