/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Smart;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.SpellUseEntity;
import com.jerotes.jerotesvillage.entity.Smart.SmartEntity;
import com.jerotes.jerotesvillage.goal.BulgeFloatGoal;
import com.jerotes.jerotesvillage.goal.HighNearestAttackableTargetGoal;
import com.jerotes.jerotesvillage.goal.SmartBulgeAttackGoal;
import com.jerotes.jerotesvillage.goal.SmartBulgeDodgeProjectileGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageSounds;
import com.jerotes.jerotesvillage.spell.OtherSpellList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class SmartBulgeEntity
extends SmartEntity
implements RangedAttackMob,
JerotesEntity,
SpellUseEntity {
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState shootAnimationState = new AnimationState();
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(SmartBulgeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIM_TICK = SynchedEntityData.m_135353_(SmartBulgeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int spellLevel = 3;

    public SmartBulgeEntity(EntityType<? extends SmartBulgeEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 10;
        this.m_274367_(0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public boolean m_6914_(LevelReader levelReader) {
        return levelReader.m_45784_((Entity)this);
    }

    public void m_7023_(Vec3 vec3) {
        if (this.m_6109_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), vec3);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        } else {
            super.m_7023_(vec3);
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BulgeFloatGoal((Mob)this, 0.35f));
        this.f_21345_.m_25352_(1, (Goal)new SmartBulgeAttackGoal(this, 1.0, 60, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new SmartBulgeDodgeProjectileGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, new HighNearestAttackableTargetGoal<Player>((Mob)this, Player.class, true));
    }

    private float m_21376_(float p_21377_, float p_21378_, float p_21379_) {
        float f = Mth.m_14177_((float)(p_21378_ - p_21377_));
        if (f > p_21379_) {
            f = p_21379_;
        }
        if (f < -p_21379_) {
            f = -p_21379_;
        }
        return p_21377_ + f;
    }

    public void lookJump(Entity p_21392_, float p_21393_, float p_21394_) {
        double d1;
        double d0 = p_21392_.m_20185_() - this.m_20185_();
        double d2 = p_21392_.m_20189_() - this.m_20189_();
        if (p_21392_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_21392_;
            d1 = livingentity.m_20188_() - this.m_20188_();
        } else {
            d1 = (p_21392_.m_20191_().f_82289_ + p_21392_.m_20191_().f_82292_) / 2.0 - this.m_20188_();
        }
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float ff = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        float ff1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
        float f1 = this.m_21376_(this.m_146909_(), ff1, p_21394_);
        float f2 = this.m_21376_(this.m_146908_(), ff, p_21393_);
        float f3 = -Mth.m_14031_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f4 = -Mth.m_14031_((float)(f2 * ((float)Math.PI / 180)));
        float f5 = Mth.m_14089_((float)(f1 * ((float)Math.PI / 180))) * Mth.m_14089_((float)(f2 * ((float)Math.PI / 180)));
        float f6 = Mth.m_14116_((float)(f3 * f3 + f4 * f4 + f5 * f5));
        float f7 = -0.3f;
        this.m_6853_(false);
        this.m_20256_(this.m_20184_().m_82520_((double)(f3 *= f7 / f6 * 2.0f), 0.3, (double)(f5 *= f7 / f6 * 2.0f)));
    }

    public void m_6504_(LivingEntity livingEntity, float f) {
        if (this.m_20270_((Entity)livingEntity) < Math.max(6.0f, livingEntity.m_20205_() / 1.5f)) {
            this.lookJump((Entity)livingEntity, 360.0f, 360.0f);
        }
        if (!this.m_9236_().m_5776_()) {
            this.setAnimTick(20);
            this.setAnimationState("shoot");
        }
        OtherSpellList.BulgeBullet(this.getSpellLevel(), (LivingEntity)this, (Entity)livingEntity).spellUse();
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22277_, 24.0);
        return builder;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public SoundEvent m_7515_() {
        return JerotesVillageSounds.BULGE_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return JerotesVillageSounds.BULGE_HURT;
    }

    protected SoundEvent m_5592_() {
        return JerotesVillageSounds.BULGE_DEATH;
    }

    protected float m_6121_() {
        return 0.5f;
    }

    public int getSpellLevel() {
        return this.spellLevel;
    }

    public void setAnimTick(int n) {
        this.m_20088_().m_135381_(ANIM_TICK, (Object)n);
    }

    public int getAnimTick() {
        return (Integer)this.m_20088_().m_135370_(ANIM_TICK);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "shoot")) {
            return 1;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> list = new ArrayList<AnimationState>();
        list.add(this.shootAnimationState);
        return list;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public void stopAllAnimation() {
        for (AnimationState state : this.getAllAnimations()) {
            state.m_216973_();
        }
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("SpellLevel", this.spellLevel);
        compoundTag.m_128405_("AnimTick", this.getAnimTick());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.spellLevel = compoundTag.m_128451_("SpellLevel");
        this.setAnimTick(compoundTag.m_128451_("AnimTick"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ANIM_STATE, (Object)0);
        this.m_20088_().m_135372_(ANIM_TICK, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ANIM_STATE.equals(entityDataAccessor) && this.m_9236_().m_5776_()) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    this.stopAllAnimation();
                    break;
                }
                case 1: {
                    this.shootAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.shootAnimationState);
                }
            }
        }
        super.m_7350_(entityDataAccessor);
    }

    public boolean m_6063_() {
        return false;
    }

    public int m_8100_() {
        return 480;
    }

    protected PathNavigation m_6037_(Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 1.125f;
    }

    @Override
    public void m_8107_() {
        block5: {
            Player player;
            Object object;
            super.m_8107_();
            this.m_20095_();
            if (this.m_6084_()) {
                this.idleAnimationState.m_216982_(this.f_19797_);
            }
            if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (object = this.m_5448_()) instanceof Player && ((player = (Player)object).m_7500_() || player.m_5833_()))) {
                this.m_6710_(null);
            }
            Vec3 vec3 = this.m_20184_();
            if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
                this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
            }
            if (!this.m_9236_().m_5776_()) {
                this.setAnimTick(Math.max(-1, this.getAnimTick() - 1));
            }
            if (this.getAnimTick() == 0 && !this.m_9236_().m_5776_()) {
                this.setAnimationState(0);
            }
            if (!(object = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(6.0), e -> {
                Mob mob;
                return e != this && (e.f_20913_ == -1 || e.f_20911_) && (e.m_20270_((Entity)e) <= 4.0f || e instanceof Mob && (mob = (Mob)e).m_217066_((LivingEntity)this)) && this.m_20096_() && this.m_5912_() && this.m_217043_().m_188503_(20) == 1;
            }).iterator()).hasNext()) break block5;
            LivingEntity livingEntity = (LivingEntity)object.next();
            Vec3 awayDir = this.m_20182_().m_82546_(livingEntity.m_20182_()).m_82541_().m_82490_(0.5);
            this.m_6853_(false);
            this.m_20334_(awayDir.f_82479_, 0.15, awayDir.f_82481_);
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_269533_(DamageTypeTags.f_268581_) || damageSource.m_269533_(DamageTypeTags.f_268549_)) {
            return true;
        }
        return super.m_6673_(damageSource);
    }
}

