/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.entity.Smart;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotesvillage.JerotesVillage;
import com.jerotes.jerotesvillage.init.JerotesVillageEntityType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class SmartEntity
extends PathfinderMob
implements JerotesEntity {
    public static final EntityDataAccessor<Boolean> SHOULD_REPORT = SynchedEntityData.m_135353_(SmartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> SMART_LEVEL = SynchedEntityData.m_135353_(SmartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float distanceToTarget = 8.0f;
    public boolean hasLineOfSightWithBlock = true;
    public boolean hasLineOfSightWithEntity = true;
    public boolean canMoveTo = true;
    public boolean targetPositionDanger = false;
    public boolean thisPositionDanger = false;
    public float heightWithTarget = 0.0f;
    public float targetHealthPercent = 1.0f;
    public float targetAttributeLevel = 2000.0f;
    public float targetHealthTrendShort = 0.0f;
    public float targetHealthTrendLong = 0.0f;
    public int targetPotionLevel = 0;
    public float targetSizeCompare = 1.0f;
    private Vec3 lastSelfPos = null;
    private final Map<UUID, Vec3> lastTargetPos = new HashMap<UUID, Vec3>();
    public float targetMoveState = 1.0f;
    public Vec3 targetMoveDirection = Vec3.f_82478_;
    public int targetAlliesNearby = 0;
    public ItemStack targetMainHandItem = ItemStack.f_41583_;
    public ItemStack targetUseItem = ItemStack.f_41583_;
    private final Deque<DistanceRecord> targetAttackHistory = new ArrayDeque<DistanceRecord>();
    private final Deque<DistanceRecord> selfAttackHistory = new ArrayDeque<DistanceRecord>();
    public float avgTargetAttackDistance = this.getAvgTargetAttackDistance();
    public float avgSelfAttackDistance = this.getAvgSelfAttackDistance();
    public float selfHealthPercent = 1.0f;
    public float selfAttributeLevel = 2000.0f;
    public float selfHealthTrendShort = 0.0f;
    public float selfHealthTrendLong = 0.0f;
    public int selfPotionLevel = this.calculatePotionLevel((LivingEntity)this);
    public float selfMoveState = 1.0f;
    public int selfUsableTypes = 1;
    public int selfAlliesNearby = 0;
    public boolean incomingProjectileDanger = false;
    public Entity extraAttacker = null;
    public boolean needRest = false;
    public int selfIntelligenceLevel = this.getSmartLevel();
    private final Map<UUID, HealthRecord> healthHistory = new HashMap<UUID, HealthRecord>();
    private final Deque<AttackRecord> attackHistory = new ArrayDeque<AttackRecord>();

    public SmartEntity(EntityType<? extends SmartEntity> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22276_, 1024.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 128.0);
        return builder;
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 1.62f;
    }

    public void m_6710_(@Nullable LivingEntity livingEntity) {
        this.healthHistory.clear();
        if (!this.attackHistory.isEmpty()) {
            this.attackHistory.clear();
        }
        super.m_6710_(livingEntity);
        this.resetKnow();
    }

    public void resetKnow() {
        LivingEntity target = this.m_5448_();
        long now = this.m_9236_().m_46467_();
        if (target != null) {
            this.distanceToTarget = this.m_20270_((Entity)target);
            this.hasLineOfSightWithBlock = this.m_142582_((Entity)target);
            this.hasLineOfSightWithEntity = this.canSeeEntity((Entity)target);
            Path path = this.m_21573_().m_6570_((Entity)target, 0);
            this.canMoveTo = path != null && path.m_77403_();
            this.targetPositionDanger = this.isPositionDangerous(target.m_20183_());
            this.thisPositionDanger = this.isPositionDangerous(this.m_20183_());
            this.heightWithTarget = (float)(this.m_20186_() - target.m_20186_());
            this.targetHealthPercent = target.m_21223_() / target.m_21233_();
            this.targetAttributeLevel = (int)((target.m_21051_(Attributes.f_22276_) != null ? target.m_21051_(Attributes.f_22276_).m_22135_() : 0.0) * (target.m_21051_(Attributes.f_22281_) != null ? target.m_21051_(Attributes.f_22281_).m_22135_() : 0.0) * (target.m_21051_(Attributes.f_22284_) != null ? target.m_21051_(Attributes.f_22284_).m_22135_() + 20.0 : 20.0));
            this.targetHealthTrendShort = this.calcHealthTrend(target, 40);
            this.targetHealthTrendLong = this.calcHealthTrend(target, 200);
            this.targetPotionLevel = this.calculatePotionLevel(target);
            this.targetSizeCompare = target.m_20205_() * target.m_20205_() * target.m_20206_() / (this.m_20205_() * this.m_20205_() * this.m_20206_());
            this.targetMoveState = this.detectMoveState(target);
            this.targetMoveDirection = target.m_20184_();
            this.targetAlliesNearby = this.m_9236_().m_6443_(target.getClass(), target.m_20191_().m_82400_(8.0), e -> e != target && e.m_6084_()).size();
            this.targetMainHandItem = target.m_21205_();
            this.targetUseItem = target.m_6117_() ? target.m_21211_() : ItemStack.f_41583_;
            this.avgTargetAttackDistance = this.getAvgTargetAttackDistance();
            this.avgSelfAttackDistance = this.getAvgSelfAttackDistance();
            this.selfHealthPercent = this.m_21223_() / this.m_21233_();
            this.selfAttributeLevel = (int)((this.m_21051_(Attributes.f_22276_) != null ? this.m_21051_(Attributes.f_22276_).m_22135_() : 0.0) * (this.m_21051_(Attributes.f_22281_) != null ? this.m_21051_(Attributes.f_22281_).m_22135_() : 0.0) * (this.m_21051_(Attributes.f_22284_) != null ? this.m_21051_(Attributes.f_22284_).m_22135_() + 20.0 : 20.0));
            this.selfHealthTrendShort = this.calcHealthTrend((LivingEntity)this, 40);
            this.selfHealthTrendLong = this.calcHealthTrend((LivingEntity)this, 200);
            this.selfPotionLevel = this.calculatePotionLevel((LivingEntity)this);
            this.selfMoveState = this.detectSelfMoveState();
            this.selfUsableTypes = this.evaluateSelfType();
            this.selfAlliesNearby = this.m_9236_().m_6443_(((Object)((Object)this)).getClass(), this.m_20191_().m_82400_(8.0), e -> e != this && e.m_6084_()).size();
            this.incomingProjectileDanger = this.detectProjectileDanger();
            this.extraAttacker = this.findExtraAttacker();
            this.needRest = false;
            this.selfIntelligenceLevel = this.getSmartLevel();
        } else {
            this.distanceToTarget = 8.0f;
            this.hasLineOfSightWithBlock = true;
            this.hasLineOfSightWithEntity = true;
            this.canMoveTo = true;
            this.targetPositionDanger = false;
            this.thisPositionDanger = false;
            this.heightWithTarget = 0.0f;
            this.healthHistory.clear();
            this.targetHealthPercent = 1.0f;
            this.targetAttributeLevel = 2000.0f;
            this.targetHealthTrendShort = 0.0f;
            this.targetHealthTrendLong = 0.0f;
            this.targetPotionLevel = 0;
            this.targetSizeCompare = 1.0f;
            this.targetMoveState = 1.0f;
            this.targetMoveDirection = Vec3.f_82478_;
            this.targetAlliesNearby = 0;
            this.targetMainHandItem = ItemStack.f_41583_;
            this.targetUseItem = ItemStack.f_41583_;
            this.avgTargetAttackDistance = this.getAvgTargetAttackDistance();
            this.avgSelfAttackDistance = this.getAvgSelfAttackDistance();
            this.selfHealthPercent = this.m_21223_() / this.m_21233_();
            this.selfAttributeLevel = 2000.0f;
            this.selfHealthTrendShort = 0.0f;
            this.selfHealthTrendLong = 0.0f;
            this.selfPotionLevel = this.calculatePotionLevel((LivingEntity)this);
            this.selfMoveState = 1.0f;
            this.selfUsableTypes = 1;
            this.selfAlliesNearby = 0;
            this.incomingProjectileDanger = false;
            this.extraAttacker = null;
            this.needRest = false;
            this.selfIntelligenceLevel = this.getSmartLevel();
        }
        this.healthHistory.entrySet().removeIf(e -> now - ((HealthRecord)e.getValue()).lastUpdateTick > 2000L);
    }

    private void pruneHistory(Deque<DistanceRecord> history) {
        long cutoff = this.m_9236_().m_46467_() - 400L;
        while (!history.isEmpty() && history.getFirst().tick < cutoff) {
            history.removeFirst();
        }
    }

    public void recordTargetAttack(LivingEntity attacker) {
        float dist = this.m_20270_((Entity)attacker);
        this.targetAttackHistory.addLast(new DistanceRecord(dist, this.m_9236_().m_46467_()));
        this.pruneHistory(this.targetAttackHistory);
    }

    public void recordSelfAttack(LivingEntity target) {
        float dist = this.m_20270_((Entity)target);
        this.selfAttackHistory.addLast(new DistanceRecord(dist, this.m_9236_().m_46467_()));
        this.pruneHistory(this.selfAttackHistory);
    }

    private float averageDistance(Deque<DistanceRecord> history) {
        this.pruneHistory(history);
        if (history.isEmpty()) {
            return -1.0f;
        }
        float sum = 0.0f;
        for (DistanceRecord r : history) {
            sum += r.distance;
        }
        return sum / (float)history.size();
    }

    public float getAvgTargetAttackDistance() {
        return this.averageDistance(this.targetAttackHistory);
    }

    public float getAvgSelfAttackDistance() {
        return this.averageDistance(this.selfAttackHistory);
    }

    private int calculatePotionLevel(LivingEntity entity) {
        int level = 0;
        for (MobEffectInstance effect : entity.m_21220_()) {
            int amp = effect.m_19564_() + 1;
            if (effect.m_19544_().m_19486_()) {
                level += amp;
                continue;
            }
            level -= amp;
        }
        return level;
    }

    private float detectMoveState(LivingEntity target) {
        UUID id = target.m_20148_();
        Vec3 lastPos = this.lastTargetPos.getOrDefault(id, target.m_20182_());
        Vec3 currentPos = target.m_20182_();
        Vec3 selfPos = this.m_20182_();
        float lastDistance = (float)lastPos.m_82554_(this.lastSelfPos != null ? this.lastSelfPos : selfPos);
        float currentDistance = (float)currentPos.m_82554_(selfPos);
        this.lastTargetPos.put(id, currentPos);
        this.lastSelfPos = selfPos;
        float diff = currentDistance - lastDistance;
        if (diff < -0.05f) {
            return 1.0f;
        }
        if (diff > 0.05f) {
            return 3.0f;
        }
        return 2.0f;
    }

    private float detectSelfMoveState() {
        if (this.lastSelfPos == null) {
            this.lastSelfPos = this.m_20182_();
            return 2.0f;
        }
        float diff = (float)this.m_20182_().m_82554_(this.lastSelfPos);
        float state = diff < 0.01f ? 2.0f : 1.0f;
        this.lastSelfPos = this.m_20182_();
        return state;
    }

    private boolean canSeeEntity(Entity target) {
        AABB box;
        Vec3 end;
        Vec3 start = this.m_146892_();
        EntityHitResult hit = ProjectileUtil.m_37287_((Entity)this, (Vec3)start, (Vec3)(end = target.m_146892_()), (AABB)(box = this.m_20191_().m_82369_(end.m_82546_(start)).m_82400_(1.0)), e -> e.m_6087_() && !e.m_5833_() && e != this, (double)start.m_82557_(end));
        return hit == null || hit.m_82443_() == target;
    }

    private boolean isPositionDangerous(BlockPos pos) {
        Level level = this.m_9236_();
        return WalkNodeEvaluator.m_77604_((BlockGetter)level, (BlockPos.MutableBlockPos)pos.m_7495_().m_122032_()) == BlockPathTypes.DANGER_OTHER;
    }

    private float calcHealthTrend(LivingEntity entity, int tickWindow) {
        UUID id = entity.m_20148_();
        long now = this.m_9236_().m_46467_();
        HealthRecord record = this.healthHistory.get(id);
        if (record == null || now - record.lastUpdateTick > (long)tickWindow) {
            this.healthHistory.put(id, new HealthRecord(entity.m_21223_(), now));
            return 0.0f;
        }
        float diff = entity.m_21223_() - record.lastHealth;
        record.lastHealth = entity.m_21223_();
        record.lastUpdateTick = now;
        return diff;
    }

    private int evaluateSelfType() {
        return 1;
    }

    private boolean detectProjectileDanger() {
        return !this.m_9236_().m_6443_(Projectile.class, this.m_20191_().m_82400_(8.0), p -> p.m_6084_() && p.m_20184_().m_82556_() > 0.01).isEmpty();
    }

    private Entity findExtraAttacker() {
        return this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(12.0), e -> e != this && e.m_21214_() == this).stream().findFirst().orElse(null);
    }

    private void pruneAttackHistory() {
        long cutoff = this.m_9236_().m_46467_() - 400L;
        while (!this.attackHistory.isEmpty() && this.attackHistory.getFirst().tick < cutoff) {
            this.attackHistory.removeFirst();
        }
    }

    private void recordIncomingAttackFrom(LivingEntity attacker) {
        float dist = this.m_20270_((Entity)attacker);
        this.attackHistory.addLast(new AttackRecord(dist, this.m_9236_().m_46467_()));
        this.pruneAttackHistory();
    }

    private float evaluateCombatType() {
        this.pruneAttackHistory();
        if (this.attackHistory.isEmpty()) {
            return 1.0f;
        }
        float sum = 0.0f;
        for (AttackRecord r : this.attackHistory) {
            sum += r.distance;
        }
        float avgDist = sum / (float)this.attackHistory.size();
        if (avgDist <= 3.0f) {
            return 1.0f;
        }
        if (avgDist >= 8.0f) {
            return 2.0f;
        }
        return 1.0f + (avgDist - 3.0f) / 5.0f;
    }

    public boolean isShouldReport() {
        return (Boolean)this.m_20088_().m_135370_(SHOULD_REPORT);
    }

    public void setShouldReport(boolean bl) {
        this.m_20088_().m_135381_(SHOULD_REPORT, (Object)bl);
    }

    public int getSmartLevel() {
        return (Integer)this.m_20088_().m_135370_(SMART_LEVEL);
    }

    public void setSmartLevel(int n) {
        this.m_20088_().m_135381_(SMART_LEVEL, (Object)n);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("ShouldReport", this.isShouldReport());
        compoundTag.m_128405_("SmartLevel", this.getSmartLevel());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setShouldReport(compoundTag.m_128471_("ShouldReport"));
        this.setSmartLevel(compoundTag.m_128451_("SmartLevel"));
        this.resetKnow();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(SHOULD_REPORT, (Object)(this.m_6095_() == JerotesVillageEntityType.SMART.get() || this.m_6095_() == JerotesVillageEntityType.SMART_BULGE.get() ? 1 : 0));
        this.m_20088_().m_135372_(SMART_LEVEL, (Object)5);
    }

    protected Component getSay() {
        StringBuilder string = new StringBuilder();
        if (this.m_5448_() == null) {
            string.append("\u6ca1\u6709\u654c\u4eba/NoTarget:true;\n");
        } else {
            LivingEntity livingEntity = this.m_5448_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                string.append("\u654c\u4eba\u662f\u73a9\u5bb6/TargetIsPlayer:").append(player.m_7755_().getString()).append(";\n");
            } else {
                livingEntity = this.m_5448_();
                if (livingEntity instanceof Mob) {
                    Mob mob = (Mob)livingEntity;
                    string.append("\u654c\u4eba\u662fMob/TargetIsMob:").append(mob.m_7755_().getString()).append(";\n");
                } else {
                    string.append("\u654c\u4eba\u662f\u751f\u7269/TargetIsLivingEntity:").append(this.m_5448_().m_7755_().getString()).append(";\n");
                }
            }
            string.append("\u4e0e\u654c\u4eba\u7684\u8ddd\u79bb/DistanceToTarget:").append(String.format("%.2f", Float.valueOf(this.distanceToTarget))).append(";\n");
            string.append("\u89c6\u7ebf\u88ab\u65b9\u5757\u963b\u6321/LineOfSightBlockedByBlocks:").append(!this.hasLineOfSightWithBlock).append(";\n");
            string.append("\u89c6\u7ebf\u88ab\u5b9e\u4f53\u963b\u6321/LineOfSightBlockedByEntities:").append(!this.hasLineOfSightWithEntity).append(";\n");
            string.append("\u662f\u5426\u53ef\u5230\u8fbe\u654c\u4eba/CanReachTarget:").append(this.canMoveTo).append(";\n");
            string.append("\u654c\u4eba\u4f4d\u7f6e\u5371\u9669/TargetPositionDanger:").append(this.targetPositionDanger).append(";\n");
            string.append("\u81ea\u8eab\u4f4d\u7f6e\u5371\u9669/SelfPositionDanger:").append(this.thisPositionDanger).append(";\n");
            string.append("\u4e0e\u654c\u4eba\u7684\u9ad8\u5ea6\u5dee(\u81ea\u5df1-\u654c\u4eba)/HeightDifference:").append(String.format("%.2f", Float.valueOf(this.heightWithTarget))).append(";\n");
            string.append("\u654c\u4eba\u751f\u547d\u503c\u767e\u5206\u6bd4/TargetHPPercent:").append(String.format("%.2f", Float.valueOf(this.targetHealthPercent))).append(";\n");
            string.append("\u654c\u4eba\u5c5e\u6027\u6c34\u5e73/TargetAttributeLevel:").append(String.format("%.0f", Float.valueOf(this.targetAttributeLevel))).append(";\n");
            string.append("\u654c\u4eba\u77ed\u671f\u8840\u91cf\u8d8b\u52bf/TargetShortTermHPTrend:").append(String.format("%.2f", Float.valueOf(this.targetHealthTrendShort))).append(";\n");
            string.append("\u654c\u4eba\u957f\u671f\u8840\u91cf\u8d8b\u52bf/TargetLongTermHPTrend:").append(String.format("%.2f", Float.valueOf(this.targetHealthTrendLong))).append(";\n");
            string.append("\u654c\u4eba\u836f\u6c34\u6548\u679c\u7b49\u7ea7/TargetPotionEffectLevel:").append(this.targetPotionLevel > 0 ? "+" + this.targetPotionLevel : Integer.valueOf(this.targetPotionLevel)).append(";\n");
            string.append("\u654c\u4eba\u4f53\u578b\u4e0e\u81ea\u8eab\u6bd4\u4f8b/TargetSizeCompare:").append(String.format("%.2f", Float.valueOf(this.targetSizeCompare))).append(";\n");
            string.append("\u654c\u4eba\u79fb\u52a8\u72b6\u6001/TargetMoveState:").append(this.targetMoveState == 1.0f ? "\u9760\u8fd1/approaching" : (this.targetMoveState == 2.0f ? "\u7ad9\u7acb/idle" : "\u8fdc\u79bb/retreating")).append(";\n");
            string.append("\u654c\u4eba\u79fb\u52a8\u65b9\u5411/TargetMoveDirection:").append(this.targetMoveDirection).append(";\n");
            string.append("\u654c\u4eba\u9644\u8fd1\u540c\u4f34\u6570\u91cf/TargetNearbyAllies:").append(this.targetAlliesNearby).append(";\n");
            string.append("\u654c\u4eba\u624b\u6301\u7269\u54c1/TargetMainHandItem:").append(this.targetMainHandItem.m_41786_().getString()).append(";\n");
            string.append("\u654c\u4eba\u4f7f\u7528\u7269\u54c1/TargetUsingItem:").append(this.targetUseItem.m_41619_() ? "none" : this.targetUseItem.m_41786_().getString()).append(";\n");
            string.append("\u76ee\u6807\u653b\u51fb\u7684\u5e73\u5747\u8ddd\u79bb/AvgTargetAttackDistance:").append(String.format("%.2f", Float.valueOf(this.avgTargetAttackDistance))).append(";\n");
            string.append("\u81ea\u5df1\u653b\u51fb\u7684\u5e73\u5747\u8ddd\u79bb/AvgSelfAttackDistance:").append(String.format("%.2f", Float.valueOf(this.avgSelfAttackDistance))).append(";\n");
        }
        if (this.m_21188_() != null) {
            string.append("\u521a\u521a\u88ab\u653b\u51fb/IWasJustAttackedBy:").append(this.m_21188_().m_7755_().getString()).append(";\n");
        }
        if (this.m_21214_() != null) {
            string.append("\u521a\u521a\u653b\u51fb/IJustAttacked:").append(this.m_21214_().m_7755_().getString()).append(";\n");
        }
        string.append("\u81ea\u8eab\u751f\u547d\u503c\u767e\u5206\u6bd4/SelfHPPercent:").append(String.format("%.2f", Float.valueOf(this.selfHealthPercent))).append(";\n");
        string.append("\u81ea\u8eab\u5c5e\u6027\u6c34\u5e73/SelfAttributeLevel:").append(String.format("%.0f", Float.valueOf(this.selfAttributeLevel))).append(";\n");
        string.append("\u81ea\u8eab\u77ed\u671f\u8840\u91cf\u8d8b\u52bf/SelfShortTermHPTrend:").append(String.format("%.2f", Float.valueOf(this.selfHealthTrendShort))).append(";\n");
        string.append("\u81ea\u8eab\u957f\u671f\u8840\u91cf\u8d8b\u52bf/SelfLongTermHPTrend:").append(String.format("%.2f", Float.valueOf(this.selfHealthTrendLong))).append(";\n");
        string.append("\u81ea\u8eab\u836f\u6c34\u6548\u679c\u7b49\u7ea7/SelfPotionEffectLevel:").append(this.selfPotionLevel > 0 ? "+" + this.selfPotionLevel : Integer.valueOf(this.selfPotionLevel)).append(";\n");
        string.append("\u81ea\u8eab\u79fb\u52a8\u72b6\u6001/SelfMoveState:").append(this.selfMoveState == 1.0f ? "\u9760\u8fd1/approaching" : (this.selfMoveState == 2.0f ? "\u7ad9\u7acb/idle" : "\u8fdc\u79bb/retreating")).append(";\n");
        string.append("\u81ea\u8eab\u53ef\u7528\u653b\u51fb\u7c7b\u578b/SelfUsableAttackTypes:").append(this.selfUsableTypes).append(";\n");
        string.append("\u81ea\u8eab\u9644\u8fd1\u540c\u4f34\u6570\u91cf/SelfNearbyAllies:").append(this.selfAlliesNearby).append(";\n");
        string.append("\u672a\u5bdf\u89c9\u7684\u5371\u9669\u5c04\u5f39/IncomingProjectileDanger:").append(this.incomingProjectileDanger).append(";\n");
        string.append("\u591a\u4f59\u653b\u51fb\u6765\u6e90/ExtraAttackers:").append(this.extraAttacker != null ? this.extraAttacker.m_7755_().getString() : "none").append(";\n");
        string.append("\u662f\u5426\u9700\u8981\u4f11\u606f/NeedRest:").append(this.needRest).append(";\n");
        string.append("\u81ea\u8eab\u667a\u529b\u7b49\u7ea7/SelfIntelligenceLevel:").append(this.selfIntelligenceLevel).append(";\n");
        return Component.m_237113_((String)("\u6765\u81ea/ReportFrom" + this.m_7755_().getString() + ":\n" + string.toString())).m_130940_(ChatFormatting.GREEN);
    }

    protected void logSay() {
        JerotesVillage.LOGGER.info("\u6765\u81ea {} \u7684\u62a5\u544a:\n{}", (Object)this.m_7755_().getString(), (Object)this.getSay());
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void m_8107_() {
        Player player;
        LivingEntity livingEntity;
        super.m_8107_();
        if (this.m_5448_() != null && (!this.m_5448_().m_6084_() || (livingEntity = this.m_5448_()) instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_()))) {
            this.m_6710_(null);
        }
        if (this.f_19797_ % (11 - this.getSmartLevel() * 4) == 0) {
            this.resetKnow();
        }
        if (this.isShouldReport() && this.f_19797_ % (11 - this.getSmartLevel() * 4) == 0) {
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            AABB area = new AABB(x - 64.0, y - 64.0, z - 64.0, x + 64.0, y + 64.0, z + 64.0);
            List nearbyPlayers = this.m_9236_().m_45976_(ServerPlayer.class, area);
            if (!nearbyPlayers.isEmpty()) {
                this.logSay();
            }
        }
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        LivingEntity target;
        if (this.m_6673_(damageSource)) {
            return super.m_6469_(damageSource, f);
        }
        if (!this.m_9236_().f_46443_ && (target = this.m_5448_()) != null) {
            LivingEntity living;
            Entity attacker = damageSource.m_7639_();
            if (attacker instanceof LivingEntity && (living = (LivingEntity)attacker) == target) {
                this.recordIncomingAttackFrom(living);
            } else {
                LivingEntity livingOwner;
                Projectile projectile;
                Entity owner;
                Entity direct = damageSource.m_7640_();
                if (direct instanceof Projectile && (owner = (projectile = (Projectile)direct).m_19749_()) instanceof LivingEntity && (livingOwner = (LivingEntity)owner) == target) {
                    this.recordIncomingAttackFrom(livingOwner);
                }
            }
        }
        if (this.m_6095_() == JerotesVillageEntityType.SMART.get()) {
            if (damageSource.m_269533_(DamageTypeTags.f_268738_)) {
                return super.m_6469_(damageSource, f);
            }
            if (super.m_6469_(damageSource, f)) {
                this.m_21153_(this.m_21233_());
            }
            return true;
        }
        return super.m_6469_(damageSource, f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    private static class DistanceRecord {
        final float distance;
        final long tick;

        DistanceRecord(float distance, long tick) {
            this.distance = distance;
            this.tick = tick;
        }
    }

    private static class HealthRecord {
        float lastHealth;
        long lastUpdateTick;

        HealthRecord(float lastHealth, long lastUpdateTick) {
            this.lastHealth = lastHealth;
            this.lastUpdateTick = lastUpdateTick;
        }
    }

    private static class AttackRecord {
        final float distance;
        final long tick;

        AttackRecord(float distance, long tick) {
            this.distance = distance;
            this.tick = tick;
        }
    }
}

