/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.event;

import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.entity.Boss.Biome.BrightLandBeastEntity;
import com.jerotes.jerotesvillage.entity.Boss.Biome.CelestialCoilvineEntity;
import com.jerotes.jerotesvillage.entity.Boss.Biome.CorrosiverEntity;
import com.jerotes.jerotesvillage.entity.Boss.Biome.GemstoneMalignasaurEntity;
import com.jerotes.jerotesvillage.entity.Boss.Biome.PurpleSandHagEntity;
import com.jerotes.jerotesvillage.entity.Boss.Biome.SecondRounderGolemEntity;
import com.jerotes.jerotesvillage.entity.Boss.Biome.SerponCombatExecuterEntity;
import com.jerotes.jerotesvillage.entity.Boss.Biome.VariantZsieinEntity;
import com.jerotes.jerotesvillage.entity.Boss.OminousBannerProjectionEntity;
import com.jerotes.jerotesvillage.entity.Boss.ProsperousEnvoyEntity;
import com.jerotes.jerotesvillage.entity.Boss.SedimentLordEntity;
import com.jerotes.jerotesvillage.entity.Boss.TyrantOfTheMountainRealmEntity;
import com.jerotes.jerotesvillage.event.WorldEvent;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="jerotesvillage", value={Dist.CLIENT})
public class BossBarEvent {
    public static final Set<Mob> BOSSES = Collections.newSetFromMap(new WeakHashMap());
    private static final ResourceLocation BASE_LOCATION = new ResourceLocation("jerotesvillage", "textures/gui/new_bars.png");
    private static final ResourceLocation BASE_LOCATION_OLD = new ResourceLocation("jerotesvillage", "textures/gui/bars.png");

    @SubscribeEvent
    public static void onRenderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent bossEvent = event.getBossEvent();
        Mob boss = null;
        int color = 0xFFFFFF;
        int colorBar = 1;
        if (!BOSSES.isEmpty()) {
            for (Mob mob : BOSSES) {
                if (!mob.m_20148_().equals(bossEvent.m_18860_())) continue;
                boss = mob;
                break;
            }
            if (boss != null) {
                ResourceLocation barLocation;
                JerotesEntity jerotesEntity;
                MutableComponent bossDesc = null;
                if (boss instanceof JerotesEntity && (jerotesEntity = (JerotesEntity)boss).isLegendary()) {
                    bossDesc = Component.m_237115_((String)"boss.jerotes.legendary");
                }
                if (boss instanceof SedimentLordEntity) {
                    event.setCanceled(true);
                    barLocation = new ResourceLocation("jerotesvillage", "textures/gui/sprites/boss_bar/sediment_lord_progress.png");
                    color = OtherMainConfig.SedimentLordBossBarNameColor;
                    colorBar = OtherMainConfig.SedimentLordBossBarColor;
                } else if (boss instanceof ProsperousEnvoyEntity) {
                    event.setCanceled(true);
                    barLocation = new ResourceLocation("jerotesvillage", "textures/gui/sprites/boss_bar/prosperous_envoy_progress.png");
                    color = OtherMainConfig.ProsperousEnvoyBossBarNameColor;
                    colorBar = OtherMainConfig.ProsperousEnvoyBossBarColor;
                } else if (boss instanceof OminousBannerProjectionEntity) {
                    event.setCanceled(true);
                    barLocation = new ResourceLocation("jerotesvillage", "textures/gui/sprites/boss_bar/ominous_banner_projection_progress.png");
                    color = OtherMainConfig.OminousBannerProjectionBossBarNameColor;
                    colorBar = OtherMainConfig.OminousBannerProjectionBossBarColor;
                } else if (boss instanceof TyrantOfTheMountainRealmEntity) {
                    event.setCanceled(true);
                    barLocation = new ResourceLocation("jerotesvillage", "textures/gui/sprites/boss_bar/tyrant_of_the_mountain_realm_progress.png");
                    color = OtherMainConfig.TyrantOfTheMountainRealmBossBarNameColor;
                    colorBar = OtherMainConfig.TyrantOfTheMountainRealmBossBarColor;
                } else if (boss instanceof CorrosiverEntity) {
                    event.setCanceled(true);
                    barLocation = new ResourceLocation("jerotesvillage", "textures/gui/sprites/boss_bar/corrosiver_progress.png");
                    color = OtherMainConfig.CorrosiverBossBarNameColor;
                    colorBar = OtherMainConfig.CorrosiverBossBarColor;
                } else if (boss instanceof PurpleSandHagEntity) {
                    event.setCanceled(true);
                    barLocation = new ResourceLocation("jerotesvillage", "textures/gui/sprites/boss_bar/purple_sand_hag_progress.png");
                    color = OtherMainConfig.PurpleSandHagBossBarNameColor;
                    colorBar = OtherMainConfig.PurpleSandHagBossBarColor;
                } else if (boss instanceof GemstoneMalignasaurEntity) {
                    event.setCanceled(true);
                    barLocation = new ResourceLocation("jerotesvillage", "textures/gui/sprites/boss_bar/gemstone_malignasaur_progress.png");
                    color = OtherMainConfig.GemstoneMalignasaurBossBarNameColor;
                    colorBar = OtherMainConfig.GemstoneMalignasaurBossBarColor;
                } else if (boss instanceof BrightLandBeastEntity) {
                    event.setCanceled(true);
                    barLocation = new ResourceLocation("jerotesvillage", "textures/gui/sprites/boss_bar/bright_land_beast_progress.png");
                    color = OtherMainConfig.BrightLandBeastBossBarNameColor;
                    colorBar = OtherMainConfig.BrightLandBeastBossBarColor;
                } else if (boss instanceof SerponCombatExecuterEntity) {
                    event.setCanceled(true);
                    barLocation = new ResourceLocation("jerotesvillage", "textures/gui/sprites/boss_bar/serpon_combat_executer_progress.png");
                    color = OtherMainConfig.SerponCombatExecuterBossBarNameColor;
                    colorBar = OtherMainConfig.SerponCombatExecuterBossBarColor;
                } else if (boss instanceof CelestialCoilvineEntity) {
                    event.setCanceled(true);
                    barLocation = new ResourceLocation("jerotesvillage", "textures/gui/sprites/boss_bar/celestial_coilvine_progress.png");
                    color = OtherMainConfig.CelestialCoilvineBossBarNameColor;
                    colorBar = OtherMainConfig.CelestialCoilvineBossBarColor;
                } else if (boss instanceof SecondRounderGolemEntity) {
                    event.setCanceled(true);
                    barLocation = new ResourceLocation("jerotesvillage", "textures/gui/sprites/boss_bar/second_rounder_golem_progress.png");
                    color = OtherMainConfig.SecondRounderGolemBossBarNameColor;
                    colorBar = OtherMainConfig.SecondRounderGolemBossBarColor;
                } else if (boss instanceof VariantZsieinEntity) {
                    event.setCanceled(true);
                    barLocation = new ResourceLocation("jerotesvillage", "textures/gui/sprites/boss_bar/variant_zsiein_progress.png");
                    color = 1;
                    colorBar = 6;
                } else {
                    return;
                }
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)BASE_LOCATION_OLD);
                BossBarEvent.drawBar(event.getGuiGraphics(), event.getX(), event.getY(), (BossEvent)bossEvent, barLocation, colorBar);
                Component component = bossEvent.m_18861_();
                int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
                int textX = Minecraft.m_91087_().m_91268_().m_85445_() / 2 - textWidth / 2;
                int textY = event.getY() - 9;
                event.getGuiGraphics().m_280430_(Minecraft.m_91087_().f_91062_, component, textX, textY, color);
                if (bossDesc != null) {
                    int descWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)bossDesc);
                    int descX = Minecraft.m_91087_().m_91268_().m_85445_() / 2 - descWidth / 2;
                    int descY = event.getY() + 5;
                    event.getGuiGraphics().m_280430_(Minecraft.m_91087_().f_91062_, (Component)bossDesc, descX, descY, color);
                }
            }
        }
    }

    public static void drawBar(GuiGraphics guiGraphics, int x, int y, BossEvent event, ResourceLocation barLocation, int color) {
        BossBarEvent.drawBar(guiGraphics, x, y, event, 182, 0, color);
        int i = (int)(event.m_142717_() * 183.0f);
        if (i > 0) {
            BossBarEvent.drawBar(guiGraphics, x, y, event, i, 5, color);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)barLocation);
        guiGraphics.m_280163_(barLocation, x - 3, y - 2, 0.0f, 0.0f, 188, 9, 188, 9);
    }

    private static void drawBar(GuiGraphics guiGraphics, int x, int y, BossEvent event, int width, int i, int color) {
        guiGraphics.m_280218_(BASE_LOCATION_OLD, x, y, 0, color * 5 * 2 + i, width, 5);
        if (event.m_18863_() != BossEvent.BossBarOverlay.PROGRESS) {
            RenderSystem.enableBlend();
            guiGraphics.m_280218_(BASE_LOCATION_OLD, x, y, 0, 80 + (event.m_18863_().ordinal() - 1) * 5 * 2 + i, width, 5);
            RenderSystem.disableBlend();
        }
    }

    @SubscribeEvent
    public static void onRenderBossBarWickedRidiculeNight(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent bossEvent = event.getBossEvent();
        if (WorldEvent.NIGHT_UUID.equals(bossEvent.m_18860_())) {
            event.setCanceled(true);
            ResourceLocation barLocation = new ResourceLocation("jerotesvillage", "textures/gui/sprites/boss_bar/wicked_ridicule_night_progress.png");
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            event.setIncrement(12 + 2 * 9);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BASE_LOCATION_OLD);
            BossBarEvent.drawBar(event.getGuiGraphics(), event.getX(), event.getY(), (BossEvent)bossEvent, barLocation, OtherMainConfig.WickedRidiculeNightBossBarColor);
            Component component = bossEvent.m_18861_();
            int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
            int textX = Minecraft.m_91087_().m_91268_().m_85445_() / 2 - textWidth / 2;
            int textY = event.getY() - 9;
            event.getGuiGraphics().m_280430_(Minecraft.m_91087_().f_91062_, component, textX, textY, OtherMainConfig.WickedRidiculeNightBossBarNameColor);
        }
    }

    @SubscribeEvent
    public static void onRenderBossBarZsiein(CustomizeGuiOverlayEvent.BossEventProgress event) {
        LerpingBossEvent bossEvent = event.getBossEvent();
        if (WorldEvent.ZSIEIN_UUID.equals(bossEvent.m_18860_())) {
            event.setCanceled(true);
            event.setIncrement(0);
        }
    }
}

