/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.event;

import com.jerotes.jerotesvillage.JerotesVillage;
import com.jerotes.jerotesvillage.block.BaseBlock.ABaseBlock;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jerotesvillage", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class HeadModelEvent {
    @SubscribeEvent
    public static void onCreateSkullModel(EntityRenderersEvent.CreateSkullModels event) {
        HeadModelEvent.registerSkullModelSafe(event, ABaseBlock.Types.SECOND_ROUNDER_ZOMBIE, ModelLayers.f_171224_);
        HeadModelEvent.registerSkullModelSafe(event, ABaseBlock.Types.SECOND_ROUNDER_SKELETON, ModelLayers.f_171240_);
        HeadModelEvent.registerSkullModelSafe(event, ABaseBlock.Types.RESURRECTER, ModelLayers.f_171163_);
        HeadModelEvent.registerSkullModelSafe(event, ABaseBlock.Types.PURPLE_SAND_CREEPER, ModelLayers.f_171130_);
        HeadModelEvent.registerSkullModelSafe(event, ABaseBlock.Types.SPIRVE, ModelLayers.f_171163_);
        HeadModelEvent.registerSkullModelSafe(event, ABaseBlock.Types.TANGLER, ModelLayers.f_171163_);
        HeadModelEvent.registerSkullModelSafe(event, ABaseBlock.Types.BLAMER, ModelLayers.f_171163_);
    }

    private static void registerSkullModelSafe(EntityRenderersEvent.CreateSkullModels event, SkullBlock.Type skullType, ModelLayerLocation modelLayer) {
        try {
            ModelPart modelPart = event.getEntityModelSet().m_171103_(modelLayer);
            if (modelPart == null) {
                JerotesVillage.LOGGER.error("Failed to bake model layer for skull type: {}", (Object)skullType);
                return;
            }
            event.registerSkullModel(skullType, (SkullModelBase)new SkullModel(modelPart));
        }
        catch (Exception e) {
            JerotesVillage.LOGGER.error("Failed to register skull model for type: {}", (Object)skullType, (Object)e);
        }
    }
}

