/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.event;

import com.jerotes.jerotes.entity.WickedRidiculeCallsEntity;
import com.jerotes.jerotes.event.JerotesBossEvent;
import com.jerotes.jerotesvillage.config.OtherMainConfig;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import com.jerotes.jerotesvillage.network.JerotesVillageLevelData;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jerotesvillage")
public class WorldEvent {
    public static final UUID NIGHT_UUID = UUID.fromString("0DD1F1C7-A309-D2AF-5EB9-6EEB1D513047");
    public static final UUID ZSIEIN_UUID = UUID.fromString("be7a4304-3c4d-4311-9dd2-33e5c376502b");
    private static final JerotesBossEvent nightEvent = new JerotesBossEvent((Component)Component.m_237115_((String)"event.jerotesvillage.wicked_ridicule_night"), NIGHT_UUID, BossEvent.BossBarColor.RED, true, true);
    private static final JerotesBossEvent zsieinEvent = new JerotesBossEvent((Component)Component.m_237115_((String)"event.jerotesvillage.zsein"), ZSIEIN_UUID, BossEvent.BossBarColor.WHITE, true, true, true);

    public static boolean WickedRidiculeNightAbout(Level level) {
        return OtherMainConfig.WickedRidiculeNightAboutDimension.contains(level.m_46472_().m_135782_().toString()) || OtherMainConfig.WickedRidiculeNightAboutAllDimension;
    }

    @SubscribeEvent
    public static void WickedRidiculeNight(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (level.m_46791_() != Difficulty.PEACEFUL && WorldEvent.WickedRidiculeNightAbout(level) && !WorldEvent.ZsieinModerateInfectedAbove(level)) {
            List list;
            float times = level.m_46468_() % 24000L;
            double chance = OtherMainConfig.WickedRidiculeNightChance;
            if (level.m_46462_() && level.m_46468_() > 72000L && times == 15000.0f && (double)level.m_213780_().m_188501_() <= chance && JerotesVillageLevelData.get((LevelAccessor)level) != null && !JerotesVillageLevelData.get((LevelAccessor)level).WickedRidiculeNight) {
                WorldEvent.WickedRidiculeNightTrueOrFalse(level, true);
                if (!level.m_5776_() && JerotesVillageLevelData.get((LevelAccessor)level) != null && JerotesVillageLevelData.get((LevelAccessor)level).WickedRidiculeNight) {
                    list = level.m_6907_();
                    list.removeIf(player -> player.m_9236_() != level);
                    for (Player player2 : list) {
                        player2.m_7292_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.WICKED_RIDICULE_NIGHT_START.get(), 20, 1));
                        player2.m_213846_((Component)Component.m_237115_((String)"message.jerotesvillage.wicked_ridicule_night_start").m_130940_(ChatFormatting.DARK_RED));
                    }
                }
            }
            if (JerotesVillageLevelData.get((LevelAccessor)level) != null && JerotesVillageLevelData.get((LevelAccessor)level).WickedRidiculeNight) {
                if (times > 6000.0f) {
                    nightEvent.m_142711_((24000.0f - times) / 10000.0f + 0.1f);
                } else {
                    nightEvent.m_142711_((1000.0f - times) / 10000.0f);
                }
                if (level.m_46461_() && times > 1000.0f && times < 6000.0f) {
                    if (!level.m_5776_() && JerotesVillageLevelData.get((LevelAccessor)level) != null && JerotesVillageLevelData.get((LevelAccessor)level).WickedRidiculeNight && WorldEvent.WickedRidiculeNightAbout(level)) {
                        list = level.m_6907_();
                        list.removeIf(player -> player.m_9236_() != level);
                        for (Player player2 : list) {
                            player2.m_7292_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.WICKED_RIDICULE_NIGHT_START.get(), 20, 1));
                            player2.m_213846_((Component)Component.m_237115_((String)"message.jerotesvillage.wicked_ridicule_night_stop").m_130940_(ChatFormatting.DARK_RED));
                        }
                    }
                    WorldEvent.WickedRidiculeNightTrueOrFalse(level, false);
                }
            }
        } else {
            if (!level.m_5776_() && JerotesVillageLevelData.get((LevelAccessor)level) != null && JerotesVillageLevelData.get((LevelAccessor)level).WickedRidiculeNight) {
                List list = level.m_6907_();
                list.removeIf(player -> player.m_9236_() != level);
                for (Player player3 : list) {
                    player3.m_7292_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.WICKED_RIDICULE_NIGHT_START.get(), 20, 1));
                    player3.m_213846_((Component)Component.m_237115_((String)"message.jerotesvillage.wicked_ridicule_night_stop").m_130940_(ChatFormatting.DARK_RED));
                }
            }
            WorldEvent.WickedRidiculeNightTrueOrFalse(level, false);
        }
    }

    @SubscribeEvent
    public static void PlayerNight(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        Level level = event.getEntity().m_9236_();
        if (JerotesVillageLevelData.get((LevelAccessor)level) == null) {
            return;
        }
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (JerotesVillageLevelData.get((LevelAccessor)level) != null && JerotesVillageLevelData.get((LevelAccessor)level).WickedRidiculeNight && !player.m_9236_().m_5776_()) {
                player.m_7292_(new MobEffectInstance((MobEffect)JerotesVillageMobEffects.WICKED_RIDICULE_NIGHT.get(), 5, 0, false, false));
            }
            if (JerotesVillageLevelData.get((LevelAccessor)level) != null && JerotesVillageLevelData.get((LevelAccessor)level).WickedRidiculeNight && OtherMainConfig.WickedRidiculeNightBossBar) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (!nightEvent.m_8324_().contains(player)) {
                        nightEvent.m_6543_(serverPlayer);
                    }
                }
            } else if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (nightEvent.m_8324_().contains(serverPlayer)) {
                    nightEvent.m_6539_(serverPlayer);
                }
            }
        }
        if (livingEntity instanceof WickedRidiculeCallsEntity) {
            WickedRidiculeCallsEntity wickedRidiculeCallsEntity = (WickedRidiculeCallsEntity)livingEntity;
            if (JerotesVillageLevelData.get((LevelAccessor)level) != null && JerotesVillageLevelData.get((LevelAccessor)level).WickedRidiculeNight) {
                wickedRidiculeCallsEntity.addInWickedRidiculeNight(true);
            }
        }
    }

    public static void WickedRidiculeNightTrueOrFalse(Level level, boolean bl) {
        if (JerotesVillageLevelData.get((LevelAccessor)level) == null) {
            return;
        }
        JerotesVillageLevelData.get((LevelAccessor)level).setWickedRidiculeNight(bl);
    }

    public static void allChanged() {
        Minecraft.m_91087_().f_91060_.m_109818_();
    }

    public static boolean ZsieinLatentInfectedAbove(Level level) {
        if (level == null) {
            return false;
        }
        if (JerotesVillageLevelData.get((LevelAccessor)level) == null) {
            return false;
        }
        return OtherMainConfig.ZsieinAffinityAboutDimension.contains(level.m_46472_().m_135782_().toString()) || OtherMainConfig.ZsieinAffinityAboutAllDimension;
    }

    public static boolean ZsieinMildInfectedAbove(Level level) {
        if (level == null) {
            return false;
        }
        if (JerotesVillageLevelData.get((LevelAccessor)level) == null) {
            return false;
        }
        if (!WorldEvent.ZsieinLatentInfectedAbove(level)) {
            return false;
        }
        return JerotesVillageLevelData.get((LevelAccessor)level).ZsieinAffinity >= OtherMainConfig.ZsieinMildInfectedLevel || JerotesVillageLevelData.get((LevelAccessor)level).ZsieinAffinity >= OtherMainConfig.ZsieinModerateInfectedLevel || JerotesVillageLevelData.get((LevelAccessor)level).ZsieinAffinity >= OtherMainConfig.ZsieinSevereInfectedLevel || JerotesVillageLevelData.get((LevelAccessor)level).ZsieinAffinity >= OtherMainConfig.ZsieinExtremelyInfectedLevel;
    }

    public static boolean ZsieinModerateInfectedAbove(Level level) {
        if (level == null) {
            return false;
        }
        if (JerotesVillageLevelData.get((LevelAccessor)level) == null) {
            return false;
        }
        if (!WorldEvent.ZsieinLatentInfectedAbove(level)) {
            return false;
        }
        return JerotesVillageLevelData.get((LevelAccessor)level).ZsieinAffinity >= OtherMainConfig.ZsieinModerateInfectedLevel || JerotesVillageLevelData.get((LevelAccessor)level).ZsieinAffinity >= OtherMainConfig.ZsieinSevereInfectedLevel || JerotesVillageLevelData.get((LevelAccessor)level).ZsieinAffinity >= OtherMainConfig.ZsieinExtremelyInfectedLevel;
    }

    public static boolean ZsieinSevereInfectedAbove(Level level) {
        if (level == null) {
            return false;
        }
        if (JerotesVillageLevelData.get((LevelAccessor)level) == null) {
            return false;
        }
        if (!WorldEvent.ZsieinLatentInfectedAbove(level)) {
            return false;
        }
        return JerotesVillageLevelData.get((LevelAccessor)level).ZsieinAffinity >= OtherMainConfig.ZsieinSevereInfectedLevel || JerotesVillageLevelData.get((LevelAccessor)level).ZsieinAffinity >= OtherMainConfig.ZsieinExtremelyInfectedLevel;
    }

    public static boolean ZsieinExtremelyInfectedAbove(Level level) {
        if (level == null) {
            return false;
        }
        if (JerotesVillageLevelData.get((LevelAccessor)level) == null) {
            return false;
        }
        if (!WorldEvent.ZsieinLatentInfectedAbove(level)) {
            return false;
        }
        return JerotesVillageLevelData.get((LevelAccessor)level).ZsieinAffinity >= OtherMainConfig.ZsieinExtremelyInfectedLevel;
    }

    public static void ZsieinAffinityAdd(Level level, double d) {
        if (level == null) {
            return;
        }
        if (JerotesVillageLevelData.get((LevelAccessor)level) == null) {
            return;
        }
        if (WorldEvent.ZsieinLatentInfectedAbove(level)) {
            if (WorldEvent.ZsieinAffinityGet(level) + d > OtherMainConfig.ZsieinAffinityMaxLevel) {
                JerotesVillageLevelData.get((LevelAccessor)level).setZsieinAffinity(OtherMainConfig.ZsieinAffinityMaxLevel);
            } else if (WorldEvent.ZsieinAffinityGet(level) + d < 0.0) {
                JerotesVillageLevelData.get((LevelAccessor)level).setZsieinAffinity(0.0);
            } else {
                JerotesVillageLevelData.get((LevelAccessor)level).setZsieinAffinity(JerotesVillageLevelData.get((LevelAccessor)level).ZsieinAffinity + d);
            }
        }
    }

    public static void ZsieinAffinitySet(Level level, double d) {
        if (level == null) {
            return;
        }
        if (JerotesVillageLevelData.get((LevelAccessor)level) == null) {
            return;
        }
        if (WorldEvent.ZsieinLatentInfectedAbove(level)) {
            if (d > OtherMainConfig.ZsieinAffinityMaxLevel) {
                JerotesVillageLevelData.get((LevelAccessor)level).setZsieinAffinity(OtherMainConfig.ZsieinAffinityMaxLevel);
            } else if (d < 0.0) {
                JerotesVillageLevelData.get((LevelAccessor)level).setZsieinAffinity(0.0);
            } else {
                JerotesVillageLevelData.get((LevelAccessor)level).setZsieinAffinity(d);
            }
        }
    }

    public static double ZsieinAffinityGet(Level level) {
        if (level == null) {
            return -1.0;
        }
        if (JerotesVillageLevelData.get((LevelAccessor)level) == null) {
            return 0.0;
        }
        return JerotesVillageLevelData.get((LevelAccessor)level).ZsieinAffinity;
    }

    @SubscribeEvent
    public static void PlayerZsieinFog(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (serverPlayer.m_21023_((MobEffect)JerotesVillageMobEffects.ZSIEIN_FOG.get())) {
                if (!zsieinEvent.m_8324_().contains(serverPlayer)) {
                    zsieinEvent.m_6543_(serverPlayer);
                }
            } else if (zsieinEvent.m_8324_().contains(serverPlayer)) {
                zsieinEvent.m_6539_(serverPlayer);
            }
        }
    }
}

