/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.goal;

import java.util.EnumSet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class CelestialCoilvineAttackGoal
extends Goal {
    protected final PathfinderMob mob;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;

    public CelestialCoilvineAttackGoal(PathfinderMob pathfinderMob) {
        this.mob = pathfinderMob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long l = this.mob.m_9236_().m_46467_();
        if (l - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = l;
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        return livingEntity.m_6084_();
    }

    public boolean m_8045_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        if (!this.mob.m_21444_(livingEntity.m_20183_())) {
            return false;
        }
        return !(livingEntity instanceof Player) || !livingEntity.m_5833_() && !((Player)livingEntity).m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21561_(true);
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(livingEntity)) {
            this.mob.m_6710_(null);
        }
        this.mob.m_21561_(false);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return;
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(livingEntity);
    }

    protected void checkAndPerformAttack(LivingEntity livingEntity) {
        if (this.canPerformAttack(livingEntity)) {
            this.resetAttackCooldown();
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.m_7327_((Entity)livingEntity);
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformAttack(LivingEntity livingEntity) {
        return this.isTimeToAttack() && this.mob.m_217066_(livingEntity) && this.mob.m_21574_().m_148306_((Entity)livingEntity);
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.m_183277_(20);
    }
}

