/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.goal;

import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.entity.Neutral.CleaningRobotEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;

public class CleaningRobotRandomStrollGoal
extends Goal {
    public static final int DEFAULT_INTERVAL = 120;
    protected final CleaningRobotEntity mob;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected final double speedModifier;
    protected int interval;
    protected boolean forceTrigger;
    private final boolean checkNoActionTime;

    public CleaningRobotRandomStrollGoal(CleaningRobotEntity pathfinderMob, double d) {
        this(pathfinderMob, d, 120);
    }

    public CleaningRobotRandomStrollGoal(CleaningRobotEntity pathfinderMob, double d, int n) {
        this(pathfinderMob, d, n, true);
    }

    public CleaningRobotRandomStrollGoal(CleaningRobotEntity pathfinderMob, double d, int n, boolean bl) {
        this.mob = pathfinderMob;
        this.speedModifier = d;
        this.interval = n;
        this.checkNoActionTime = bl;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Vec3 vec3;
        if (this.mob.isGoingHome()) {
            return false;
        }
        if (this.mob.m_217005_()) {
            return false;
        }
        if (!this.forceTrigger) {
            if (this.checkNoActionTime && this.mob.m_21216_() >= 100) {
                return false;
            }
            if (this.mob.m_217043_().m_188503_(RandomStrollGoal.m_186073_((int)this.interval)) != 0) {
                return false;
            }
        }
        if ((vec3 = this.getPosition()) == null) {
            return false;
        }
        if (!this.mob.isOn()) {
            return false;
        }
        this.wantedX = vec3.f_82479_;
        this.wantedY = vec3.f_82480_;
        this.wantedZ = vec3.f_82481_;
        this.forceTrigger = false;
        return true;
    }

    @Nullable
    protected Vec3 getPosition() {
        return Main.findSpawnPositionNearFillOnBlock((LevelReader)this.mob.m_9236_(), (BlockPos)this.mob.getHomePos(), (int)32).m_252807_();
    }

    public boolean m_8045_() {
        if (!this.mob.isOn()) {
            return false;
        }
        return !this.mob.m_21573_().m_26571_() && !this.mob.m_217005_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
        super.m_8041_();
    }

    public void trigger() {
        this.forceTrigger = true;
    }

    public void setInterval(int n) {
        this.interval = n;
    }
}

