/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.goal;

import com.jerotes.jerotes.entity.TameMobEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageMobEffects;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;

public class FollowFragranceGoal
extends Goal {
    private final Animal follower;
    @Nullable
    private LivingEntity fragrance;
    private double speedModifier;
    private int timeToRecalcPath;

    public FollowFragranceGoal(Animal follower, double d) {
        this.follower = follower;
        this.speedModifier = d;
    }

    public boolean m_8036_() {
        TameMobEntity tamableFlowers;
        TamableAnimal tamableFlower;
        OwnableEntity ownable;
        if (this.follower.m_21188_() != null || this.follower.m_203117_() || this.follower.m_6060_()) {
            return false;
        }
        if (this.follower instanceof Enemy || this.follower.m_5448_() != null || this.follower.m_5912_()) {
            return false;
        }
        Animal animal = this.follower;
        if (animal instanceof OwnableEntity && (ownable = (OwnableEntity)animal).m_269323_() != null) {
            return false;
        }
        Animal animal2 = this.follower;
        if (animal2 instanceof TamableAnimal && (tamableFlower = (TamableAnimal)animal2).m_21825_() || (animal2 = this.follower) instanceof TameMobEntity && (tamableFlowers = (TameMobEntity)animal2).isInSittingPose()) {
            return false;
        }
        if (this.follower.m_21525_() || !this.follower.m_6084_()) {
            return false;
        }
        List<LivingEntity> list = this.follower.m_9236_().m_45976_(LivingEntity.class, this.follower.m_20191_().m_82377_(64.0, 32.0, 64.0)).stream().filter(entity -> entity.m_21023_((MobEffect)JerotesVillageMobEffects.FRAGRANCE.get())).toList();
        if (list.isEmpty()) {
            return false;
        }
        LivingEntity find = null;
        double speed = this.speedModifier;
        double d = Double.MAX_VALUE;
        for (LivingEntity fragrance : list) {
            double d2;
            int n = 0;
            if (fragrance.m_21023_((MobEffect)JerotesVillageMobEffects.FRAGRANCE.get())) {
                n = Objects.requireNonNull(fragrance.m_21124_((MobEffect)JerotesVillageMobEffects.FRAGRANCE.get())).m_19564_();
            }
            int effectLevel = n + 1;
            double distance = 16 + n * 4;
            if (distance > 64.0) {
                distance = 64.0;
            }
            if ((speed = 1.0 + (double)n * 0.1) > 2.5) {
                speed = 2.5;
            }
            double d22 = this.follower.m_20270_((Entity)fragrance);
            if (d2 > d || (double)fragrance.m_20270_((Entity)this.follower) > distance * 1.5 || this.follower.m_21233_() >= (float)(60 + effectLevel * 20) || this.follower.m_21223_() >= (float)(60 + effectLevel * 20)) continue;
            d = d22;
            find = fragrance;
        }
        if (find == null) {
            return false;
        }
        if (d < 64.0) {
            return false;
        }
        this.speedModifier = speed;
        this.fragrance = find;
        return true;
    }

    public boolean m_8045_() {
        TameMobEntity tamableFlowers;
        TamableAnimal tamableFlower;
        OwnableEntity ownable;
        if (this.follower.m_21188_() != null || this.follower.m_203117_() || this.follower.m_6060_()) {
            return false;
        }
        if (this.follower instanceof Enemy || this.follower.m_5448_() != null || this.follower.m_5912_()) {
            return false;
        }
        Animal animal = this.follower;
        if (animal instanceof OwnableEntity && (ownable = (OwnableEntity)animal).m_269323_() != null) {
            return false;
        }
        Animal animal2 = this.follower;
        if (animal2 instanceof TamableAnimal && (tamableFlower = (TamableAnimal)animal2).m_21825_() || (animal2 = this.follower) instanceof TameMobEntity && (tamableFlowers = (TameMobEntity)animal2).isInSittingPose()) {
            return false;
        }
        if (this.follower.m_21525_() || !this.follower.m_6084_()) {
            return false;
        }
        if (this.fragrance != null && !this.fragrance.m_6084_()) {
            return false;
        }
        double d = 0.0;
        if (this.fragrance != null) {
            d = this.follower.m_20280_((Entity)this.fragrance);
        }
        return !(d < 4.0) && !(d > 1024.0);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
    }

    public void m_8041_() {
        this.fragrance = null;
    }

    public void m_8037_() {
        if (this.fragrance != null) {
            if (--this.timeToRecalcPath > 0) {
                return;
            }
            this.timeToRecalcPath = this.m_183277_(10);
            this.follower.m_21573_().m_5624_((Entity)this.fragrance, this.speedModifier);
        }
    }
}

