/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.goal;

import com.jerotes.jerotesvillage.entity.Monster.Resurrecter.ResurrecterEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class ResurrecterAttackTargetGoal<T extends LivingEntity>
extends TargetGoal {
    private static final int DEFAULT_RANDOM_INTERVAL = 10;
    protected final Class<T> targetType;
    protected final int randomInterval;
    @Nullable
    protected LivingEntity target;
    protected TargetingConditions targetConditions;

    public ResurrecterAttackTargetGoal(Mob mob, Class<T> class_, boolean bl) {
        this(mob, class_, 10, bl, false, null);
    }

    public ResurrecterAttackTargetGoal(Mob mob, Class<T> class_, boolean bl, Predicate<LivingEntity> predicate) {
        this(mob, class_, 10, bl, false, predicate);
    }

    public ResurrecterAttackTargetGoal(Mob mob, Class<T> class_, boolean bl, boolean bl2) {
        this(mob, class_, 10, bl, bl2, null);
    }

    public ResurrecterAttackTargetGoal(Mob mob, Class<T> class_, int n, boolean bl, boolean bl2, @Nullable Predicate<LivingEntity> predicate) {
        super(mob, bl, bl2);
        this.targetType = class_;
        this.randomInterval = NearestAttackableTargetGoal.m_186073_((int)n);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(predicate);
    }

    public boolean m_8036_() {
        if (this.randomInterval > 0 && this.f_26135_.m_217043_().m_188503_(this.randomInterval) != 0) {
            return false;
        }
        if (!((ResurrecterEntity)this.f_26135_).isAngryTick()) {
            return false;
        }
        this.findTarget();
        boolean helmet = this.target != null && (this.target.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.ANCIENT_SECOND_ROUNDER_NOBLE_HELMET.get() || this.target.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.RESURRECTER_HEAD.get());
        boolean chestplate = this.target != null && this.target.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.ANCIENT_SECOND_ROUNDER_NOBLE_CHESTPLATE.get();
        boolean legs = this.target != null && this.target.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.ANCIENT_SECOND_ROUNDER_NOBLE_LEGGINGS.get();
        boolean feet = this.target != null && this.target.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.ANCIENT_SECOND_ROUNDER_NOBLE_BOOTS.get();
        return this.target != null && !OtherEntityFactionFind.isResurrecter(this.target.m_6095_()) && !helmet && !chestplate && !legs && !feet && !(this.target instanceof Bat) && (this.target instanceof Mob || this.target instanceof Player);
    }

    protected AABB getTargetSearchArea(double d) {
        return this.f_26135_.m_20191_().m_82377_(d, 4.0, d);
    }

    protected void findTarget() {
        this.target = this.targetType == Player.class || this.targetType == ServerPlayer.class ? this.f_26135_.m_9236_().m_45949_(this.targetConditions, (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_()) : this.f_26135_.m_9236_().m_45982_(this.f_26135_.m_9236_().m_6443_(this.targetType, this.getTargetSearchArea(this.m_7623_()), livingEntity -> true), this.targetConditions, (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_());
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.target);
        super.m_8056_();
    }

    public void setTarget(@Nullable LivingEntity livingEntity) {
        this.target = livingEntity;
    }
}

