/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.goal;

import java.util.Comparator;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;

public class SmartBulgeDodgeProjectileGoal
extends Goal {
    private final Mob mob;
    private Projectile targetProjectile;
    private int cooldown;
    private static final double DODGE_THRESHOLD = 0.7;
    private static final double MIN_PROJECTILE_SPEED = 0.5;

    public SmartBulgeDodgeProjectileGoal(Mob mob) {
        this.mob = mob;
    }

    public boolean m_8036_() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        List projectiles = this.mob.m_9236_().m_6443_(Projectile.class, this.mob.m_20191_().m_82400_(3.0), p -> this.isValidProjectile((Projectile)p));
        this.targetProjectile = projectiles.stream().min(Comparator.comparingDouble(p -> {
            Vec3 dir = p.m_20184_();
            Vec3 toMob = this.mob.m_20182_().m_82546_(p.m_20182_());
            return dir.m_82526_(toMob) / (dir.m_82553_() * toMob.m_82553_());
        })).orElse(null);
        return this.targetProjectile != null;
    }

    private boolean isValidProjectile(Projectile projectile) {
        LivingEntity owner;
        Entity entity = projectile.m_19749_();
        if (!(entity instanceof LivingEntity) || (owner = (LivingEntity)entity).m_7307_((Entity)this.mob)) {
            return false;
        }
        if (projectile.m_20096_()) {
            return false;
        }
        Vec3 velocity = projectile.m_20184_();
        if (velocity.m_82556_() < 0.25) {
            return false;
        }
        Vec3 toMob = this.mob.m_20182_().m_82546_(projectile.m_20182_()).m_82541_();
        double angle = velocity.m_82541_().m_82526_(toMob);
        return angle >= 0.7;
    }

    public void m_8056_() {
        if (this.targetProjectile == null) {
            return;
        }
        Vec3 dodgeDir = this.calculateDodgeDirection();
        this.performDodge(dodgeDir);
        this.cooldown = 5;
        this.playDodgeEffects();
    }

    private Vec3 calculateDodgeDirection() {
        Vec3 projectileDir = this.targetProjectile.m_20184_().m_82541_();
        Vec3 toMob = this.mob.m_20182_().m_82546_(this.targetProjectile.m_20182_()).m_82541_();
        Vec3 baseDir = projectileDir.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        double verticalFactor = 0.0;
        if (projectileDir.f_82480_ > 0.3) {
            verticalFactor = -0.5;
        } else if (projectileDir.f_82480_ < -0.3) {
            verticalFactor = 0.5;
        }
        if (this.mob.m_217043_().m_188499_()) {
            baseDir = baseDir.m_82490_(-1.0);
        }
        return new Vec3(baseDir.f_82479_ * 0.8, baseDir.f_82480_ * 0.5 + verticalFactor, baseDir.f_82481_ * 0.8);
    }

    private void performDodge(Vec3 dodgeDir) {
        this.mob.m_20256_(dodgeDir);
        this.mob.m_21563_().m_24950_(this.targetProjectile.m_20185_(), this.targetProjectile.m_20186_(), this.targetProjectile.m_20189_(), 30.0f, 30.0f);
        if (!this.mob.m_20068_() && dodgeDir.f_82480_ > 0.2) {
            this.mob.m_6862_(true);
        }
    }

    private void playDodgeEffects() {
        this.mob.m_9236_().m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), SoundEvents.f_12317_, SoundSource.HOSTILE, 0.5f, 1.5f + this.mob.m_217043_().m_188501_() * 0.2f);
        for (int i = 0; i < 8; ++i) {
            this.mob.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.mob.m_20185_(), this.mob.m_20186_() + 0.5, this.mob.m_20189_(), (this.mob.m_217043_().m_188500_() - 0.5) * 0.2, 0.1, (this.mob.m_217043_().m_188500_() - 0.5) * 0.2);
        }
    }

    public boolean m_8045_() {
        return false;
    }
}

