/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.goal;

import com.jerotes.jerotesvillage.entity.Boss.Biome.VariantZsieinEntity;
import java.util.EnumSet;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class VariantZsieinMeleeAttackGoal
extends Goal {
    protected final VariantZsieinEntity variantZsiein;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final int attackInterval = 20;
    private long lastCanUseCheck;
    private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;

    public VariantZsieinMeleeAttackGoal(VariantZsieinEntity variantZsiein, double d, boolean bl) {
        this.variantZsiein = variantZsiein;
        this.speedModifier = d;
        this.followingTargetEvenIfNotSeen = bl;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long l = this.variantZsiein.m_9236_().m_46467_();
        if (l - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = l;
        LivingEntity livingEntity = this.variantZsiein.getBossZsieinTarget();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        this.path = this.variantZsiein.m_21573_().m_6570_((Entity)livingEntity, 0);
        if (this.path != null) {
            return true;
        }
        return this.variantZsiein.m_217066_(livingEntity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_8045_() {
        LivingEntity livingEntity = this.variantZsiein.getBossZsieinTarget();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            if (this.variantZsiein.m_21573_().m_26571_()) return false;
            return true;
        }
        if (!this.variantZsiein.m_21444_(livingEntity.m_20183_())) {
            return false;
        }
        if (!(livingEntity instanceof Player)) return true;
        if (!(livingEntity instanceof Player)) return true;
        Player player = (Player)livingEntity;
        if (!player.m_150110_().f_35937_) {
            if (!player.m_5833_()) return true;
        }
        if (this.variantZsiein.m_9236_().m_46791_() != Difficulty.HARD) return false;
        return true;
    }

    public void m_8056_() {
        this.variantZsiein.m_21573_().m_26536_(this.path, this.speedModifier);
        this.variantZsiein.m_21561_(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void m_8041_() {
        this.variantZsiein.setBossZsieinTarget(null);
        this.variantZsiein.setDataZsieinTargetId(-1);
        this.variantZsiein.m_21561_(false);
        this.variantZsiein.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.variantZsiein.getBossZsieinTarget();
        if (livingEntity == null) {
            return;
        }
        this.variantZsiein.m_21563_().m_24960_((Entity)livingEntity, 360.0f, 360.0f);
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        if ((this.followingTargetEvenIfNotSeen || this.variantZsiein.m_21574_().m_148306_((Entity)livingEntity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingEntity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.variantZsiein.m_217043_().m_188501_() < 0.05f)) {
            this.pathedTargetX = livingEntity.m_20185_();
            this.pathedTargetY = livingEntity.m_20186_();
            this.pathedTargetZ = livingEntity.m_20189_();
            this.ticksUntilNextPathRecalculation = 4 + this.variantZsiein.m_217043_().m_188503_(7);
            double d = this.variantZsiein.m_20280_((Entity)livingEntity);
            if (d > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.variantZsiein.m_21573_().m_5624_((Entity)livingEntity, this.speedModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
            this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
        }
        this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        this.checkAndPerformAttack(livingEntity);
    }

    protected void checkAndPerformAttack(LivingEntity livingEntity) {
        if (this.canPerformAttack(livingEntity)) {
            this.resetAttackCooldown();
            this.variantZsiein.m_6674_(InteractionHand.MAIN_HAND);
            this.variantZsiein.m_7327_((Entity)livingEntity);
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.m_183277_(20);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformAttack(LivingEntity livingEntity) {
        return this.isTimeToAttack() && this.variantZsiein.m_217066_(livingEntity) && this.variantZsiein.m_21574_().m_148306_((Entity)livingEntity);
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.m_183277_(20);
    }
}

