/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.goal;

import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.entity.Neutral.Wonderlin.BaseWonderlinEntity;
import com.jerotes.jerotesvillage.goal.WonderlinTargetGoal;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.AABB;

public class WonderlinKickTargetGoal<T extends LivingEntity>
extends WonderlinTargetGoal {
    private static final int DEFAULT_RANDOM_INTERVAL = 180;
    protected final Class<T> targetType;
    protected final int randomInterval;
    @Nullable
    protected LivingEntity target;
    protected TargetingConditions targetConditions;

    public WonderlinKickTargetGoal(BaseWonderlinEntity mob, Class<T> class_, boolean bl) {
        this(mob, class_, 180, bl, false, null);
    }

    public WonderlinKickTargetGoal(BaseWonderlinEntity mob, Class<T> class_, boolean bl, Predicate<LivingEntity> predicate) {
        this(mob, class_, 180, bl, false, predicate);
    }

    public WonderlinKickTargetGoal(BaseWonderlinEntity mob, Class<T> class_, boolean bl, boolean bl2) {
        this(mob, class_, 180, bl, bl2, null);
    }

    public WonderlinKickTargetGoal(BaseWonderlinEntity mob, Class<T> class_, int n, boolean bl, boolean bl2, @Nullable Predicate<LivingEntity> predicate) {
        super(mob, bl, bl2);
        this.targetType = class_;
        this.randomInterval = NearestAttackableTargetGoal.m_186073_((int)n);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.getFollowDistance()).m_26888_(predicate);
    }

    public boolean m_8036_() {
        if (this.mob.m_5448_() != null) {
            return false;
        }
        if (this.randomInterval > 0 && this.mob.m_217043_().m_188503_(this.randomInterval) != 0) {
            return false;
        }
        this.findTarget();
        boolean helmet = this.target != null && (this.target.m_6844_(EquipmentSlot.HEAD).getEnchantmentLevel(Enchantments.f_44972_) > 0 || this.target.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.MOUNTAIN_REALM_HELMET.get() || this.target.m_6844_(EquipmentSlot.HEAD).m_41720_() == JerotesVillageItems.WONDERLIN_FAKE_EARS.get());
        boolean chestplate = this.target != null && (this.target.m_6844_(EquipmentSlot.CHEST).getEnchantmentLevel(Enchantments.f_44972_) > 0 || this.target.m_6844_(EquipmentSlot.CHEST).m_41720_() == JerotesVillageItems.MOUNTAIN_REALM_CHESTPLATE.get());
        boolean legs = this.target != null && (this.target.m_6844_(EquipmentSlot.LEGS).getEnchantmentLevel(Enchantments.f_44972_) > 0 || this.target.m_6844_(EquipmentSlot.LEGS).m_41720_() == JerotesVillageItems.MOUNTAIN_REALM_LEGGINGS.get());
        boolean feet = this.target != null && (this.target.m_6844_(EquipmentSlot.FEET).getEnchantmentLevel(Enchantments.f_44972_) > 0 || this.target.m_6844_(EquipmentSlot.FEET).m_41720_() == JerotesVillageItems.MOUNTAIN_REALM_BOOTS.get());
        return this.target != null && (this.target instanceof Mob || this.target instanceof Player) && !helmet && !chestplate && !legs && !feet;
    }

    @Override
    public boolean m_8045_() {
        if (this.mob.m_5448_() != null) {
            return false;
        }
        return super.m_8045_();
    }

    protected AABB getNotAttackTargetSearchArea(double d) {
        return this.mob.m_20191_().m_82377_(d, 4.0, d);
    }

    protected void findTarget() {
        this.target = this.targetType == Player.class || this.targetType == ServerPlayer.class ? this.mob.m_9236_().m_45949_(this.targetConditions, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_()) : this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(this.targetType, this.getNotAttackTargetSearchArea(this.getFollowDistance()), livingEntity -> livingEntity.m_21223_() > 1.0f && !Main.canSee((Entity)this.mob, (Entity)livingEntity) && !livingEntity.m_21023_(MobEffects.f_19590_) && !(livingEntity.m_21223_() > this.mob.m_21223_() * 10.0f) && (Main.mobSizeSmall((Entity)livingEntity) || Main.mobSizeMedium((Entity)livingEntity)) && !EntityAndItemFind.isBoss((EntityType)livingEntity.m_6095_())), this.targetConditions, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_());
    }

    @Override
    public void m_8056_() {
        this.mob.setNotAttackTarget(this.target);
        super.m_8056_();
    }

    public void setNotAttackTarget(@Nullable LivingEntity livingEntity) {
        this.target = livingEntity;
    }
}

