/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.init;

import com.google.common.collect.ImmutableSet;
import com.jerotes.jerotesvillage.init.JerotesVillageBlocks;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class JerotesVillageVillagerProfessions {
    private static final Map<String, ProfessionPoiType> POI_TYPES = new HashMap<String, ProfessionPoiType>();
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)"jerotesvillage");
    public static final RegistryObject<VillagerProfession> VILLAGER_WITCH = JerotesVillageVillagerProfessions.registerProfession("villager_witch", JerotesVillageBlocks.VILLAGER_BLOCK_WITCH, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_cleric")));
    public static final RegistryObject<VillagerProfession> VILLAGER_OBSERVER = JerotesVillageVillagerProfessions.registerProfession("villager_observer", JerotesVillageBlocks.VILLAGER_BLOCK_OBSERVER, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_librarian")));
    public static final RegistryObject<VillagerProfession> VILLAGER_SHOPKEEPER = JerotesVillageVillagerProfessions.registerProfession("villager_shopkeeper", JerotesVillageBlocks.VILLAGER_BLOCK_SHOPKEEPER, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_cartographer")));
    public static final RegistryObject<VillagerProfession> VILLAGER_VILLAGEHEAD = JerotesVillageVillagerProfessions.registerProfession("villager_villagehead", JerotesVillageBlocks.VILLAGER_BLOCK_VILLAGEHEAD, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_cartographer")));
    public static final RegistryObject<VillagerProfession> VILLAGER_FORGER = JerotesVillageVillagerProfessions.registerProfession("villager_forger", JerotesVillageBlocks.VILLAGER_BLOCK_FORGER, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_weaponsmith")));
    public static final RegistryObject<VillagerProfession> VILLAGER_CHEF = JerotesVillageVillagerProfessions.registerProfession("villager_chef", JerotesVillageBlocks.VILLAGER_BLOCK_CHEF, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_butcher")));
    public static final RegistryObject<VillagerProfession> VILLAGER_HUNTER = JerotesVillageVillagerProfessions.registerProfession("villager_hunter", JerotesVillageBlocks.VILLAGER_BLOCK_HUNTER, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_butcher")));
    public static final RegistryObject<VillagerProfession> VILLAGER_PHYSICIAN = JerotesVillageVillagerProfessions.registerProfession("villager_physician", JerotesVillageBlocks.VILLAGER_BLOCK_PHYSICIAN, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_cleric")));
    public static final RegistryObject<VillagerProfession> VILLAGER_CONSCRIPTION = JerotesVillageVillagerProfessions.registerProfession("villager_conscription", JerotesVillageBlocks.VILLAGER_BLOCK_CONSCRIPTION, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_cleric")));
    public static final RegistryObject<VillagerProfession> VILLAGER_BARTENDER = JerotesVillageVillagerProfessions.registerProfession("villager_bartender", JerotesVillageBlocks.VILLAGER_BLOCK_BARTENDER, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_fisherman")));
    public static final RegistryObject<VillagerProfession> VILLAGER_LAMPLIGHTER = JerotesVillageVillagerProfessions.registerProfession("villager_lamplighter", JerotesVillageBlocks.VILLAGER_BLOCK_LAMPLIGHTER, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_toolsmith")));
    public static final RegistryObject<VillagerProfession> VILLAGER_HORSEMAN = JerotesVillageVillagerProfessions.registerProfession("villager_horseman", JerotesVillageBlocks.VILLAGER_BLOCK_HORSEMAN, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_farmer")));
    public static final RegistryObject<VillagerProfession> VILLAGER_COACHMAN = JerotesVillageVillagerProfessions.registerProfession("villager_coachman", JerotesVillageBlocks.VILLAGER_BLOCK_COACHMAN, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_leatherworker")));
    public static final RegistryObject<VillagerProfession> VILLAGER_BUILDER = JerotesVillageVillagerProfessions.registerProfession("villager_builder", JerotesVillageBlocks.VILLAGER_BLOCK_BUILDER, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_toolsmith")));
    public static final RegistryObject<VillagerProfession> VILLAGER_BREEDER = JerotesVillageVillagerProfessions.registerProfession("villager_breeder", JerotesVillageBlocks.VILLAGER_BLOCK_BREEDER, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_farmer")));
    public static final RegistryObject<VillagerProfession> VILLAGER_HAWKER = JerotesVillageVillagerProfessions.registerProfession("villager_hawker", JerotesVillageBlocks.VILLAGER_BLOCK_HAWKER, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_farmer")));
    public static final RegistryObject<VillagerProfession> VILLAGER_JAILER = JerotesVillageVillagerProfessions.registerProfession("villager_jailer", JerotesVillageBlocks.VILLAGER_BLOCK_JAILER, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_weaponsmith")));
    public static final RegistryObject<VillagerProfession> VILLAGER_PISCATOR = JerotesVillageVillagerProfessions.registerProfession("villager_piscator", JerotesVillageBlocks.VILLAGER_BLOCK_PISCATOR, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_fisherman")));
    public static final RegistryObject<VillagerProfession> VILLAGER_MAGICIAN = JerotesVillageVillagerProfessions.registerProfession("villager_magician", JerotesVillageBlocks.VILLAGER_BLOCK_MAGICIAN, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_cleric")));
    public static final RegistryObject<VillagerProfession> VILLAGER_CAPTAIN = JerotesVillageVillagerProfessions.registerProfession("villager_captain", JerotesVillageBlocks.VILLAGER_BLOCK_CAPTAIN, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_fisherman")));
    public static final RegistryObject<VillagerProfession> VILLAGER_MESSENGER = JerotesVillageVillagerProfessions.registerProfession("villager_messenger", JerotesVillageBlocks.VILLAGER_BLOCK_MESSENGER, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_cartographer")));
    public static final RegistryObject<VillagerProfession> VILLAGER_DYE_MERCHANT = JerotesVillageVillagerProfessions.registerProfession("villager_dye_merchant", JerotesVillageBlocks.VILLAGER_BLOCK_DYE_MERCHANT, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_leatherworker")));
    public static final RegistryObject<VillagerProfession> VILLAGER_ILLAGER = JerotesVillageVillagerProfessions.registerProfession("villager_illager", JerotesVillageBlocks.VILLAGER_BLOCK_ILLAGER, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_leatherworker")));
    public static final RegistryObject<VillagerProfession> VILLAGER_PIGLIN = JerotesVillageVillagerProfessions.registerProfession("villager_piglin", JerotesVillageBlocks.VILLAGER_BLOCK_PIGLIN, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_leatherworker")));
    public static final RegistryObject<VillagerProfession> VILLAGER_BEEKEEPER = JerotesVillageVillagerProfessions.registerProfession("villager_beekeeper", JerotesVillageBlocks.VILLAGER_BLOCK_BEEKEEPER, () -> (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.villager.work_farmer")));

    private static RegistryObject<VillagerProfession> registerProfession(String name, Supplier<Block> block, Supplier<SoundEvent> soundEvent) {
        POI_TYPES.put(name, new ProfessionPoiType(block, null));
        return PROFESSIONS.register(name, () -> {
            Predicate<Holder> poiPredicate = poiTypeHolder -> JerotesVillageVillagerProfessions.POI_TYPES.get((Object)name).poiType != null && poiTypeHolder.get() == JerotesVillageVillagerProfessions.POI_TYPES.get((Object)name).poiType.get();
            return new VillagerProfession("jerotesvillage:" + name, poiPredicate, poiPredicate, ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)soundEvent.get());
        });
    }

    @SubscribeEvent
    public static void registerProfessionPointsOfInterest(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.POI_TYPES, registerHelper -> {
            for (Map.Entry<String, ProfessionPoiType> entry : POI_TYPES.entrySet()) {
                Block block = entry.getValue().block.get();
                String name = entry.getKey();
                Optional existingCheck = PoiTypes.m_218075_((BlockState)block.m_49966_());
                if (existingCheck.isPresent()) continue;
                PoiType poiType = new PoiType((Set)ImmutableSet.copyOf((Collection)block.m_49965_().m_61056_()), 1, 1);
                registerHelper.register(name, (Object)poiType);
                entry.getValue().poiType = (Holder)ForgeRegistries.POI_TYPES.getHolder((Object)poiType).get();
            }
        });
    }

    private static class ProfessionPoiType {
        final Supplier<Block> block;
        Holder<PoiType> poiType;

        ProfessionPoiType(Supplier<Block> block, Holder<PoiType> poiType) {
            this.block = block;
            this.poiType = poiType;
        }
    }
}

