/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.item;

import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.util.Main;
import com.jerotes.jerotesvillage.event.RelationshipEvent;
import com.jerotes.jerotesvillage.init.JerotesVillageBlocks;
import com.jerotes.jerotesvillage.init.JerotesVillageItems;
import com.jerotes.jerotesvillage.util.OtherEntityFactionFind;
import com.jerotes.jerotesvillage.world.inventory.CarvedFactionMenu;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import org.slf4j.Logger;

public class CarvedContacter
extends Item
implements Vanishable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String TAG_CARVED_LODESTONE_POS = "CarvedLodestonePos";
    public static final String TAG_CARVED_LODESTONE_DIMENSION = "CarvedLodestoneDimension";
    public static final String TAG_CARVED_LODESTONE_TRACKED = "CarvedLodestoneTracked";

    public CarvedContacter() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    public static boolean isLodestoneContacter(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        return compoundtag != null && compoundtag.m_128441_(TAG_CARVED_LODESTONE_DIMENSION) && compoundtag.m_128441_(TAG_CARVED_LODESTONE_POS);
    }

    private static Optional<ResourceKey<Level>> getLodestoneDimension(CompoundTag compoundTag) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_(TAG_CARVED_LODESTONE_DIMENSION)).result();
    }

    public boolean m_5812_(ItemStack itemStack) {
        return CarvedContacter.isLodestoneContacter(itemStack) || super.m_5812_(itemStack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player.m_9236_() instanceof ServerLevel) {
            ItemStack itemStack = player.m_21120_(hand);
            CompoundTag compoundTag = itemStack.m_41783_();
            if (compoundTag != null && CarvedContacter.isLodestoneContacter(itemStack) && itemStack.m_41720_() instanceof CarvedContacter) {
                BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_(TAG_CARVED_LODESTONE_POS));
                Optional<ResourceKey<Level>> optional = CarvedContacter.getLodestoneDimension(compoundTag);
                if (optional.isPresent() && optional.get() == level.m_46472_() && optional.get() == player.m_9236_().m_46472_() && !level.m_8055_(blockPos).m_60713_((Block)JerotesVillageBlocks.CARVED_LODESTONE.get())) {
                    level.m_6269_(null, (Entity)player, SoundEvents.f_12107_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    ItemStack itemstack1 = new ItemStack((ItemLike)JerotesVillageItems.CARVED_CONTACTER.get(), 1);
                    if (!player.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                    }
                    if (!player.m_150109_().m_36054_(itemstack1)) {
                        player.m_36176_(itemstack1, false);
                    }
                    player.m_213846_((Component)Component.m_237115_((String)"message.jerotesvillage.carved_lodestone_not_find").m_130940_(ChatFormatting.GOLD));
                }
            }
            if (player.m_6144_() && RelationshipEvent.MoreCopperCarvedCompanyRelationship(player, 500)) {
                List list = player.m_9236_().m_45976_(Mob.class, player.m_20191_().m_82377_(128.0, 128.0, 128.0));
                double d = Double.MAX_VALUE;
                for (Mob carved : list) {
                    LivingEntity livingEntity;
                    if (carved == null || carved.m_20280_((Entity)carved) > d || !OtherEntityFactionFind.isCarved(carved.m_6095_()) || carved.m_5448_() != null && carved.m_5448_() == player) continue;
                    CarvedContacter.teleportPos((LivingEntity)carved, player, player.m_21120_(hand));
                    carved.m_21573_().m_26573_();
                    Entity entity = carved.m_20202_();
                    if (!(entity instanceof LivingEntity) || (livingEntity = (LivingEntity)entity).m_6688_() != carved) continue;
                    CarvedContacter.teleportPos(livingEntity, player, player.m_21120_(hand));
                    if (!(livingEntity instanceof Mob)) continue;
                    Mob mob = (Mob)livingEntity;
                    mob.m_21573_().m_26573_();
                }
            } else {
                player.m_5893_((MenuProvider)new SimpleMenuProvider((n, inventory, player2) -> new CarvedFactionMenu(n, inventory), (Component)Component.m_237115_((String)this.m_5524_())));
            }
        }
        return super.m_7203_(level, player, hand);
    }

    public static void teleport(LivingEntity livingEntity, Player player, double x, double y, double z) {
        Level level = livingEntity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos tpPos = Main.findSpawnPositionNearFillOnBlock((LevelReader)player.m_9236_(), (BlockPos)new BlockPos((int)x, (int)y, (int)z), (int)3);
            livingEntity.m_20035_(tpPos, livingEntity.m_146908_(), livingEntity.m_146909_());
            for (int i = 0; i < 20; ++i) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, livingEntity.m_20208_(1.5), livingEntity.m_20187_(), livingEntity.m_20262_(1.5), 0, 0.0, 0.0, 0.0, 0.0);
            }
            if (!livingEntity.m_20067_()) {
                serverLevel.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), JerotesSounds.TELEPORT, livingEntity.m_5720_(), 5.0f, 1.0f);
            }
        }
    }

    public static void teleportPos(LivingEntity livingEntity, Player player, ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (itemStack.m_41720_() instanceof CarvedContacter) {
            if (CarvedContacter.isLodestoneContacter(itemStack) && compoundTag != null) {
                Optional<ResourceKey<Level>> optional = CarvedContacter.getLodestoneDimension(compoundTag);
                if (optional.isPresent() && optional.get() == livingEntity.m_9236_().m_46472_() && optional.get() == player.m_9236_().m_46472_()) {
                    BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_(TAG_CARVED_LODESTONE_POS));
                    CarvedContacter.teleport(livingEntity, player, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"message.jerotesvillage.carved_lodestone_dimension_not_find").m_130940_(ChatFormatting.GOLD));
                }
                return;
            }
            CarvedContacter.teleport(livingEntity, player, player.m_20185_(), player.m_20186_(), player.m_20189_());
        }
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        boolean flag;
        BlockPos blockpos = useOnContext.m_8083_();
        Level level = useOnContext.m_43725_();
        if (!level.m_8055_(blockpos).m_60713_((Block)JerotesVillageBlocks.CARVED_LODESTONE.get())) {
            return super.m_6225_(useOnContext);
        }
        level.m_5594_(null, blockpos, SoundEvents.f_12107_, SoundSource.PLAYERS, 1.0f, 1.0f);
        Player player = useOnContext.m_43723_();
        ItemStack itemstack = useOnContext.m_43722_();
        boolean bl = flag = !player.m_150110_().f_35937_ && itemstack.m_41613_() == 1;
        if (flag) {
            this.addLodestoneTags((ResourceKey<Level>)level.m_46472_(), blockpos, itemstack.m_41784_());
        } else {
            ItemStack itemstack1 = new ItemStack((ItemLike)JerotesVillageItems.CARVED_CONTACTER.get(), 1);
            CompoundTag compoundtag = itemstack.m_41782_() ? itemstack.m_41783_().m_6426_() : new CompoundTag();
            itemstack1.m_41751_(compoundtag);
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.addLodestoneTags((ResourceKey<Level>)level.m_46472_(), blockpos, compoundtag);
            if (!player.m_150109_().m_36054_(itemstack1)) {
                player.m_36176_(itemstack1, false);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private void addLodestoneTags(ResourceKey<Level> resourceKey, BlockPos blockPos, CompoundTag compoundTag) {
        compoundTag.m_128365_(TAG_CARVED_LODESTONE_POS, (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, resourceKey).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_ -> compoundTag.m_128365_(TAG_CARVED_LODESTONE_DIMENSION, p_));
        compoundTag.m_128379_(TAG_CARVED_LODESTONE_TRACKED, true);
    }

    public String m_5671_(ItemStack itemStack) {
        return CarvedContacter.isLodestoneContacter(itemStack) ? "item.jerotesvillage.lodestone_carved_contacter" : super.m_5671_(itemStack);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        list.add((Component)this.getDisplayName_0().m_130940_(ChatFormatting.GRAY));
        list.add((Component)this.getDisplayName_1().m_130940_(ChatFormatting.GRAY));
        list.add((Component)this.getDisplayName_2().m_130940_(ChatFormatting.GRAY));
    }

    public MutableComponent getDisplayName_0() {
        return Component.m_237115_((String)(this.m_5524_() + ".desc_0"));
    }

    public MutableComponent getDisplayName_1() {
        return Component.m_237115_((String)(this.m_5524_() + ".desc_1"));
    }

    public MutableComponent getDisplayName_2() {
        return Component.m_237115_((String)(this.m_5524_() + ".desc_2"));
    }
}

