/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.jerotes.jerotes.init.JerotesDamageTypes;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotesvillage.item.VillagerMetalSyringe;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ItemTabletBase
extends Item {
    private static final Map<EntityType<? extends Mob>, ItemTabletBase> BY_ID = Maps.newIdentityHashMap();
    private final MobEffect mobEffect;
    private final int time;
    private final int level;
    private final MobEffect mobEffect2;
    private final int time2;
    private final int level2;
    private final boolean hurt;
    private final int color;
    private final int color2;

    public ItemTabletBase(Item.Properties properties, MobEffect mobEffect, int time, int level, MobEffect mobEffect2, int time2, int level2, boolean hurt, int color, int color2) {
        super(properties);
        this.mobEffect = mobEffect;
        this.time = time;
        this.level = level;
        this.mobEffect2 = mobEffect2;
        this.time2 = time2;
        this.level2 = level2;
        this.hurt = hurt;
        this.color = color;
        this.color2 = color2;
    }

    public static Iterable<ItemTabletBase> tablets() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }

    public int getColor() {
        return this.color;
    }

    public int getColor2() {
        return this.color2;
    }

    public int m_8105_(ItemStack itemStack) {
        return 10;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.EAT;
    }

    public SoundEvent m_6023_() {
        return SoundEvents.f_11912_;
    }

    public SoundEvent m_6061_() {
        return SoundEvents.f_11912_;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        if (interactionHand == InteractionHand.OFF_HAND && player.m_21205_().m_41720_() instanceof VillagerMetalSyringe) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)interactionHand);
    }

    public boolean useTablet(LivingEntity patient, LivingEntity operator) {
        if (!patient.m_6084_()) {
            return false;
        }
        if (!patient.m_9236_().m_5776_()) {
            patient.m_147207_(new MobEffectInstance(this.mobEffect, this.time, this.level, false, true), (Entity)operator);
            patient.m_147207_(new MobEffectInstance(this.mobEffect2, this.time2, this.level2, false, true), (Entity)operator);
            if (patient != operator && this.hurt) {
                DamageSource damageSources = new DamageSource((Holder)operator.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(JerotesDamageTypes.SYRINGE), (Entity)operator);
                AttackFind.attackBegin((LivingEntity)operator, (Entity)patient);
                AttackFind.attackAfterCustomDamage((LivingEntity)operator, (Entity)patient, (DamageSource)damageSources, (float)0.0f, (float)0.0f, (boolean)true, (float)1.0f);
            }
        }
        return true;
    }

    public ItemStack m_5922_(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        super.m_5922_(itemStack, level, livingEntity);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            CriteriaTriggers.f_10592_.m_23682_(player, itemStack);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
        if (!level.f_46443_) {
            this.useTablet(livingEntity, livingEntity);
        }
        if (livingEntity instanceof Player && !((Player)livingEntity).m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return itemStack;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)this.getDisplayName().m_130940_(ChatFormatting.GRAY));
        super.m_7373_(itemStack, level, list, tooltipFlag);
    }

    public MutableComponent getDisplayName() {
        MutableComponent string = Component.m_237115_((String)this.mobEffect.m_19482_().getString());
        MutableComponent string2 = Component.m_237115_((String)this.mobEffect2.m_19482_().getString());
        return Component.m_237110_((String)"item.jerotesvillage.tablet.desc", (Object[])new Object[]{string, string2});
    }
}

