/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.mixin;

import com.jerotes.jerotesvillage.entity.in.GoastEntity;
import com.jerotes.jerotesvillage.init.JerotesVillageBiomes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Goat.class})
public abstract class GoatMixin
extends Animal
implements GoastEntity {
    @Unique
    private static final UniformInt TIME_BETWEEN_LONG_JUMPS = UniformInt.m_146622_((int)600, (int)1200);
    @Unique
    private static final UniformInt TIME_BETWEEN_RAMS = UniformInt.m_146622_((int)600, (int)6000);
    private static final EntityDataAccessor<Boolean> IS_GOAST = SynchedEntityData.m_135353_(GoatMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected GoatMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public boolean isGoast() {
        return (Boolean)this.m_20088_().m_135370_(IS_GOAST);
    }

    @Override
    public void setGoast(boolean bl) {
        this.m_20088_().m_135381_(IS_GOAST, (Object)bl);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        compoundTag.m_128379_("IsGoast", this.isGoast());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag compoundTag, CallbackInfo ci) {
        this.setGoast(compoundTag.m_128471_("IsGoast"));
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    protected void defineSynchedData(CallbackInfo ci) {
        this.m_20088_().m_135372_(IS_GOAST, (Object)false);
    }

    protected Component m_5677_() {
        if (this.isGoast()) {
            return Component.m_237115_((String)"entity.jerotesvillage.goast");
        }
        return Component.m_237115_((String)this.m_6095_().m_20675_());
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    protected void aiStep(CallbackInfo ci) {
        if (this.isGoast() && this.f_20919_ == 5 && !this.m_6084_()) {
            this.m_19998_((ItemLike)Items.f_42586_);
        }
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="HEAD")})
    private void finalizeSpawn(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, SpawnGroupData p_21437_, CompoundTag p_21438_, CallbackInfoReturnable<SpawnGroupData> cir) {
        if (this.m_9236_().m_204166_(BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_())).m_203565_(JerotesVillageBiomes.DROUGHT_FIRE) && this.m_6095_() == EntityType.f_147035_) {
            this.setGoast(true);
        }
    }

    @Inject(method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/animal/goat/Goat;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob, CallbackInfoReturnable<Goat> cir) {
        GoastEntity goastEntity;
        if (this.isGoast() || ageableMob instanceof GoastEntity && (goastEntity = (GoastEntity)ageableMob).isGoast()) {
            Goat goatBaby = (Goat)EntityType.f_147035_.m_20615_((Level)serverLevel);
            if (goatBaby != null) {
                Goat goat;
                goatBaby.m_6274_().m_21879_(MemoryModuleType.f_148199_, (Object)TIME_BETWEEN_LONG_JUMPS.m_214085_(serverLevel.m_213780_()));
                goatBaby.m_6274_().m_21879_(MemoryModuleType.f_148202_, (Object)TIME_BETWEEN_RAMS.m_214085_(serverLevel.m_213780_()));
                GoatMixin ageableMob1 = serverLevel.m_213780_().m_188499_() ? this : ageableMob;
                boolean var10000 = ageableMob1 instanceof Goat && (goat = (Goat)ageableMob1).m_149397_() || serverLevel.m_213780_().m_188500_() < 0.02;
                boolean $$5 = var10000;
                goatBaby.m_149405_($$5);
                if (goatBaby instanceof GoastEntity) {
                    GoastEntity goastEntity2 = (GoastEntity)goatBaby;
                    goastEntity2.setGoast(true);
                }
            }
            cir.setReturnValue((Object)goatBaby);
            cir.cancel();
        }
    }
}

