/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.network;

import com.jerotes.jerotesvillage.network.OtherPacketHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="jerotesvillage", bus=Mod.EventBusSubscriber.Bus.MOD)
public class JerotesVillagePlayerData {
    public static final Capability<PlayerVariables> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class PlayerVariables {
        public int CopperCarvedCompanyRelationship = 0;
        public boolean HaveCopperCarvedCompanyRelationship = false;

        public void setHaveCopperCarvedCompanyRelationship(boolean bl) {
            this.HaveCopperCarvedCompanyRelationship = bl;
        }

        public void setCopperCarvedCompanyRelationship(int n) {
            this.CopperCarvedCompanyRelationship = n;
        }

        public void syncPlayerVariables(Entity entity) {
            if (!entity.m_9236_().m_5776_() && entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (this.writeNBT() != null) {
                    OtherPacketHandler.NETWORK_WRAPPER.send((Object)new PlayerVariablesSyncMessage(this.writeNBT()), PacketDistributor.PLAYER.with((Object)serverPlayer));
                }
            }
        }

        public CompoundTag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("JerotesVillageCopperCarvedCompanyRelationship", this.CopperCarvedCompanyRelationship);
            nbt.m_128379_("JerotesVillageHaveCopperCarvedCompanyRelationship", this.HaveCopperCarvedCompanyRelationship);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.CopperCarvedCompanyRelationship = nbt.m_128451_("JerotesVillageCopperCarvedCompanyRelationship");
            this.HaveCopperCarvedCompanyRelationship = nbt.m_128471_("JerotesVillageHaveCopperCarvedCompanyRelationship");
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final CompoundTag data;

        public PlayerVariablesSyncMessage(CompoundTag nbt) {
            this.data = nbt;
        }

        public static void encode(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((Tag)message.data);
        }

        public static PlayerVariablesSyncMessage decode(FriendlyByteBuf buffer) {
            return new PlayerVariablesSyncMessage(buffer.m_130260_());
        }

        public static void consume(PlayerVariablesSyncMessage message, CustomPayloadEvent.Context context) {
            context.enqueueWork(() -> {
                Minecraft minecraft = Minecraft.m_91087_();
                if (minecraft.f_91074_ != null) {
                    minecraft.f_91074_.getCapability(CAPABILITY).ifPresent(cap -> cap.readNBT((Tag)message.data));
                }
            });
            context.setPacketHandled(true);
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player) {
                event.addCapability(new ResourceLocation("jerotesvillage", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.CopperCarvedCompanyRelationship = original.CopperCarvedCompanyRelationship;
            clone.HaveCopperCarvedCompanyRelationship = original.HaveCopperCarvedCompanyRelationship;
        }
    }
}

