/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotesvillage.network;

import com.jerotes.jerotesvillage.block.BitterCold.TorchOfFirmIce;
import com.jerotes.jerotesvillage.block.BitterCold.TorchOfFirmIceEntity;
import com.jerotes.jerotesvillage.client.gui.TorchOfFirmIceScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class TorchOfFirmIcePacket {
    public int elite;
    public BlockPos blockPos;
    public boolean open;
    public int count;

    public TorchOfFirmIcePacket(int id, BlockPos blockPos, boolean open, int count) {
        this.elite = id;
        this.blockPos = blockPos;
        this.open = open;
        this.count = count;
    }

    public static void encode(TorchOfFirmIcePacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.elite);
        buffer.m_130064_(packet.blockPos);
        buffer.writeBoolean(packet.open);
        buffer.writeInt(packet.elite);
    }

    public static TorchOfFirmIcePacket decode(FriendlyByteBuf buffer) {
        return new TorchOfFirmIcePacket(buffer.readInt(), buffer.m_130135_(), buffer.readBoolean(), buffer.readInt());
    }

    public void consume(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            Level level;
            Block patt1703$temp;
            ServerPlayer playerEntity = context.getSender();
            if (playerEntity != null && (patt1703$temp = (level = playerEntity.m_9236_()).m_8055_(this.blockPos).m_60734_()) instanceof TorchOfFirmIce) {
                TorchOfFirmIce torchOfFirmIce = (TorchOfFirmIce)patt1703$temp;
                if (this.open) {
                    ServerLevel serverLevel;
                    if (level instanceof ServerLevel && TorchOfFirmIceScreen.canSummonFindBlockCount(this.elite, serverLevel = (ServerLevel)level, this.blockPos, (Player)playerEntity)) {
                        torchOfFirmIce.setOpen((Entity)playerEntity, level, level.m_8055_(this.blockPos), this.blockPos, true);
                        BlockEntity blockentity = level.m_7702_(this.blockPos);
                        if (blockentity instanceof TorchOfFirmIceEntity) {
                            TorchOfFirmIceEntity torchOfFirmIceEntity = (TorchOfFirmIceEntity)blockentity;
                            torchOfFirmIceEntity.shrink(this.count);
                        }
                        TorchOfFirmIceScreen.changeEntity(this.elite, level, this.blockPos);
                    }
                } else if (torchOfFirmIce.getElite(level.m_8055_(this.blockPos)) == this.elite) {
                    torchOfFirmIce.setElite((Entity)playerEntity, level, level.m_8055_(this.blockPos), this.blockPos, 0);
                } else {
                    torchOfFirmIce.setElite((Entity)playerEntity, level, level.m_8055_(this.blockPos), this.blockPos, this.elite);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

