/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.entity;

import com.google.common.collect.ImmutableList;
import com.jerotes.jerotes.entity.EntityTrueBasePart;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BasePartLivingEntity
extends LivingEntity
implements EntityTrueBasePart {
    private static final EntityDataAccessor<Integer> BODYINDEX = SynchedEntityData.m_135353_(BasePartLivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.m_135353_(BasePartLivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public EntityDimensions multipartSize;
    public float radius;
    public float angleYaw;
    public float offsetY;
    public float damageMultiplier = 0.8f;
    public Entity cachedParent;

    public BasePartLivingEntity(EntityType t, Level world) {
        super(t, world);
        this.multipartSize = t.m_20680_();
    }

    public BasePartLivingEntity(EntityType t, LivingEntity parent, float radius, float angleYaw, float offsetY) {
        super(t, parent.m_9236_());
        this.setParent((Entity)parent);
        this.radius = radius;
        this.angleYaw = (angleYaw + 90.0f) * ((float)Math.PI / 180);
        this.offsetY = offsetY;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.35);
        builder = builder.m_22268_(Attributes.f_22280_, 1.0);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22281_, 2.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        return builder;
    }

    public boolean m_7306_(@NotNull Entity entity) {
        return this == entity || this.getParent() == entity;
    }

    public boolean m_6087_() {
        return true;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public boolean m_20329_(Entity entityIn) {
        return false;
    }

    public boolean m_142066_() {
        return false;
    }

    public void m_6138_() {
    }

    @Nullable
    public ItemStack m_142340_() {
        Entity parent = this.getParent();
        return parent != null ? parent.m_142340_() : ItemStack.f_41583_;
    }

    protected void m_7324_(Entity entity) {
        if (entity.m_6095_() != this.m_6095_() && (this.getParent() == null || entity.m_6095_() != this.getParent().m_6095_())) {
            super.m_7324_(entity);
        }
    }

    public Iterable<ItemStack> m_6168_() {
        return ImmutableList.of();
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }

    public void m_21229_() {
    }

    public boolean m_142079_() {
        if (this.getParent() != null && !this.getParent().m_142079_()) {
            return false;
        }
        return super.m_142079_();
    }

    public boolean m_203117_() {
        if (this.getParent() != null && !this.getParent().m_203117_()) {
            return false;
        }
        return super.m_203117_();
    }

    public boolean m_6060_() {
        if (this.getParent() != null && !this.getParent().m_6060_()) {
            return false;
        }
        return super.m_6060_();
    }

    protected void m_7840_(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
        if (this.getParent() == null) {
            super.m_7840_(d, bl, blockState, blockPos);
        }
    }

    @Nullable
    public UUID getParentId() {
        return ((Optional)this.f_19804_.m_135370_(PARENT_UUID)).orElse(null);
    }

    public void setParentId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(PARENT_UUID, Optional.ofNullable(uniqueId));
    }

    public void setInitialPartPos(Entity parent) {
        this.m_6034_(parent.m_20185_() + (double)this.radius * Math.cos(parent.m_146908_() * ((float)Math.PI / 180) + this.angleYaw), parent.m_20186_() + (double)this.offsetY, parent.m_20189_() + (double)this.radius * Math.sin(parent.m_146908_() * ((float)Math.PI / 180) + this.angleYaw));
    }

    public int getBodyIndex() {
        return (Integer)this.f_19804_.m_135370_(BODYINDEX);
    }

    public void setBodyIndex(int index) {
        this.f_19804_.m_135381_(BODYINDEX, (Object)index);
    }

    public Entity getParent() {
        Level level;
        UUID id = this.getParentId();
        if (id != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_8791_(id);
        }
        return null;
    }

    public void setParent(Entity entity) {
        this.setParentId(entity.m_20148_());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getParentId() != null) {
            compound.m_128362_("ParentUUID", this.getParentId());
        }
        compound.m_128405_("BodyIndex", this.getBodyIndex());
        compound.m_128350_("AngleYaw", this.angleYaw);
        compound.m_128350_("Radius", this.radius);
        compound.m_128350_("OffsetY", this.offsetY);
        compound.m_128350_("DamageMultiplier", this.damageMultiplier);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("ParentUUID")) {
            this.setParentId(compound.m_128342_("ParentUUID"));
        }
        this.setBodyIndex(compound.m_128451_("BodyIndex"));
        this.angleYaw = compound.m_128457_("AngleYaw");
        this.radius = compound.m_128457_("Radius");
        this.offsetY = compound.m_128457_("OffsetY");
        this.damageMultiplier = compound.m_128457_("DamageMultiplier");
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(PARENT_UUID, Optional.empty());
        this.m_20088_().m_135372_(BODYINDEX, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (PARENT_UUID.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        if (BODYINDEX.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(entityDataAccessor);
    }

    public void m_8119_() {
        Object object;
        Collection collection;
        this.f_19817_ = false;
        if (this.f_19797_ > 10) {
            if (this.cachedParent == null || this.f_19797_ % 20 == 0) {
                this.cachedParent = this.getParent();
            }
            Entity parent = this.cachedParent;
            if (this.f_19797_ % 10 == 0) {
                this.m_6210_();
            }
            if (parent != null && !this.m_9236_().f_46443_) {
                LivingEntity livingParent;
                this.m_20242_(parent.m_20068_());
                double targetX = parent.f_19854_ + (double)this.radius * Math.cos(parent.f_19859_ * ((float)Math.PI / 180) + this.angleYaw);
                double targetY = parent.f_19855_ + (double)this.offsetY;
                double targetZ = parent.f_19856_ + (double)this.radius * Math.sin(parent.f_19859_ * ((float)Math.PI / 180) + this.angleYaw);
                this.m_6034_(Mth.m_14139_((double)0.75, (double)this.m_20185_(), (double)targetX), Mth.m_14139_((double)0.75, (double)this.m_20186_(), (double)targetY), Mth.m_14139_((double)0.75, (double)this.m_20189_(), (double)targetZ));
                double d0 = parent.m_20185_() - this.m_20185_();
                double d1 = parent.m_20186_() - this.m_20186_();
                double d2 = parent.m_20189_() - this.m_20189_();
                float f2 = -((float)(Mth.m_14136_((double)d1, (double)Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)))) * 57.2957763671875));
                this.m_146926_(this.limitAngle(this.m_146909_(), f2, 5.0f));
                if (parent instanceof LivingEntity) {
                    livingParent = (LivingEntity)parent;
                    if (livingParent.f_20916_ > 0) {
                        this.m_5834_();
                    }
                }
                this.m_146922_(Mth.m_14179_((float)0.75f, (float)this.m_146908_(), (float)parent.f_19859_));
                this.f_20885_ = this.m_146908_();
                this.f_20883_ = Mth.m_14179_((float)0.25f, (float)this.m_146908_(), (float)parent.f_19859_);
                if (parent instanceof LivingEntity) {
                    livingParent = (LivingEntity)parent;
                    if (!(this.m_9236_().f_46443_ || livingParent.f_20916_ <= 0 && livingParent.f_20919_ <= 0)) {
                        this.f_20916_ = livingParent.f_20916_;
                        this.f_20919_ = livingParent.f_20919_;
                    }
                }
                if (parent.m_213877_() && !this.m_9236_().f_46443_) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            } else if (this.f_19797_ > 20 && !this.m_9236_().f_46443_) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (!(collection = this.m_21220_()).isEmpty() && this.getParent() != null && (object = this.getParent()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)object;
            for (MobEffectInstance effect : collection) {
                if (livingEntity.m_21023_(effect.m_19544_())) continue;
                livingEntity.m_7292_(new MobEffectInstance(effect));
            }
            this.m_21219_();
        }
        if (this.m_20094_() > 0) {
            object = this.getParent();
            if (object instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)object;
                if (this.m_20094_() > livingEntity.m_20094_()) {
                    livingEntity.m_7311_(this.m_20094_());
                }
            }
            this.m_20095_();
        }
        if (this.m_146888_() > 0) {
            object = this.getParent();
            if (object instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)object;
                if (this.m_146888_() > livingEntity.m_146888_()) {
                    livingEntity.m_146917_(this.m_146888_());
                }
            }
            this.m_146917_(0);
        }
        super.m_8119_();
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        Entity parent = this.getParent();
        return parent != null ? parent.m_6096_(player, hand) : InteractionResult.PASS;
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        if (this.m_6673_(damagesource)) {
            return super.m_6469_(damagesource, amount);
        }
        Entity parent = this.getParent();
        return parent != null && parent.m_6469_(damagesource, amount * this.damageMultiplier);
    }

    public boolean m_6673_(@NotNull DamageSource source) {
        return source.m_269533_(DamageTypeTags.f_268549_) || source.m_269533_(DamageTypeTags.f_268581_) || source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268659_) || source.m_276093_(DamageTypes.f_268546_) || source.m_269533_(DamageTypeTags.f_268745_) || source.m_276093_(DamageTypes.f_268613_) || source.m_276093_(DamageTypes.f_268752_) || source.m_276093_(DamageTypes.f_268585_) || source.m_276093_(DamageTypes.f_268469_) || super.m_6673_(source);
    }

    @Override
    public void onAttackedFromServer(LivingEntity parent, float damage, DamageSource damageSource) {
        if (parent.f_20919_ > 0) {
            this.f_20919_ = parent.f_20919_;
        }
        if (parent.f_20916_ > 0) {
            this.f_20916_ = parent.f_20916_;
        }
    }
}

