/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.entity;

import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.init.JerotesGameRules;
import com.jerotes.jerotes.item.CanBeOffHand;
import com.jerotes.jerotes.item.CanGetOffHand;
import com.jerotes.jerotes.item.ItemOtherRange;
import com.jerotes.jerotes.item.ItemTwoHanded;
import com.jerotes.jerotes.item.JerotesItemThrowUse;
import com.jerotes.jerotes.item.JerotesItemThrownJavelinUse;
import com.jerotes.jerotes.item.MagicItem;
import com.jerotes.jerotes.item.MeleeItem;
import com.jerotes.jerotes.item.tool.ItemToolBaseSpearBase;
import com.jerotes.jerotes.util.EntityAndItemFind;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public interface InventoryEntity {
    public SimpleContainer mobInventory();

    public int inventoryCount();

    default public boolean hasCanChangeMeleeOrRange() {
        return true;
    }

    default public boolean hasCanChangeInventory() {
        return true;
    }

    public boolean isCanChangeInventory();

    public void setCanChangeInventory(boolean var1);

    public boolean isCanChangeMeleeOrRange();

    public void setCanChangeMeleeOrRange(boolean var1);

    default public float meleeOrRangeDistance() {
        return 8.0f;
    }

    default public int changeInventoryCooldownTick() {
        return 50;
    }

    default public boolean canEatOrDrinkHand() {
        return false;
    }

    default public boolean howToEatOrDrinkHand(Mob mob, ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof PotionItem && !(itemStack.m_41720_() instanceof ThrowablePotionItem) && (PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43611_ || PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43610_)) {
            return true;
        }
        return itemStack.m_41720_() instanceof PotionItem && !(itemStack.m_41720_() instanceof ThrowablePotionItem) && (PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43621_ || PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43622_);
    }

    default public boolean NonCombatEmptyWeapon() {
        return false;
    }

    default public boolean NonCombatEmptyShield() {
        return false;
    }

    default public boolean canUseMeleeWeapon() {
        return true;
    }

    default public boolean canUseRangeJavelin() {
        return true;
    }

    default public boolean canUseCrossbow() {
        return true;
    }

    default public boolean canUseThrow() {
        return true;
    }

    default public boolean canUseBow() {
        return true;
    }

    default public boolean canUseShield() {
        return true;
    }

    default public boolean canUseHelmet() {
        return true;
    }

    default public boolean canUseChestplate() {
        return true;
    }

    default public boolean canUseLeggings() {
        return true;
    }

    default public boolean canUseBoots() {
        return true;
    }

    default public boolean canUseMagicItem() {
        return true;
    }

    default public Component componentInventoryIYes() {
        return Component.m_237115_((String)"message.jerotes.mob_inventory_inventory_yes");
    }

    default public Component componentInventoryINo() {
        return Component.m_237115_((String)"message.jerotes.mob_inventory_inventory_no");
    }

    default public Component componentInventoryIIYes() {
        return Component.m_237115_((String)"message.jerotes.mob_inventory_melee_or_range_yes");
    }

    default public Component componentInventoryIINo() {
        return Component.m_237115_((String)"message.jerotes.mob_inventory_melee_or_range_no");
    }

    public static boolean canReplaceMeleeWeapon(InventoryEntity inventory, ItemStack newItem, ItemStack oldItem) {
        if (InventoryEntity.isMeleeWeapon(inventory, newItem) || InventoryEntity.isMeleeWeapon(inventory, oldItem)) {
            if (!inventory.canUseMeleeWeapon() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isMeleeWeapon(inventory, newItem) && InventoryEntity.isMeleeWeapon(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isMeleeWeapon(inventory, newItem) || InventoryEntity.isMeleeWeapon(inventory, oldItem) && inventory.canUseMeleeWeapon() || InventoryEntity.isCrossbow(inventory, oldItem) && inventory.canUseCrossbow() || InventoryEntity.isMagicItem(inventory, oldItem) && inventory.canUseMagicItem() || InventoryEntity.isThrow(inventory, oldItem) && inventory.canUseThrow() || InventoryEntity.isBow(inventory, oldItem) && inventory.canUseBow() || InventoryEntity.isOtherRange(inventory, oldItem));
        }
        return false;
    }

    public static boolean canReplaceBow(InventoryEntity inventory, ItemStack newItem, ItemStack oldItem) {
        if (InventoryEntity.isBow(inventory, newItem) || InventoryEntity.isBow(inventory, oldItem)) {
            if (!inventory.canUseBow() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isBow(inventory, newItem) && InventoryEntity.isBow(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isBow(inventory, newItem) || InventoryEntity.isMeleeWeapon(inventory, oldItem) && inventory.canUseMeleeWeapon() || InventoryEntity.isCrossbow(inventory, oldItem) && inventory.canUseCrossbow() || InventoryEntity.isMagicItem(inventory, oldItem) && inventory.canUseMagicItem() || InventoryEntity.isThrow(inventory, oldItem) && inventory.canUseThrow() || InventoryEntity.isBow(inventory, oldItem) && inventory.canUseBow() || InventoryEntity.isOtherRange(inventory, oldItem));
        }
        return false;
    }

    public static boolean canReplaceOtherRange(InventoryEntity inventory, ItemStack newItem, ItemStack oldItem) {
        if (InventoryEntity.isOtherRange(inventory, newItem) || InventoryEntity.isOtherRange(inventory, oldItem)) {
            if (!inventory.canUseBow() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isOtherRange(inventory, newItem) && InventoryEntity.isOtherRange(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isOtherRange(inventory, newItem) || InventoryEntity.isMeleeWeapon(inventory, oldItem) && inventory.canUseMeleeWeapon() || InventoryEntity.isCrossbow(inventory, oldItem) && inventory.canUseCrossbow() || InventoryEntity.isMagicItem(inventory, oldItem) && inventory.canUseMagicItem() || InventoryEntity.isThrow(inventory, oldItem) && inventory.canUseThrow() || InventoryEntity.isBow(inventory, oldItem) && inventory.canUseBow() || InventoryEntity.isOtherRange(inventory, oldItem));
        }
        return false;
    }

    public static boolean canReplaceCrossbow(InventoryEntity inventory, ItemStack newItem, ItemStack oldItem) {
        if (InventoryEntity.isCrossbow(inventory, newItem) || InventoryEntity.isCrossbow(inventory, oldItem)) {
            if (!inventory.canUseCrossbow() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isCrossbow(inventory, newItem) && InventoryEntity.isCrossbow(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isCrossbow(inventory, newItem) || InventoryEntity.isMeleeWeapon(inventory, oldItem) && inventory.canUseMeleeWeapon() || InventoryEntity.isCrossbow(inventory, oldItem) && inventory.canUseCrossbow() || InventoryEntity.isMagicItem(inventory, oldItem) && inventory.canUseMagicItem() || InventoryEntity.isThrow(inventory, oldItem) && inventory.canUseThrow() || InventoryEntity.isBow(inventory, oldItem) && inventory.canUseBow() || InventoryEntity.isOtherRange(inventory, oldItem));
        }
        return false;
    }

    public static boolean canReplaceMagicItem(InventoryEntity inventory, ItemStack newItem, ItemStack oldItem) {
        if (InventoryEntity.isMagicItem(inventory, newItem) || InventoryEntity.isMagicItem(inventory, oldItem)) {
            if (!inventory.canUseMagicItem() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isMagicItem(inventory, newItem) && InventoryEntity.isMagicItem(inventory, oldItem)) {
                Item item = newItem.m_41720_();
                if (item instanceof MagicItem) {
                    MagicItem magicItemNew = (MagicItem)item;
                    item = oldItem.m_41720_();
                    if (item instanceof MagicItem) {
                        MagicItem magicItemOld = (MagicItem)item;
                        if (magicItemNew.getSpellLevel(newItem) > magicItemOld.getSpellLevel(oldItem)) {
                            return true;
                        }
                    }
                }
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isMagicItem(inventory, newItem) || InventoryEntity.isMeleeWeapon(inventory, oldItem) && inventory.canUseMeleeWeapon() || InventoryEntity.isCrossbow(inventory, oldItem) && inventory.canUseCrossbow() || InventoryEntity.isMagicItem(inventory, oldItem) && inventory.canUseMagicItem() || InventoryEntity.isThrow(inventory, oldItem) && inventory.canUseThrow() || InventoryEntity.isBow(inventory, oldItem) && inventory.canUseBow() || InventoryEntity.isOtherRange(inventory, oldItem));
        }
        return false;
    }

    public static boolean canReplaceThrow(InventoryEntity inventory, ItemStack newItem, ItemStack oldItem) {
        if (InventoryEntity.isThrow(inventory, newItem) || InventoryEntity.isThrow(inventory, oldItem)) {
            if (!inventory.canUseCrossbow() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isThrow(inventory, newItem) && InventoryEntity.isThrow(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isThrow(inventory, newItem) || InventoryEntity.isMeleeWeapon(inventory, oldItem) && inventory.canUseMeleeWeapon() || InventoryEntity.isCrossbow(inventory, oldItem) && inventory.canUseCrossbow() || InventoryEntity.isMagicItem(inventory, oldItem) && inventory.canUseMagicItem() || InventoryEntity.isThrow(inventory, oldItem) && inventory.canUseThrow() || InventoryEntity.isBow(inventory, oldItem) && inventory.canUseBow() || InventoryEntity.isOtherRange(inventory, oldItem));
        }
        return false;
    }

    public static boolean canReplaceShield(InventoryEntity inventory, ItemStack newItem, ItemStack oldItem) {
        if (InventoryEntity.isShield(inventory, newItem) || InventoryEntity.isShield(inventory, oldItem)) {
            if (oldItem.m_41720_() instanceof ItemTwoHanded && newItem.m_41720_() instanceof ShieldItem) {
                return false;
            }
            if (!inventory.canUseShield() && newItem.m_41720_() instanceof ShieldItem || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (oldItem.m_41720_() instanceof CanBeOffHand) {
                return false;
            }
            if (newItem.m_41720_() instanceof CanBeOffHand) {
                return true;
            }
            if (InventoryEntity.isShield(inventory, newItem) && InventoryEntity.isShield(inventory, oldItem)) {
                if (!(oldItem.m_41720_() instanceof ShieldItem)) {
                    return false;
                }
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return InventoryEntity.isShield(inventory, newItem) && (!InventoryEntity.isShield(inventory, oldItem) || !inventory.canUseShield());
        }
        return false;
    }

    public static boolean canReplaceHelmet(InventoryEntity inventory, ItemStack newItem, ItemStack oldItem) {
        if (InventoryEntity.isHelmet(inventory, newItem) || InventoryEntity.isHelmet(inventory, oldItem)) {
            if (!inventory.canUseHelmet() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isHelmet(inventory, newItem) && InventoryEntity.isHelmet(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return InventoryEntity.isHelmet(inventory, newItem) && !InventoryEntity.isHelmet(inventory, oldItem);
        }
        return false;
    }

    public static boolean canReplaceChestplate(InventoryEntity inventory, ItemStack newItem, ItemStack oldItem) {
        if (InventoryEntity.isChestplate(inventory, newItem) || InventoryEntity.isChestplate(inventory, oldItem)) {
            if (!inventory.canUseChestplate() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isChestplate(inventory, newItem) && InventoryEntity.isChestplate(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return InventoryEntity.isChestplate(inventory, newItem) && !InventoryEntity.isChestplate(inventory, oldItem);
        }
        return false;
    }

    public static boolean canReplaceLeggings(InventoryEntity inventory, ItemStack newItem, ItemStack oldItem) {
        if (InventoryEntity.isLeggings(inventory, newItem) || InventoryEntity.isLeggings(inventory, oldItem)) {
            if (!inventory.canUseLeggings() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isLeggings(inventory, newItem) && InventoryEntity.isLeggings(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return InventoryEntity.isLeggings(inventory, newItem) && !InventoryEntity.isLeggings(inventory, oldItem);
        }
        return false;
    }

    public static boolean canReplaceBoots(InventoryEntity inventory, ItemStack newItem, ItemStack oldItem) {
        if (InventoryEntity.isBoots(inventory, newItem) || InventoryEntity.isBoots(inventory, oldItem)) {
            if (!inventory.canUseBoots() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isBoots(inventory, newItem) && InventoryEntity.isBoots(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return InventoryEntity.isBoots(inventory, newItem) && !InventoryEntity.isBoots(inventory, oldItem);
        }
        return false;
    }

    public static boolean canReplaceCurrentItem(InventoryEntity inventory, ItemStack newItem, ItemStack oldItem) {
        if (InventoryEntity.isMeleeWeapon(inventory, newItem) || InventoryEntity.isMeleeWeapon(inventory, oldItem)) {
            if (!inventory.canUseMeleeWeapon() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isMeleeWeapon(inventory, newItem) && InventoryEntity.isMeleeWeapon(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isMeleeWeapon(inventory, newItem) || InventoryEntity.isMeleeWeapon(inventory, oldItem) && inventory.canUseMeleeWeapon() || InventoryEntity.isCrossbow(inventory, oldItem) && inventory.canUseCrossbow() || InventoryEntity.isMagicItem(inventory, oldItem) && inventory.canUseMagicItem() || InventoryEntity.isThrow(inventory, oldItem) && inventory.canUseThrow() || InventoryEntity.isBow(inventory, oldItem) && inventory.canUseBow() || InventoryEntity.isOtherRange(inventory, oldItem));
        }
        if (InventoryEntity.isBow(inventory, newItem) || InventoryEntity.isBow(inventory, oldItem)) {
            if (!inventory.canUseBow() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isBow(inventory, newItem) && InventoryEntity.isBow(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isBow(inventory, newItem) || InventoryEntity.isMeleeWeapon(inventory, oldItem) && inventory.canUseMeleeWeapon() || InventoryEntity.isCrossbow(inventory, oldItem) && inventory.canUseCrossbow() || InventoryEntity.isMagicItem(inventory, oldItem) && inventory.canUseMagicItem() || InventoryEntity.isThrow(inventory, oldItem) && inventory.canUseThrow() || InventoryEntity.isBow(inventory, oldItem) && inventory.canUseBow() || InventoryEntity.isOtherRange(inventory, oldItem));
        }
        if (InventoryEntity.isOtherRange(inventory, newItem) || InventoryEntity.isOtherRange(inventory, oldItem)) {
            if (!inventory.canUseBow() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isOtherRange(inventory, newItem) && InventoryEntity.isOtherRange(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isOtherRange(inventory, newItem) || InventoryEntity.isMeleeWeapon(inventory, oldItem) && inventory.canUseMeleeWeapon() || InventoryEntity.isCrossbow(inventory, oldItem) && inventory.canUseCrossbow() || InventoryEntity.isMagicItem(inventory, oldItem) && inventory.canUseMagicItem() || InventoryEntity.isThrow(inventory, oldItem) && inventory.canUseThrow() || InventoryEntity.isBow(inventory, oldItem) && inventory.canUseBow() || InventoryEntity.isOtherRange(inventory, oldItem));
        }
        if (InventoryEntity.isMagicItem(inventory, newItem) || InventoryEntity.isMagicItem(inventory, oldItem)) {
            if (!inventory.canUseMagicItem() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isMagicItem(inventory, newItem) && InventoryEntity.isMagicItem(inventory, oldItem)) {
                Item item = newItem.m_41720_();
                if (item instanceof MagicItem) {
                    MagicItem magicItemNew = (MagicItem)item;
                    item = oldItem.m_41720_();
                    if (item instanceof MagicItem) {
                        MagicItem magicItemOld = (MagicItem)item;
                        if (magicItemNew.getSpellLevel(newItem) > magicItemOld.getSpellLevel(oldItem)) {
                            return true;
                        }
                    }
                }
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isMagicItem(inventory, newItem) || InventoryEntity.isMeleeWeapon(inventory, oldItem) && inventory.canUseMeleeWeapon() || InventoryEntity.isCrossbow(inventory, oldItem) && inventory.canUseCrossbow() || InventoryEntity.isMagicItem(inventory, oldItem) && inventory.canUseMagicItem() || InventoryEntity.isThrow(inventory, oldItem) && inventory.canUseThrow() || InventoryEntity.isBow(inventory, oldItem) && inventory.canUseBow() || InventoryEntity.isOtherRange(inventory, oldItem));
        }
        if (InventoryEntity.isCrossbow(inventory, newItem) || InventoryEntity.isCrossbow(inventory, oldItem)) {
            if (!inventory.canUseCrossbow() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isCrossbow(inventory, newItem) && InventoryEntity.isCrossbow(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isCrossbow(inventory, newItem) || InventoryEntity.isMeleeWeapon(inventory, oldItem) && inventory.canUseMeleeWeapon() || InventoryEntity.isCrossbow(inventory, oldItem) && inventory.canUseCrossbow() || InventoryEntity.isMagicItem(inventory, oldItem) && inventory.canUseMagicItem() || InventoryEntity.isThrow(inventory, oldItem) && inventory.canUseThrow() || InventoryEntity.isBow(inventory, oldItem) && inventory.canUseBow() || InventoryEntity.isOtherRange(inventory, oldItem));
        }
        if (InventoryEntity.isThrow(inventory, newItem) || InventoryEntity.isThrow(inventory, oldItem)) {
            if (!inventory.canUseThrow() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isThrow(inventory, newItem) && InventoryEntity.isThrow(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isThrow(inventory, newItem) || InventoryEntity.isMeleeWeapon(inventory, oldItem) && inventory.canUseMeleeWeapon() || InventoryEntity.isCrossbow(inventory, oldItem) && inventory.canUseCrossbow() || InventoryEntity.isMagicItem(inventory, oldItem) && inventory.canUseMagicItem() || InventoryEntity.isThrow(inventory, oldItem) && inventory.canUseThrow() || InventoryEntity.isBow(inventory, oldItem) && inventory.canUseBow() || InventoryEntity.isOtherRange(inventory, oldItem));
        }
        if (InventoryEntity.isShield(inventory, newItem) || InventoryEntity.isShield(inventory, oldItem)) {
            if (oldItem.m_41720_() instanceof ItemTwoHanded && newItem.m_41720_() instanceof ShieldItem) {
                return false;
            }
            if (!inventory.canUseShield() && newItem.m_41720_() instanceof ShieldItem || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (oldItem.m_41720_() instanceof CanBeOffHand) {
                return false;
            }
            if (newItem.m_41720_() instanceof CanBeOffHand) {
                return true;
            }
            if (InventoryEntity.isShield(inventory, newItem) && InventoryEntity.isShield(inventory, oldItem)) {
                if (!(oldItem.m_41720_() instanceof ShieldItem)) {
                    return false;
                }
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return InventoryEntity.isShield(inventory, newItem) && (!InventoryEntity.isShield(inventory, oldItem) || !inventory.canUseShield());
        }
        if (InventoryEntity.isHelmet(inventory, newItem) || InventoryEntity.isHelmet(inventory, oldItem)) {
            if (!inventory.canUseHelmet() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isHelmet(inventory, newItem) && InventoryEntity.isHelmet(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return InventoryEntity.isHelmet(inventory, newItem) && !InventoryEntity.isHelmet(inventory, oldItem);
        }
        if (InventoryEntity.isChestplate(inventory, newItem) || InventoryEntity.isChestplate(inventory, oldItem)) {
            if (!inventory.canUseChestplate() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isChestplate(inventory, newItem) && InventoryEntity.isChestplate(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return InventoryEntity.isChestplate(inventory, newItem) && !InventoryEntity.isChestplate(inventory, oldItem);
        }
        if (InventoryEntity.isLeggings(inventory, newItem) || InventoryEntity.isLeggings(inventory, oldItem)) {
            if (!inventory.canUseLeggings() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isLeggings(inventory, newItem) && InventoryEntity.isLeggings(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return InventoryEntity.isLeggings(inventory, newItem) && !InventoryEntity.isLeggings(inventory, oldItem);
        }
        if (InventoryEntity.isBoots(inventory, newItem) || InventoryEntity.isBoots(inventory, oldItem)) {
            if (!inventory.canUseBoots() || oldItem.getEnchantmentLevel(Enchantments.f_44975_) > 0) {
                return false;
            }
            if (InventoryEntity.isBoots(inventory, newItem) && InventoryEntity.isBoots(inventory, oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return InventoryEntity.isBoots(inventory, newItem) && !InventoryEntity.isBoots(inventory, oldItem);
        }
        return InventoryEntity.canReplaceCurrentItemBase(newItem, oldItem);
    }

    public static boolean canReplaceCurrentItem(ItemStack newItem, ItemStack oldItem, boolean canUseMelee, boolean canUseBow, boolean canUseCrossbow, boolean canUseMagicItem, boolean canUseThrow, boolean canUseShield, boolean canUseHelmet, boolean canUseChestplate, boolean canUseLeggings, boolean canUseBoots) {
        if (InventoryEntity.isMeleeWeapon(newItem) || InventoryEntity.isMeleeWeapon(oldItem)) {
            if (!canUseMelee) {
                return false;
            }
            if (InventoryEntity.isMeleeWeapon(newItem) && InventoryEntity.isMeleeWeapon(oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isMeleeWeapon(newItem) || InventoryEntity.isMeleeWeapon(oldItem) && canUseMelee || InventoryEntity.isCrossbow(oldItem) && canUseCrossbow && (!InventoryEntity.isMagicItem(oldItem) || !canUseMagicItem) || InventoryEntity.isThrow(oldItem) && canUseThrow || InventoryEntity.isBow(oldItem) && canUseThrow || InventoryEntity.isOtherRange(oldItem));
        }
        if (InventoryEntity.isBow(newItem) || InventoryEntity.isBow(oldItem)) {
            if (!canUseBow) {
                return false;
            }
            if (InventoryEntity.isBow(newItem) && InventoryEntity.isBow(oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isBow(newItem) || InventoryEntity.isMeleeWeapon(oldItem) && canUseMelee || InventoryEntity.isCrossbow(oldItem) && canUseCrossbow || InventoryEntity.isMagicItem(oldItem) && canUseMagicItem || InventoryEntity.isThrow(oldItem) && canUseThrow || InventoryEntity.isBow(oldItem) && canUseBow || InventoryEntity.isOtherRange(oldItem));
        }
        if (InventoryEntity.isOtherRange(newItem) || InventoryEntity.isOtherRange(oldItem)) {
            if (!canUseBow) {
                return false;
            }
            if (InventoryEntity.isOtherRange(newItem) && InventoryEntity.isOtherRange(oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isOtherRange(newItem) || InventoryEntity.isMeleeWeapon(oldItem) && canUseMelee || InventoryEntity.isCrossbow(oldItem) && canUseCrossbow || InventoryEntity.isMagicItem(oldItem) && canUseMagicItem || InventoryEntity.isThrow(oldItem) && canUseThrow || InventoryEntity.isBow(oldItem) && canUseBow || InventoryEntity.isOtherRange(oldItem));
        }
        if (InventoryEntity.isCrossbow(newItem) || InventoryEntity.isCrossbow(oldItem)) {
            if (!canUseCrossbow) {
                return false;
            }
            if (InventoryEntity.isCrossbow(newItem) && InventoryEntity.isCrossbow(oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isCrossbow(newItem) || InventoryEntity.isMeleeWeapon(oldItem) && canUseMelee || InventoryEntity.isCrossbow(oldItem) && canUseCrossbow || InventoryEntity.isMagicItem(oldItem) && canUseMagicItem || InventoryEntity.isThrow(oldItem) && canUseThrow || InventoryEntity.isBow(oldItem) && canUseBow || InventoryEntity.isOtherRange(oldItem));
        }
        if (InventoryEntity.isMagicItem(newItem) || InventoryEntity.isMagicItem(oldItem)) {
            if (!canUseMagicItem) {
                return false;
            }
            if (InventoryEntity.isMagicItem(newItem) && InventoryEntity.isMagicItem(oldItem)) {
                Item item = newItem.m_41720_();
                if (item instanceof MagicItem) {
                    MagicItem magicItemNew = (MagicItem)item;
                    item = oldItem.m_41720_();
                    if (item instanceof MagicItem) {
                        MagicItem magicItemOld = (MagicItem)item;
                        if (magicItemNew.getSpellLevel(newItem) > magicItemOld.getSpellLevel(oldItem)) {
                            return true;
                        }
                    }
                }
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isMagicItem(newItem) || InventoryEntity.isMeleeWeapon(oldItem) && canUseMelee || InventoryEntity.isCrossbow(oldItem) && canUseCrossbow || InventoryEntity.isMagicItem(oldItem) && canUseMagicItem || InventoryEntity.isThrow(oldItem) && canUseThrow || InventoryEntity.isBow(oldItem) && canUseBow || InventoryEntity.isOtherRange(oldItem));
        }
        if (InventoryEntity.isThrow(newItem) || InventoryEntity.isThrow(oldItem)) {
            if (!canUseThrow) {
                return false;
            }
            if (InventoryEntity.isThrow(newItem) && InventoryEntity.isThrow(oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return !(!InventoryEntity.isThrow(newItem) || InventoryEntity.isMeleeWeapon(oldItem) && canUseMelee || InventoryEntity.isCrossbow(oldItem) && canUseCrossbow || InventoryEntity.isMagicItem(oldItem) && canUseMagicItem || InventoryEntity.isThrow(oldItem) && canUseThrow || InventoryEntity.isBow(oldItem) && canUseBow || InventoryEntity.isOtherRange(oldItem));
        }
        if (InventoryEntity.isShield(newItem) || InventoryEntity.isShield(oldItem)) {
            if (oldItem.m_41720_() instanceof ItemTwoHanded && newItem.m_41720_() instanceof ShieldItem) {
                return false;
            }
            if (!canUseShield && newItem.m_41720_() instanceof ShieldItem) {
                return false;
            }
            if (InventoryEntity.isShield(newItem) && InventoryEntity.isShield(oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return InventoryEntity.isShield(newItem) && (!InventoryEntity.isShield(oldItem) || !canUseShield && newItem.m_41720_() instanceof ShieldItem);
        }
        if (InventoryEntity.isHelmet(newItem) || InventoryEntity.isHelmet(oldItem)) {
            if (!canUseHelmet) {
                return false;
            }
            if (InventoryEntity.isHelmet(newItem) && InventoryEntity.isHelmet(oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return InventoryEntity.isHelmet(newItem) && !InventoryEntity.isHelmet(oldItem);
        }
        if (InventoryEntity.isChestplate(newItem) || InventoryEntity.isChestplate(oldItem)) {
            if (!canUseChestplate) {
                return false;
            }
            if (InventoryEntity.isChestplate(newItem) && InventoryEntity.isChestplate(oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return InventoryEntity.isChestplate(newItem) && !InventoryEntity.isChestplate(oldItem);
        }
        if (InventoryEntity.isLeggings(newItem) || InventoryEntity.isLeggings(oldItem)) {
            if (!canUseLeggings) {
                return false;
            }
            if (InventoryEntity.isLeggings(newItem) && InventoryEntity.isLeggings(oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return InventoryEntity.isLeggings(newItem) && !InventoryEntity.isLeggings(oldItem);
        }
        if (InventoryEntity.isBoots(newItem) || InventoryEntity.isBoots(oldItem)) {
            if (!canUseBoots) {
                return false;
            }
            if (InventoryEntity.isBoots(newItem) && InventoryEntity.isBoots(oldItem)) {
                if (newItem.m_41776_() > oldItem.m_41776_()) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && EntityAndItemFind.isEnchantLevelBetter(newItem, oldItem)) {
                    return true;
                }
                if (newItem.m_41776_() == oldItem.m_41776_() && newItem.m_41773_() < oldItem.m_41773_()) {
                    return true;
                }
            }
            return InventoryEntity.isBoots(newItem) && !InventoryEntity.isBoots(oldItem);
        }
        return InventoryEntity.canReplaceCurrentItemBase(newItem, oldItem);
    }

    public static boolean canReplaceCurrentItemBase(ItemStack p_21428_, ItemStack p_21429_) {
        if (p_21429_.m_41619_()) {
            return true;
        }
        if (p_21428_.m_41720_() instanceof SwordItem) {
            if (!(p_21429_.m_41720_() instanceof SwordItem)) {
                return true;
            }
            SwordItem sworditem = (SwordItem)p_21428_.m_41720_();
            SwordItem sworditem1 = (SwordItem)p_21429_.m_41720_();
            if (sworditem.m_43299_() != sworditem1.m_43299_()) {
                return sworditem.m_43299_() > sworditem1.m_43299_();
            }
            return InventoryEntity.canReplaceEqualItem(p_21428_, p_21429_);
        }
        if (p_21428_.m_41720_() instanceof BowItem && p_21429_.m_41720_() instanceof BowItem) {
            return InventoryEntity.canReplaceEqualItem(p_21428_, p_21429_);
        }
        if (p_21428_.m_41720_() instanceof CrossbowItem && p_21429_.m_41720_() instanceof CrossbowItem) {
            return InventoryEntity.canReplaceEqualItem(p_21428_, p_21429_);
        }
        Item $$6 = p_21428_.m_41720_();
        if ($$6 instanceof ArmorItem) {
            ArmorItem armoritem = (ArmorItem)$$6;
            if (EnchantmentHelper.m_44920_((ItemStack)p_21429_)) {
                return false;
            }
            if (!(p_21429_.m_41720_() instanceof ArmorItem)) {
                return true;
            }
            ArmorItem armoritem1 = (ArmorItem)p_21429_.m_41720_();
            if (armoritem.m_40404_() != armoritem1.m_40404_()) {
                return armoritem.m_40404_() > armoritem1.m_40404_();
            }
            if (armoritem.m_40405_() != armoritem1.m_40405_()) {
                return armoritem.m_40405_() > armoritem1.m_40405_();
            }
            return InventoryEntity.canReplaceEqualItem(p_21428_, p_21429_);
        }
        if (p_21428_.m_41720_() instanceof DiggerItem) {
            if (p_21429_.m_41720_() instanceof BlockItem) {
                return true;
            }
            Item $$7 = p_21429_.m_41720_();
            if ($$7 instanceof DiggerItem) {
                DiggerItem diggeritem = (DiggerItem)$$7;
                DiggerItem diggeritem1 = (DiggerItem)p_21428_.m_41720_();
                if (diggeritem1.m_41008_() != diggeritem.m_41008_()) {
                    return diggeritem1.m_41008_() > diggeritem.m_41008_();
                }
                return InventoryEntity.canReplaceEqualItem(p_21428_, p_21429_);
            }
        }
        return false;
    }

    public static boolean canReplaceEqualItem(ItemStack p_21478_, ItemStack p_21479_) {
        if (p_21478_.m_41773_() < p_21479_.m_41773_() || p_21478_.m_41782_() && !p_21479_.m_41782_()) {
            return true;
        }
        if (p_21478_.m_41782_() && p_21479_.m_41782_()) {
            return p_21478_.m_41783_().m_128431_().stream().anyMatch(p_21513_ -> !p_21513_.equals("Damage")) && !p_21479_.m_41783_().m_128431_().stream().anyMatch(p_21503_ -> !p_21503_.equals("Damage"));
        }
        return false;
    }

    public static boolean isFoodOrPotion(InventoryEntity inventory, ItemStack itemStack) {
        return itemStack.m_41720_().m_41472_() || itemStack.m_41720_() instanceof PotionItem && !(itemStack.m_41720_() instanceof ThrowablePotionItem);
    }

    public static boolean isMeleeWeapon(InventoryEntity inventory, ItemStack itemStack) {
        if (inventory.canUseMeleeWeapon()) {
            return InventoryEntity.isMeleeWeapon(itemStack) || InventoryEntity.isSpear(inventory, itemStack);
        }
        return false;
    }

    public static boolean isMeleeWeapon(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof MeleeItem) {
            MeleeItem meleeItem = (MeleeItem)item;
            return meleeItem.isMeleeWeapon();
        }
        return itemStack.m_41720_() instanceof AxeItem || itemStack.m_41720_() instanceof SwordItem || itemStack.m_41720_() instanceof TridentItem || itemStack.m_41720_() instanceof ItemToolBaseSpearBase;
    }

    public static boolean isSpear(InventoryEntity inventory, ItemStack itemStack) {
        if (inventory.canUseMeleeWeapon()) {
            return InventoryEntity.isSpear(itemStack);
        }
        return false;
    }

    public static boolean isSpear(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof ItemToolBaseSpearBase;
    }

    public static boolean isCrossbow(InventoryEntity inventory, ItemStack itemStack) {
        if (inventory.canUseCrossbow()) {
            return InventoryEntity.isCrossbow(itemStack);
        }
        return false;
    }

    public static boolean isCrossbow(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof CrossbowItem;
    }

    public static boolean isMagicItem(InventoryEntity inventory, ItemStack itemStack) {
        if (inventory.canUseMagicItem()) {
            return InventoryEntity.isMagicItem(itemStack);
        }
        return false;
    }

    public static boolean isMagicItem(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof MagicItem;
    }

    public static boolean isThrow(InventoryEntity inventory, ItemStack itemStack) {
        if (inventory instanceof LivingEntity) {
            JerotesItemThrowUse jerotesItemThrowUse;
            LivingEntity livingEntity = (LivingEntity)inventory;
            Item item = itemStack.m_41720_();
            if (item instanceof JerotesItemThrowUse && !(jerotesItemThrowUse = (JerotesItemThrowUse)item).isJerotesThrow(livingEntity)) {
                return false;
            }
        }
        if (inventory.canUseThrow()) {
            return InventoryEntity.isThrow(itemStack);
        }
        return false;
    }

    public static boolean isThrow(ItemStack itemStack) {
        JerotesItemThrowUse jerotesItemThrowUse;
        Item item = itemStack.m_41720_();
        return item instanceof JerotesItemThrowUse && (jerotesItemThrowUse = (JerotesItemThrowUse)item).isJerotesThrow() || itemStack.m_41720_() instanceof EggItem || itemStack.m_41720_() instanceof SnowballItem || itemStack.m_41720_() instanceof ThrowablePotionItem || itemStack.m_41720_() instanceof EnderpearlItem;
    }

    public static boolean isBow(InventoryEntity inventory, ItemStack itemStack) {
        if (inventory.canUseBow()) {
            return InventoryEntity.isBow(itemStack);
        }
        return false;
    }

    public static boolean isBow(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof BowItem;
    }

    public static boolean isRangeJavelin(InventoryEntity inventory, ItemStack itemStack) {
        Mob mob;
        if (!(itemStack.m_41773_() >= itemStack.m_41776_() - 1 && inventory instanceof Mob && (mob = (Mob)inventory).m_9236_().m_6106_().m_5470_().m_46207_(JerotesGameRules.JEROTES_RANGE_CAN_BREAK) || !inventory.canUseRangeJavelin())) {
            return InventoryEntity.isRangeJavelin(itemStack);
        }
        return false;
    }

    public static boolean isRangeJavelin(ItemStack itemStack) {
        JerotesItemThrownJavelinUse jerotesItemThrownJavelinUse;
        Item item = itemStack.m_41720_();
        return item instanceof JerotesItemThrownJavelinUse && (jerotesItemThrownJavelinUse = (JerotesItemThrownJavelinUse)item).isJerotesThrownJavelin() && jerotesItemThrownJavelinUse.JerotesThrownJavelinCanRange() || itemStack.m_41720_() == Items.f_42713_;
    }

    public static boolean isOtherRange(InventoryEntity inventory, ItemStack itemStack) {
        ItemOtherRange itemOtherRange;
        if (!(inventory instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)inventory;
        Item item = itemStack.m_41720_();
        return item instanceof ItemOtherRange && (itemOtherRange = (ItemOtherRange)item).isRange(livingEntity, itemStack) && inventory.isSelfOtherRange(itemStack);
    }

    public static boolean isOtherRange(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof ItemOtherRange;
    }

    default public boolean isSelfOtherRange(ItemStack itemStack) {
        return true;
    }

    public static boolean isShield(InventoryEntity inventory, ItemStack itemStack) {
        CanGetOffHand canGetOffHand;
        Item item;
        LivingEntity livingEntity;
        JerotesEntity jerotes;
        if (inventory instanceof JerotesEntity && (jerotes = (JerotesEntity)((Object)inventory)).isOffHandItem(itemStack)) {
            return true;
        }
        if (inventory instanceof LivingEntity) {
            CanBeOffHand canBeOffHand;
            livingEntity = (LivingEntity)inventory;
            item = itemStack.m_41720_();
            if (item instanceof CanBeOffHand && (canBeOffHand = (CanBeOffHand)item).isOffHandItem(livingEntity)) {
                return true;
            }
        }
        if (inventory instanceof LivingEntity && (item = (livingEntity = (LivingEntity)inventory).m_21205_().m_41720_()) instanceof CanGetOffHand && (canGetOffHand = (CanGetOffHand)item).getOffHandItem(livingEntity)) {
            return true;
        }
        if (inventory.canUseCrossbow() && inventory instanceof LivingEntity && InventoryEntity.isCrossbow(inventory, (livingEntity = (LivingEntity)inventory).m_21205_()) && livingEntity.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof FireworkRocketItem) {
            return true;
        }
        if (inventory.canUseShield()) {
            return InventoryEntity.isShield(itemStack);
        }
        return false;
    }

    public static boolean isShield(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof ShieldItem || itemStack.m_41720_() == Items.f_42747_;
    }

    public static boolean isHelmet(InventoryEntity inventory, ItemStack itemStack) {
        if (inventory.canUseHelmet()) {
            return InventoryEntity.isHelmet(itemStack);
        }
        return false;
    }

    public static boolean isHelmet(ItemStack itemStack) {
        ArmorItem armorItem;
        Item item = itemStack.m_41720_();
        return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == EquipmentSlot.HEAD;
    }

    public static boolean isChestplate(InventoryEntity inventory, ItemStack itemStack) {
        if (inventory.canUseChestplate()) {
            return InventoryEntity.isChestplate(itemStack);
        }
        return false;
    }

    public static boolean isChestplate(ItemStack itemStack) {
        ArmorItem armorItem;
        Item item = itemStack.m_41720_();
        return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == EquipmentSlot.CHEST;
    }

    public static boolean isLeggings(InventoryEntity inventory, ItemStack itemStack) {
        if (inventory.canUseLeggings()) {
            return InventoryEntity.isLeggings(itemStack);
        }
        return false;
    }

    public static boolean isLeggings(ItemStack itemStack) {
        ArmorItem armorItem;
        Item item = itemStack.m_41720_();
        return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == EquipmentSlot.LEGS;
    }

    public static boolean isBoots(InventoryEntity inventory, ItemStack itemStack) {
        if (inventory.canUseBoots()) {
            return InventoryEntity.isBoots(itemStack);
        }
        return false;
    }

    public static boolean isBoots(ItemStack itemStack) {
        ArmorItem armorItem;
        Item item = itemStack.m_41720_();
        return item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == EquipmentSlot.FEET;
    }

    default public void changeInventory(Mob mob) {
        InventoryEntity inventory;
        if (mob instanceof InventoryEntity && (inventory = (InventoryEntity)mob).isCanChangeInventory() && !mob.m_21525_()) {
            ItemStack offHandItem;
            ItemStack mainHandItem;
            int tick;
            if (inventory.canEatOrDrinkHand() && mob.f_19797_ % (tick = inventory.changeInventoryCooldownTick()) == 0) {
                mainHandItem = mob.m_21205_();
                offHandItem = mob.m_21206_();
                if (InventoryEntity.isFoodOrPotion(inventory, offHandItem) && !mob.m_6117_() && inventory.howToEatOrDrinkHand(mob, offHandItem)) {
                    mob.m_6672_(InteractionHand.OFF_HAND);
                }
                if (InventoryEntity.isFoodOrPotion(inventory, mainHandItem) && !mob.m_6117_() && inventory.howToEatOrDrinkHand(mob, mainHandItem)) {
                    mob.m_6672_(InteractionHand.MAIN_HAND);
                }
            }
            if (MainConfig.InventoryMobAboutItemstackInventoryTick) {
                for (int n = 0; n < this.inventoryCount(); ++n) {
                    ItemStack itemStack = inventory.mobInventory().m_8020_(n);
                    int slot = n + 1;
                    if (slot >= 100) {
                        slot += 4;
                    }
                    if (slot >= 150) {
                        ++slot;
                    }
                    itemStack.m_41666_(mob.m_9236_(), (Entity)mob, slot, false);
                }
                mob.m_6844_(EquipmentSlot.MAINHAND).m_41666_(mob.m_9236_(), (Entity)mob, 0, true);
                mob.m_6844_(EquipmentSlot.OFFHAND).m_41666_(mob.m_9236_(), (Entity)mob, 150, false);
                mob.m_6844_(EquipmentSlot.HEAD).m_41666_(mob.m_9236_(), (Entity)mob, 100, false);
                mob.m_6844_(EquipmentSlot.CHEST).m_41666_(mob.m_9236_(), (Entity)mob, 101, false);
                mob.m_6844_(EquipmentSlot.LEGS).m_41666_(mob.m_9236_(), (Entity)mob, 102, false);
                mob.m_6844_(EquipmentSlot.FEET).m_41666_(mob.m_9236_(), (Entity)mob, 103, false);
            }
            if (mob.f_19797_ % (tick = inventory.changeInventoryCooldownTick()) == 0 && !mob.m_9236_().m_5776_()) {
                mainHandItem = mob.m_21205_();
                offHandItem = mob.m_21206_();
                ItemStack headItem = mob.m_6844_(EquipmentSlot.HEAD);
                ItemStack chestItem = mob.m_6844_(EquipmentSlot.CHEST);
                ItemStack legsItem = mob.m_6844_(EquipmentSlot.LEGS);
                ItemStack feetItem = mob.m_6844_(EquipmentSlot.FEET);
                ItemStack findNestMainHandItem = mainHandItem;
                ItemStack findNestOffHandItem = offHandItem;
                ItemStack findNestHeadItem = headItem;
                ItemStack findNestChestItem = chestItem;
                ItemStack findNestLegsItem = legsItem;
                ItemStack findNestFeetItem = feetItem;
                int findNumMainHandItem = -1;
                int findNumOffHandItem = -1;
                int findNumHeadItem = -1;
                int findNumChestItem = -1;
                int findNumLegsItem = -1;
                int findNumFeetItem = -1;
                for (int n = 0; n < this.inventoryCount(); ++n) {
                    ItemStack itemStack = inventory.mobInventory().m_8020_(n);
                    if (!(inventory.canEatOrDrinkHand() && InventoryEntity.isFoodOrPotion(inventory, findNestOffHandItem) || itemStack.m_41619_() || !InventoryEntity.canReplaceShield(inventory, itemStack, findNestOffHandItem) && !findNestOffHandItem.m_41619_() || !InventoryEntity.isShield(inventory, itemStack) || inventory.NonCombatEmptyShield() && !mob.m_5912_())) {
                        findNestOffHandItem = itemStack;
                        findNumOffHandItem = n;
                        continue;
                    }
                    if (!(inventory.canEatOrDrinkHand() && InventoryEntity.isFoodOrPotion(inventory, findNestOffHandItem) || findNestOffHandItem.m_41619_() || !itemStack.m_41619_() || !inventory.NonCombatEmptyShield() || mob.m_5912_())) {
                        findNestOffHandItem = itemStack;
                        findNumOffHandItem = n;
                        continue;
                    }
                    if (!itemStack.m_41619_() && (InventoryEntity.canReplaceHelmet(inventory, itemStack, findNestHeadItem) || findNestHeadItem.m_41619_()) && InventoryEntity.isHelmet(inventory, itemStack)) {
                        findNestHeadItem = itemStack;
                        findNumHeadItem = n;
                        continue;
                    }
                    if (!itemStack.m_41619_() && (InventoryEntity.canReplaceChestplate(inventory, itemStack, findNestChestItem) || findNestChestItem.m_41619_() && InventoryEntity.isHelmet(inventory, itemStack))) {
                        findNestChestItem = itemStack;
                        findNumChestItem = n;
                        continue;
                    }
                    if (!itemStack.m_41619_() && (InventoryEntity.canReplaceLeggings(inventory, itemStack, findNestLegsItem) || findNestLegsItem.m_41619_() && InventoryEntity.isLeggings(inventory, itemStack))) {
                        findNestLegsItem = itemStack;
                        findNumLegsItem = n;
                        continue;
                    }
                    if (!itemStack.m_41619_() && (InventoryEntity.canReplaceBoots(inventory, itemStack, findNestFeetItem) || findNestFeetItem.m_41619_() && InventoryEntity.isBoots(inventory, itemStack))) {
                        findNestFeetItem = itemStack;
                        findNumFeetItem = n;
                        continue;
                    }
                    if (!(mob.m_5448_() == null || !inventory.isCanChangeMeleeOrRange() || itemStack.m_41619_() || inventory.canEatOrDrinkHand() && InventoryEntity.isFoodOrPotion(inventory, findNestMainHandItem))) {
                        MagicItem magicItem;
                        MagicItem magicItems;
                        Object magicItem2;
                        Item item;
                        MagicItem magicItem3;
                        if (mob.m_20270_((Entity)mob.m_5448_()) <= this.meleeOrRangeDistance() && (!(mob.m_20270_((Entity)mob.m_5448_()) > this.meleeOrRangeDistance() / 2.0f) || mob.m_5448_().m_20096_())) {
                            MagicItem magicItems2;
                            Item item2;
                            if (!InventoryEntity.isMeleeWeapon(inventory, itemStack) && !InventoryEntity.isBow(inventory, itemStack) && !InventoryEntity.isOtherRange(inventory, itemStack) && !InventoryEntity.isCrossbow(inventory, itemStack) && !InventoryEntity.isMagicItem(inventory, itemStack) && !InventoryEntity.isThrow(inventory, itemStack)) continue;
                            if (InventoryEntity.isMeleeWeapon(inventory, mob.m_21205_()) || InventoryEntity.isMagicItem(inventory, mob.m_21205_()) && (item2 = mob.m_21205_().m_41720_()) instanceof MagicItem && (magicItem3 = (MagicItem)item2).isMelee(mob.m_21205_()) && !magicItem3.isHelp(mob.m_21205_())) {
                                if (!InventoryEntity.canReplaceMeleeWeapon(inventory, itemStack, findNestMainHandItem) && !InventoryEntity.canReplaceBow(inventory, itemStack, findNestMainHandItem) && !InventoryEntity.canReplaceOtherRange(inventory, itemStack, findNestMainHandItem) && !InventoryEntity.canReplaceCrossbow(inventory, itemStack, findNestMainHandItem) && !InventoryEntity.canReplaceMagicItem(inventory, itemStack, findNestMainHandItem) && !InventoryEntity.canReplaceThrow(inventory, itemStack, findNestMainHandItem) && !findNestMainHandItem.m_41619_()) continue;
                                findNestMainHandItem = itemStack;
                                findNumMainHandItem = n;
                                continue;
                            }
                            if (!InventoryEntity.isMeleeWeapon(inventory, itemStack) && (!InventoryEntity.isMagicItem(inventory, itemStack) || !((item = itemStack.m_41720_()) instanceof MagicItem) || !(magicItem2 = (MagicItem)item).isMelee(itemStack) || magicItem2.isHelp(itemStack)) && !InventoryEntity.canReplaceBow(inventory, itemStack, findNestMainHandItem) && !InventoryEntity.canReplaceOtherRange(inventory, itemStack, findNestMainHandItem) && !InventoryEntity.canReplaceCrossbow(inventory, itemStack, findNestMainHandItem) && (!InventoryEntity.canReplaceMagicItem(inventory, itemStack, findNestMainHandItem) || !InventoryEntity.isMagicItem(inventory, itemStack) || !((item = itemStack.m_41720_()) instanceof MagicItem) || (magicItems2 = (MagicItem)item).isMelee(itemStack) && magicItems2.isHelp(itemStack)) && !InventoryEntity.canReplaceThrow(inventory, itemStack, findNestMainHandItem) && !findNestMainHandItem.m_41619_()) continue;
                            findNestMainHandItem = itemStack;
                            findNumMainHandItem = n;
                            continue;
                        }
                        if (!InventoryEntity.isMeleeWeapon(inventory, itemStack) && !InventoryEntity.isBow(inventory, itemStack) && !InventoryEntity.isOtherRange(inventory, itemStack) && !InventoryEntity.isCrossbow(inventory, itemStack) && !InventoryEntity.isMagicItem(inventory, itemStack) && !InventoryEntity.isThrow(inventory, itemStack)) continue;
                        if (InventoryEntity.isBow(inventory, mob.m_21205_()) || InventoryEntity.isOtherRange(inventory, mob.m_21205_()) || InventoryEntity.isCrossbow(inventory, mob.m_21205_()) || InventoryEntity.isThrow(inventory, mob.m_21205_()) || InventoryEntity.isRangeJavelin(inventory, mob.m_21205_()) && inventory.canUseRangeJavelin() || InventoryEntity.isMagicItem(inventory, mob.m_21205_()) && (magicItem2 = mob.m_21205_().m_41720_()) instanceof MagicItem && !(magicItem3 = (MagicItem)magicItem2).isMelee(mob.m_21205_()) && !magicItem3.isHelp(mob.m_21205_())) {
                            if ((!InventoryEntity.canReplaceMeleeWeapon(inventory, itemStack, findNestMainHandItem) || !InventoryEntity.isRangeJavelin(inventory, itemStack) || !InventoryEntity.isRangeJavelin(inventory, findNestMainHandItem)) && !InventoryEntity.canReplaceBow(inventory, itemStack, findNestMainHandItem) && !InventoryEntity.canReplaceOtherRange(inventory, itemStack, findNestMainHandItem) && !InventoryEntity.canReplaceCrossbow(inventory, itemStack, findNestMainHandItem) && !InventoryEntity.canReplaceMagicItem(inventory, itemStack, findNestMainHandItem) && !InventoryEntity.canReplaceThrow(inventory, itemStack, findNestMainHandItem) && !findNestMainHandItem.m_41619_()) continue;
                            findNestMainHandItem = itemStack;
                            findNumMainHandItem = n;
                            continue;
                        }
                        if (!(InventoryEntity.canReplaceMeleeWeapon(inventory, itemStack, findNestMainHandItem) && InventoryEntity.isRangeJavelin(inventory, findNestMainHandItem) && inventory.canUseRangeJavelin() || InventoryEntity.canReplaceMagicItem(inventory, itemStack, findNestMainHandItem) && InventoryEntity.isMagicItem(inventory, itemStack) && (item = itemStack.m_41720_()) instanceof MagicItem && ((magicItems = (MagicItem)item).isMelee(itemStack) || magicItems.isHelp(itemStack)) || InventoryEntity.isMagicItem(inventory, itemStack) && (item = itemStack.m_41720_()) instanceof MagicItem && !(magicItem = (MagicItem)item).isMelee(itemStack) && !magicItem.isHelp(itemStack) || InventoryEntity.isBow(inventory, itemStack) || InventoryEntity.isOtherRange(inventory, itemStack) || InventoryEntity.isCrossbow(inventory, itemStack) || InventoryEntity.isRangeJavelin(inventory, itemStack) && inventory.canUseRangeJavelin() || InventoryEntity.isThrow(inventory, itemStack)) && !findNestMainHandItem.m_41619_()) continue;
                        findNestMainHandItem = itemStack;
                        findNumMainHandItem = n;
                        continue;
                    }
                    if (!(!inventory.NonCombatEmptyWeapon() || mob.m_5912_() || mob.m_5448_() != null || inventory.canEatOrDrinkHand() && InventoryEntity.isFoodOrPotion(inventory, findNestMainHandItem))) {
                        if (findNestMainHandItem.m_41619_() || !itemStack.m_41619_()) continue;
                        findNestMainHandItem = itemStack;
                        findNumMainHandItem = n;
                        continue;
                    }
                    if (itemStack.m_41619_() || inventory.canEatOrDrinkHand() && InventoryEntity.isFoodOrPotion(inventory, findNestMainHandItem) || !InventoryEntity.isMeleeWeapon(inventory, itemStack) && !InventoryEntity.isBow(inventory, itemStack) && !InventoryEntity.isOtherRange(inventory, itemStack) && !InventoryEntity.isCrossbow(inventory, itemStack) && !InventoryEntity.isMagicItem(inventory, itemStack) && !InventoryEntity.isThrow(inventory, itemStack) || !InventoryEntity.canReplaceMeleeWeapon(inventory, itemStack, findNestMainHandItem) && !InventoryEntity.canReplaceBow(inventory, itemStack, findNestMainHandItem) && !InventoryEntity.canReplaceCrossbow(inventory, itemStack, findNestMainHandItem) && !InventoryEntity.canReplaceThrow(inventory, itemStack, findNestMainHandItem) && !InventoryEntity.canReplaceMagicItem(inventory, itemStack, findNestMainHandItem) && !findNestMainHandItem.m_41619_()) continue;
                    findNestMainHandItem = itemStack;
                    findNumMainHandItem = n;
                }
                if (findNumOffHandItem != -1 && offHandItem.getEnchantmentLevel(Enchantments.f_44975_) <= 0) {
                    mob.m_8061_(EquipmentSlot.OFFHAND, inventory.mobInventory().m_8020_(findNumOffHandItem));
                    inventory.mobInventory().m_6836_(findNumOffHandItem, offHandItem);
                } else if (findNumHeadItem != -1 && headItem.getEnchantmentLevel(Enchantments.f_44975_) <= 0) {
                    mob.m_8061_(EquipmentSlot.HEAD, inventory.mobInventory().m_8020_(findNumHeadItem));
                    inventory.mobInventory().m_6836_(findNumHeadItem, headItem);
                } else if (findNumChestItem != -1 && chestItem.getEnchantmentLevel(Enchantments.f_44975_) <= 0) {
                    mob.m_8061_(EquipmentSlot.CHEST, inventory.mobInventory().m_8020_(findNumChestItem));
                    inventory.mobInventory().m_6836_(findNumChestItem, chestItem);
                } else if (findNumLegsItem != -1 && legsItem.getEnchantmentLevel(Enchantments.f_44975_) <= 0) {
                    mob.m_8061_(EquipmentSlot.LEGS, inventory.mobInventory().m_8020_(findNumLegsItem));
                    inventory.mobInventory().m_6836_(findNumLegsItem, legsItem);
                } else if (findNumFeetItem != -1 && feetItem.getEnchantmentLevel(Enchantments.f_44975_) <= 0) {
                    mob.m_8061_(EquipmentSlot.FEET, inventory.mobInventory().m_8020_(findNumFeetItem));
                    inventory.mobInventory().m_6836_(findNumFeetItem, feetItem);
                } else if (findNumMainHandItem != -1 && mainHandItem.getEnchantmentLevel(Enchantments.f_44975_) <= 0) {
                    mob.m_8061_(EquipmentSlot.MAINHAND, inventory.mobInventory().m_8020_(findNumMainHandItem));
                    inventory.mobInventory().m_6836_(findNumMainHandItem, mainHandItem);
                }
            }
        }
    }
}

