/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.entity;

import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.util.EntityAndItemFind;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public interface JerotesEntity {
    default public boolean helpAllSameFaction() {
        return true;
    }

    default public boolean helpByAllSameFaction() {
        return true;
    }

    default public boolean helpSameType() {
        return true;
    }

    default public boolean canBeHelp(Entity entity) {
        return true;
    }

    default public boolean isJerotesFlyingMob() {
        return false;
    }

    default public boolean OwnerCanOrderAttack() {
        return true;
    }

    default public boolean isFactionWith(Entity entity) {
        return false;
    }

    default public String getFactionTypeName() {
        return "";
    }

    default public String getMobTypeNameModId() {
        return "";
    }

    default public boolean isOffHandItem(ItemStack itemStack) {
        return false;
    }

    default public void MobInventoryAddTooltip(List<Component> tooltip, LivingEntity livingEntity) {
    }

    default public boolean hasPercentageDamage() {
        JerotesEntity jerotesEntity = this;
        if (!(jerotesEntity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)jerotesEntity;
        return MainConfig.HasPercentageDamage.contains(livingEntity.m_20078_());
    }

    default public float PercentageDamage(DamageSource damageSource) {
        if (EntityAndItemFind.MagicResistance(damageSource)) {
            return (float)MainConfig.BaseMagicAttackPercentage;
        }
        return (float)MainConfig.BaseAttackPercentage;
    }

    default public boolean hasDamageCap() {
        JerotesEntity jerotesEntity = this;
        if (!(jerotesEntity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)jerotesEntity;
        return MainConfig.HasDamageCap.contains(livingEntity.m_20078_());
    }

    default public float DamageCap(DamageSource damageSource, Entity entity) {
        JerotesEntity jerotesEntity = this;
        if (!(jerotesEntity instanceof LivingEntity)) {
            return Float.MAX_VALUE;
        }
        LivingEntity self = (LivingEntity)jerotesEntity;
        return (float)MainConfig.BaseDamageCap / 100.0f * self.m_21233_();
    }

    default public boolean hasDamageCooldownTick() {
        JerotesEntity jerotesEntity = this;
        if (!(jerotesEntity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)jerotesEntity;
        return MainConfig.HasDamageCooldownTick.contains(livingEntity.m_20078_());
    }

    default public float DamageCooldownTick(DamageSource damageSource, Entity entity) {
        float base = 1.0f;
        if (damageSource.m_269533_(DamageTypeTags.f_273918_)) {
            base *= 0.5f;
        }
        return (float)MainConfig.BaseDamageCooldownTick * base;
    }

    default public float BreakHurtCooldownMultiple(DamageSource damageSource, Entity entity) {
        return (float)MainConfig.BaseBreakHurtCooldownMultiple;
    }

    default public boolean isLegendary() {
        return this.hasDamageCap() && this.hasDamageCooldownTick() && this.hasPercentageDamage();
    }
}

