/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.entity.arrow;

import com.google.common.collect.Lists;
import com.jerotes.jerotes.entity.arrow.BaseAbstractArrowEntity;
import com.jerotes.jerotes.util.EntityFactionFind;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class BaseArrowEntity
extends BaseAbstractArrowEntity {
    private double baseDamage = 2.0;
    private int knockback;
    public SoundEvent soundEvent = this.m_7239_();
    public float soundLevel = 1.0f;
    @Nullable
    private IntOpenHashSet piercingIgnoreEntityIds;
    @Nullable
    private List<Entity> piercedAndKilledEntities;
    private ItemStack arrowItem = new ItemStack((ItemLike)Items.f_42412_);

    public BaseArrowEntity(EntityType<? extends AbstractArrow> entityType, Level level, ItemStack itemStack, double damages) {
        super(entityType, level, itemStack);
        this.arrowItem = itemStack.m_41777_();
        this.baseDamage = damages;
    }

    public BaseArrowEntity(Level level, LivingEntity livingEntity, ItemStack itemStack, EntityType<? extends AbstractArrow> entityType, double damages) {
        super(entityType, livingEntity, level, itemStack);
        this.arrowItem = itemStack.m_41777_();
        this.baseDamage = damages;
    }

    public BaseArrowEntity(Level level, double d, double d2, double d3, ItemStack itemStack, EntityType<? extends AbstractArrow> entityType, double damages) {
        super(entityType, d, d2, d3, level, itemStack);
        this.arrowItem = itemStack.m_41777_();
        this.baseDamage = damages;
    }

    public byte getPierceLevelBase() {
        return super.m_36796_();
    }

    public byte m_36796_() {
        return (byte)(this.getPierceLevelBase() + this.basePierce());
    }

    protected ItemStack m_7941_() {
        return this.arrowItem.m_41777_();
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        LivingEntity livingEntity;
        if (this.piercingIgnoreEntityIds.size() >= this.m_36796_() + 1) {
            return;
        }
        Entity entity2 = entityHitResult.m_82443_();
        float special = this.specialDamage(entity2);
        float f = (float)this.m_20184_().m_82553_();
        int n = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * this.baseDamage), (double)0.0, (double)2.147483647E9));
        if (this.m_36796_() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.m_36796_() + 1) {
                if (!this.canNotBreak()) {
                    this.m_146870_();
                }
                return;
            }
            this.piercingIgnoreEntityIds.add(entity2.m_19879_());
        }
        if (this.m_36792_()) {
            long l = this.f_19796_.m_188503_(n / 2 + 2);
            n = (int)Math.min(l + (long)n, Integer.MAX_VALUE);
        }
        DamageSource damageSource = this.getDamageSource(entity2);
        Entity entity = this.m_19749_();
        if (entity != null && entity instanceof LivingEntity) {
            ((LivingEntity)entity).m_21335_(entity2);
        }
        boolean bl = entity2 instanceof LivingEntity && EntityFactionFind.isEnderman(livingEntity = (LivingEntity)entity2);
        int n2 = entity2.m_20094_();
        boolean bl2 = entity2.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("deflects_arrows")));
        if (this.m_6060_() && !bl && !bl2) {
            entity2.m_20254_(5);
        }
        if (entity2.m_6469_(damageSource, (float)n + special)) {
            if (bl && !this.canHurtEnderman()) {
                return;
            }
            if (entity2 instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity2;
                if (!this.m_9236_().f_46443_ && this.m_36796_() <= 0) {
                    livingEntity2.m_21317_(livingEntity2.m_21234_() + 1);
                }
                this.hitLivingEntityUse(livingEntity2);
                if (this.knockback > 0) {
                    double d = Math.max(0.0, 1.0 - livingEntity2.m_21133_(Attributes.f_22278_));
                    Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.knockback * 0.6 * d);
                    if (vec3.m_82556_() > 0.0) {
                        livingEntity2.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                    }
                }
                if (!this.m_9236_().f_46443_ && entity instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity2, (Entity)entity);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity), (Entity)livingEntity2);
                }
                this.m_7761_(livingEntity2);
                if (entity != null && livingEntity2 != entity && livingEntity2 instanceof Player && entity instanceof ServerPlayer && !this.m_20067_()) {
                    ((ServerPlayer)entity).f_8906_.m_141995_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
                if (!entity2.m_6084_() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add((Entity)livingEntity2);
                }
                if (!this.m_9236_().f_46443_ && entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    if (this.piercedAndKilledEntities != null && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverPlayer, this.piercedAndKilledEntities);
                    } else if (!entity2.m_6084_() && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverPlayer, Arrays.asList(entity2));
                    }
                }
            }
            this.soundLevel = 1.0f;
            SoundEvent soundEvent = this.soundEvent;
            this.hitUse(entity2);
            this.m_5496_(soundEvent, this.soundLevel, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            if (this.m_36796_() <= 0 && !this.canNotBreak() || this.mustBreak()) {
                this.m_146870_();
            }
        } else if (bl2) {
            this.m_305997_();
        } else {
            entity2.m_7311_(n2);
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
            if (!this.m_9236_().f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            }
        }
        if (this.mustBreak()) {
            this.m_146870_();
        }
    }

    public DamageSource getDamageSource(Entity entity) {
        if (this.m_19749_() == null) {
            return this.m_269291_().m_269418_((AbstractArrow)this, (Entity)this);
        }
        return this.m_269291_().m_269418_((AbstractArrow)this, this.m_19749_());
    }

    public float specialDamage(Entity entity) {
        return 0.0f;
    }

    public int basePierce() {
        return 0;
    }

    public boolean canNotBreak() {
        return false;
    }

    public boolean mustBreak() {
        return false;
    }

    public boolean canHurtEnderman() {
        return false;
    }

    public void hitLivingEntityUse(LivingEntity entity) {
    }

    public void hitUse(Entity entity) {
    }

    protected boolean m_5603_(Entity p_36743_) {
        return super.m_5603_(p_36743_) && (this.piercingIgnoreEntityIds == null || !this.piercingIgnoreEntityIds.contains(p_36743_.m_19879_()));
    }

    private void m_36723_() {
        if (this.piercedAndKilledEntities != null) {
            this.piercedAndKilledEntities.clear();
        }
        if (this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.m_36723_();
    }

    public void m_36735_(int n) {
        this.knockback = n;
    }

    public int m_150123_() {
        return this.knockback;
    }

    public void m_36781_(double d) {
        this.baseDamage = d;
    }

    public double m_36789_() {
        return this.baseDamage;
    }

    public void m_305997_() {
        float f = this.f_19796_.m_188501_() * 360.0f;
        this.m_20256_(this.m_20184_().m_82524_(f * ((float)Math.PI / 180)).m_82490_(0.5));
        this.m_146922_(this.m_146908_() + f);
        this.f_19859_ += f;
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("Arrow", 10)) {
            this.arrowItem = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("Arrow"));
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128365_("Arrow", (Tag)this.arrowItem.m_41739_(new CompoundTag()));
    }

    protected float m_6882_() {
        return 0.6f;
    }
}

