/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.entity.magic;

import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.magic.MagicAbout;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.spell.SpellFind;
import com.jerotes.jerotes.util.AttackFind;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public abstract class MagicAbstractHurtingProjectile
extends Projectile
implements MagicAbout {
    public double xPower;
    public double yPower;
    public double zPower;

    protected MagicAbstractHurtingProjectile(EntityType<? extends MagicAbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected MagicAbstractHurtingProjectile(EntityType<? extends MagicAbstractHurtingProjectile> entityType, double d, double d2, double d3, Level level) {
        this(entityType, level);
        this.m_6034_(d, d2, d3);
    }

    public MagicAbstractHurtingProjectile(EntityType<? extends MagicAbstractHurtingProjectile> entityType, double d, double d2, double d3, double d4, double d5, double d6, Level level) {
        this(entityType, level);
        this.m_7678_(d, d2, d3, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d7 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (d7 != 0.0) {
            this.xPower = d4 / d7 * 0.1;
            this.yPower = d5 / d7 * 0.1;
            this.zPower = d6 / d7 * 0.1;
        }
    }

    public MagicAbstractHurtingProjectile(EntityType<? extends MagicAbstractHurtingProjectile> entityType, LivingEntity livingEntity, double d, double d2, double d3, Level level) {
        this(entityType, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), d, d2, d3, level);
        this.m_5602_((Entity)livingEntity);
        this.m_19915_(livingEntity.m_146908_(), livingEntity.m_146909_());
    }

    protected void m_8097_() {
    }

    public boolean m_6783_(double d) {
        double d2;
        double d22 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d22)) {
            d22 = 4.0;
        }
        return d < d2 * (d22 *= 64.0);
    }

    protected ClipContext.Block getClipType() {
        return ClipContext.Block.COLLIDER;
    }

    public void m_8119_() {
        float f;
        HitResult hitResult;
        Entity entity = this.m_19749_();
        if (!this.m_9236_().f_46443_ && (entity != null && entity.m_213877_() || !this.m_9236_().m_46805_(this.m_20183_()))) {
            this.m_146870_();
            return;
        }
        super.m_8119_();
        if (this.shouldBurn()) {
            this.m_20254_(1);
        }
        if ((hitResult = ProjectileUtil.m_307639_((Entity)this, this::m_5603_, (ClipContext.Block)this.getClipType())).m_6662_() != HitResult.Type.MISS) {
            this.m_6532_(hitResult);
        }
        this.m_20101_();
        Vec3 vec3 = this.m_20184_();
        double d = this.m_20185_() + vec3.f_82479_;
        double d2 = this.m_20186_() + vec3.f_82480_;
        double d3 = this.m_20189_() + vec3.f_82481_;
        ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d - vec3.f_82479_ * 0.25, d2 - vec3.f_82480_ * 0.25, d3 - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
            f = this.getLiquidInertia();
        } else {
            f = this.getInertia();
        }
        this.m_20256_(vec3.m_82520_(this.xPower, this.yPower, this.zPower).m_82490_((double)f));
        ParticleOptions particleOptions = this.getTrailParticle();
        if (particleOptions != null) {
            this.m_9236_().m_7106_(particleOptions, d, d2 + (double)(this.m_20206_() / 2.0f), d3, 0.0, 0.0, 0.0);
        }
        this.m_6034_(d, d2, d3);
    }

    protected boolean m_5603_(Entity entity) {
        LivingEntity livingEntity;
        if (!(this.isHelp() || entity == this.m_19749_() || !(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_21023_((MobEffect)JerotesMobEffects.COUNTERSPELL.get()) || livingEntity.m_21124_((MobEffect)JerotesMobEffects.COUNTERSPELL.get()).m_19564_() + 1 < this.getSpellLevel() || this.m_19749_() != null && MainConfig.SameFactionAvoidDamage && AttackFind.SameFactionAvoidDamage(this.m_19749_(), livingEntity))) {
            if (!livingEntity.m_9236_().m_5776_()) {
                livingEntity.m_21195_((MobEffect)JerotesMobEffects.COUNTERSPELL.get());
            }
            livingEntity.m_6674_(InteractionHand.MAIN_HAND);
            SpellFind.Counterspell(livingEntity);
            return false;
        }
        return super.m_5603_(entity);
    }

    protected boolean shouldBurn() {
        return false;
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.f_123762_;
    }

    protected float getInertia() {
        return 1.0f;
    }

    protected float getLiquidInertia() {
        return 1.0f;
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128365_("power", (Tag)this.m_20063_(new double[]{this.xPower, this.yPower, this.zPower}));
    }

    public void m_7378_(CompoundTag compoundTag) {
        ListTag listTag;
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("power", 9) && (listTag = compoundTag.m_128437_("power", 6)).size() == 3) {
            this.xPower = listTag.m_128772_(0);
            this.yPower = listTag.m_128772_(1);
            this.zPower = listTag.m_128772_(2);
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public float m_6143_() {
        return 1.0f;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        this.m_5834_();
        Entity entity = damageSource.m_7639_();
        if (entity != null) {
            if (!this.m_9236_().f_46443_) {
                Vec3 vec3 = entity.m_20154_();
                this.m_20256_(vec3);
                this.xPower = vec3.f_82479_ * 0.1;
                this.yPower = vec3.f_82480_ * 0.1;
                this.zPower = vec3.f_82481_ * 0.1;
                this.m_5602_(entity);
            }
            return true;
        }
        return false;
    }

    public float m_213856_() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        Entity entity = this.m_19749_();
        int n = entity == null ? 0 : entity.m_19879_();
        return new ClientboundAddEntityPacket(this.m_19879_(), this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), n, new Vec3(this.xPower, this.yPower, this.zPower), 0.0);
    }

    public void m_141965_(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        super.m_141965_(clientboundAddEntityPacket);
        double d = clientboundAddEntityPacket.m_131503_();
        double d2 = clientboundAddEntityPacket.m_131504_();
        double d3 = clientboundAddEntityPacket.m_131505_();
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        if (d4 != 0.0) {
            this.xPower = d / d4 * 0.1;
            this.yPower = d2 / d4 * 0.1;
            this.zPower = d3 / d4 * 0.1;
        }
    }
}

