/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.entity.magic.Target;

import com.google.common.annotations.VisibleForTesting;
import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.magic.MagicAboutEntity;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.init.JerotesParticleTypes;
import com.jerotes.jerotes.spell.SpellFind;
import com.jerotes.jerotes.util.AttackFind;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class BaseTargetEntity
extends MagicAboutEntity {
    private static final EntityDataAccessor<Float> ID_SIZE = SynchedEntityData.m_135353_(BaseTargetEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    @Nullable
    private Entity target;
    @Nullable
    private UUID targetUUID;

    public BaseTargetEntity(EntityType<? extends MagicAboutEntity> entityType, Level level) {
        super(entityType, level);
        this.m_252801_();
    }

    public BaseTargetEntity(EntityType<? extends MagicAboutEntity> entityType, double d, double d2, double d3, double d4, double d5, double d6, Level level) {
        super(entityType, d, d2, d3, d4, d5, d6, level);
        this.m_252801_();
    }

    public BaseTargetEntity(EntityType<? extends MagicAboutEntity> entityType, LivingEntity livingEntity, double d, double d2, double d3, Level level) {
        super(entityType, livingEntity, d, d2, d3, level);
        this.m_252801_();
    }

    @Nullable
    public Entity getTarget() {
        Entity entity;
        if (this.target == null && this.targetUUID != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.targetUUID)) instanceof Entity) {
            this.target = entity;
        }
        return this.target;
    }

    public void setTarget(@Nullable Entity entity) {
        LivingEntity livingEntity;
        if (!(this.isHelp() || entity == this.m_19749_() || !(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).m_21023_((MobEffect)JerotesMobEffects.COUNTERSPELL.get()) || livingEntity.m_21124_((MobEffect)JerotesMobEffects.COUNTERSPELL.get()).m_19564_() + 1 < this.getSpellLevel() || this.m_19749_() != null && MainConfig.SameFactionAvoidDamage && AttackFind.SameFactionAvoidDamage(this.m_19749_(), livingEntity))) {
            if (!livingEntity.m_9236_().m_5776_()) {
                livingEntity.m_21195_((MobEffect)JerotesMobEffects.COUNTERSPELL.get());
            }
            livingEntity.m_6674_(InteractionHand.MAIN_HAND);
            SpellFind.Counterspell(livingEntity);
            return;
        }
        this.target = entity;
        this.targetUUID = entity == null ? null : entity.m_20148_();
    }

    @VisibleForTesting
    public void setSize(float f) {
        float f2 = Mth.m_14036_((float)f, (float)0.0f, (float)256.0f);
        this.f_19804_.m_135381_(ID_SIZE, (Object)Float.valueOf(f2));
        this.m_20090_();
        this.m_6210_();
    }

    public float getSize() {
        return ((Float)this.f_19804_.m_135370_(ID_SIZE)).floatValue();
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.targetUUID != null) {
            compoundTag.m_128362_("Target", this.targetUUID);
        }
        compoundTag.m_128350_("Size", this.getSize());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128403_("Target")) {
            this.targetUUID = compoundTag.m_128342_("Target");
        }
        this.setSize(compoundTag.m_128457_("Size"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ID_SIZE, (Object)Float.valueOf(1.0f));
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (ID_SIZE.equals(entityDataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(entityDataAccessor);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.life <= this.getUseLife()) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)level;
                if (this.getTrailParticle() != null && this.f_19797_ % 20 == 0) {
                    _level.m_8767_(this.getTrailParticle(), this.m_20185_() + (this.f_19796_.m_188500_() - 0.5), this.m_20186_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.getSize() * 1.0, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.getSize() * 1.0, 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (this.getTarget() != null && !(this.getTarget() instanceof Player)) {
                this.m_6027_(this.getTarget().m_20185_(), this.getTarget().m_20227_(0.5), this.getTarget().m_20189_());
            }
        }
        if (this.life == this.getUseLife()) {
            List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2));
            list.removeIf(livingEntity -> livingEntity != this.getTarget());
            for (LivingEntity livingEntity2 : list) {
                if (livingEntity2 == null) continue;
                Entity entity = this.m_19749_();
                if (!livingEntity2.m_6084_() || livingEntity2.m_20147_() || livingEntity2 == entity) continue;
                this.useMagicTo(livingEntity2);
            }
        }
    }

    public void useMagicTo(LivingEntity livingEntity) {
        if (!(this.isHelp() || livingEntity == this.m_19749_() || !livingEntity.m_21023_((MobEffect)JerotesMobEffects.COUNTERSPELL.get()) || livingEntity.m_21124_((MobEffect)JerotesMobEffects.COUNTERSPELL.get()).m_19564_() + 1 < this.getSpellLevel() || this.m_19749_() != null && MainConfig.SameFactionAvoidDamage && AttackFind.SameFactionAvoidDamage(this.m_19749_(), livingEntity))) {
            if (!livingEntity.m_9236_().m_5776_()) {
                livingEntity.m_21195_((MobEffect)JerotesMobEffects.COUNTERSPELL.get());
            }
            livingEntity.m_6674_(InteractionHand.MAIN_HAND);
            SpellFind.Counterspell(livingEntity);
            return;
        }
    }

    public abstract int getUseLife();

    @Override
    public int getMaxLife() {
        return 20;
    }

    @Override
    protected ParticleOptions getTrailParticle() {
        return (ParticleOptions)JerotesParticleTypes.NULL.get();
    }

    @Override
    public ItemStack m_7846_() {
        ItemStack itemStack = this.getItemRaw();
        return itemStack.m_41619_() ? new ItemStack((ItemLike)Items.f_41852_) : itemStack;
    }

    @Override
    protected float getInertia() {
        return 1.0f;
    }

    @Override
    protected float getLiquidInertia() {
        return 1.0f;
    }
}

