/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.event;

import com.jerotes.jerotes.entity.EliteEntity;
import com.jerotes.jerotes.entity.FireAbsorptionEntity;
import com.jerotes.jerotes.entity.FreezeAbsorptionEntity;
import com.jerotes.jerotes.entity.LightningAbsorptionEntity;
import com.jerotes.jerotes.entity.Mob.MirrorImageEntity;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.init.JerotesSounds;
import com.jerotes.jerotes.spell.SpellFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.Main;
import java.util.List;
import java.util.Objects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jerotes")
public class EffectEvent {
    @SubscribeEvent
    public static void MagicAbsorption(LivingHurtEvent event) {
        DamageSource damagesource = event.getSource();
        LivingEntity entity = event.getEntity();
        if (damagesource == null || entity == null) {
            return;
        }
        if (EntityAndItemFind.MagicResistance(damagesource)) {
            float damages = 1.0f;
            if (!entity.m_9236_().m_5776_() && entity.m_21023_((MobEffect)JerotesMobEffects.MAGIC_ABSORPTION.get())) {
                int effectLevel = Objects.requireNonNull(entity.m_21124_((MobEffect)JerotesMobEffects.MAGIC_ABSORPTION.get())).m_19564_() + 1;
                damages -= (float)effectLevel * 0.1f;
            }
            event.setAmount(event.getAmount() * damages);
        }
    }

    @SubscribeEvent
    public static void OtherAbsorption(LivingAttackEvent event) {
        boolean bl;
        double AbsorptionPercentage;
        DamageSource damagesource = event.getSource();
        LivingEntity entity = event.getEntity();
        if (damagesource == null || entity == null) {
            return;
        }
        double damages = 1.0;
        if (damagesource.m_269533_(DamageTypeTags.f_268745_) && !entity.m_9236_().m_5776_() && (entity.m_21023_((MobEffect)JerotesMobEffects.FIRE_ABSORPTION.get()) || entity instanceof FireAbsorptionEntity)) {
            double d;
            if (entity instanceof FireAbsorptionEntity) {
                FireAbsorptionEntity absorptionEntity = (FireAbsorptionEntity)entity;
                d = absorptionEntity.FireAbsorptionPercentage();
            } else {
                d = 0.0;
            }
            AbsorptionPercentage = Math.max(d, entity.m_21023_((MobEffect)JerotesMobEffects.FIRE_ABSORPTION.get()) ? (double)((Objects.requireNonNull(entity.m_21124_((MobEffect)JerotesMobEffects.FIRE_ABSORPTION.get())).m_19564_() + 1) * 20) : 0.0);
            damages -= AbsorptionPercentage / 100.0;
            bl = SpellFind.FireAbsorption(entity, event.getAmount(), AbsorptionPercentage, 0.25f);
            if (bl && !entity.m_20067_()) {
                entity.m_5496_(JerotesSounds.MAGIC_FIRE_ABSORPTION, EntityAndItemFind.isBoss(entity.m_6095_()) ? 5.0f : (entity instanceof EliteEntity ? 2.0f : 1.0f) * 1.0f, 1.0f);
            }
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268419_) && !entity.m_9236_().m_5776_() && (entity.m_21023_((MobEffect)JerotesMobEffects.FREEZE_ABSORPTION.get()) || entity instanceof FreezeAbsorptionEntity)) {
            double d;
            if (entity instanceof FreezeAbsorptionEntity) {
                FreezeAbsorptionEntity absorptionEntity = (FreezeAbsorptionEntity)entity;
                d = absorptionEntity.FreezeAbsorptionPercentage();
            } else {
                d = 0.0;
            }
            AbsorptionPercentage = Math.max(d, entity.m_21023_((MobEffect)JerotesMobEffects.FREEZE_ABSORPTION.get()) ? (double)((Objects.requireNonNull(entity.m_21124_((MobEffect)JerotesMobEffects.FREEZE_ABSORPTION.get())).m_19564_() + 1) * 20) : 0.0);
            damages -= AbsorptionPercentage / 100.0;
            bl = SpellFind.FreezeAbsorption(entity, event.getAmount(), AbsorptionPercentage, 0.25f);
            if (bl && !entity.m_20067_()) {
                entity.m_5496_(JerotesSounds.MAGIC_FREEZE_ABSORPTION, EntityAndItemFind.isBoss(entity.m_6095_()) ? 5.0f : (entity instanceof EliteEntity ? 2.0f : 1.0f) * 1.0f, 1.0f);
            }
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268725_) && !entity.m_9236_().m_5776_() && (entity.m_21023_((MobEffect)JerotesMobEffects.LIGHTNING_ABSORPTION.get()) || entity instanceof LightningAbsorptionEntity)) {
            double d;
            if (entity instanceof LightningAbsorptionEntity) {
                LightningAbsorptionEntity absorptionEntity = (LightningAbsorptionEntity)entity;
                d = absorptionEntity.LightningAbsorptionPercentage();
            } else {
                d = 0.0;
            }
            AbsorptionPercentage = Math.max(d, entity.m_21023_((MobEffect)JerotesMobEffects.LIGHTNING_ABSORPTION.get()) ? (double)((Objects.requireNonNull(entity.m_21124_((MobEffect)JerotesMobEffects.LIGHTNING_ABSORPTION.get())).m_19564_() + 1) * 20) : 0.0);
            damages -= AbsorptionPercentage / 100.0;
            boolean bl2 = SpellFind.LightningAbsorption(entity, event.getAmount(), AbsorptionPercentage, 0.25f);
            if (bl2 && !entity.m_20067_()) {
                entity.m_5496_(JerotesSounds.MAGIC_LIGHTNING_ABSORPTION, EntityAndItemFind.isBoss(entity.m_6095_()) ? 5.0f : (entity instanceof EliteEntity ? 2.0f : 1.0f) * 1.0f, 1.0f);
            }
        }
        if (damages <= 0.0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void OtherAbsorption(LivingHurtEvent event) {
        double AbsorptionPercentage;
        Object absorptionEntity;
        DamageSource damagesource = event.getSource();
        LivingEntity entity = event.getEntity();
        if (damagesource == null || entity == null) {
            return;
        }
        double damages = 1.0;
        if (damagesource.m_269533_(DamageTypeTags.f_268745_) && !entity.m_9236_().m_5776_() && (entity.m_21023_((MobEffect)JerotesMobEffects.FIRE_ABSORPTION.get()) || entity instanceof FireAbsorptionEntity)) {
            double d;
            if (entity instanceof FireAbsorptionEntity) {
                absorptionEntity = (FireAbsorptionEntity)entity;
                d = absorptionEntity.FireAbsorptionPercentage();
            } else {
                d = 0.0;
            }
            AbsorptionPercentage = Math.max(d, entity.m_21023_((MobEffect)JerotesMobEffects.FIRE_ABSORPTION.get()) ? (double)((Objects.requireNonNull(entity.m_21124_((MobEffect)JerotesMobEffects.FIRE_ABSORPTION.get())).m_19564_() + 1) * 20) : 0.0);
            damages -= AbsorptionPercentage / 100.0;
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268419_) && !entity.m_9236_().m_5776_() && (entity.m_21023_((MobEffect)JerotesMobEffects.FREEZE_ABSORPTION.get()) || entity instanceof FreezeAbsorptionEntity)) {
            double d;
            if (entity instanceof FreezeAbsorptionEntity) {
                absorptionEntity = (FreezeAbsorptionEntity)entity;
                d = absorptionEntity.FreezeAbsorptionPercentage();
            } else {
                d = 0.0;
            }
            AbsorptionPercentage = Math.max(d, entity.m_21023_((MobEffect)JerotesMobEffects.FREEZE_ABSORPTION.get()) ? (double)((Objects.requireNonNull(entity.m_21124_((MobEffect)JerotesMobEffects.FREEZE_ABSORPTION.get())).m_19564_() + 1) * 20) : 0.0);
            damages -= AbsorptionPercentage / 100.0;
        }
        if (damagesource.m_269533_(DamageTypeTags.f_268725_) && !entity.m_9236_().m_5776_() && (entity.m_21023_((MobEffect)JerotesMobEffects.LIGHTNING_ABSORPTION.get()) || entity instanceof LightningAbsorptionEntity)) {
            double d;
            if (entity instanceof LightningAbsorptionEntity) {
                absorptionEntity = (LightningAbsorptionEntity)entity;
                d = absorptionEntity.LightningAbsorptionPercentage();
            } else {
                d = 0.0;
            }
            AbsorptionPercentage = Math.max(d, entity.m_21023_((MobEffect)JerotesMobEffects.LIGHTNING_ABSORPTION.get()) ? (double)((Objects.requireNonNull(entity.m_21124_((MobEffect)JerotesMobEffects.LIGHTNING_ABSORPTION.get())).m_19564_() + 1) * 20) : 0.0);
            damages -= AbsorptionPercentage / 100.0;
        }
        event.setAmount((float)((double)event.getAmount() * Math.max(0.0, damages)));
    }

    @SubscribeEvent
    public static void MobHold(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity != null) {
            if (livingEntity.m_21023_((MobEffect)JerotesMobEffects.HOLD_MOB.get())) {
                if (livingEntity.getPersistentData().m_128457_("jerotes_hold_mob_x_rot") < 500.0f) {
                    livingEntity.getPersistentData().m_128350_("jerotes_hold_mob_x_rot", livingEntity.m_146909_() + 500.0f);
                } else {
                    livingEntity.m_146926_(livingEntity.getPersistentData().m_128457_("jerotes_hold_mob_x_rot") - 500.0f);
                    livingEntity.f_19860_ = livingEntity.getPersistentData().m_128457_("jerotes_hold_mob_x_rot") - 500.0f;
                }
                if (livingEntity.getPersistentData().m_128457_("jerotes_hold_mob_y_rot") < 500.0f) {
                    livingEntity.getPersistentData().m_128350_("jerotes_hold_mob_y_rot", livingEntity.m_146908_() + 500.0f);
                } else {
                    livingEntity.m_146922_(livingEntity.getPersistentData().m_128457_("jerotes_hold_mob_y_rot") - 500.0f);
                    livingEntity.f_19859_ = livingEntity.getPersistentData().m_128457_("jerotes_hold_mob_y_rot") - 500.0f;
                    livingEntity.m_5616_(livingEntity.getPersistentData().m_128457_("jerotes_hold_mob_y_rot") - 500.0f);
                    livingEntity.m_5618_(livingEntity.getPersistentData().m_128457_("jerotes_hold_mob_y_rot") - 500.0f);
                }
            }
            if (!livingEntity.m_21023_((MobEffect)JerotesMobEffects.HOLD_MOB.get())) {
                Main.persistentDataRemove(livingEntity, "jerotes_hold_mob_x_rot");
                Main.persistentDataRemove(livingEntity, "jerotes_hold_mob_y_rot");
            }
        }
    }

    @SubscribeEvent
    public static void MirrorImage(LivingAttackEvent event) {
        int chance;
        boolean bl3;
        boolean bl2;
        LivingEntity living;
        DamageSource damagesource = event.getSource();
        LivingEntity entity = event.getEntity();
        if (damagesource == null || entity == null) {
            return;
        }
        Entity entity2 = damagesource.m_7639_();
        if (entity2 instanceof LivingEntity && (EntityAndItemFind.targetBlindnessTrue(living = (LivingEntity)entity2) || living.m_21023_((MobEffect)JerotesMobEffects.TRUESIGHT.get()))) {
            return;
        }
        boolean bl1 = entity.getPersistentData().m_128423_("jerotes_has_mirror_image_1_tick") != null;
        int n = (bl1 ? 1 : 0) + ((bl2 = entity.getPersistentData().m_128423_("jerotes_has_mirror_image_2_tick") != null) ? 1 : 0) + ((bl3 = entity.getPersistentData().m_128423_("jerotes_has_mirror_image_3_tick") != null) ? 1 : 0);
        if (n == 0) {
            return;
        }
        int n2 = n == 1 ? 6 : (chance = n == 2 ? 8 : 11);
        if (Main.randomReach(entity.m_217043_(), 1, 20) >= chance && !damagesource.m_269533_(DamageTypeTags.f_268738_)) {
            List list = entity.m_9236_().m_45976_(MirrorImageEntity.class, entity.m_20191_().m_82377_(32.0, 32.0, 32.0));
            list.removeIf(mirrorImageEntity -> mirrorImageEntity.m_269323_() != entity);
            for (MirrorImageEntity mirrorImageEntity2 : list) {
                if (mirrorImageEntity2 == null || mirrorImageEntity2.m_269323_() != entity) continue;
                mirrorImageEntity2.m_146870_();
                event.setCanceled(true);
                break;
            }
        }
    }
}

