/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.event;

import com.jerotes.jerotes.config.MainConfig;
import com.jerotes.jerotes.entity.JerotesEntity;
import com.jerotes.jerotes.entity.magic.MagicAbout;
import com.jerotes.jerotes.goal.JerotesShockAbackGoal;
import com.jerotes.jerotes.goal.JerotesSpearUseGoal;
import com.jerotes.jerotes.init.JerotesDamageTypes;
import com.jerotes.jerotes.init.JerotesEnchantments;
import com.jerotes.jerotes.init.JerotesMobEffectTags;
import com.jerotes.jerotes.init.JerotesMobEffects;
import com.jerotes.jerotes.util.AttackFind;
import com.jerotes.jerotes.util.EntityAndItemFind;
import com.jerotes.jerotes.util.EntityFactionFind;
import com.jerotes.jerotes.util.Main;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jerotes")
public class EntityAboutEvent {
    @SubscribeEvent
    public static void FactionHurt(LivingAttackEvent event) {
        Mob mob;
        LivingEntity hurt = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        if (!MainConfig.SameFactionAvoidDamage) {
            return;
        }
        if (AttackFind.SameFactionAvoidDamage(attacker, hurt)) {
            event.setCanceled(true);
        }
        if (AttackFind.SameFactionAvoidDamage(attacker, hurt.m_6688_()) && hurt instanceof Mob && (mob = (Mob)hurt).m_5448_() != attacker) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void OtherVisibility(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity self = event.getEntity();
        Entity lookingEntity = event.getLookingEntity();
        if (lookingEntity == null || self == null) {
            return;
        }
        if (self.m_21023_((MobEffect)JerotesMobEffects.CLOAKING.get())) {
            int cloakingLevel = Objects.requireNonNull(self.m_21124_((MobEffect)JerotesMobEffects.CLOAKING.get())).m_19564_() + 1;
            if (self.m_20270_(lookingEntity) > (float)(48 - cloakingLevel * 8)) {
                event.modifyVisibility(0.0);
            }
        }
    }

    @SubscribeEvent
    public static void OtherHurt(LivingAttackEvent event) {
        MagicAbout magicShoot;
        LivingEntity hurt = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        Entity attackerUse = event.getSource().m_7640_();
        if (attacker instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attacker;
            attacker.m_9236_().m_9598_().m_175515_(Registries.f_256929_).m_206058_(JerotesMobEffectTags.REMOVE_AFTER_ATTACK).forEach(effect -> {
                if (livingEntity.m_21023_((MobEffect)effect.get()) && !livingEntity.m_9236_().m_5776_()) {
                    livingEntity.m_21195_((MobEffect)effect.get());
                }
            });
        }
        if (!(attackerUse instanceof MagicAbout) || !((magicShoot = (MagicAbout)attackerUse) instanceof Projectile)) {
            return;
        }
        Projectile projectile = (Projectile)magicShoot;
        if (hurt == projectile.m_19749_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void EnchantHurt(LivingHurtEvent event) {
        if (event != null && event.getEntity() != null) {
            LivingEntity livingEntity = event.getEntity();
            DamageSource damagesource = event.getSource();
            if (damagesource == null || livingEntity == null) {
                return;
            }
            if (!livingEntity.m_9236_().m_5776_() && damagesource.m_276093_(JerotesDamageTypes.CORROSIVE)) {
                float damages = 1.0f;
                ItemStack head = livingEntity.m_6844_(EquipmentSlot.HEAD);
                ItemStack chest = livingEntity.m_6844_(EquipmentSlot.CHEST);
                ItemStack legs = livingEntity.m_6844_(EquipmentSlot.LEGS);
                ItemStack feet = livingEntity.m_6844_(EquipmentSlot.FEET);
                damages -= (float)head.getEnchantmentLevel((Enchantment)JerotesEnchantments.CORROSION_RESISTANCE.get()) * 0.08f;
                damages -= (float)chest.getEnchantmentLevel((Enchantment)JerotesEnchantments.CORROSION_RESISTANCE.get()) * 0.08f;
                damages -= (float)legs.getEnchantmentLevel((Enchantment)JerotesEnchantments.CORROSION_RESISTANCE.get()) * 0.08f;
                event.setAmount(event.getAmount() * (damages -= (float)feet.getEnchantmentLevel((Enchantment)JerotesEnchantments.CORROSION_RESISTANCE.get()) * 0.08f));
            }
        }
    }

    @SubscribeEvent
    public static void addWeaponEnchant(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        Entity attackBy = event.getSource().m_7639_();
        float amount = event.getAmount();
        if (entity == null || !entity.m_6084_()) {
            return;
        }
        if (attackBy != null && attackBy instanceof LivingEntity) {
            LivingEntity livingEntity;
            LivingEntity living = (LivingEntity)attackBy;
            if ((attackBy instanceof Mob || attackBy instanceof Player) && event.getSource().m_7640_() == living && EntityAndItemFind.isMeleeDamage(event.getSource()) && JerotesEnchantments.BANE_OF_HUMANOIDS != null && EntityFactionFind.isHumanoid(entity) && attackBy instanceof LivingEntity && !(livingEntity = (LivingEntity)attackBy).m_21205_().m_41619_() && livingEntity.m_21205_().getEnchantmentLevel((Enchantment)JerotesEnchantments.BANE_OF_HUMANOIDS.get()) > 0 && living.m_21051_(Attributes.f_22281_) != null) {
                float baseDamage = (float)living.m_21133_(Attributes.f_22281_);
                event.setAmount(amount + amount / baseDamage * ((float)livingEntity.m_21205_().getEnchantmentLevel((Enchantment)JerotesEnchantments.BANE_OF_HUMANOIDS.get()) * 2.5f));
            }
        }
    }

    @SubscribeEvent
    public static void FactionHurtHaveDamage(LivingDamageEvent event) {
        Mob mob;
        OwnableEntity ownable;
        LivingEntity hurt = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntityAttacker = (LivingEntity)attacker;
        if (!MainConfig.TamedMobHurtByOwnerHasReduce) {
            return;
        }
        if (livingEntityAttacker instanceof OwnableEntity && (ownable = (OwnableEntity)livingEntityAttacker).m_269323_() == hurt && (livingEntityAttacker instanceof JerotesEntity || hurt instanceof JerotesEntity || MainConfig.AffectsNonThisModEntities)) {
            event.setAmount(event.getAmount() / 3.0f);
            event.setCanceled(true);
        }
        if (hurt instanceof OwnableEntity && (ownable = (OwnableEntity)hurt).m_269323_() == livingEntityAttacker && (livingEntityAttacker instanceof JerotesEntity || hurt instanceof JerotesEntity || MainConfig.AffectsNonThisModEntities)) {
            event.setAmount(event.getAmount() / 3.0f);
        }
        if (hurt instanceof Mob && (mob = (Mob)hurt).m_5448_() != livingEntityAttacker && (hurt instanceof JerotesEntity || MainConfig.AffectsNonThisModEntities) && Main.isTrusted(hurt, livingEntityAttacker, true)) {
            event.setAmount(event.getAmount() / 3.0f);
        }
    }

    @SubscribeEvent
    public static void GoalAdd(EntityJoinLevelEvent event) {
        PathfinderMob pathfinderMob;
        Entity entity = event.getEntity();
        if (entity instanceof PathfinderMob) {
            pathfinderMob = (PathfinderMob)entity;
            pathfinderMob.f_21345_.m_25352_(1, (Goal)new JerotesShockAbackGoal(pathfinderMob, 1.2));
        }
        if (entity instanceof Zombie) {
            pathfinderMob = (Zombie)entity;
            pathfinderMob.f_21345_.m_25352_(1, new JerotesSpearUseGoal<PathfinderMob>(pathfinderMob, 1.0, 1.0, 10.0f, 2.0f));
        }
    }

    @SubscribeEvent
    public static void Tick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null || !entity.m_6084_()) {
            return;
        }
        Main.persistentDataDoubleReduceToZero(entity, "jerotes_has_mirror_image_1_tick", true);
        Main.persistentDataDoubleReduceToZero(entity, "jerotes_has_mirror_image_2_tick", true);
        Main.persistentDataDoubleReduceToZero(entity, "jerotes_has_mirror_image_3_tick", true);
        if (entity.getPersistentData().m_128423_("jerotes_has_mirror_image_1_tick") == null || entity.getPersistentData().m_128459_("jerotes_has_mirror_image_1_tick") <= 0.0) {
            Main.persistentDataRemove(entity, "jerotes_has_mirror_image_1_x");
            Main.persistentDataRemove(entity, "jerotes_has_mirror_image_1_y");
            Main.persistentDataRemove(entity, "jerotes_has_mirror_image_1_z");
        }
        if (entity.getPersistentData().m_128423_("jerotes_has_mirror_image_2_tick") == null && entity.getPersistentData().m_128459_("jerotes_has_mirror_image_2_tick") <= 0.0) {
            Main.persistentDataRemove(entity, "jerotes_has_mirror_image_2_x");
            Main.persistentDataRemove(entity, "jerotes_has_mirror_image_2_y");
            Main.persistentDataRemove(entity, "jerotes_has_mirror_image_2_z");
        }
        if (entity.getPersistentData().m_128423_("jerotes_has_mirror_image_3_tick") == null && entity.getPersistentData().m_128459_("jerotes_has_mirror_image_3_tick") <= 0.0) {
            Main.persistentDataRemove(entity, "jerotes_has_mirror_image_3_x");
            Main.persistentDataRemove(entity, "jerotes_has_mirror_image_3_y");
            Main.persistentDataRemove(entity, "jerotes_has_mirror_image_3_z");
        }
        if (entity.getPersistentData().m_128457_("jerotes_boss_hurt_cooldown") > 0.0f) {
            entity.getPersistentData().m_128350_("jerotes_boss_hurt_cooldown", entity.getPersistentData().m_128457_("jerotes_boss_hurt_cooldown") - 1.0f);
        }
    }

    @SubscribeEvent
    public static void BossAttack(LivingAttackEvent event) {
        Entity entity = event.getSource().m_7639_();
        float damage = event.getAmount();
        LivingEntity boss = event.getEntity();
        if (boss instanceof JerotesEntity) {
            JerotesEntity jerotes = (JerotesEntity)boss;
            if (jerotes.hasDamageCooldownTick()) {
                if (!event.getSource().m_269533_(DamageTypeTags.f_268738_) && !boss.m_6673_(event.getSource())) {
                    boolean noCooldown;
                    boolean breakThis = damage > boss.getPersistentData().m_128457_("jerotes_boss_hurt_cooldown_last_damage") * jerotes.BreakHurtCooldownMultiple(event.getSource(), entity);
                    boolean bl = noCooldown = boss.getPersistentData().m_128457_("jerotes_boss_hurt_cooldown") <= 0.0f;
                    if (!breakThis && !noCooldown) {
                        event.setCanceled(true);
                    } else {
                        boss.getPersistentData().m_128350_("jerotes_boss_hurt_cooldown", jerotes.DamageCooldownTick(event.getSource(), entity));
                        boss.getPersistentData().m_128350_("jerotes_boss_hurt_cooldown_last_damage", damage);
                    }
                } else {
                    boss.getPersistentData().m_128350_("jerotes_boss_hurt_cooldown", jerotes.DamageCooldownTick(event.getSource(), entity));
                    boss.getPersistentData().m_128350_("jerotes_boss_hurt_cooldown_last_damage", damage);
                }
            }
        } else if (MainConfig.HasDamageCooldownTick.contains(boss.m_20078_())) {
            float base = 1.0f;
            if (event.getSource().m_269533_(DamageTypeTags.f_273918_)) {
                base *= 0.5f;
            }
            if (!event.getSource().m_269533_(DamageTypeTags.f_268738_) && !boss.m_6673_(event.getSource())) {
                boolean noCooldown;
                boolean breakThis = damage > boss.getPersistentData().m_128457_("jerotes_boss_hurt_cooldown_last_damage") * (float)MainConfig.BaseBreakHurtCooldownMultiple;
                boolean bl = noCooldown = boss.getPersistentData().m_128457_("jerotes_boss_hurt_cooldown") <= 0.0f;
                if (!breakThis && !noCooldown) {
                    event.setCanceled(true);
                } else {
                    boss.getPersistentData().m_128350_("jerotes_boss_hurt_cooldown", (float)MainConfig.BaseDamageCooldownTick * base);
                    boss.getPersistentData().m_128350_("jerotes_boss_hurt_cooldown_last_damage", damage);
                }
            } else {
                boss.getPersistentData().m_128350_("jerotes_boss_hurt_cooldown", (float)MainConfig.BaseDamageCooldownTick * base);
                boss.getPersistentData().m_128350_("jerotes_boss_hurt_cooldown_last_damage", damage);
            }
        }
    }

    @SubscribeEvent
    public static void BossHurt(LivingHurtEvent event) {
        JerotesEntity jerotes;
        Entity entity = event.getSource().m_7639_();
        float damage = event.getAmount();
        if (entity instanceof LivingEntity) {
            LivingEntity bossAttacker = (LivingEntity)entity;
            if (bossAttacker instanceof JerotesEntity) {
                jerotes = (JerotesEntity)bossAttacker;
                if (jerotes.hasPercentageDamage() && damage > 0.0f) {
                    float damageAdd = jerotes.PercentageDamage(event.getSource());
                    if (bossAttacker.m_21051_(Attributes.f_22281_) != null && (double)event.getAmount() < bossAttacker.m_21133_(Attributes.f_22281_) / 0.75) {
                        damageAdd = (float)Math.max((double)(damageAdd / 5.0f), (double)(damageAdd * event.getAmount()) / bossAttacker.m_21133_(Attributes.f_22281_));
                    }
                    damage += damageAdd / 100.0f * event.getEntity().m_21233_();
                }
            } else if (MainConfig.HasPercentageDamage.contains(bossAttacker.m_20078_()) && damage > 0.0f) {
                float f = (float)MainConfig.BaseAttackPercentage;
                if (EntityAndItemFind.MagicResistance(event.getSource())) {
                    f = (float)MainConfig.BaseMagicAttackPercentage;
                }
                float damageAdd = f;
                if (bossAttacker.m_21051_(Attributes.f_22281_) != null && (double)event.getAmount() < bossAttacker.m_21133_(Attributes.f_22281_) / 0.75) {
                    damageAdd = (float)Math.max((double)(damageAdd / 5.0f), (double)(damageAdd * event.getAmount()) / bossAttacker.m_21133_(Attributes.f_22281_));
                }
                damage += damageAdd / 100.0f * event.getEntity().m_21233_();
            }
        }
        LivingEntity boss = event.getEntity();
        if (!event.getSource().m_269533_(DamageTypeTags.f_268738_) && !boss.m_6673_(event.getSource())) {
            if (boss instanceof JerotesEntity) {
                jerotes = (JerotesEntity)boss;
                if (jerotes.hasDamageCap() && damage > jerotes.DamageCap(event.getSource(), entity)) {
                    damage = jerotes.DamageCap(event.getSource(), entity);
                }
            } else if (MainConfig.HasDamageCap.contains(boss.m_20078_()) && damage > (float)MainConfig.BaseDamageCap / 100.0f * boss.m_21233_()) {
                damage = (float)MainConfig.BaseDamageCap / 100.0f * boss.m_21233_();
            }
        }
        event.setAmount(damage);
    }

    @SubscribeEvent
    public static void BossDamage(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7639_();
        float damage = event.getAmount();
        LivingEntity boss = event.getEntity();
        if (!event.getSource().m_269533_(DamageTypeTags.f_268738_) && !boss.m_6673_(event.getSource())) {
            if (boss instanceof JerotesEntity) {
                JerotesEntity jerotes = (JerotesEntity)boss;
                if (jerotes.hasDamageCap() && damage > jerotes.DamageCap(event.getSource(), entity)) {
                    damage = jerotes.DamageCap(event.getSource(), entity);
                }
            } else if (MainConfig.HasDamageCap.contains(boss.m_20078_()) && damage > (float)MainConfig.BaseDamageCap / 100.0f * boss.m_21233_()) {
                damage = (float)MainConfig.BaseDamageCap / 100.0f * boss.m_21233_();
            }
        }
    }
}

