/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.goal;

import com.jerotes.jerotes.entity.TameMobEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class JerotesTameMobFollowOwnerGoal
extends Goal {
    private final TameMobEntity tameMob;
    private LivingEntity owner;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;
    private final boolean canFly;

    public JerotesTameMobFollowOwnerGoal(TameMobEntity tameMob, double d, float f, float f2, boolean bl) {
        this.tameMob = tameMob;
        this.level = ((Mob)tameMob).m_9236_();
        this.speedModifier = d;
        this.navigation = ((Mob)tameMob).m_21573_();
        this.startDistance = f;
        this.stopDistance = f2;
        this.canFly = bl;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        Mob mob;
        TameMobEntity tameMobEntity = this.tameMob;
        if (tameMobEntity instanceof Mob && (mob = (Mob)tameMobEntity).m_5448_() != null) {
            return false;
        }
        LivingEntity livingEntity = ((OwnableEntity)this.tameMob).m_269323_();
        if (livingEntity == null) {
            return false;
        }
        if (livingEntity.m_5833_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (((Mob)this.tameMob).m_20280_((Entity)livingEntity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingEntity;
        return true;
    }

    public boolean m_8045_() {
        Mob mob;
        TameMobEntity tameMobEntity = this.tameMob;
        if (tameMobEntity instanceof Mob && (mob = (Mob)tameMobEntity).m_5448_() != null) {
            return false;
        }
        if (this.navigation.m_26571_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        return !(((Mob)this.tameMob).m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    private boolean unableToMove() {
        return this.tameMob.isOrderedToSit() || ((Mob)this.tameMob).m_20159_() || ((Mob)this.tameMob).m_21523_() || ((OwnableEntity)this.tameMob).m_269323_() != null && ((Mob)this.tameMob).m_9236_() != ((OwnableEntity)this.tameMob).m_269323_().m_9236_();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = ((Mob)this.tameMob).m_21439_(BlockPathTypes.WATER);
        ((Mob)this.tameMob).m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigation.m_26573_();
        ((Mob)this.tameMob).m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        ((Mob)this.tameMob).m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)((Mob)this.tameMob).m_8132_());
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = this.m_183277_(10);
        if (((Mob)this.tameMob).m_20280_((Entity)this.owner) >= 144.0) {
            this.teleportToOwner();
        } else {
            this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
        }
    }

    private void teleportToOwner() {
        BlockPos blockPos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int n = this.randomIntInclusive(-3, 3);
            int n2 = this.randomIntInclusive(-1, 1);
            int n3 = this.randomIntInclusive(-3, 3);
            boolean bl = this.maybeTeleportTo(blockPos.m_123341_() + n, blockPos.m_123342_() + n2, blockPos.m_123343_() + n3);
            if (!bl) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int n, int n2, int n3) {
        if (Math.abs((double)n - this.owner.m_20185_()) < 2.0 && Math.abs((double)n3 - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(n, n2, n3))) {
            return false;
        }
        ((Mob)this.tameMob).m_7678_((double)n + 0.5, (double)n2, (double)n3 + 0.5, ((Mob)this.tameMob).m_146908_(), ((Mob)this.tameMob).m_146909_());
        this.navigation.m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos blockPos) {
        BlockPathTypes pathType = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)blockPos.m_122032_());
        if (pathType != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockState = this.level.m_8055_(blockPos.m_7495_());
        if (!this.canFly && blockState.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockPos2 = blockPos.m_121996_((Vec3i)((Mob)this.tameMob).m_20183_());
        return this.level.m_45756_((Entity)((Mob)this.tameMob), ((Mob)this.tameMob).m_20191_().m_82338_(blockPos2));
    }

    private int randomIntInclusive(int n, int n2) {
        return ((Mob)this.tameMob).m_217043_().m_188503_(n2 - n + 1) + n;
    }
}

