/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.item;

import com.jerotes.jerotes.entity.CatchEntity;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class ItemCatchBase
extends Item {
    private final Supplier<? extends EntityType<?>> entityTypeSupplier;

    public ItemCatchBase(Supplier<? extends EntityType<?>> entitySupplier, Item.Properties properties) {
        super(properties);
        this.entityTypeSupplier = entitySupplier;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        BlockHitResult blockhitresult = ItemCatchBase.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockPos blockpos = blockhitresult.m_82425_();
        this.checkExtraContent(player, level, itemStack, blockpos);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        if (!player.m_150110_().f_35937_) {
            player.m_21120_(interactionHand).m_41774_(1);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    public EntityType<?> getEntityType() {
        return this.entityTypeSupplier.get();
    }

    public void checkExtraContent(@Nullable Player player, Level level, ItemStack itemStack, BlockPos blockPos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawnFish(serverLevel, itemStack, blockPos);
            serverLevel.m_142346_((Entity)player, GameEvent.f_157810_, blockPos);
        }
    }

    private void spawnFish(ServerLevel serverLevel, ItemStack stack, BlockPos pos) {
        Entity entity = this.getEntityType().m_20592_(serverLevel, stack, null, pos, MobSpawnType.BUCKET, true, false);
        if (entity instanceof CatchEntity) {
            CatchEntity catchEntity = (CatchEntity)entity;
            catchEntity.loadFromCatchTag(stack.m_41784_());
            catchEntity.setFromCatch(true);
        }
    }

    public static boolean isBaby(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.m_41783_();
        return compoundtag != null && (compoundtag.m_128441_("Age") && compoundtag.m_128451_("Age") < 0 || compoundtag.m_128441_("IsBaby") && compoundtag.m_128471_("IsBaby"));
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
    }
}

