/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.item.tool;

import com.google.common.collect.Sets;
import com.jerotes.jerotes.item.ItemAnesthetized;
import com.jerotes.jerotes.item.ItemSpecialEffect;
import com.jerotes.jerotes.item.MeleeItem;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ItemToolBaseHammer
extends SwordItem
implements ItemAnesthetized,
ItemSpecialEffect,
MeleeItem {
    public static final Set<ToolAction> ONE_HANDED_BREAK_SHIELD_ACTIONS = ItemToolBaseHammer.of(ToolActions.SWORD_DIG);

    public ItemToolBaseHammer(Tier tier, int damage, float speed, Item.Properties properties) {
        super(tier, damage, speed, properties);
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    private static Set<ToolAction> of(ToolAction ... actions) {
        return Stream.of(actions).collect(Collectors.toCollection(Sets::newIdentityHashSet));
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ONE_HANDED_BREAK_SHIELD_ACTIONS.contains(toolAction);
    }

    @Override
    public int getAnesthetized() {
        return 12;
    }

    @Override
    public boolean onlyPlayer() {
        return true;
    }

    @Override
    public boolean onlyThrowing() {
        return false;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        list.add((Component)Component.m_237115_((String)"item.jerotes.hammer").m_130940_(ChatFormatting.YELLOW));
        list.add((Component)Component.m_237110_((String)"item.jerotes.anesthetized_only_melee", (Object[])new Object[]{this.getAnesthetized()}).m_130940_(ChatFormatting.YELLOW));
    }
}

