/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.item.tool;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jerotes.jerotes.entity.JerotesChangeLivingEntity;
import com.jerotes.jerotes.entity.ServerPlayerEntity;
import com.jerotes.jerotes.item.ItemSpecialEffect;
import com.jerotes.jerotes.item.MeleeItem;
import com.jerotes.jerotes.util.Main;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ItemToolBaseSpearBase
extends Item
implements ItemSpecialEffect,
MeleeItem,
Vanishable {
    public final float minReach;
    public final float maxReach;
    public final float hitboxMargin;
    public final int delayTicks;
    public final Optional<Condition> dismountConditions;
    public final Optional<Condition> knockbackConditions;
    public final Optional<Condition> damageConditions;
    public final float forwardMovement;
    public final float damageMultiplier;
    public final SoundEvent sound;
    public final SoundEvent hitSound;
    public final float minReach2;
    public final float maxReach2;
    public final float hitboxMargin2;
    public final boolean dealsKnockback;
    public final boolean dismounts;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public ItemToolBaseSpearBase(Item.Properties properties, float minReach, float maxReach, float hitboxMargin, int delayTicks, Optional<Condition> dismountConditions, Optional<Condition> knockbackConditions, Optional<Condition> damageConditions, float forwardMovement, float damageMultiplier, SoundEvent sound, SoundEvent hitSound, float minReach2, float maxReach2, float hitboxMargin2, boolean dealsKnockback, boolean dismounts, float n, float f) {
        super(properties);
        this.minReach = minReach;
        this.maxReach = maxReach;
        this.hitboxMargin = hitboxMargin;
        this.delayTicks = delayTicks;
        this.dismountConditions = dismountConditions;
        this.knockbackConditions = knockbackConditions;
        this.damageConditions = damageConditions;
        this.forwardMovement = forwardMovement;
        this.damageMultiplier = damageMultiplier;
        this.sound = sound;
        this.hitSound = hitSound;
        this.minReach2 = minReach2;
        this.maxReach2 = maxReach2;
        this.hitboxMargin2 = hitboxMargin2;
        this.dealsKnockback = dealsKnockback;
        this.dismounts = dismounts;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)(f - 1.0f), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)(n - 4.0f), AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.MAINHAND) {
            return this.defaultModifiers;
        }
        return super.m_7167_(equipmentSlot);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        player.m_6672_(interactionHand);
        this.makeSound((Entity)player);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public int m_8105_(ItemStack itemStack) {
        return 72000;
    }

    public static Vec3 getKnownMovement(Entity entity) {
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)entity;
            return serverPlayer.jerotesGetKnownMovement();
        }
        LivingEntity livingEntity = entity.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (entity.m_6084_()) {
                return ItemToolBaseSpearBase.getKnownMovement((Entity)player);
            }
        }
        return entity.m_20184_();
    }

    public static Vec3 getMotion(Entity entity) {
        if (!(entity instanceof Player) && entity.m_20159_()) {
            entity = entity.m_20201_();
        }
        Vec3 vec3 = ItemToolBaseSpearBase.getKnownMovement(entity).m_82490_(20.0);
        if (entity.m_20096_()) {
            return vec3.m_193103_(Direction.Axis.Y, 0.0);
        }
        return vec3;
    }

    public boolean m_6777_(BlockState p_43291_, Level p_43292_, BlockPos p_43293_, Player p_43294_) {
        return false;
    }

    public void makeSound(Entity entity) {
        entity.m_9236_().m_6263_((Player)entity, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.sound, entity.m_5720_(), 1.0f, 1.0f);
    }

    public void makeHitSound(Entity entity) {
        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.hitSound, entity.m_5720_(), 1.0f, 1.0f);
    }

    public int computeDamageUseDuration() {
        return this.delayTicks + this.damageConditions.map(Condition::maxDurationTicks).orElse(0);
    }

    public void damageEntities(ItemStack itemStack, int n, LivingEntity livingEntity, EquipmentSlot equipmentSlot) {
        int n2 = itemStack.m_41779_() - n;
        if (n2 < this.delayTicks) {
            return;
        }
        n2 -= this.delayTicks;
        Vec3 vec3 = livingEntity.m_20154_();
        double d = vec3.m_82526_(ItemToolBaseSpearBase.getMotion((Entity)livingEntity));
        float f = livingEntity instanceof Player ? 1.0f : 0.2f;
        float f2 = livingEntity instanceof Player ? 1.0f : 0.5f;
        boolean bl = false;
        for (EntityHitResult entityHitResult : ItemToolBaseSpearBase.getHitEntitiesAlong(livingEntity, f2 * this.minReach, f2 * this.maxReach, this.hitboxMargin, entity -> ItemToolBaseSpearBase.canHitEntity((Entity)livingEntity, entity))) {
            boolean bl4;
            Entity entity2 = entityHitResult.m_82443_();
            double d2 = vec3.m_82526_(ItemToolBaseSpearBase.getMotion(entity2));
            double d3 = Math.max(0.0, d - d2);
            boolean bl2 = this.dismountConditions.isPresent() && this.dismountConditions.get().test(n2, d, d3, f);
            boolean bl3 = this.knockbackConditions.isPresent() && this.knockbackConditions.get().test(n2, d, d3, f);
            boolean bl5 = bl4 = this.damageConditions.isPresent() && this.damageConditions.get().test(n2, d, d3, f);
            if (livingEntity instanceof JerotesChangeLivingEntity) {
                JerotesChangeLivingEntity jerotesChangeLivingEntity = (JerotesChangeLivingEntity)livingEntity;
                jerotesChangeLivingEntity.rememberStabbedEntityJerotes(entity2);
            }
            bl |= this.stabAttack(equipmentSlot, entity2, Mth.m_14107_((double)(d3 * (double)this.damageMultiplier)), bl4, bl3, bl2, livingEntity);
        }
        if (bl) {
            this.makeHitSound((Entity)livingEntity);
        }
    }

    public boolean stabAttack(EquipmentSlot equipmentSlot, Entity entity, float f, boolean bl, boolean bl2, boolean bl3, LivingEntity self) {
        Level object = self.m_9236_();
        if (!(object instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)object;
        object = self.m_6844_(equipmentSlot);
        DamageSource damageSource = self.m_269291_().m_269333_(self);
        float f2 = f;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            f2 += EnchantmentHelper.m_44833_((ItemStack)((ItemStack)object), (MobType)livingEntity.m_6336_());
        }
        Vec3 vec3 = entity.m_20184_();
        boolean bl4 = bl2;
        bl4 |= bl && entity.m_6469_(damageSource, f2);
        if (bl2) {
            ItemToolBaseSpearBase.causeExtraKnockback(self, entity, 0.4f + this.getKnockback(self, entity, damageSource), vec3);
        }
        if (bl3 && entity.m_20159_()) {
            bl4 = true;
            entity.m_8127_();
        }
        if (!bl4) {
            return false;
        }
        self.m_21335_(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (self instanceof Player) {
                Player player = (Player)self;
                ((ItemStack)object).m_41640_(livingEntity, player);
            }
        }
        self.m_6844_(equipmentSlot).m_41622_(1, self, livingEntitys -> self.m_21166_(equipmentSlot));
        return true;
    }

    public static void causeExtraKnockback(LivingEntity self, Entity entity, float f, Vec3 vec3) {
        if (self instanceof Player) {
            if (f > 0.0f) {
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.m_147240_((double)f, (double)Mth.m_14031_((float)(self.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(self.m_146908_() * ((float)Math.PI / 180)))));
                } else {
                    entity.m_5997_((double)(-Mth.m_14031_((float)(self.m_146908_() * ((float)Math.PI / 180))) * f), 0.1, (double)(Mth.m_14089_((float)(self.m_146908_() * ((float)Math.PI / 180))) * f));
                }
                self.m_20256_(self.m_20184_().m_82542_(0.6, 1.0, 0.6));
                self.m_6858_(false);
            }
            if (entity instanceof ServerPlayer && entity.f_19864_) {
                ((ServerPlayer)entity).f_8906_.m_141995_((Packet)new ClientboundSetEntityMotionPacket(entity));
                entity.f_19864_ = false;
                entity.m_20256_(vec3);
            }
        } else if (f > 0.0f && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_147240_((double)f, (double)Mth.m_14031_((float)(self.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(self.m_146908_() * ((float)Math.PI / 180)))));
            self.m_20256_(self.m_20184_().m_82542_(0.6, 1.0, 0.6));
        }
    }

    protected float getKnockback(LivingEntity self, Entity entity, DamageSource damageSource) {
        float f = (float)self.m_21133_(Attributes.f_22282_);
        Level level = self.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                return (float)EnchantmentHelper.m_44894_((LivingEntity)livingEntity) / 2.0f;
            }
        }
        return f / 2.0f;
    }

    public static Collection<EntityHitResult> getHitEntitiesAlong(LivingEntity livingEntity, float f, float f2, float f3, Predicate<Entity> predicate) {
        Vec3 vec3 = ItemToolBaseSpearBase.getHeadLookAngle((Entity)livingEntity);
        Vec3 vec32 = livingEntity.m_146892_();
        Vec3 vec33 = vec32.m_82549_(vec3.m_82490_((double)f));
        Vec3 vec34 = vec32.m_82549_(vec3.m_82490_((double)f2));
        return (Collection)ItemToolBaseSpearBase.getHitEntitiesAlong(vec33, (Entity)livingEntity, predicate, vec34, f3, ClipContext.Block.COLLIDER).map(blockHitResult -> List.of(), collection -> collection);
    }

    public static Vec3 getHeadLookAngle(Entity entity) {
        return ItemToolBaseSpearBase.calculateViewVector(entity.m_146909_(), entity.m_6080_());
    }

    public static Vec3 calculateViewVector(float p_20172_, float p_20173_) {
        float f = p_20172_ * ((float)Math.PI / 180);
        float f1 = -p_20173_ * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.BLOCK;
    }

    private static Either<BlockHitResult, Collection<EntityHitResult>> getHitEntitiesAlong(Vec3 vec3, Entity entity, Predicate<Entity> predicate, Vec3 vec32, float f, ClipContext.Block block) {
        AABB aABB;
        Collection<EntityHitResult> collection;
        Level level = entity.m_9236_();
        BlockHitResult blockHitResult = ItemToolBaseSpearBase.clipIncludingBorder(new ClipContext(vec3, vec32, block, ClipContext.Fluid.NONE, entity), level);
        if (blockHitResult.m_6662_() != HitResult.Type.MISS) {
            vec32 = blockHitResult.m_82450_();
        }
        if (!(collection = ItemToolBaseSpearBase.getManyEntityHitResult(level, entity, vec3, vec32, aABB = AABB.m_165882_((Vec3)vec3, (double)f, (double)f, (double)f).m_82369_(vec32.m_82546_(vec3)).m_82400_(1.0), predicate, f)).isEmpty()) {
            return Either.right(collection);
        }
        return Either.left((Object)blockHitResult);
    }

    public static Collection<EntityHitResult> getManyEntityHitResult(Level level, Entity entity, Vec3 vec32, Vec3 vec33, AABB aABB, Predicate<Entity> predicate, float f) {
        ArrayList<EntityHitResult> arrayList = new ArrayList<EntityHitResult>();
        for (Entity entity2 : level.m_6249_(entity, aABB, predicate)) {
            AABB aABB2 = entity2.m_20191_().m_82400_((double)f);
            if (aABB2.m_82390_(vec32)) {
                arrayList.add(new EntityHitResult(entity2, vec32));
                continue;
            }
            Optional optional = aABB2.m_82371_(vec32, vec33);
            optional.ifPresent(vec3 -> arrayList.add(new EntityHitResult(entity2, vec3)));
        }
        return arrayList;
    }

    public static BlockHitResult clipIncludingBorder(ClipContext clipContext, Level level) {
        BlockHitResult blockHitResult = level.m_45547_(clipContext);
        WorldBorder worldBorder = level.m_6857_();
        if (worldBorder.m_61937_(BlockPos.m_274446_((Position)clipContext.m_45702_())) && !worldBorder.m_61937_(BlockPos.m_274446_((Position)blockHitResult.m_82450_()))) {
            Vec3 vec3 = blockHitResult.m_82450_().m_82546_(clipContext.m_45702_());
            Direction direction = ItemToolBaseSpearBase.getApproximateNearest(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            Vec3 vec32 = ItemToolBaseSpearBase.clampVec3ToBound(blockHitResult.m_82450_(), worldBorder);
            return new BlockHitResult(vec32, direction, BlockPos.m_274446_((Position)vec32), false);
        }
        return blockHitResult;
    }

    public static Vec3 clampVec3ToBound(Vec3 vec3, WorldBorder worldBorder) {
        return ItemToolBaseSpearBase.clampVec3ToBound(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, worldBorder);
    }

    public static Vec3 clampVec3ToBound(double d, double d2, double d3, WorldBorder worldBorder) {
        return new Vec3(Mth.m_14008_((double)d, (double)worldBorder.m_61955_(), (double)(worldBorder.m_61957_() - (double)1.0E-5f)), d2, Mth.m_14008_((double)d3, (double)worldBorder.m_61956_(), (double)(worldBorder.m_61958_() - (double)1.0E-5f)));
    }

    public static Direction getApproximateNearest(double d, double d2, double d3) {
        return ItemToolBaseSpearBase.getApproximateNearest((float)d, (float)d2, (float)d3);
    }

    public static Direction getApproximateNearest(float f, float f2, float f3) {
        Direction direction = Direction.NORTH;
        float f4 = Float.MIN_VALUE;
        for (Direction direction2 : Direction.values()) {
            float f5 = f * (float)direction2.m_122429_() + f2 * (float)direction2.m_122430_() + f3 * (float)direction2.m_122431_();
            if (!(f5 > f4)) continue;
            f4 = f5;
            direction = direction2;
        }
        return direction;
    }

    public static boolean canHitEntity(Entity entity, Entity entity2) {
        JerotesChangeLivingEntity jerotesChangeLivingEntity;
        LivingEntity living;
        if (!entity2.m_271807_()) {
            return false;
        }
        if (!Main.hasLineOfSightEntity(entity, entity2)) {
            return false;
        }
        if (entity2 instanceof Player) {
            Player player;
            Player livingEntity = (Player)entity2;
            if (entity instanceof Player && !(player = (Player)entity).m_7099_(livingEntity)) {
                return false;
            }
        }
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity) instanceof JerotesChangeLivingEntity && (jerotesChangeLivingEntity = (JerotesChangeLivingEntity)living).wasRecentlyStabbedJerotes(entity2)) {
            return false;
        }
        return !entity.m_20365_(entity2);
    }

    public void attack(Player serverPlayer, EquipmentSlot equipmentSlot) {
        float f = (float)serverPlayer.m_21133_(Attributes.f_22281_);
        boolean bl = false;
        for (EntityHitResult entityHitResult : ItemToolBaseSpearBase.getHitEntitiesAlong((LivingEntity)serverPlayer, this.minReach2, this.maxReach2, this.hitboxMargin2, entity -> ItemToolBaseSpearBase.canHitEntity((Entity)serverPlayer, entity))) {
            bl |= this.stabAttack(equipmentSlot, entityHitResult.m_82443_(), f, true, this.dealsKnockback, this.dismounts, (LivingEntity)serverPlayer);
        }
        serverPlayer.m_36334_();
        if (bl) {
            this.makeHitSound((Entity)serverPlayer);
        }
        this.makeSound((Entity)serverPlayer);
        serverPlayer.m_21011_(InteractionHand.MAIN_HAND, false);
    }

    public record Condition(int maxDurationTicks, float minSpeed, float minRelativeSpeed) {
        public boolean test(int n, double d, double d2, double d3) {
            return n <= this.maxDurationTicks && d >= (double)this.minSpeed * d3 && d2 >= (double)this.minRelativeSpeed * d3;
        }

        public static Optional<Condition> ofAttackerSpeed(int n, float f) {
            return Optional.of(new Condition(n, f, 0.0f));
        }

        public static Optional<Condition> ofRelativeSpeed(int n, float f) {
            return Optional.of(new Condition(n, 0.0f, f));
        }
    }
}

