/*
 * Decompiled with CFR 0.152.
 */
package com.jerotes.jerotes.item.tool;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.jerotes.jerotes.item.ItemSpecialEffect;
import com.jerotes.jerotes.item.ItemTwoHanded;
import com.jerotes.jerotes.item.MeleeItem;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ItemToolBaseTwoHandedShovel
extends ShovelItem
implements ItemTwoHanded,
ItemSpecialEffect,
MeleeItem {
    protected static final UUID BASE_ENTITY_REACH_UUID = UUID.fromString("c0b279fb-83be-442f-b062-c577d26065d3");
    protected static final UUID BASE_BLOCK_REACH_UUID = UUID.fromString("2ab44e2a-0eb7-4825-8a10-88709f6e2219");
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    private final float attackDamageBaseline;
    public static final Set<ToolAction> TWO_HANDED_SHOVEL_ACTIONS = ItemToolBaseTwoHandedShovel.of(ToolActions.SHOVEL_DIG, ToolActions.SHOVEL_FLATTEN, ToolActions.SWORD_SWEEP);

    public ItemToolBaseTwoHandedShovel(Tier tier, int damage, float speed, Item.Properties properties) {
        super(tier, (float)damage, speed, properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.attackDamageBaseline = (float)damage + tier.m_6631_();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.attackDamageBaseline, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)speed, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(BASE_ENTITY_REACH_UUID, "Tool modifier", 0.5, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)new AttributeModifier(BASE_BLOCK_REACH_UUID, "Tool modifier", 0.5, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }

    public float m_41008_() {
        return this.attackDamageBaseline;
    }

    @Override
    public boolean isMeleeWeapon() {
        return false;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack itemStack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (!player.m_21206_().m_41619_()) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    private static Set<ToolAction> of(ToolAction ... actions) {
        return Stream.of(actions).collect(Collectors.toCollection(Sets::newIdentityHashSet));
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return TWO_HANDED_SHOVEL_ACTIONS.contains(toolAction);
    }

    @Override
    public int getBlockReduction() {
        return 50;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, list, tooltipFlag);
        list.add((Component)Component.m_237115_((String)"item.jerotes.two_handed_shovel").m_130940_(ChatFormatting.YELLOW));
        list.add((Component)Component.m_237110_((String)"item.jerotes.two_handed", (Object[])new Object[]{this.getBlockReduction()}).m_130940_(ChatFormatting.YELLOW));
    }
}

